<?php namespace Config;

use CodeIgniter\Config\BaseConfig;

class Filters extends BaseConfig
{
	// Makes reading things below nicer,
	// and simpler to change out script that's used.
	public $aliases = [
		'csrf'     => \CodeIgniter\Filters\CSRF::class,
		'toolbar'  => \CodeIgniter\Filters\DebugToolbar::class,
		'honeypot' => \CodeIgniter\Filters\Honeypot::class,
        'authAdmin' => \App\Filters\Admin\AuthFilter::class,
        'authGuest' => \App\Filters\Guest\AuthFilter::class,
        'detailSaveBackList' => \App\Filters\Common\DetailSaveBackListFilter::class,
	];

	// Always applied before every request
	public $globals = [
		'before' => [
			//'honeypot'
			// 'csrf',
		],
		'after'  => [
			'toolbar',
			//'honeypot'
		],
	];

	// Works on all of a particular HTTP method
	// (GET, POST, etc) as BEFORE filters only
	//     like: 'post' => ['CSRF', 'throttle'],
	public $methods = [];

	// List filter aliases and any before/after uri patterns
	// that they should run on, like:
	//    'isLoggedIn' => ['before' => ['account/*', 'profiles/*']],

	public $filters = [
	    'authAdmin' => [
			'before' => [
				'admin',
				'admin/*'
			] ,
            'after' => [
				'admin/*',
				'admin'
			]
		],
        'authGuest' => [
            'before' => [
				'me/*',
				// 'orderinfo',
				// 'orderinfo/detail/*',
				'cart',
				'cart/*',
				'sale/estifromcart',
				'one2one',
				'one2one/*',
				'estimate',
				'estimate/detail',
				'estimate/detail/*',
				'estimate/update',
				'estimate/update/*',
				'deferredpay',
				'deferredpay/*',
				'refundinfo',
				'refundinfo/*',
			],
        ],
        'detailSaveBackList' => [
            'before' => [
                'sale',
                'contact/news',
                'me/quotation-history',
                'admin/sale/quote',
                'admin/sales',
                'admin/news',
                'admin/inquiries',
                'admin/members'
            ],
        ]
    ];
}
