<?php namespace App\Controllers\Admin;

use App\Entities\Bannermains;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\BannermainCategoryModel;
use App\Models\BannermainFileModel;
use App\Models\BannermainModel;
use App\Services\BannermainsService;

class BannermainsController extends BaseController
{
    protected $bannermainsModel;
    protected $bannermainsFileModel;
    protected $bannermainsService;
    protected $bannermainCategoryModel;

    public function __construct()
    {
        $this->bannermainsModel = new BannermainModel();
        $this->bannermainsFileModel = new BannermainFileModel();
        $this->bannermainsService = new BannermainsService();
        $this->bannermainCategoryModel = new BannermainCategoryModel();
    }

    public function index()
    {
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( ( isset($searchInput['category_id']) && $searchInput['category_id'] != '') || ( isset($searchInput['title']) && $searchInput['title'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $categories = $this->bannermainCategoryModel->findAll();
        $data = $this->bannermainsModel->getSearch($searchInput,$perPage);
        $data['categories'] = $categories;
        //exit;
        return $this->viewAdmin('bannermains/index',array_merge($data,$searchInput));
    }

    protected function validationMapFieldLabels(){
        return [
            'title' => lang_common('title'),
            'sub_title' => lang_common('sub_title')
        ];
    }

    public function showCreate(){
        $this->rules = $this->bannermainsModel->getValidationRules();
        $categories = $this->bannermainCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['maxFiles'] = 10;
        return $this->viewAdmin('bannermains/create',$data);
    }

    public function create(){
        $this->rules = $this->bannermainsModel->getValidationRules();
        if($this->checkValidation()){
            $accountManger = AuthHelpers::getLoginInfoAdmin();
            $this->bannermainsService->saveBannermains($this->request,$accountManger->account_id);
            $message = 'Create bannermains success.';
            return redirect()->route('admin.bannermains.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('bannermains/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->bannermainsModel->getValidationRules();
        $bannermainsItem = $this->bannermainsModel->find($id);
        $files = $this->bannermainsFileModel->where('bannermains_id',$id)->findAll();
        $categories = $this->bannermainCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['item'] = $bannermainsItem;
        $data['files'] = $files;
        $data['maxFiles'] = 10 - count($files);
        return $this->viewAdmin('bannermains/update', $data);
    }

    public function update($id){
        $this->rules = $this->bannermainsModel->getValidationRules();
        if($this->checkValidation()){
            $this->bannermainsService->updateBannermains($id,$this->request);
            $message = "Update bannermains success";
            return redirect()->route('admin.bannermains.index')->with('message',$message);
        }else{
            return view('admin/bannermains/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteBannermains($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->bannermainsService->deleteBannermains($ids);
            if($result) $message = "Delete bannermains success";
        }
        return redirect()->route('admin.bannermains.index')->with('message',$message);
    }

    public function deleteFile($bannermainsId,$fileNo){
        $this->bannermainsFileModel->delete($fileNo);
        $message = "Delete file success";
        return redirect()->route('admin.bannermains.update',[$bannermainsId])->with('message',$message);;
    }

}
