<?php namespace App\Controllers\Admin;

use App\Entities\Category3;
use App\Entities\Category2;
use App\Entities\Category1;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Helpers\NumberHelper;
use App\Services\Category3Service;
use App\Models\InCategory3Model;

use App\Models\Category1Model;
use App\Models\Category2Model;
use App\Models\Category3Model;

class Category3Controller extends BaseController
{
    protected $incategory3Model;
    protected $category3Service;

    protected $category1Model;
    protected $category2Model;
    protected $category3Model;


    public function __construct()
    {
        parent::__construct();
        $this->incategory3Model = new InCategory3Model();
        $this->category3Service = new Category3Service();

        $this->category1Model = new Category1Model();
        $this->category2Model = new Category2Model();
        $this->category3Model = new Category3Model();

    }

    public function index(){
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( isset($searchInput['category3_name']) && $searchInput['category3_name'] != '' ) $searchInput['is_search'] = true;
        $data = $this->incategory3Model->getAdmSearch($searchInput,$perPage);

        $listcategory3 = $this->incategory3Model->findAll();
        $data['countcategory3'] = count($listcategory3);

        //echo $data['countcategory3'];
        //var_dump($data);
        //echo "Test";
        //exit;
        
        return $this->viewAdmin('category3s/index',array_merge($data, $searchInput));
    
    }

    public function showUpdate($category3Id){
        $item = $this->incategory3Model->find($category3Id);
        $data['item'] = $item;

        // var_dump($data['item']);
        $category3Id = $item->category3_id;
        // var_dump($category3Id); // Printing Test
        $data['category3_category3'] = $this->category3Model->find($category3Id);
       // var_dump($data['category3_category3']);
        $category3info = $data['category3_category3'];
        // var_dump($category3info['category2_id']);
        $category2Id = $category3info['category2_id'];
        // var_dump($category2Id); // Printing Test
        $data['category3_category2'] = $this->category2Model->find($category2Id);
        // var_dump($data['category3_category2']);

        $category2info = $data['category3_category2'];
        $category1Id = $category2info['category1_id'];

        $data['category3_category1'] = $this->category1Model->find($category1Id);     

		$data['category1'] =  $this->category1Model->orderBy('category1_name', 'ASC')->findAll();
		$data['category2'] =  $this->category2Model->orderBy('category2_name', 'ASC')->findAll();

        return $this->viewAdmin('category3s/update',$data);
    }

    
    public function showCreate(){
        $this->rules = $this->incategory3Model->getValidationRules();
        $data['category1'] = $this->category1Model->orderBy('category1_name', 'ASC')->findAll();
        
        return $this->viewAdmin('category3s/create',$data);
    }

    public function create(){
        $category3 = new Category3();
        $category3->fill($this->request->getPost());
        $category3->category3_code = 'CL'.time();
        $this->incategory3Model->save($category3);
        $message = 'Create category3 success.';
        return redirect()->route('admin.category3.index')->with('message' , $message);
    }

    public function delete($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->category3Service->deleteCategory3($ids);
            if($result) $message = "Delete category3 success";
        }
        return redirect()->route('admin.category3.index')->with('message',$message);
    }

    public function showCategory2Create(){
        $this->rules = $this->incategory3Model->getValidationRules();
        $data['category1'] = $this->category1Model->orderBy('category1_name', 'ASC')->findAll();
        return $this->viewAdmin('category3s/category2create',$data);
    }

    public function category2create(){
        $category2 = new Category2();
        $category2->fill($this->request->getPost());
        $this->category2Model->save($category2);
        $message = 'Create Category2 success.';
        return redirect()->route('admin.category3.create')->with('message' , $message);
    }

    public function showCategory1Create(){
        $this->rules = $this->incategory3Model->getValidationRules();
        $data['category1'] = $this->category1Model->orderBy('category1_name', 'ASC')->findAll();
        return $this->viewAdmin('category3s/category1create',$data);
    }

    public function category1create(){
        $category1 = new Category1();
        $category1->fill($this->request->getPost());

        var_dump($category1);
        $this->category1Model->save($category1);
        $message = 'Create Category1 success.';
        return redirect()->route('admin.category3.create')->with('message' , $message);
    }

    public function accept($strIds){
        $message = "";
        $page = $this->request->getGet('page');
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->category3Service->acceptCategory3($ids);
            if($result) $message = "Accept category3 success";
        }
        return redirect()->to(route_to('admin.category3.index').'?page=' . $page)->with('message',$message);
    }

    public function notAccept($strIds){
        $message = "";
        $page = $this->request->getGet('page');
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->category3Service->acceptCategory3($ids, STUDENT_ACCEPT_OFF);
            if($result) $message = "Not Accept category3 success";
        }
        return redirect()->to(route_to('admin.category3.index').'?page=' . $page)->with('message',$message);
    }

    public function resetPassword($category3Id){
        ini_set('display_errors',1);
        $category3 = $this->incategory3Model->find($category3Id);
        if(isset($category3)){
            $pass = $digitsRandom = NumberHelper::generateRandom();
            $passMd5 = md5($pass);
            $category3->password = $passMd5;
            $category3->password_random = $pass;
            $this->incategory3Model->save($category3);
        }
        $message = "Random password success";
        return redirect()->route('admin.category3.update', [$category3Id])->with('message',$message);
    }

    public function update($category3Id){

        $this->rules = $this->incategory3Model->getValidationRules(
            [
                'only' => array('category3_name'),
                'except_rule' => [
                    'category3_name' => 'is_unique'
                ]
            ]);

        // var_dump($this->rules);
        // var_dump($category3Id);
        $info = $this->incategory3Model->find($category3Id);

        $pre_category2_id = $info->category2_id;
        $pre_category3_name = $info->category3_name;
        $pre_category3_add = $info->category3_add;
        $pre_category3_tel = $info->category3_tel;

        $inputs = $this->request->getPost();
        
        if(isset($info)){
            $this->rules['category3_name'] = $this->rules['category3_name'].'|is_unique[category3s.category3_name,category3_id,'.$category3Id.']';
            $info->category2_id = $this->request->getPost('category2_id');
            $info->category3_name = $this->request->getPost('category3_name');
            $info->category3_add = $this->request->getPost('category3_add');
            $info->category3_tel = $this->request->getPost('category3_tel');

            //var_dump($inputs);

            //if($this->checkValidation($inputs)){

                /*
                $fileImage = $this->request->getFile('avatar_dir');
                if(isset($fileImage) && !empty($fileImage->getClientName())){
                    FileHelper::deleteFile($info->avatar_dir);
                    $fileImagePath = FileHelper::saveFile($fileImage, FileHelper::FOLDER_PATCH_UPLOAD_MEMBER, $category3Id);
                    $info->avatar_dir = $fileImagePath;
                }
                */

            //var_dump($category3Id);

                    if($pre_category2_id != $info->category2_id || $pre_category3_name != $info->category3_name || $pre_category3_add != $info->category3_add || $pre_category3_tel != $info->category3_tel){

                        $this->incategory3Model->save($info);
                        return redirect()->route('admin.category3.show_update',[$category3Id])->with('message', 'Update Information Success.');
                    }else{
                        return redirect()->route('admin.category3.show_update',[$category3Id])->with('message', 'No change in information.');
                    }

            //}else{
            //    return redirect()->route('admin.category3.show_update',[$category3Id])->withInput();
            //}
        }
        return redirect()->route('admin.category3.show_update',[$category3Id])->with('error', 'Category3 do not exit.');
    }

}
