<?php namespace App\Controllers\Admin;

use App\Entities\Categorylevel3;
use App\Entities\Categorylevel2;
use App\Entities\Categorylevel1;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Helpers\NumberHelper;
use App\Helpers\FileHelper;
use App\Services\Categorylevel3Service;
use App\Services\Categorylevel2Service;
use App\Services\Categorylevel1Service;

use App\Models\InCategorylevel1Model;
use App\Models\InCategorylevel2Model;
use App\Models\InCategorylevel3Model;
use App\Models\Categorylevel1Model;
use App\Models\Categorylevel2Model;
use App\Models\Categorylevel3Model;
// use App\Models\MemberCategoryModel;

class CategorylevelController extends BaseController
{
    protected $incategorylevel1Model;
    protected $incategorylevel2Model;
    protected $incategorylevel3Model;
    protected $categorylevel3Service;
    protected $categorylevel2Service;
    protected $categorylevel1Service;
    protected $categorylevel1Model;
    protected $categorylevel2Model;
    protected $categorylevel3Model;
    // protected $memberCategoryModel;

    public function __construct()
    {
        parent::__construct();
        $this->incategorylevel1Model = new InCategorylevel1Model();
        $this->incategorylevel2Model = new InCategorylevel2Model();
        $this->incategorylevel3Model = new InCategorylevel3Model();
        $this->categorylevel3Service = new Categorylevel3Service();
        $this->categorylevel2Service = new Categorylevel2Service();
        $this->categorylevel1Service = new Categorylevel1Service();
        $this->categorylevel1Model = new Categorylevel1Model();
        $this->categorylevel2Model = new Categorylevel2Model();
        $this->categorylevel3Model = new Categorylevel3Model();
        // $this->memberCategoryModel = new MemberCategoryModel();

    }

    public function index(){
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( isset($searchInput['categorylevel3_name']) && $searchInput['categorylevel3_name'] != '' ) $searchInput['is_search'] = true;
        $data = $this->incategorylevel3Model->getAdmSearch($searchInput,$perPage);
        
        return $this->viewAdmin('categorylevel/categorylevel3list',array_merge($data, $searchInput));
    
    }

    public function showUpdate($categorylevel3Id){
        $item = $this->incategorylevel3Model->find($categorylevel3Id);
        $data['item'] = $item;

        // var_dump($data['item']);
        $categorylevel3Id = $item->categorylevel3_id;
        $data['categorylevel3_categorylevel3'] = $this->categorylevel3Model->find($categorylevel3Id);
        $categorylevel3info = $data['categorylevel3_categorylevel3'];
        $categorylevel2Id = $categorylevel3info['categorylevel2_id'];
        $data['categorylevel3_categorylevel2'] = $this->categorylevel2Model->find($categorylevel2Id);

        $categorylevel2info = $data['categorylevel3_categorylevel2'];
        $categorylevel1Id = $categorylevel2info['categorylevel1_id'];

        $data['categorylevel3_categorylevel1'] = $this->categorylevel1Model->find($categorylevel1Id);     

		$data['categorylevel1'] =  $this->categorylevel1Model->orderBy('categorylevel1_name', 'ASC')->findAll();
		$data['categorylevel2'] =  $this->categorylevel2Model->orderBy('categorylevel2_name', 'ASC')->findAll();

        return $this->viewAdmin('categorylevel/categorylevel3update',$data);
    }

    
    public function showCreate(){
        $this->rules = $this->incategorylevel3Model->getValidationRules();
        $data['categorylevel1'] = $this->categorylevel1Model->orderBy('categorylevel1_name', 'ASC')->findAll();
        return $this->viewAdmin('categorylevel/categorylevel3create',$data);
    }

    public function create(){
        $categorylevel3 = new Categorylevel3();
        $categorylevel3->fill($this->request->getPost());

        $categorylevel2_code = $this->request->getPost('categorylevel2_code');
        $categorylevel2info =  $this->categorylevel2Model->findByCategoryName($categorylevel2_code);
        $categorylevel3->categorylevel2_id = $categorylevel2info["categorylevel2_id"];

        $newcategorylevel3id = count($this->categorylevel3Model->where('categorylevel2_code', $categorylevel2_code)->findAll())+1;
        $categorylevel3Codetemp = sprintf('%04d',$newcategorylevel3id);
        $categorylevel3->categorylevel3_code = $categorylevel2_code.$categorylevel3Codetemp;

        $this->incategorylevel3Model->save($categorylevel3);
        $message = 'Create categorylevel3 success.';
        return redirect()->route('admin.categorylevel.index')->with('message' , $message);
    }

    public function delete($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->categorylevel3Service->deleteCategorylevel3($ids);
            if($result) $message = "Delete categorylevel3 success";
        }
        return redirect()->route('admin.categorylevel.index')->with('message',$message);
    }

    public function categorylevel2List(){

        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( ( isset($searchInput['categorylevel2_code']) && $searchInput['categorylevel2_code'] != '') || ( isset($searchInput['categorylevel2_name']) && $searchInput['categorylevel2_name'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;

        $data = $this->incategorylevel2Model->getSearch($searchInput,$perPage);

        $data['categorylevel1'] =  $this->categorylevel1Model->orderBy('categorylevel1_name', 'ASC')->findAll();

        return $this->viewAdmin('categorylevel/categorylevel2list',array_merge($data, $searchInput));
    }

    public function categorylevel2ChangeOrder(){

        $searchInput = $this->request->getGet();
        //var_dump ($searchInput);
        //exit;

        $categorylevel1_code = $searchInput['categorylevel1_code'];
        $categorylevel2_name = $searchInput['categorylevel2_name'];
        $page = $searchInput['page'];

        $categorylevel2_id = $searchInput['categorylevel2_id'];
        $memseq = $searchInput['memseq'];

        $this->incategorylevel2Model->update(['categorylevel2_id' => $categorylevel2_id], ['memseq' => $memseq]);

        $message = 'Change Order member success.';
        return redirect()->to(route_to('admin.categorylevel.categorylevel2list').'?categorylevel1_code=' . $categorylevel1_code.'&categorylevel2_name=' . $categorylevel2_name.'&page=' . $page)->with('message',$message);
    }

    public function categorylevel2Accept($strIds){
        $message = "";
        $page = $this->request->getGet('page');
        // var_dump ($strIds);
        // exit;

        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->categorylevel2Service->acceptCategorylevel2($ids);
            if($result) $message = "Accept Categorylevel2 success";
        }
        return redirect()->route('admin.categorylevel.categorylevel2list')->with('message',$message);
    }

    public function categorylevel2notAccept($strIds){
        $message = "";
        $page = $this->request->getGet('page');
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->categorylevel2Service->acceptCategorylevel2($ids, MEMBER_ACCEPT_OFF);
            if($result) $message = "Not Accept Categorylevel2 success";
        }
        return redirect()->route('admin.categorylevel.categorylevel2list')->with('message',$message);
    }
    
    public function categorylevel2del($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->categorylevel2Service->deleteCategorylevel2($ids);
            if($result) $message = "Delete categorylevel2 success";
        }
        return redirect()->route('admin.categorylevel.categorylevel2list')->with('message',$message);
    }

    public function showCategorylevel2Create(){
        $this->rules = $this->incategorylevel3Model->getValidationRules();
        $data['categorylevel1'] = $this->categorylevel1Model->orderBy('categorylevel1_name', 'ASC')->findAll();
        // $data['categories'] = $this->memberCategoryModel->findAll();
        return $this->viewAdmin('categorylevel/categorylevel2create',$data);
    }

    public function categorylevel2create(){
        $categorylevel2 = new Categorylevel2();
        $categorylevel2->fill($this->request->getPost());

        $categorylevel1_code = $this->request->getPost('categorylevel1_code');
        $categorylevel1info =  $this->categorylevel1Model->findByCategoryCode($categorylevel1_code);

        $categorylevel2->categorylevel1_code = $categorylevel1_code;
        $categorylevel2->categorylevel1_id = $categorylevel1info["categorylevel1_id"];

        $newcategorylevel2id = count($this->categorylevel2Model->where('categorylevel1_code', $categorylevel1_code)->findAll())+1;
        $categorylevel2Codetemp = sprintf('%03d',$newcategorylevel2id);
        $newcategorylevel2_code = $categorylevel1_code.$categorylevel2Codetemp;


        $categorylevel2->categorylevel2_code = $newcategorylevel2_code;
        $this->incategorylevel2Model->save($categorylevel2);

        $message = 'Create Categorylevel2 success.';
        return redirect()->route('admin.categorylevel.categorylevel2list')->with('message' , $message);
    }

    public function categorylevel1List(){

        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( ( isset($searchInput['categorylevel1_code']) && $searchInput['categorylevel1_code'] != '') || ( isset($searchInput['categorylevel1_name']) && $searchInput['categorylevel1_name'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;

        $data = $this->incategorylevel1Model->getSearch($searchInput,$perPage);

        return $this->viewAdmin('categorylevel/categorylevel1list',array_merge($data, $searchInput));
    }

    public function categorylevel1del($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->categorylevel1Service->deleteCategorylevel1($ids);
            if($result) $message = "Delete categorylevel1 success";
        }
        return redirect()->route('admin.categorylevel.categorylevel1list')->with('message',$message);
    }


    public function showCategorylevel1Create(){
        $this->rules = $this->incategorylevel3Model->getValidationRules();
        $data['categorylevel1'] = $this->categorylevel1Model->orderBy('categorylevel1_name', 'ASC')->findAll();

        $listcategorylevel1id = $this->categorylevel1Model->orderBy('categorylevel1_id', 'DESC')->first();
        $newcategorylevel1id = $listcategorylevel1id["categorylevel1_id"]+1;

        $data['categorylevel1Code'] = sprintf('%03d',$newcategorylevel1id);
        //$data['categorylevel1Code'] = str_pad($newcategorylevel1id, 4 , "0");
        //echo $data['categorylevel1Code'];
        //exit;

        return $this->viewAdmin('categorylevel/categorylevel1create',$data);
    }

    public function categorylevel1create(){
        $categorylevel1 = new Categorylevel1();
        $categorylevel1->fill($this->request->getPost());
        $this->incategorylevel1Model->save($categorylevel1);
        $message = 'Create Categorylevel1 success.';
        return redirect()->route('admin.categorylevel.show_categorylevel2create')->with('message' , $message);
    }


    public function showUpdateindex1($categorylevel1Id){

        $item = $this->incategorylevel1Model->find($categorylevel1Id);
        $data['item'] = $item;

        //var_dump($data['item']);
        //exit;

        return $this->viewAdmin('categorylevel/categorylevel1update',$data);
    }

    public function updateindex1($categorylevel1Id){

        $this->rules = $this->incategorylevel1Model->getValidationRules(
            [
                'only' => array('categorylevel1_name'),
                'except_rule' => [
                    'categorylevel1_name' => 'is_unique'
                ]
            ]);

        $info = $this->incategorylevel1Model->find($categorylevel1Id);

        $pre_categorylevel1_name = $info->categorylevel1_name;
        $pre_categorylevel1_name_eng = $info->categorylevel1_name_eng;

        $inputs = $this->request->getPost();
        
        //var_dump($info);
        //var_dump($inputs);
        //exit;

        if(isset($info)){
            // $this->rules['categorylevel1_name'] = $this->rules['categorylevel1_name'].'|is_unique[categorylevel1s.categorylevel1_name,categorylevel1_id,'.$categorylevel1Id.']';
            $info->categorylevel1_name = $this->request->getPost('categorylevel1_name');
            $info->categorylevel1_name_eng = $this->request->getPost('categorylevel1_name_eng');

                    if($pre_categorylevel1_name != $info->categorylevel1_name || $pre_categorylevel1_name_eng != $info->categorylevel1_name_eng){

        //var_dump($info);
        //exit;

                        $this->incategorylevel1Model->save($info);

                        return redirect()->route('admin.categorylevel.categorylevel1list')->with('message', 'Update Information Success.');
                    }else{
                        return redirect()->route('admin.categorylevel.show_updateindex1',[$categorylevel1Id])->with('message', 'No change in information.');
                    }

        }
        return redirect()->route('admin.categorylevel.show_updateindex1',[$categorylevel1Id])->with('error', 'Categorylevel1 do not exit.');
    }

    public function showUpdateindex2($categorylevel2Id){
        $item = $this->incategorylevel2Model->find($categorylevel2Id);
        $data['item'] = $item;

        // var_dump($data['item']);
        $categorylevel2Id = $item->categorylevel2_id;

        //var_dump($categorylevel2Id); // Printing Test
        $data['categorylevel3_categorylevel2'] = $this->incategorylevel2Model->find($categorylevel2Id);
        //var_dump($data['categorylevel3_categorylevel2']);
        //exit;
        $categorylevel2info = $data['categorylevel3_categorylevel2'];
        $categorylevel1Id = $categorylevel2info->categorylevel1_id;

        $data['categorylevel3_categorylevel1'] = $this->categorylevel1Model->find($categorylevel1Id);     
        //var_dump($data['categorylevel3_categorylevel1']);
        //exit;

		$data['categorylevel1'] =  $this->categorylevel1Model->orderBy('categorylevel1_name', 'ASC')->findAll();
        // $data['categories'] = $this->memberCategoryModel->findAll();
        
        return $this->viewAdmin('categorylevel/categorylevel2update',$data);
    }


    
    public function updateindex2($categorylevel2Id){

        $this->rules = $this->incategorylevel2Model->getValidationRules(
            [
                'only' => array('categorylevel2_name'),
                'except_rule' => [
                    'categorylevel2_name' => 'is_unique'
                ]
            ]);

        $info = $this->incategorylevel2Model->find($categorylevel2Id);

        $categorylevel2_code = $info->categorylevel2_code;

        $pre_categorylevel1_id = $info->categorylevel1_id;
        $pre_categorylevel2_name = $info->categorylevel2_name;
        $pre_categorylevel2_name_eng = $info->categorylevel2_name_eng;

        $pre_image_dir = $info->image_dir;
        $inputs = $this->request->getPost();

        if(isset($info)){
            $info->categorylevel1_id = $this->request->getPost('categorylevel1_id');
            $info->categorylevel2_name = $this->request->getPost('categorylevel2_name');
            $info->categorylevel2_name_eng = $this->request->getPost('categorylevel2_name_eng');
            $info->zipcode = $this->request->getPost('zipcode');
            $info->address1 = $this->request->getPost('address1');
            $info->address2 = $this->request->getPost('address2');
            $info->phonenum = $this->request->getPost('phonenum');
            $info->faxnum = $this->request->getPost('faxnum');
            $info->homepage = $this->request->getPost('homepage');
            $info->email = $this->request->getPost('email');
            $info->pastors_name = $this->request->getPost('pastors_name');
            $info->pastors_position = $this->request->getPost('pastors_position');

            $categorylevel1_getinfo = $this->incategorylevel1Model->find($info->categorylevel1_id);
            $info->categorylevel1_code = $categorylevel1_getinfo->categorylevel1_code;

            $files = $this->request->getFiles();

            if(isset($files)){
                foreach ($files as $file){
                    $fileName = $file->getClientName();
                    if ($fileName) {
                        @unlink($pre_image_dir);

                        if(isset($fileName) && !empty($fileName)){
                        $fileImagePath = FileHelper::saveMemFile($file, $categorylevel2_code, FileHelper::FOLDER_PATCH_UPLOAD_AREALEVEL2);
                        chmod($fileImagePath, 0777);
                        $info->image_dir = $fileImagePath;
                        }

                    }

                }
            }

            $this->incategorylevel2Model->save($info);
            return redirect()->route('admin.categorylevel.categorylevel2list')->with('message', 'Update Information Success.');
        }
        
        return redirect()->route('admin.categorylevel.show_updateindex2',[$categorylevel2Id])->with('error', 'Categorylevel2 do not exit.');
    }


    public function accept($strIds){
        $message = "";
        $page = $this->request->getGet('page');
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->categorylevel3Service->acceptCategorylevel3($ids);
            if($result) $message = "Accept categorylevel3 success";
        }
        return redirect()->to(route_to('admin.categorylevel.index').'?page=' . $page)->with('message',$message);
    }

    public function notAccept($strIds){
        $message = "";
        $page = $this->request->getGet('page');
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->categorylevel3Service->acceptCategorylevel3($ids, STUDENT_ACCEPT_OFF);
            if($result) $message = "Not Accept categorylevel3 success";
        }
        return redirect()->to(route_to('admin.categorylevel.index').'?page=' . $page)->with('message',$message);
    }

    public function resetPassword($categorylevel3Id){
        ini_set('display_errors',1);
        $categorylevel3 = $this->incategorylevel3Model->find($categorylevel3Id);
        if(isset($categorylevel3)){
            $pass = $digitsRandom = NumberHelper::generateRandom();
            $passMd5 = md5($pass);
            $categorylevel3->password = $passMd5;
            $categorylevel3->password_random = $pass;
            $this->incategorylevel3Model->save($categorylevel3);
        }
        $message = "Random password success";
        return redirect()->route('admin.categorylevel.update', [$categorylevel3Id])->with('message',$message);
    }

    public function update($categorylevel3Id){

        $this->rules = $this->incategorylevel3Model->getValidationRules(
            [
                'only' => array('categorylevel3_name'),
                'except_rule' => [
                    'categorylevel3_name' => 'is_unique'
                ]
            ]);

        // var_dump($this->rules);
        // var_dump($categorylevel3Id);
        $info = $this->incategorylevel3Model->find($categorylevel3Id);

        $pre_categorylevel2_id = $info->categorylevel2_id;
        $pre_categorylevel3_name = $info->categorylevel3_name;
        $pre_categorylevel3_name_eng = $info->categorylevel3_name_eng;
        $pre_class_manager = $info->class_manager;

        $inputs = $this->request->getPost();
        
        if(isset($info)){
            $this->rules['categorylevel3_name'] = $this->rules['categorylevel3_name'].'|is_unique[categorylevel3s.categorylevel3_name,categorylevel3_id,'.$categorylevel3Id.']';
            $info->categorylevel2_id = $this->request->getPost('categorylevel2_id');
            $info->categorylevel3_name = $this->request->getPost('categorylevel3_name');
            $info->categorylevel3_name_eng = $this->request->getPost('categorylevel3_name_eng');
            $info->class_manager = $this->request->getPost('class_manager');

            $categorylevel2_getinfo = $this->incategorylevel2Model->find($info->categorylevel2_id);
            $info->categorylevel2_code = $categorylevel2_getinfo->categorylevel2_code;

            $this->incategorylevel3Model->save($info);
            return redirect()->route('admin.categorylevel.index')->with('message', 'Update Information Success.');

        }
        return redirect()->route('admin.categorylevel.show_update',[$categorylevel3Id])->with('error', 'Categorylevel3 do not exit.');
    }

    public function downLevel1Excel(){

        ini_set('max_execution_time',600);
        $data = $this->incategorylevel1Model->getSearchExl(17000);
        //var_dump($data["lists"]);
        //exit;

        $headerColumns = [
            lang_categorylevel('categorylevel1_id'),
            lang_categorylevel('categorylevel1_code'),
            lang_categorylevel('categorylevel1_name'),
            //lang_categorylevel('categorylevel1_name_eng'),
            lang_categorylevel('active_flg'),
            // lang_categorylevel('del_flg'),
            lang_categorylevel('created_at'),
            lang_categorylevel('updated_at')
        ];


        $dataColumns = [
            Categorylevel1::CATEGORYLEVEL1_ID,
            Categorylevel1::CATEGORYLEVEL1_CODE,
            Categorylevel1::CATEGORYLEVEL1_NAME,
            //Categorylevel1::CATEGORYLEVEL1_NAME_ENG,
            Categorylevel1::ACTIVE_FLG,
            // Categorylevel1::DEL_FLG,
            Categorylevel1::CREATED_AT,
            Categorylevel1::UPDATED_AT
        ];

        $fileName = 'Category1_List';
        $filePath = $this->excel->export($headerColumns, $data["lists"], $dataColumns,['file_name' => $fileName]);
        $this->setHeaderDownload($fileName.'.xlsx', PUBLIC_PATH . $filePath);
        exit;
    }
    
    public function downLevel2Excel(){

        ini_set('max_execution_time',600);
        $data = $this->incategorylevel2Model->getSearchExl(17000);
        //var_dump($data["lists"]);
        //exit;

        $headerColumns = [
            lang_categorylevel('categorylevel2_id'),
            //lang_categorylevel('categorylevel1_id'),
            lang_categorylevel('categorylevel2_code'),
            //lang_categorylevel('categorylevel1_code'),
            lang_categorylevel('categorylevel2_name'),
            //lang_categorylevel('categorylevel2_name_eng'),
            lang_categorylevel('active_flg'),
            // lang_categorylevel('del_flg'),
            lang_categorylevel('created_at'),
            lang_categorylevel('updated_at')
        ];


        $dataColumns = [
            Categorylevel2::CATEGORYLEVEL2_ID,
            //Categorylevel2::CATEGORYLEVEL1_ID,
            Categorylevel2::CATEGORYLEVEL2_CODE,
            //Categorylevel2::CATEGORYLEVEL1_CODE,
            Categorylevel2::CATEGORYLEVEL2_NAME,
            //Categorylevel2::CATEGORYLEVEL2_NAME_ENG,
            Categorylevel2::ACTIVE_FLG,
            // Categorylevel2::DEL_FLG,
            Categorylevel2::CREATED_AT,
            Categorylevel2::UPDATED_AT
        ];

        $fileName = 'Category2_List';
        $filePath = $this->excel->export($headerColumns, $data["lists"], $dataColumns,['file_name' => $fileName]);
        $this->setHeaderDownload($fileName.'.xlsx', PUBLIC_PATH . $filePath);
        exit;
    }

}
