<?php namespace App\Controllers\Admin;

use App\Entities\DigikeyApiProductinfo;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\DigikeyApiProductinfoModel;
use App\Services\DigikeyApiProductinfoService;
use App\Models\ExchangeInfoModel;

class DigikeyApiController extends BaseController
{
    protected $digikeyApiProductinfoModel;
    protected $digikeyApiProductinfoService;
    protected $exchangeInfoModel;

    public function __construct()
    {
        $this->digikeyApiProductinfoModel = new DigikeyApiProductinfoModel();
        $this->digikeyApiProductinfoService = new DigikeyApiProductinfoService();
        $this->exchangeInfoModel = new ExchangeInfoModel();
    }


    public function index()
    {

        //echo "Test OK!!";
        //exit;
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if(isset($searchInput['manufacturer_pn']) && $searchInput['manufacturer_pn'] != '') $searchInput['is_search'] = true;
        $data = $this->digikeyApiProductinfoModel->getAdmin($searchInput,$perPage);
        return $this->viewAdmin('digikeyapiproductinfo/index',array_merge($data,$searchInput));
    }


    protected function validationMapFieldLabels(){
        return [
            'manufacturer_pn' => lang_common('manufacturer_pn')
        ];
    }


    public function standardInfo(){

        $count_tmp = $this->digikeyApiProductinfoModel->insertPndata();
        $message = 'Pndata update success.';
        return redirect()->route('admin.digikeyapiproductinfo.index')->with('message' , $message);

    }

    public function toProducts(){
        $this->digikeyApiProductinfoModel->updateProducts();
        $this->digikeyApiProductinfoModel->truncate();

        $message = 'Products update success.';
        return redirect()->route('admin.digikeyapiproductinfo.index')->with('message' , $message);

    }


    public function showCreate(){
        $this->rules = $this->digikeyApiProductinfoModel->getValidationRules();

        return $this->viewAdmin('digikeyapiproductinfo/create',$data);
    }


    public function create(){
        $this->rules = $this->digikeyApiProductinfoModel->getValidationRules();
        if($this->checkValidation()){
            $this->digikeyApiProductinfoService->saveDigikeyApiProductinfo($this->request,$accountManger->account_id);
            $message = 'Create DigikeyApiProductinfo success.';
            return redirect()->route('admin.digikeyapiproductinfo.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('digikeyapiproductinfo/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->digikeyApiProductinfoModel->getValidationRules();
        $digikeyApiProductinfoItem = $this->digikeyApiProductinfoModel->find($id);

        $data['item'] = $digikeyApiProductinfoItem;
        return $this->viewAdmin('digikeyapiproductinfo/update', $data);
    }

    public function update($id){
        //var_dump($this->request);
        //exit;
        $this->rules = $this->digikeyApiProductinfoModel->getValidationRules();

        if($this->checkValidation()){
            $this->digikeyApiProductinfoService->updateDigikeyApiProductinfo($id,$this->request);

            $message = "Update digikeyApiProductinfo success";
            return redirect()->route('admin.digikeyapiproductinfo.index')->with('message',$message);
        }else{
            return view('admin/digikeyApiProductinfo/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function delete($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->digikeyApiProductinfoService->deleteDigikeyApiProductinfo($ids);
            if($result) $message = "Delete digikeyApiProductinfo success";
        }
        return redirect()->route('admin.digikeyapiproductinfo.index')->with('message',$message);
    }

}
