<?php namespace App\Controllers\Admin;

use App\Entities\Estimate;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\EstimateCategoryModel;
use App\Models\EstimateFileModel;
use App\Models\EstimateModel;
use App\Services\EstimateService;

use App\Models\ProductModel;
use App\Models\ProductsShippingModel;
use App\Models\StocklocationCategoryModel;
use App\Models\DeliverycodeModel;
use App\Models\EstimatePartinfoModel;

class EstimateController extends BaseController
{
    protected $estimateModel;
    protected $estimateFileModel;
    protected $estimateService;
    protected $estimateCategoryModel;

    private $productModel;
    private $productsShippingModel;
    protected $stocklocationCategoryModel;
    protected $deliverycodesModel;
    protected $estimatePartinfoModel;

    public function __construct()
    {
        $this->estimateModel = new EstimateModel();
        $this->estimateFileModel = new EstimateFileModel();
        $this->estimateService = new EstimateService();
        $this->estimateCategoryModel = new EstimateCategoryModel();

        $this->productModel = new ProductModel();
        $this->productsShippingModel = new ProductsShippingModel();
        $this->stocklocationCategoryModel = new StocklocationCategoryModel();
        $this->deliverycodesModel = new DeliverycodeModel();
        $this->estimatePartinfoModel = new EstimatePartinfoModel();
    }

    public function index()
    {
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( ( isset($searchInput['category_id']) && $searchInput['category_id'] != '') || ( isset($searchInput['title']) && $searchInput['title'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $categories = $this->estimateCategoryModel->findAll();
        $data = $this->estimateModel->getSearch($searchInput,$perPage);
        $data['categories'] = $categories;
        return $this->viewAdmin('estimate/index',array_merge($data,$searchInput));
    }

    protected function validationMapFieldLabels(){
        return [
            'title' => lang_common('title'),
            'content' => lang_common('content')
        ];
    }

    public function showCreate(){
        $this->rules = $this->estimateModel->getValidationRules();
        $categories = $this->estimateCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['maxFiles'] = 10;
        return $this->viewAdmin('estimate/create',$data);
    }

    public function create(){
        $this->rules = $this->estimateModel->getValidationRules();
        if($this->checkValidation()){
            $accountManger = AuthHelpers::getLoginInfoAdmin();
            $this->estimateService->saveEstimate($this->request,$accountManger->account_id);
            $message = 'Create estimate success.';
            return redirect()->route('admin.estimate.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('estimate/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->estimateModel->getValidationRules();
        $estimateItem = $this->estimateModel->find($id);

        // =====================================

        $data['item'] = $estimateItem;
        $estimate_code = $estimateItem->estimate_code;

        $estimateparts = $this->estimatePartinfoModel->getEstimateParts($estimate_code);
        $lists = $estimateparts['lists'];

        foreach ($lists as $key => $item){
            $part_sequence =  $item->part_sequence;
            $now_product_info = $this->productModel->findByProductInfo($part_sequence);

            $nowinfo = [
                'product_code'   => $now_product_info ->product_code,
                'part_number' => $now_product_info ->part_number,
                'image_dir'   => $now_product_info ->image_dir,
                'api_flg'   => $now_product_info ->api_flg,
                'part_category3' => $now_product_info ->part_category3,
                'selling_price1' => $now_product_info ->selling_price1,
                'part_number_sequence' => $now_product_info ->part_number_sequence,
                'brief_description' => $now_product_info ->brief_description,
                'product_related' => $now_product_info ->product_related,
                'stock_location' => $now_product_info ->stock_location,
                'delivery_code' => $now_product_info ->delivery_code
            ];
    
            $lists[$key]->nowinfo = $nowinfo;

            }
    
        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();

        $data['lists'] = $lists;
        // var_dump($lists);
        // exit;

        //====================================

        $files = $this->estimateFileModel->where('estimate_id',$id)->findAll();
        $categories = $this->estimateCategoryModel->findAll();
        $data['categories'] = $categories;
        // $data['item'] = $estimateItem;
        $data['files'] = $files;
        $data['maxFiles'] = 10 - count($files);
        return $this->viewAdmin('estimate/update', $data);
    }

    public function update($id){
        // $this->rules = $this->estimateModel->getValidationRules();
        // if($this->checkValidation()){

            $this->estimateService->updateEstimate($id,$this->request);
            $message = "Update estimate success";
            return redirect()->route('admin.estimate.index')->with('message',$message);

        /*
        }else{
            return view('admin/estimate/update', [
                'validator' => $this->validator
            ]);
        }
        */

    }

    public function updatepartinfo($id){

        //var_dump ($id);
        //echo "<br>";
        //var_dump ($this->request);
        $estimate_id = $this->request->getPost('estimate_id');
        $q_qty = $this->request->getPost('q_qty');
        $q_price = $this->request->getPost('q_price');
        $this->estimatePartinfoModel->updateQPartinfo($estimate_id, $q_qty, $q_price);
        // exit;

        $message = "입력한 부픔정보를 등록했습니다.";
        return redirect()->route('admin.estimate.update',[$id])->with('message',$message);;

    }


    public function deleteEstimate($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->estimateService->deleteEstimate($ids);
            if($result) $message = "Delete estimate success";
        }
        return redirect()->route('admin.estimate.index')->with('message',$message);
    }

    public function deleteFile($estimateId,$fileNo){
        $this->estimateFileModel->delete($fileNo);
        $message = "Delete file success";
        return redirect()->route('admin.estimate.update',[$estimateId])->with('message',$message);;
    }

}
