<?php namespace App\Controllers\Admin;

use App\Entities\Product;
use App\Helpers\ArrayHelper;
use App\Models\ProductModel;
use App\Models\ManufacturerModel;
use App\Models\Categorylevel1Model;
use App\Models\Categorylevel2Model;
use App\Models\Categorylevel3Model;

class ExcelloopController extends BaseController
{
    protected $productModel;
    protected $manufacturerModel;
    protected $categorylevel1Model;
    protected $categorylevel2Model;
    protected $categorylevel3Model;

    public function __construct()
    {
        $this->productModel = new ProductModel();
        $this->manufacturerModel = new ManufacturerModel();
        $this->categorylevel1Model = new Categorylevel1Model();
        $this->categorylevel2Model = new Categorylevel2Model();
        $this->categorylevel3Model = new Categorylevel3Model();
    }

    public function index()
    {
        //return view('index');
        return $this->viewAdmin('excelloop/index');
    }

    public function downloadTemplate(){
        // $fileName = 'loop_data_sample.csv';
        $fileName = 'loop_data_sample.xlsx';
        $filePath = PUBLIC_PATH. 'upload/excel/'.$fileName;
        $this->setHeaderDownload($fileName, $filePath);
        exit;
    }


    public function importCsvToDb()
    {

        // 디렉토리 갯수와 파일의 갯수 구하기

        $file_count =0;

		$loopexcel_path =  PUBLIC_PATH. 'upload/loopexcel/';
		$result=opendir($loopexcel_path); 

		while($file=readdir($result)) {
			
			if($file=="."||$file=="..") {continue;} // file명이 ".", ".." 이면 무시함
			$fileInfo = pathinfo($file);
			$fileExt = $fileInfo['extension']; // 파일의 확장자를 구함

			If (empty($fileExt)){
			$dir_count++; // 파일에 확장자가 없으면 디렉토리로 판단하여 dir_count를 증가시킴
			} else {
			$file_count++;// 파일에 확장자가 있으면 file_count를 증가시킴
			}

		}

        // echo"디렉토리 갯수는:".$dir_count."<br>";
  		// echo"파일의 갯수는:".$file_count."<br>";
        // var_dump($file_count);
        // exit;

    // 디렉토리 갯수와 파일의 갯수 구하기 끝

	$file_countend = $file_count + 1;

	for ($file_count =1;$file_count < $file_countend;$file_count ++) {
			
            $filecon = $file_count;
            $bs_filename = 'loop_data_';

            $this->loop_file_check($bs_filename, $filecon, 'csv');
            $loopfilepath = $this->filePath;
            //var_dump($loopfilepath);
            //echo"<br>";
            //exit;

                $file = fopen($loopfilepath,"r");
                
                $i = 0;
                $numberOfFields = 62;
                $csvArr = array();
                while (($filedata = fgetcsv($file, 1000, ",")) !== FALSE) {
                    $num = count($filedata);
                    if($i > 0 && $num == $numberOfFields){ 
                        
                        $timestr = date(time());
                        $codestr = substr($timestr, 4);
                        $codecount = str_pad($i, 6, "0", STR_PAD_LEFT);
                        $csvArr[$i]['product_code'] = "M".$codestr.$codecount;

                        $categorylevel1 = $this->categorylevel1Model->findByCategoryInfo($filedata[0]);
                        $csvArr[$i]['part_category'] = $categorylevel1['categorylevel1_code'];

                        $categorylevel2 = $this->categorylevel2Model->findByCategoryInfo($filedata[1]);
                        $csvArr[$i]['part_category2'] = $categorylevel2['categorylevel2_code'];

                        $categorylevel3 = $this->categorylevel3Model->findByCategoryInfo($filedata[2]);
                        $csvArr[$i]['part_category3'] = $categorylevel3['categorylevel3_code'];
                        
                        $manufacturer = $this->manufacturerModel->findByManufactureId($filedata[3]);
                        $csvArr[$i]['maker_seq'] = $manufacturer->maker_seq;
                        $csvArr[$i]['manufacturer_name'] = $manufacturer->name;

                        $csvArr[$i]['location_code'] = $filedata[4];
                        $csvArr[$i]['part_number'] = $filedata[5];
                        $csvArr[$i]['part_number_sequence'] = preg_replace("/\s+/", "", $filedata[15].$manufacturer->name.$filedata[5].$filedata[17]); // 수정필요
                        $csvArr[$i]['search_word'] = $filedata[7];
                        $csvArr[$i]['brief_description'] = $filedata[8];
                        $csvArr[$i]['date_code'] = $filedata[10];
                        $csvArr[$i]['image_dir'] = $filedata[11];
                        $csvArr[$i]['pdf_dir'] = $filedata[12];
                        $csvArr[$i]['delivery_code'] = $filedata[13];
                        $csvArr[$i]['api_flg'] = $filedata[14];
                        $csvArr[$i]['api_code']  = $filedata[15];
                        $csvArr[$i]['tariff_rate']  = $filedata[16];
                        $csvArr[$i]['product_api_id'] = $filedata[17];
                        $csvArr[$i]['qty'] = $filedata[18];
                        $csvArr[$i]['packing_code'] = $filedata[19];
                        $csvArr[$i]['wearing_price'] = $filedata[20];
                        $csvArr[$i]['price'] = $filedata[21];
                        $csvArr[$i]['leadtime'] = $filedata[21];
                        $csvArr[$i]['moq'] = $filedata[22];
                        $csvArr[$i]['mpq'] = $filedata[23];
                        $csvArr[$i]['stock_location'] = $filedata[24];
                        $csvArr[$i]['taxable'] = $filedata[25];
                        $csvArr[$i]['selling_price1'] = $filedata[26];
                        $csvArr[$i]['margin_rate1'] = $filedata[27];
                        $csvArr[$i]['unit_mini_quantity1'] = $filedata[28];
                        $csvArr[$i]['unit_max_quantity1'] = $filedata[29];
                        $csvArr[$i]['selling_price2'] = $filedata[30];
                        $csvArr[$i]['margin_rate2'] = $filedata[31];
                        $csvArr[$i]['unit_mini_quantity2'] = $filedata[32];
                        $csvArr[$i]['unit_max_quantity2'] = $filedata[33];
                        $csvArr[$i]['selling_price3'] = $filedata[34];
                        $csvArr[$i]['margin_rate3'] = $filedata[35];
                        $csvArr[$i]['unit_mini_quantity3'] = $filedata[36];
                        $csvArr[$i]['unit_max_quantity3'] = $filedata[37];
                        $csvArr[$i]['selling_price4'] = $filedata[38];
                        $csvArr[$i]['margin_rate4'] = $filedata[39];
                        $csvArr[$i]['unit_mini_quantity4'] = $filedata[40];
                        $csvArr[$i]['unit_max_quantity4'] = $filedata[41];
                        $csvArr[$i]['selling_price5'] = $filedata[42];
                        $csvArr[$i]['margin_rate5'] = $filedata[43];
                        $csvArr[$i]['unit_mini_quantity5'] = $filedata[44];
                        $csvArr[$i]['unit_max_quantity5'] = $filedata[45];
                        $csvArr[$i]['selling_price6'] = $filedata[46];
                        $csvArr[$i]['margin_rate6'] = $filedata[47];
                        $csvArr[$i]['unit_mini_quantity6'] = $filedata[48];
                        $csvArr[$i]['unit_max_quantity6'] = $filedata[49];

                    }
                    $i++;

                }
                fclose($file);

                $count = 0;

                $product = new Product();

                foreach($csvArr as $exceldata){

                        $product->product_code = $exceldata['product_code'];
                        $product->part_category = $exceldata['part_category'];
                        $product->part_category2 = $exceldata['part_category2'];
                        $product->part_category3 = $exceldata['part_category3'];
                        $product->maker_seq = $exceldata['maker_seq'];
                        $product->location_code = $exceldata['location_code'];
                        $product->part_number = $exceldata['part_number'];
                        $product->part_number_sequence = $exceldata['part_number_sequence'];
                        $product->search_word = $exceldata['search_word'];
                        $product->brief_description = $exceldata['brief_description'];
                        $product->date_code = $exceldata['date_code'];
                        $product->image_dir = $exceldata['image_dir'];
                        $product->pdf_dir = $exceldata['pdf_dir'];
                        $product->delivery_code = $exceldata['delivery_code'];
                        $product->api_flg = $exceldata['api_flg'];
                        $product->api_code = $exceldata['api_code'];
                        $product->tariff_rate = $exceldata['tariff_rate'];
                        $product->product_api_id = $exceldata['product_api_id'];
                        $product->qty = $exceldata['qty'];
                        $product->packing_code = $exceldata['packing_code'];
                        $product->wearing_price = $exceldata['wearing_price'];
                        $product->price = $exceldata['price'];
                        $product->leadtime = $exceldata['leadtime'];
                        $product->moq = $exceldata['moq'];
                        $product->mpq = $exceldata['mpq'];
                        $product->stock_location = $exceldata['stock_location'];
                        $product->taxable = $exceldata['taxable'];

                        if ($exceldata['unit_mini_quantity1'] > 0) {
                        $product->selling_price1 = $exceldata['selling_price1'];
                        $product->margin_rate1 = $exceldata['margin_rate1'];
                        $product->unit_mini_quantity1 = $exceldata['unit_mini_quantity1'];
                        $product->unit_max_quantity1 = $exceldata['unit_max_quantity1'];
                        }

                        if ($exceldata['unit_mini_quantity1'] > 0) {
                        $product->selling_price2 = $exceldata['selling_price2'];
                        $product->margin_rate2 = $exceldata['margin_rate2'];
                        $product->unit_mini_quantity2 = $exceldata['unit_mini_quantity2'];
                        $product->unit_max_quantity2 = $exceldata['unit_max_quantity2'];
                        }

                        if ($exceldata['unit_mini_quantity3'] > 0) {
                        $product->selling_price3 = $exceldata['selling_price3'];
                        $product->margin_rate3 = $exceldata['margin_rate3'];
                        $product->unit_mini_quantity3 = $exceldata['unit_mini_quantity3'];
                        $product->unit_max_quantity3 = $exceldata['unit_max_quantity3'];
                        }

                        if ($exceldata['unit_mini_quantity4'] > 0) {
                        $product->selling_price4 = $exceldata['selling_price4'];
                        $product->margin_rate4 = $exceldata['margin_rate4'];
                        $product->unit_mini_quantity4 = $exceldata['unit_mini_quantity4'];
                        $product->unit_max_quantity4 = $exceldata['unit_max_quantity4'];
                        }

                        if ($exceldata['unit_mini_quantity5'] > 0) {
                        $product->selling_price5 = $exceldata['selling_price5'];
                        $product->margin_rate5 = $exceldata['margin_rate5'];
                        $product->unit_mini_quantity5 = $exceldata['unit_mini_quantity5'];
                        $product->unit_max_quantity5 = $exceldata['unit_max_quantity5'];
                        }

                        if ($exceldata['unit_mini_quantity6'] > 0) {
                        $product->selling_price6 = $exceldata['selling_price6'];
                        $product->margin_rate6 = $exceldata['margin_rate6'];
                        $product->unit_mini_quantity6 = $exceldata['unit_mini_quantity6'];
                        $product->unit_max_quantity6 = $exceldata['unit_max_quantity6'];
                        }

                        if ($exceldata['qty'] > 0) {
                            $product->qty_flag = '1';
                        } else {
                            $product->qty_flag = '0';
                        }
                
                        $vrpntem = $exceldata['part_number'].$exceldata['product_api_id'].$exceldata['product_code'].$exceldata['manufacturer_name'];
                        $str = preg_replace("/\s+/", "", $vrpntem);

                        //var_dump($str);
                        //exit;

                        $product->virtualpn = str_replace(array("/", "-", "_", "[", "]", "(", ")", "."), '', $str);

                        //var_dump($product);
                        //exit;

                        if( $this->productModel->insert($product)){
                            $count++;
                        }

                }
                session()->setFlashdata('message', $count.' rows successfully added.');
                session()->setFlashdata('alert-class', 'alert-success');

    }
         return redirect()->route('admin.product.index');   
    }

    function loop_file_check($filename, $filecon, $fileexe){

		$cfg					= array();
		$cfg['allowed_types']	= $fileexe;
		$cfg['file_name']		= $filename.$filecon;
		$cfg['upload_path']	    =  PUBLIC_PATH. 'upload/loopexcel/';
		$cfg['overwrite']		= TRUE;

			$this->fileName = $fileName;
			$this->filePath = $cfg['upload_path'] . $cfg['file_name'] . '.' . $cfg['allowed_types'];

	}

}