<?php namespace App\Controllers\Admin;

use App\Entities\Product;
use App\Entities\ProductmpEvent;
use App\Helpers\ArrayHelper;
use App\Helpers\FileHelper;
use App\Models\ProductModel;
use App\Models\ProductmpModel;
use App\Models\ProductmpEventModel;
use App\Models\ManufacturerModel;
use App\Models\Categorylevel1Model;
use App\Models\Categorylevel2Model;
use App\Models\Categorylevel3Model;
use CodeIgniter\HTTP\RequestInterface;
use App\Models\ApiinfoModel;
use App\Models\EventinfoModel;
use App\Models\ExchangeInfoModel;

class ExcellooptmpController extends BaseController
{
    protected $productModel;
    protected $productmpModel;
    protected $productmpEventModel;
    protected $manufacturerModel;
    protected $categorylevel1Model;
    protected $categorylevel2Model;
    protected $categorylevel3Model;
    protected $apiinfoModel;
    protected $eventinfoModel;
    protected $exchangeInfoModel;

    public function __construct()
    {
        $this->productModel = new ProductModel();
        $this->productmpModel = new ProductmpModel();
        $this->productmpEventModel = new ProductmpEventModel();
        $this->manufacturerModel = new ManufacturerModel();
        $this->categorylevel1Model = new Categorylevel1Model();
        $this->categorylevel2Model = new Categorylevel2Model();
        $this->categorylevel3Model = new Categorylevel3Model();
        $this->apiinfoModel = new ApiinfoModel();
        $this->eventinfoModel = new EventinfoModel();
        $this->exchangeInfoModel = new ExchangeInfoModel();
    }

    public function index()
    {
        //return view('index');
        $data['maxFiles'] = 5;
        $data['apiinfos'] = $this->apiinfoModel->selectAll();
        $data['eventinfos'] = $this->eventinfoModel->getEventinfo();

        // var_dump($data['apiinfos']);
        // exit;
        return $this->viewAdmin('excellooptmp/index',$data);
    }

    public function downloadTemplate(){
        // $fileName = 'loop_data_sample.csv';
        $fileName = 'loop_data_sample.xlsx';
        $filePath = PUBLIC_PATH. 'upload/excel/'.$fileName;
        $this->setHeaderDownload($fileName, $filePath);
        exit;
    }


    public function importCsvToDb()
    {

        // 디렉토리 갯수와 파일의 갯수 구하기

        $file_count =0;

		$loopexcel_path =  PUBLIC_PATH. 'upload/loopexcel/';
        $isDir = is_dir($loopexcel_path);

        if ($isDir) {

        $result = opendir($loopexcel_path); 

		while($file=readdir($result)) {
			
			if($file=="."||$file=="..") {continue;} // file명이 ".", ".." 이면 무시함
			$fileInfo = pathinfo($file);
			$fileExt = $fileInfo['extension']; // 파일의 확장자를 구함

			If (empty($fileExt)){
			$dir_count++; // 파일에 확장자가 없으면 디렉토리로 판단하여 dir_count를 증가시킴
			} else {
			$file_count++;// 파일에 확장자가 있으면 file_count를 증가시킴
			}

		}

        // echo"디렉토리 갯수는:".$dir_count."<br>";
  		// echo"파일의 갯수는:".$file_count."<br>";
        // var_dump($file_count);
        // exit;

    // 디렉토리 갯수와 파일의 갯수 구하기 끝

	$file_countend = $file_count;

	for ($file_count =1;$file_count < $file_countend;$file_count ++) {
			
            $filecon = $file_count;
            $bs_filename = 'loop_data_';

            $this->loop_file_check($bs_filename, $filecon, 'csv');
            $loopfilepath = $this->filePath;
            //var_dump($loopfilepath);
            //echo"<br>";
            //exit;

                $file = fopen($loopfilepath,"r");
                
                $i = 0;
                $numberOfFields = 64;
                $csvArr = array();
                while (($filedata = fgetcsv($file, 1000, ",")) !== FALSE) {

                    $num = count($filedata);

                    $allProduct = $this->productModel->countAll();

                    if($i > 0 && $num == $numberOfFields){ 
                        
                        if ($filedata[0]) {
                            $csvArr[$i]['product_code'] = $filedata[0];
                        }else{

                            $totalproduct_count = $allProduct+$i;
                            $codecount = str_pad($totalproduct_count, 9, "0", STR_PAD_LEFT);
                            $csvArr[$i]['product_code'] = "C".$codecount;

                            /*
                            $timestr = date(time());
                            $codestr = substr($timestr, 4);
                            $codecount = str_pad($i, 6, "0", STR_PAD_LEFT);
                            $csvArr[$i]['product_code'] = "CD".$codestr.$codecount;
                            */                    
                        }

                        if ($filedata[1]) {
                            $categorylevel1 = $this->categorylevel1Model->findByCategoryInfo($filedata[1]);
                            $csvArr[$i]['part_category'] = $categorylevel1['categorylevel1_code'];
                        }else{
                            $csvArr[$i]['part_category'] =  "000";                            
                        }

                        if ($filedata[2]) {
                            $categorylevel2 = $this->categorylevel2Model->findByCategoryInfo($filedata[2]);
                            $csvArr[$i]['part_category2'] = $categorylevel2['categorylevel2_code'];
                        }else{
                            $csvArr[$i]['part_category2'] =  "0000";                            
                        }

                        if ($filedata[3]) {
                            $manufacturer = $this->manufacturerModel->findByManufactureId($filedata[3]);
                            $csvArr[$i]['maker_seq'] = $manufacturer->maker_seq;
                            $csvArr[$i]['manufacturer_name'] = $manufacturer->name;
                        } else {
                            $csvArr[$i]['maker_seq'] = "0";
                            $csvArr[$i]['manufacturer_name'] = "Not";
                        }

                        $csvArr[$i]['location_code'] = $filedata[4];
                        $csvArr[$i]['part_number'] = $filedata[5];
                        $csvArr[$i]['part_number_sequence'] = preg_replace("/\s+/", "", $manufacturer->name.$filedata[6]); // 수정필요
                        $csvArr[$i]['search_word'] = $filedata[7];
                        $csvArr[$i]['brief_description'] = $filedata[8];
                        $csvArr[$i]['description'] = $filedata[9];
                        $csvArr[$i]['date_code'] = $filedata[10];
                        $csvArr[$i]['image_dir'] = $filedata[11];
                        $csvArr[$i]['image2_dir'] = $filedata[12];
                        $csvArr[$i]['image3_dir'] = $filedata[13];
                        $csvArr[$i]['pdf_dir'] = $filedata[14];
                        $csvArr[$i]['delivery_code'] = $filedata[15];
                        $csvArr[$i]['api_flg'] = $filedata[16];
                        $csvArr[$i]['api_code']  = $filedata[17];
                        $csvArr[$i]['tariff_rate']  = $filedata[18];
                        $csvArr[$i]['product_api_id'] = $filedata[19];
                        $csvArr[$i]['qty'] = $filedata[20];
                        $csvArr[$i]['packing_code'] = $filedata[21];
                        $csvArr[$i]['price'] = $filedata[22];
                        $csvArr[$i]['leadtime'] = $filedata[23];
                        $csvArr[$i]['moq'] = $filedata[24];
                        $csvArr[$i]['mpq'] = $filedata[25];
                        $csvArr[$i]['stock_location'] = $filedata[26];
                        $csvArr[$i]['taxable'] = $filedata[27];
                        $csvArr[$i]['selling_price1'] = $filedata[28];
                        $csvArr[$i]['prices_price1'] = $filedata[29];
                        $csvArr[$i]['prices_currency1'] = $filedata[30];
                        $csvArr[$i]['margin_rate1'] = $filedata[31];
                        $csvArr[$i]['unit_mini_quantity1'] = $filedata[32];
                        $csvArr[$i]['unit_max_quantity1'] = $filedata[33];
                        $csvArr[$i]['selling_price2'] = $filedata[34];
                        $csvArr[$i]['prices_price2'] = $filedata[35];
                        $csvArr[$i]['prices_currency2'] = $filedata[36];
                        $csvArr[$i]['margin_rate2'] = $filedata[37];
                        $csvArr[$i]['unit_mini_quantity2'] = $filedata[38];
                        $csvArr[$i]['unit_max_quantity2'] = $filedata[39];
                        $csvArr[$i]['selling_price3'] = $filedata[40];
                        $csvArr[$i]['prices_price3'] = $filedata[41];
                        $csvArr[$i]['prices_currency3'] = $filedata[42];
                        $csvArr[$i]['margin_rate3'] = $filedata[43];
                        $csvArr[$i]['unit_mini_quantity3'] = $filedata[44];
                        $csvArr[$i]['unit_max_quantity3'] = $filedata[45];
                        $csvArr[$i]['selling_price4'] = $filedata[46];
                        $csvArr[$i]['prices_price4'] = $filedata[47];
                        $csvArr[$i]['prices_currency4'] = $filedata[48];
                        $csvArr[$i]['margin_rate4'] = $filedata[49];
                        $csvArr[$i]['unit_mini_quantity4'] = $filedata[50];
                        $csvArr[$i]['unit_max_quantity4'] = $filedata[51];
                        $csvArr[$i]['selling_price5'] = $filedata[52];
                        $csvArr[$i]['prices_price5'] = $filedata[53];
                        $csvArr[$i]['prices_currency5'] = $filedata[54];
                        $csvArr[$i]['margin_rate5'] = $filedata[55];
                        $csvArr[$i]['unit_mini_quantity5'] = $filedata[56];
                        $csvArr[$i]['unit_max_quantity5'] = $filedata[57];
                        $csvArr[$i]['selling_price6'] = $filedata[58];
                        $csvArr[$i]['prices_price6'] = $filedata[59];
                        $csvArr[$i]['prices_currency6'] = $filedata[60];
                        $csvArr[$i]['margin_rate6'] = $filedata[61];
                        $csvArr[$i]['unit_mini_quantity6'] = $filedata[62];
                        $csvArr[$i]['unit_max_quantity6'] = $filedata[63];

                        //var_dump($csvArr[$i]);
                        //exit;

                    }
                    $i++;

                }
                fclose($file);

                $count = 0;

                $product = new Product();

                foreach($csvArr as $exceldata){
                        
                    // $manufacturer = $this->manufacturerModel->findByManufactureId($filedata[3]);
                    // $csvArr[$i]['maker_seq'] = $manufacturer->maker_seq;

                        $product->product_code = $exceldata['product_code'];
                        $product->part_category = $exceldata['part_category'];
                        $product->part_category2 = $exceldata['part_category2'];
                        // $product->part_category3 = $exceldata['part_category3'];

                        $product->maker_seq = $exceldata['maker_seq'];
                        $product->location_code = $exceldata['location_code'];
                        $product->part_number = $exceldata['part_number'];
                        $product->part_number_sequence = $exceldata['part_number_sequence'];
                        $product->search_word = $exceldata['search_word'];
                        $product->brief_description = $exceldata['brief_description'];
                        $product->description = $exceldata['description'];
                        $product->date_code = $exceldata['date_code'];
                        $product->image_dir = $exceldata['image_dir'];
                        $product->image2_dir = $exceldata['image2_dir'];
                        $product->image3_dir = $exceldata['image3_dir'];
                        $product->pdf_dir = $exceldata['pdf_dir'];
                        $product->delivery_code = $exceldata['delivery_code'];
                        $product->api_flg = $exceldata['api_flg'];
                        $product->api_code = $exceldata['api_code'];
                        $product->tariff_rate = $exceldata['tariff_rate'];
                        $product->product_api_id = $exceldata['product_api_id'];
                        $product->qty = $exceldata['qty'];
                        $product->packing_code = $exceldata['packing_code'];
                        $product->price = $exceldata['price'];
                        $product->leadtime = $exceldata['leadtime'];
                        $product->moq = $exceldata['moq'];
                        $product->mpq = $exceldata['mpq'];
                        $product->stock_location = $exceldata['stock_location'];
                        $product->taxable = $exceldata['taxable'];

                        if ($exceldata['unit_mini_quantity1'] > 0) {
                            $ExchangeRat1 = $this->exchangeInfoModel->where('counrty_code',$exceldata['prices_currency1'])->orderBy('created_at desc')->first();
                            $exchange_rat1 = $ExchangeRat1->standard_amount;
        
                            $product->selling_price1 = $exceldata['prices_price1']*$exchange_rat1;
                            $product->prices_price1 = $exceldata['prices_price1'];
                            $product->prices_currency1 = $exceldata['prices_currency1'];
                            $product->margin_rate1 = $exceldata['margin_rate1'];
                            $product->unit_mini_quantity1 = $exceldata['unit_mini_quantity1'];
                            $product->unit_max_quantity1 = $exceldata['unit_max_quantity1'];
                        }
    
                        if ($exceldata['unit_mini_quantity2'] > 0) {
                            $ExchangeRat2 = $this->exchangeInfoModel->where('counrty_code',$exceldata['prices_currency2'])->orderBy('created_at desc')->first();
                            $exchange_rat2 = $ExchangeRat2->standard_amount;
            
                            $product->selling_price2 = $exceldata['prices_price2']*$exchange_rat2;
                            $product->prices_price2 = $exceldata['prices_price2'];
                            $product->prices_currency2 = $exceldata['prices_currency2'];
                            $product->margin_rate2 = $exceldata['margin_rate2'];
                            $product->unit_mini_quantity2 = $exceldata['unit_mini_quantity2'];
                            $product->unit_max_quantity2 = $exceldata['unit_max_quantity2'];
                        }
    
                        if ($exceldata['unit_mini_quantity3'] > 0) {
                            $ExchangeRat3 = $this->exchangeInfoModel->where('counrty_code',$exceldata['prices_currency3'])->orderBy('created_at desc')->first();
                            $exchange_rat3 = $ExchangeRat3->standard_amount;
                
                            $product->selling_price3 = $exceldata['prices_price3']*$exchange_rat3;
                            $product->prices_price3 = $exceldata['prices_price3'];
                            $product->prices_currency3 = $exceldata['prices_currency3'];
                            $product->margin_rate3 = $exceldata['margin_rate3'];
                            $product->unit_mini_quantity3 = $exceldata['unit_mini_quantity3'];
                            $product->unit_max_quantity3 = $exceldata['unit_max_quantity3'];
                        }
        
                        if ($exceldata['unit_mini_quantity4'] > 0) {
                            $ExchangeRat4 = $this->exchangeInfoModel->where('counrty_code',$exceldata['prices_currency4'])->orderBy('created_at desc')->first();
                            $exchange_rat4 = $ExchangeRat4->standard_amount;
                    
                            $product->selling_price4 = $exceldata['prices_price4']*$exchange_rat4;
                            $product->prices_price4 = $exceldata['prices_price4'];
                            $product->prices_currency4 = $exceldata['prices_currency4'];
                            $product->margin_rate4 = $exceldata['margin_rate4'];
                            $product->unit_mini_quantity4 = $exceldata['unit_mini_quantity4'];
                            $product->unit_max_quantity4 = $exceldata['unit_max_quantity4'];
                        }
    
                        if ($exceldata['unit_mini_quantity5'] > 0) {
                            $ExchangeRat5 = $this->exchangeInfoModel->where('counrty_code',$exceldata['prices_currency5'])->orderBy('created_at desc')->first();
                            $exchange_rat5 = $ExchangeRat5->standard_amount;
                        
                            $product->selling_price5 = $exceldata['prices_price5']*$exchange_rat5;
                            $product->prices_price5 = $exceldata['prices_price5'];
                            $product->prices_currency5 = $exceldata['prices_currency5'];
                            $product->margin_rate5 = $exceldata['margin_rate5'];
                            $product->unit_mini_quantity5 = $exceldata['unit_mini_quantity5'];
                            $product->unit_max_quantity5 = $exceldata['unit_max_quantity5'];
                        }
    
                        if ($exceldata['unit_mini_quantity6'] > 0) {
                            $ExchangeRat6 = $this->exchangeInfoModel->where('counrty_code',$exceldata['prices_currency6'])->orderBy('created_at desc')->first();
                            $exchange_rat6 = $ExchangeRat6->standard_amount;
                        
                            $product->selling_price6 = $exceldata['prices_price6']*$exchange_rat6;
                            $product->prices_price6 = $exceldata['prices_price6'];
                            $product->prices_currency6 = $exceldata['prices_currency6'];
                            $product->margin_rate6 = $exceldata['margin_rate6'];
                            $product->unit_mini_quantity6 = $exceldata['unit_mini_quantity6'];
                            $product->unit_max_quantity6 = $exceldata['unit_max_quantity6'];
                        }
    
                        if ($exceldata['qty'] > 0) {
                            $product->qty_flag = '1';
                        } else {
                            $product->qty_flag = '0';
                        }                

                        $vrpntem = $exceldata['part_number'].$exceldata['product_api_id'].$exceldata['product_code'].$exceldata['manufacturer_name'];
                        $str = preg_replace("/\s+/", "", $vrpntem);
                        $product->virtualpn = str_replace(array("/", "-", "_", "[", "]", "(", ")", "."), '', $str);

                        // var_dump($product);
                        // $this->productmpModel->insert($product);
                        // exit;

                        if( $this->productmpModel->insert($product)){
                            $count++;
                        }

                }

                $count_all = $count_all + $count;

    }

            $message = $count_all."개의 제품이 임시등록되었습니다.";
            return redirect()->route('admin.productmp.looptmp.index')->with('message',$message);
        } else {
            $message = "등록된 파일이 없습니다.";
            return redirect()->route('admin.productmp.looptmp.index')->with('message',$message);
        }

    }


    function insertProducts(){

        $count_tmp = $this->productmpModel->insertProducts();

        session()->setFlashdata('message', ' Successfully Insert.');
        session()->setFlashdata('alert-class', 'alert-success');

        return redirect()->route('admin.product.index'); 

	}

    function updateProducts(){

        $api_code = $this->request->getPost('api_code');

        // var_dump($api_code);
        // exit;

        if ($api_code == "SP") {

            $this->productmpModel->updateProducts();
            session()->setFlashdata('message',  ' Successfully Update.');
            session()->setFlashdata('alert-class', 'alert-success');

        } elseif ($api_code == "LC" || $api_code == "ICK") {

            $this->productmpModel->updatApiProducts($api_code);
            session()->setFlashdata('message',  ' Successfully Update.');
            session()->setFlashdata('alert-class', 'alert-success');

        } else {

        }

        return redirect()->route('admin.product.index'); 

	}
    
    /*
    function updateRsProducts(){

        $count_tmp = $this->productmpModel->updateRsProducts();

        session()->setFlashdata('message',  ' Successfully RSQty Update.');
        session()->setFlashdata('alert-class', 'alert-success');

        return redirect()->route('admin.product.index'); 

	}

    */

    function loop_file_check($filename, $filecon, $fileexe){

		$cfg					= array();
		$cfg['allowed_types']	= $fileexe;
		$cfg['file_name']		= $filename.$filecon;
		$cfg['upload_path']	    =  PUBLIC_PATH. 'upload/loopexcel/';
		$cfg['overwrite']		= TRUE;

			$this->fileName = $fileName;
			$this->filePath = $cfg['upload_path'] . $cfg['file_name'] . '.' . $cfg['allowed_types'];

	}

    function event_file_check($filename, $filecon, $fileexe){

		$cfg					= array();
		$cfg['allowed_types']	= $fileexe;
		$cfg['file_name']		= $filename.$filecon;
		$cfg['upload_path']	    =  PUBLIC_PATH. 'upload/eventexcel/';
		$cfg['overwrite']		= TRUE;

			$this->fileName = $fileName;
			$this->filePath = $cfg['upload_path'] . $cfg['file_name'] . '.' . $cfg['allowed_types'];

	}

    public function upload(){
        $files = $this->request->getFiles();

        if(isset($files)){

            $file_count= 1;

            foreach ($files as $file){
                $fileName = $file->getClientName();

                if(isset($fileName) && !empty($fileName)){
                    $filePath = FileHelper::saveExFile($file, FileHelper::FOLDER_PATCH_UPLOAD_LOOPEXCEL, $file_count);
                }

            }

        }

        return redirect()->route('admin.productmp.looptmp.index');  
    }


    public function downloadEventTemp(){
        $fileName = 'event_data_sample.xlsx';
        $filePath = PUBLIC_PATH. 'upload/excel/'.$fileName;
        $this->setHeaderDownload($fileName, $filePath);
        exit;
    }

    public function importEventCsvToDb()
    {

        // 디렉토리 갯수와 파일의 갯수 구하기

        $file_count =0;

		$loopexcel_path =  PUBLIC_PATH. 'upload/eventexcel/';
        $isDir = is_dir($loopexcel_path);

        if ($isDir) {

        $result = opendir($loopexcel_path); 

		while($file=readdir($result)) {
			
			if($file=="."||$file=="..") {continue;} // file명이 ".", ".." 이면 무시함
			$fileInfo = pathinfo($file);
			$fileExt = $fileInfo['extension']; // 파일의 확장자를 구함

			If (empty($fileExt)){
			$dir_count++;
			} else {
			$file_count++;
			}

		}

        $file_countend = $file_count;

        for ($file_count =1;$file_count < $file_countend;$file_count ++) {
                $filecon = $file_count;
                $bs_filename = 'loop_data_';

                $this->event_file_check($bs_filename, $filecon, 'csv');
                $loopfilepath = $this->filePath;

                    $file = fopen($loopfilepath,"r");
                    
                    $i = 0;
                    $numberOfFields = 3;
                    $csvArr = array();
                    
                    while (($filedata = fgetcsv($file, 1000, ",")) !== FALSE) {
                        $num = count($filedata);

                        if($i > 0 && $num == $numberOfFields){ 
                            $csvArr[$i]['product_code'] = $filedata[0];
                            $csvArr[$i]['part_number'] = $filedata[1];
                            $csvArr[$i]['replacement_items'] = $filedata[2];

                        }
                        $i++;

                    }
                    fclose($file);

                    $count = 0;

                    $productmpevent = new ProductmpEvent();

                    foreach($csvArr as $exceldata){

                            $productmpevent->product_code = $exceldata['product_code'];
                            $productmpevent->part_number = $exceldata['part_number'];
                            $productmpevent->replacement_items = $exceldata['replacement_items'];


                            // var_dump($productmpevent);
                            // $this->productmpEventModel->insert($productmpevent);
                            // exit;

                            if( $this->productmpEventModel->insert($productmpevent)){
                                $count++;
                            }

                    }

                    $count_all = $count_all + $count;

        }

            $message = $count_all."개의 제품이 임시등록되었습니다.";
            return redirect()->route('admin.productmp.looptmp.index')->with('message',$message);
        } else {
            $message = "등록된 파일이 없습니다.";
            return redirect()->route('admin.productmp.looptmp.index')->with('message',$message);
        }

    }

    public function uploadEvent(){
        $files = $this->request->getFiles();

        if(isset($files)){

            $file_count= 1;

            foreach ($files as $file){
                $fileName = $file->getClientName();

                if(isset($fileName) && !empty($fileName)){
                    $filePath = FileHelper::saveExFile($file, FileHelper::FOLDER_PATCH_UPLOAD_EVENTEXCEL, $file_count);
                }

            }

        }

        return redirect()->route('admin.productmp.looptmp.index');  
    }


    public function upReplacItems(){
        $this->productmpEventModel->updateReplacItems();
        return redirect()->route('admin.productmp.looptmp.index');  
    }

    public function upEventItems(){
        $event_set = $this->request->getPost('event_set');
        $this->productmpEventModel->updatEventItems($event_set);

        return redirect()->route('admin.productmp.looptmp.index');  
    }

    public function upNavershopItems(){
        $navershop_chk = $this->request->getPost('navershop_chk');

        if ($navershop_chk == '0') {
            $navershop_status = '';
        } elseif ($navershop_chk == '2') {
            $navershop_status = 'D';
        } elseif ($navershop_chk == '3') {
            $navershop_status = 'U';
        } else {
            $navershop_status = 'I';
        }


        $this->productmpEventModel->updatNavershopItems($navershop_chk, $navershop_status);

        return redirect()->route('admin.productmp.looptmp.index');  
    }

    public function deleteFile(){
        FileHelper::deleteCSVFile( FileHelper::FOLDER_PATCH_UPLOAD_LOOPEXCEL);
        $this->productmpModel->eraseTempProducts();

        $message = "이전 작업파일을 삭제했습니다.";
        return redirect()->route('admin.productmp.looptmp.index')->with('message',$message);;
    }

    public function deleteEventFile(){
        FileHelper::deleteCSVFile( FileHelper::FOLDER_PATCH_UPLOAD_EVENTEXCEL);
        $this->productmpEventModel->eraseTempProducts();

        $message = "이전 작업파일을 삭제했습니다.";
        return redirect()->route('admin.productmp.looptmp.index')->with('message',$message);;
    }

}