<?php namespace App\Controllers\Admin;

use App\Controllers\Common\SessionConstant;
use App\Helpers\AuthHelpers;
use App\Models\AccountManagerModel;
use App\Entities\OrderInfo;
use App\Models\OrderInfoModel;
use App\Models\MemberModel;
use App\Models\One2oneModel;
use App\Models\InquiryModel;
use App\Models\EstimateModel;
use App\Models\DeferredpayModel;
use App\Models\ReviewModel;
use App\Models\NewModel;
use App\Models\ProductModel;
use App\Models\TodaystatModel;
use App\Models\ShowwindowModel;
// use App\Models\SearchRankingModel;
use App\Models\SearchTodayModel;
use App\Models\ProductExportModel;
use App\Models\ApiStatusModel;

class HomeController extends BaseController
{
    protected $orderInfoModel;
    protected $memberModel;
    protected $one2oneModel;
    protected $inquiryModel;
    protected $estimateModel;
    protected $deferredpayModel;
    protected $reviewModel;
    protected $newsModel;
    protected $productModel;
    protected $todaystatModel;
    protected $showwindowModel;
    // protected $searchrankingModel;
    protected $searchTodayModel;
    protected $productExportModel;
    protected $apiStatusModel;

    public function __construct()
    {
        $this->orderInfoModel = new OrderInfoModel();
        $this->memberModel = new MemberModel();
        $this->one2oneModel = new One2oneModel();
        $this->inquiryModel = new InquiryModel();
        $this->estimateModel = new EstimateModel();
        $this->deferredpayModel = new DeferredpayModel();
        $this->reviewModel = new ReviewModel();
        $this->newsModel = new NewModel();
        $this->productModel = new ProductModel();
        $this->todaystatModel = new TodaystatModel();
        $this->showwindowModel = new ShowwindowModel();
        // $this->searchrankingModel = new SearchRankingModel();
        $this->searchTodayModel = new SearchTodayModel();
        $this->productExportModel = new ProductExportModel();
        $this->apiStatusModel = new ApiStatusModel();
    }


    public function index()
    {
        $today = date('Y-m-d', time());
        //$today = "2023-10-18";
        //var_dump($today);
        //echo "<br>";

        
        $lcApiStatus = $this->apiStatusModel->where("created_at >=",$today)->where('active_flg', 1)->Like('api_code','LC')->findAll();
        $data['lcapierror_count'] = count($lcApiStatus);
        $IckApiStatus = $this->apiStatusModel->where("created_at >=",$today)->where('active_flg', 1)->Like('api_code','ICK')->findAll();
        $data['ickapierror_count'] = count($IckApiStatus);

        // echo $data['lcapierror_count']."<br>".$data['ickapierror_count'];
        // exit;

        $todayOrder = $this->orderInfoModel->where("created_at >=",$today)->findAll();
        $data['todayOrder_count'] = count($todayOrder);
        $todayPay = $this->orderInfoModel->where("payment_date >=",$today)->findAll();
        $data['todayPay_count'] = count($todayPay);
        $todaySales = $this->orderInfoModel->where("created_at >=",$today)->selectSum('supply_price', 'sumQuantities')->get()->getRow()->sumQuantities;
        if ($todaySales) {
            $data['todaySales'] = $todaySales;
        } else {
            $data['todaySales'] = "0";
        }
        $todaySignUp = $this->memberModel->where("created_at >=",$today)->findAll();
        $data['todaySignUp_count'] = count($todaySignUp);

        $day30ago = date('Y-m-d', strtotime('-30 Day'));
        $day30Order = $this->orderInfoModel->where("created_at >=",$day30ago)->findAll();
        $data['day30Order_count'] = count($day30Order);   
        $day30Preparing = $this->orderInfoModel->where("created_at >=",$day30ago)->Like('order_status','4')->findAll();
        $data['day30Preparing_count'] = count($day30Preparing);
        $day30Shipping = $this->orderInfoModel->where("created_at >=",$day30ago)->Like('order_status','5')->findAll();
        $data['day30Shipping_count'] = count($day30Shipping);
        $day30Complete = $this->orderInfoModel->where("created_at >=",$day30ago)->Like('order_status','8')->findAll();
        if ($day30Complete) {
            $data['day30Complete_count'] = count($day30Complete);
        } else {
            $data['day30Complete_count'] = "0";
        }
        $day30Cancel = $this->orderInfoModel->Where("created_at >=",$day30ago)->Like('order_status','9')->orLike('order_status','10')->findAll();
        $data['day30Cancel_count'] = count($day30Cancel);
        $day30Return = $this->orderInfoModel->Where("created_at >=",$day30ago)->Like('order_status','12')->findAll();
        $data['day30Return_count'] = count($day30Return);
        $day30Nullity = $this->orderInfoModel->Where("created_at >=",$day30ago)->Like('order_status','11')->findAll();
        $data['day30Nullity_count'] = count($day30Nullity);

        $day30One2one = $this->one2oneModel->Where("created_at >=",$day30ago)->Like('del_flg','0')->findAll();
        $data['day30One2one_count'] = count($day30One2one);
        $day30Inquiry = $this->inquiryModel->Where("created_at >=",$day30ago)->Like('del_flg','0')->findAll();
        $data['day30Inquiry_count'] = count($day30Inquiry);
        $day30Estimate = $this->estimateModel->Where("created_at >=",$day30ago)->Like('del_flg','0')->findAll();
        $data['day30Estimate_count'] = count($day30Estimate);
        $day30Deferredpay = $this->deferredpayModel->Where("created_at >=",$day30ago)->Like('del_flg','0')->findAll();
        $data['day30Deferredpay_count'] = count($day30Deferredpay);
        $day30Review = $this->reviewModel->Where("created_at >=",$day30ago)->Like('del_flg','0')->findAll();
        $data['day30Review_count'] = count($day30Review);
        $day30News = $this->newsModel->Where("created_at >=",$day30ago)->Like('del_flg','0')->findAll();
        $data['day30News_count'] = count($day30News);

        $data['todayProductStat'] = $this->todaystatModel->getSearch($searchInput,1);
        
        $data['Searchranking'] = $this->searchTodayModel->getSearch($searchInput,5);
        
        $data['todayStat'] = $this->todaystatModel->getSearch($searchInput,30);
        $data['todayStat2'] = $this->todaystatModel->getSearch($searchInput,14);

        $data['One2one'] = $this->one2oneModel->getSearch($searchInput,5);
        // $data['Review'] = $this->reviewModel->getSearch($searchInput,5);
        $data['Estimate'] = $this->estimateModel->getSearch($searchInput,5);

        //$estimate = $this->estimateModel->getSearch($searchInput,5);
        //var_dump($estimate);
        //exit;

        $data['Inquiry'] = $this->inquiryModel->getSearch($searchInput,5);

        return $this->viewAdmin('home', $data);

    }

}
