<?php namespace App\Controllers\Admin;

use App\Entities\IcKingInfo;
use App\Entities\ExchangeInfo;
use App\Helpers\FileHelper;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\IcKingInfoModel;
use App\Models\IcKingPndataModel;
use App\Models\ExchangeInfoModel;

class IcKingInfoController extends BaseController
{
    protected $icKingInfoModel;
    protected $icKingPndataModel;
    protected $exchangeInfoModel;

    public function __construct()
    {
        $this->icKingInfoModel = new IcKingInfoModel();
        $this->icKingPndataModel = new IcKingPndataModel();
        $this->exchangeInfoModel = new ExchangeInfoModel();
    }


    public function index()
    {
        // echo "Test OK!!";
        // exit;

        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if(isset($searchInput['mpn']) && $searchInput['mpn'] != '') $searchInput['is_search'] = true;
        $data = $this->icKingInfoModel->getAdmin($searchInput,$perPage);
        return $this->viewAdmin('ickinginfo/index',array_merge($data,$searchInput));
    }


    public function itemToDb()
    {
        // echo "Test itemToDb!!";
        // exit;

        $appid = 'SELPASEMICOM$CO$LTD_690';
        $appkey = '51d3afa11c937ae7ea0d8c4a4a77c5c9';
        $timestamp = time();

        $sign = md5('_t='.$timestamp.'&appid='.$appid.'|'.$appkey);

        $url = 'https://openapi.ickey.cn/v2/new-token/create';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded';
        $headers[] = 'Accept: application/json';
        $headers[] = 'Cache-Control: no-cache';

        $host_info = explode("/", $url);
        $port = $host_info[0] == 'https:' ? 443 : 80;
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_PORT, $port);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, 'appid='.$appid.'&_t='.$timestamp.'&sign='.$sign);

        $response = curl_exec($ch);
        curl_close($ch);

        if (!$response) {

            echo 'no response';
            exit;

        }else{
            $tokenres = json_decode($response,true);
            $token = $tokenres["result"]["token"];
            // echo $token."<br>";
            // exit;

            

                
            ////////////////////////////////////////

            $incount = "100"; // test
            $api_code = "ICK";
            $rsApiIds = $this->icKingPndataModel->getIcKingId($api_code);
    
            // var_dump (count($rsApiIds));
            // exit;
    
            if (count($rsApiIds) > 0) {
                foreach ($rsApiIds as $key => $itemId):
                    
                    if  ($incount > $key) {

                    // $keyword = "pic16f";
                    $keyword = $itemId->keyword;

            // var_dump ($keyword);
            // exit;
            ///////////////////////////////////////


            $url = 'https://openapi.ickey.cn/search-v1/products/get-single-goods-new';
            $headers[] = 'Content-Type: application/x-www-form-urlencoded';
            $headers[] = 'Accept: application/json';
            $headers[] = 'Cache-Control: no-cache';

            $host_info = explode("/", $url);
            $port = $host_info[0] == 'https:' ? 443 : 80;
            $ch_item = curl_init();

            curl_setopt($ch_item, CURLOPT_PORT, $port);
            curl_setopt($ch_item, CURLOPT_URL, $url);
            curl_setopt($ch_item, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch_item, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch_item, CURLOPT_POSTFIELDS, 'token='.$token.'&_t='.$timestamp.'&keyword='.$keyword);

            $response_item = curl_exec($ch_item);

            curl_close($ch_item);

            if (!$response_item) {

                echo '<br>no response';

            }else{


                $details = json_decode($response_item,true);
                $results = $details["result"];

                $jsonRow = count($results);

                $ickinginfo = new IcKingInfo();

                // var_dump($jsonRow);
                // echo "<br>";
                // var_dump($results);

            
                if ($results) {
                    for($i=0;$i <= $jsonRow;$i++){

                        // echo $i." : ";
                        // var_dump($results[$i]);
                        // echo "<br>";

                        $issku = $results[$i]["sku"];

                        $isskucount = $this->icKingInfoModel->getIcKingCount($issku);

                        // echo $issku." / ".$isskucount."<br>";

                        if ($isskucount == 0) {
                            $ickinginfo->supplier = $results[$i]["supplier"];
                            $ickinginfo->sku = $results[$i]["sku"];
                            $ickinginfo->pro_name = $results[$i]["pro_name"];
                            $ickinginfo->pro_maf = $results[$i]["pro_maf"];
                            $ickinginfo->pro_desc = $results[$i]["pro_desc"];
                            $ickinginfo->date_code = $results[$i]["date_code"];
                            $ickinginfo->package = $results[$i]["package"];
                            $ickinginfo->stock = $results[$i]["stock"];
                            $ickinginfo->moq = $results[$i]["moq"];
                            $ickinginfo->spq = $results[$i]["spq"];
                            $ickinginfo->rmb0 = $results[$i]["rmb"][0];
                            $ickinginfo->rmb1 = $results[$i]["rmb"][1];
                            $ickinginfo->rmb2 = $results[$i]["rmb"][2];
                            $ickinginfo->rmb3 = $results[$i]["rmb"][3];
                            $ickinginfo->rmb4 = $results[$i]["rmb"][4];
                            $ickinginfo->rmb5 = $results[$i]["rmb"][5];
                            $ickinginfo->rmb6 = $results[$i]["rmb"][6];
                            $ickinginfo->rmb7 = $results[$i]["rmb"][7];
                            $ickinginfo->nums0 = $results[$i]["nums"][0];
                            $ickinginfo->nums1 = $results[$i]["nums"][1];
                            $ickinginfo->nums2 = $results[$i]["nums"][2];
                            $ickinginfo->nums3 = $results[$i]["nums"][3];
                            $ickinginfo->nums4 = $results[$i]["nums"][4];
                            $ickinginfo->nums5 = $results[$i]["nums"][5];
                            $ickinginfo->nums6 = $results[$i]["nums"][6];
                            $ickinginfo->nums7 = $results[$i]["nums"][7];
                            $ickinginfo->lead_time_cn = $results[$i]["lead_time_cn"];
                            $ickinginfo->data_sheet = $results[$i]["data_sheet"];
                            $ickinginfo->footprint = $results[$i]["footprint"];
                            $ickinginfo->cate_name = $results[$i]["cate_name"];
                            $ickinginfo->mpq = $results[$i]["mpq"];
                            $ickinginfo->img_url = $results[$i]["img_url"];
                            $ickinginfo->detail_url = $results[$i]["detail_url"];
                            $ickinginfo->is_cwh = $results[$i]["is_cwh"];
                            $ickinginfo->is_yx = $results[$i]["is_yx"];
                            $ickinginfo->usd0 = $results[$i]["usd"][0];
                            $ickinginfo->usd1 = $results[$i]["usd"][1];
                            $ickinginfo->usd2 = $results[$i]["usd"][2];
                            $ickinginfo->usd3 = $results[$i]["usd"][3];
                            $ickinginfo->usd4 = $results[$i]["usd"][4];
                            $ickinginfo->usd5 = $results[$i]["usd"][5];
                            $ickinginfo->usd6 = $results[$i]["usd"][6];
                            $ickinginfo->usd7 = $results[$i]["usd"][7];
                            $ickinginfo->lead_time_hk = $results[$i]["lead_time_hk"];

                            if ($results[$i]["pro_name"]) {
                                $this->icKingInfoModel->save($ickinginfo);
                            }
                        }

                    }

                }
            
            }

                $this->icKingPndataModel->updateActiveFlg($keyword);
                // 2초 지연 서버속도 맞춤.
                time_sleep_until(time() + 2);

            ////////////////////////////////////////

                    }

                endforeach;
            }

            ///////////////////////////////////////

        }

    }

    public function toProductInfo(){

        $this->icKingInfoModel->tidyupProductInfo();
        //exit;

        $counrty_code = "CNY";
        $ExchangeRat = $this->exchangeInfoModel->where('counrty_code',$counrty_code)->orderBy('created_at desc')->first();
        $exchange_rat = $ExchangeRat->standard_amount;

        $this->icKingInfoModel->insertProductInfo($exchange_rat);
        $this->icKingInfoModel->replaceProductInfo();

        $message = '제품정보를 등록 했습니다.';
        return redirect()->route('admin.productcreate.create_ok')->with('message', $message);

    }

    public function skuInfo()
    {
    
        $appid = 'SELPASEMICOM$CO$LTD_690';
        $appkey = '51d3afa11c937ae7ea0d8c4a4a77c5c9';
        $timestamp = time();

        $sign = md5('_t='.$timestamp.'&appid='.$appid.'|'.$appkey);

        $url = 'https://openapi.ickey.cn/v2/new-token/create';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded';
        $headers[] = 'Accept: application/json';
        $headers[] = 'Cache-Control: no-cache';

        $host_info = explode("/", $url);
        $port = $host_info[0] == 'https:' ? 443 : 80;
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_PORT, $port);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, 'appid='.$appid.'&_t='.$timestamp.'&sign='.$sign);

        $response = curl_exec($ch);
        curl_close($ch);

        if (!$response) {

            echo 'no response';
            exit;
        }else{

            $tokenres = json_decode($response,true);
            $token = $tokenres["result"]["token"];
        
            $limit = 5;
            $skulist = $this->icKingInfoModel->getSku($limit);

            foreach ($skulist['lists'] as $key => $item){
                $sku .= '&sku['.$key.']='.$item->sku;

            }

            echo $sku;
            exit;

            $url = 'https://openapi.ickey.cn/search-v1/products/sku-info';
            $headers[] = 'Content-Type: application/x-www-form-urlencoded';
            $headers[] = 'Accept: application/json';
            $headers[] = 'Cache-Control: no-cache';
        
            $host_info = explode("/", $url);
            $port = $host_info[0] == 'https:' ? 443 : 80;
            $ch_item = curl_init();
        
            curl_setopt($ch_item, CURLOPT_PORT, $port);
            curl_setopt($ch_item, CURLOPT_URL, $url);
            curl_setopt($ch_item, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch_item, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch_item, CURLOPT_POSTFIELDS, 'token='.$token.'&_t='.$timestamp.''.$sku);
        
            $response_item = curl_exec($ch_item);
        
            curl_close($ch_item);
        
            if (!$response_item) {
                echo '<br>no response';
            }else{
                echo $response_item;
            }
        
        }

    }
    
    
    public function standardInfo(){
        $this->icKingInfoModel->insertSeqdata();

        $message = 'Pndata update success.';
        return redirect()->route('admin.ickinginfo.index')->with('message' , $message);
    }

}
