<?php namespace App\Controllers\Admin;

use App\Entities\Inquiry;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\InquiryCategoryModel;
use App\Models\InquiryFileModel;
use App\Models\InquiryModel;
use App\Services\InquiryService;

use App\Models\ProductModel;
use App\Models\ProductsShippingModel;
use App\Models\StocklocationCategoryModel;
use App\Models\DeliverycodeModel;
use App\Models\InquiryPartinfoModel;

class InquiryController extends BaseController
{
    protected $inquiryModel;
    protected $inquiryFileModel;
    protected $inquiryService;
    protected $inquiryCategoryModel;

    private $productModel;
    private $productsShippingModel;
    protected $stocklocationCategoryModel;
    protected $deliverycodesModel;
    protected $inquiryPartinfoModel;
    
    public function __construct()
    {
        $this->inquiryModel = new InquiryModel();
        $this->inquiryFileModel = new InquiryFileModel();
        $this->inquiryService = new InquiryService();
        $this->inquiryCategoryModel = new InquiryCategoryModel();

        $this->productModel = new ProductModel();
        $this->productsShippingModel = new ProductsShippingModel();
        $this->stocklocationCategoryModel = new StocklocationCategoryModel();
        $this->deliverycodesModel = new DeliverycodeModel();
        $this->inquiryPartinfoModel = new InquiryPartinfoModel();
    }

    public function index()
    {
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( ( isset($searchInput['category_id']) && $searchInput['category_id'] != '') || ( isset($searchInput['title']) && $searchInput['title'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $categories = $this->inquiryCategoryModel->findAll();
        $data = $this->inquiryModel->getSearch($searchInput,$perPage);
        $data['categories'] = $categories;
        return $this->viewAdmin('inquiry/index',array_merge($data,$searchInput));
    }

    protected function validationMapFieldLabels(){
        return [
            'title' => lang_common('title'),
            'content' => lang_common('content')
        ];
    }

    public function showCreate(){
        $this->rules = $this->inquiryModel->getValidationRules();
        $categories = $this->inquiryCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['maxFiles'] = 10;
        return $this->viewAdmin('inquiry/create',$data);
    }

    public function create(){
        $this->rules = $this->inquiryModel->getValidationRules();
        if($this->checkValidation()){
            $accountManger = AuthHelpers::getLoginInfoAdmin();
            $this->inquiryService->saveInquiry($this->request,$accountManger->account_id);
            $message = 'Create inquiry success.';
            return redirect()->route('admin.inquiry.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('inquiry/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->inquiryModel->getValidationRules();
        $inquiryItem = $this->inquiryModel->find($id);

        $data['item'] = $inquiryItem;
        
        $item_code = $inquiryItem->item_code;
        $productinfo = $this->productModel->findByProductCode($item_code);
        $data['productinfo'] = $productinfo;

        // var_dump ($data['productinfo'] );
        // exit;

        $files = $this->inquiryFileModel->where('inquiry_id',$id)->findAll();
        $categories = $this->inquiryCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['files'] = $files;
        $data['maxFiles'] = 10 - count($files);
        return $this->viewAdmin('inquiry/update', $data);
    }

    public function update($id){
        $this->rules = $this->inquiryModel->getValidationRules();
        if($this->checkValidation()){
            $this->inquiryService->updateInquiry($id,$this->request);
            $message = "Update inquiry success";
            return redirect()->route('admin.inquiry.index')->with('message',$message);
        }else{
            return view('admin/inquiry/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteInquiry($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->inquiryService->deleteInquiry($ids);
            if($result) $message = "Delete inquiry success";
        }
        return redirect()->route('admin.inquiry.index')->with('message',$message);
    }

    public function deleteFile($inquiryId,$fileNo){
        $this->inquiryFileModel->delete($fileNo);
        $message = "Delete file success";
        return redirect()->route('admin.inquiry.update',[$inquiryId])->with('message',$message);;
    }

}
