<?php namespace App\Controllers\Admin;

use App\Entities\Locationinfo;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
//use App\Models\LocationinfoCategoryModel;
//use App\Models\LocationinfoFileModel;
use App\Models\LocationinfoModel;
use App\Services\LocationinfoService;

class LocationinfoController extends BaseController
{
    protected $locationinfoModel;
  //  protected $locationinfoFileModel;
    protected $locationinfoService;
  //  protected $locationCategoryModel;

    public function __construct()
    {
        $this->locationinfoModel = new LocationinfoModel();
        //$this->locationinfoFileModel = new LocationinfoFileModel();
        $this->locationinfoService = new LocationinfoService();
        //$this->locationCategoryModel = new LocationinfoCategoryModel();
    }


    public function index()
    {
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( ( isset($searchInput['location_code']) && $searchInput['location_code'] != '') || ( isset($searchInput['location_kor_name']) && $searchInput['location_kor_name'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        //$categories = $this->locationCategoryModel->findAll();
        $data = $this->locationinfoModel->getSearch($searchInput,$perPage);
        //$data['categories'] = $categories;
        
        //var_dump ($data);
        //exit;
        return $this->viewAdmin('locationinfo/index',array_merge($data,$searchInput));
    }


    protected function validationMapFieldLabels(){
        return [
            'location_kor_name' => lang_common('location_kor_name'),
            'location_eng_name' => lang_common('location_eng_name')
        ];
    }

    public function showCreate(){
        $this->rules = $this->locationinfoModel->getValidationRules();
        // $data['locationinfo_code'] = 'LC01M'.time();
        
        return $this->viewAdmin('locationinfo/create',$data);
    }


    public function create(){
        $this->rules = $this->locationinfoModel->getValidationRules();
        if($this->checkValidation()){
            //$accountManger = AuthHelpers::getLoginInfoAdmin();
            $this->locationinfoService->saveLocationinfo($this->request,$accountManger->account_id);
            $message = 'Create Locationinfo success.';
            return redirect()->route('admin.locationinfo.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('locationinfo/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->locationinfoModel->getValidationRules();
        $locationinfoItem = $this->locationinfoModel->find($id);

        $data['item'] = $locationinfoItem;
        return $this->viewAdmin('locationinfo/update', $data);
    }

    public function update($id){
        //var_dump($this->request);
        //exit;
        $this->rules = $this->locationinfoModel->getValidationRules();

        if($this->checkValidation()){
            $this->locationinfoService->updateLocationinfo($id,$this->request);

            $message = "Update locationinfo success";
            return redirect()->route('admin.locationinfo.index')->with('message',$message);
        }else{
            return view('admin/locationinfo/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteLocationinfo($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->locationinfoService->deleteLocationinfo($ids);
            if($result) $message = "Delete locationinfo success";
        }
        return redirect()->route('admin.locationinfo.index')->with('message',$message);
    }

}
