<?php namespace App\Controllers\Admin;

use App\Entities\ExchangeInfo;
use App\Helpers\AuthHelpers;
use App\Helpers\FileHelper;
use App\Helpers\DateHelper;
use App\Helpers\Common\EmailHelper;
use App\Models\SitemapdataModel;
//use App\Services\ApiProductinfoService;
//use App\Models\ExchangeInfoModel;


class MakeSitemapController extends BaseController
{
    protected $sitemapdataModel;
    //protected $apiProductinfoService;
    //protected $exchangeInfoModel;

    public function __construct()
    {
        $this->sitemapdataModel = new SitemapdataModel();
        //$this->apiProductinfoService = new ApiProductinfoService();
        //$this->exchangeInfoModel = new ExchangeInfoModel();
    }

    public function index()
    {
        //echo "There is a Test.";
        //exit;
        $this->sitemapdataModel->deleteSitemapdata();

        // $data['workData'] = $this->sitemapdataModel->countAll();
        $data['workData'] = $this->sitemapdataModel->getActiveCount();
        return $this->viewAdmin('mksitemap/index', $data);
    }


    public function insertData(){
        $this->sitemapdataModel->insertSitemapdata();

        $message = 'Pndata update success.';
        return redirect()->route('admin.mksitemap.index')->with('message' , $message);

    }


    public function sitemapToTxt(){

        $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
        $pathFile = FileHelper::FOLDER_PATCH_SITEMAP_TOTEXT;
        $filepath = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';

        $result=opendir($filepath);

        while($file=readdir($result)) {
           if($file=="."||$file=="..") {continue;}
           $fileInfo = pathinfo($file);
           $fileExt = $fileInfo['extension'];
      
           If (empty($fileExt)){
              $dir_count++;
           } else {
              $file_count++;
           }
         }

        $filenum = $file_count+1;
        $incount = "19000";
        $endincount = $incount-1;
        $today = date("Y-m-d", time());
        // echo $today;
        // exit;

        $siteMapIds = $this->sitemapdataModel->getSitemapId($incount);

            foreach ($siteMapIds as $key => $itemId):

                if  ($incount > $key) {
                    $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
                    $pathFile = FileHelper::FOLDER_PATCH_SITEMAP_TOTEXT;
                    $filepath = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';
                    $filename = "sitemap_".$filenum;

                    $fp = fopen($filepath.$filename.".xml", "a");

                    if ($key == 0){
                        $text = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n<url>\n<loc>https://chipdirect.co.kr/sale/detail/".$itemId->product_code."</loc>\n<lastmod>".$today."</lastmod>\n<changefreq>monthly</changefreq>\n<priority>0.8</priority>\n</url>\n";
                    } elseif ($key == $endincount) {
                        $text = "<url>\n<loc>https://chipdirect.co.kr/sale/detail/".$itemId->product_code."</loc>\n<lastmod>".$today."</lastmod>\n<changefreq>monthly</changefreq>\n<priority>0.8</priority>\n</url>\n</urlset>";
                    } else {
                        $text = "<url>\n<loc>https://chipdirect.co.kr/sale/detail/".$itemId->product_code."</loc>\n<lastmod>".$today."</lastmod>\n<changefreq>monthly</changefreq>\n<priority>0.8</priority>\n</url>\n";
                    }

                    fwrite($fp, $text);
                    fclose($fp);

                    $this->sitemapdataModel->updateActiveFlg($itemId->product_code);
                }
    
            endforeach;

        $message = '생성완료';
        return redirect()->route('admin.mksitemap.index')->with('message' , $message);
    }

    public function sitemapToAuto(){

        $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
        $pathFile = FileHelper::FOLDER_PATCH_SITEMAP_TOTEXT;
        $filepath = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';

        $result=opendir($filepath);

        while($file=readdir($result)) {
           if($file=="."||$file=="..") {continue;}
           $fileInfo = pathinfo($file);
           $fileExt = $fileInfo['extension'];
      
           If (empty($fileExt)){
              $dir_count++;
           } else {
              $file_count++;
           }
         }
        
        //echo"디렉토리 갯수는:".$dir_count."<br>";
        //echo"파일의 갯수는:".$file_count;
        //exit;

        $filenum = $file_count+1;
        //$incount = "500"; // localhost_test
        $incount = "19000";
        $endincount = $incount-1;
        $today = date("Y-m-d", time());
        
        $siteMapIds = $this->sitemapdataModel->getSitemapId($incount);

            foreach ($siteMapIds as $key => $itemId):

                 if  ($incount > $key) {
                    // echo  $key." : ";
                    // echo  $itemId->product_code;
                    // echo "<br>";

                    $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
                    $pathFile = FileHelper::FOLDER_PATCH_SITEMAP_TOTEXT;
                    $filepath = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';
                    $filename = "sitemap_".$filenum;
            
                    $fp = fopen($filepath.$filename.".xml", "a");

                    if ($key == 0){
                        $text = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n<url>\n<loc>https://chipdirect.co.kr/sale/detail/".$itemId->product_code."</loc>\n<lastmod>".$today."</lastmod>\n<changefreq>monthly</changefreq>\n<priority>0.8</priority>\n</url>\n";
                    } elseif ($key == $endincount) {
                        $text = "<url>\n<loc>https://chipdirect.co.kr/sale/detail/".$itemId->product_code."</loc>\n<lastmod>".$today."</lastmod>\n<changefreq>monthly</changefreq>\n<priority>0.8</priority>\n</url>\n</urlset>";
                    } else {
                        $text = "<url>\n<loc>https://chipdirect.co.kr/sale/detail/".$itemId->product_code."</loc>\n<lastmod>".$today."</lastmod>\n<changefreq>monthly</changefreq>\n<priority>0.8</priority>\n</url>\n";
                    }

                    fwrite($fp, $text."\n");
                    fclose($fp);

                    $this->sitemapdataModel->updateActiveFlg($itemId->product_code);

                 }
    
            endforeach;

            $this->sitemapdataModel->deleteSitemapdata();
            $workData = $this->sitemapdataModel->countAll();

            if ($workData == 0){

                $message = '생성완료';
                return redirect()->route('admin.mksitemap.index')->with('message' , $message);

            } else {

                return redirect()->route('admin.mksitemap.sitemaptoauto');

            }
            
    }

}
