<?php namespace App\Controllers\Admin;

use App\Entities\ExchangeInfo;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Helpers\Common\EmailHelper;
use App\Models\ExchangeInfoModel;
use App\Services\ExchangeInfoService;


class MallinfoController extends BaseController
{
    protected $exchangeInfoModel;
    protected $exchangeInfoService;

    
    public function __construct()
    {
        $this->exchangeInfoModel = new ExchangeInfoModel();
        $this->exchangeInfoService = new ExchangeInfoService();

    }

    public function index()
    {
        echo "There is a Test.";
        exit;
    }

    protected function validationMapFieldLabels(){
        return [
            'standard_amount' => 'standard_amount'
        ];
    }

    public function indexExchange()
    {
        //echo "There is a Test.";
        // var_dump ($data['lists']);
        //exit;

        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if(isset($searchInput['from_date']) || isset($searchInput['to_date'])) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $data = $this->exchangeInfoModel->getSearch($searchInput,$perPage);

        return $this->viewAdmin('mallinfo/exchange/index',array_merge($data,$searchInput));
    }

    public function showCreateExchange(){
        $this->rules = $this->exchangeInfoModel->getValidationRules();
        return $this->viewAdmin('mallinfo/exchange/create',$data);
    }

    public function createExchange(){
        $this->rules = $this->exchangeInfoModel->getValidationRules();

        if($this->checkValidation()){
            $this->exchangeInfoService->saveExchangeInfo($this->request);
            $message = 'Create mallinfo success.';
            return redirect()->route('admin.mallinfo.exchange.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('mallinfo/exchange/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdateExchange($id){
        $this->rules = $this->exchangeInfoModel->getValidationRules();
        $mallinfoItem = $this->exchangeInfoModel->find($id);

        $data['item'] = $mallinfoItem;

        return $this->viewAdmin('mallinfo/exchange/update', $data);
    }

    public function updateExchange($id){
        $this->rules = $this->exchangeInfoModel->getValidationRules();
        if($this->checkValidation()){
            $this->exchangeInfoService->updateExchangeInfo($id,$this->request);
            $message = "Update mallinfo success";
            return redirect()->route('admin.mallinfo.exchange.index')->with('message',$message);
        }else{
            return view('admin/mallinfo/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteExchange($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->exchangeInfoService->deleteExchangeInfo($ids);
            if($result) $message = "Delete mallinfo success";
        }
        return redirect()->route('admin.mallinfo.exchange.index')->with('message',$message);
    }

    public function deleteOld(){
        
        $this->exchangeInfoModel->deleteOld();

        $message = "오래된 환율정보를 삭제했습니다.";
        return redirect()->route('admin.mallinfo.exchange.index')->with('message',$message);
    }

    public function mailTester()
    {
        // echo "There is a Mail Tester.";
        // exit;

        // $sendto = $this->request->getGet('sendto');

        $email = \Config\Services::email();
        
        $config['protocol'] = 'html';
        $config['mailPath'] = '/usr/sbin/sendmail -t -i';
        $config['fromEmail'] = 'chipdirectmall@gmail.com';
        $config['fromName'] = 'ChipDirect';


        $email->initialize($config);

        // echo $sendto;
        // exit;

        //$email->setTo($sendto);
        $email->setTo('pixel25@naver.com');

        $email->setSubject('[메일테스트] 메일 테스터를 전송했습니다.');
        $email->setMessage('메일 테스터를 전송했습니다.<br>메일 테스터를 전송했습니다.<br>메일 테스터를 전송했습니다.<br>메일 테스터를 전송했습니다.');

        if($email->send(false)){
            echo "테스트 메일을 전송했습니다.";
        }else{
            echo "테스트 메일 전송에 문제가 있습니다.";
        }


    }

}
