<?php namespace App\Controllers\Admin;

use App\Entities\Manufacturer;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\ManufacturerModel;
use App\Services\ManufacturerService;

class ManufacturerController extends BaseController
{
    protected $manufacturerModel;
    protected $manufacturerService;

    public function __construct()
    {
        $this->manufacturerModel = new ManufacturerModel();
        $this->manufacturerService = new ManufacturerService();
    }


    public function index()
    {
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( ( isset($searchInput['maker_code']) && $searchInput['maker_code'] != '') || ( isset($searchInput['name']) && $searchInput['name'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $data = $this->manufacturerModel->getSearch($searchInput,$perPage);
        
        //var_dump ($data);
        //exit;
        return $this->viewAdmin('manufacturer/index',array_merge($data,$searchInput));
    }


    protected function validationMapFieldLabels(){
        return [
            'name' => lang_common('name'),
        ];
    }

    public function showCreate(){
        $this->rules = $this->manufacturerModel->getValidationRules();

        return $this->viewAdmin('manufacturer/create',$data);
    }


    public function create(){
        $this->rules = $this->manufacturerModel->getValidationRules();
        if($this->checkValidation()){
            $this->manufacturerService->saveManufacturer($this->request);
            $message = 'Create Manufacturer success.';
            return redirect()->route('admin.manufacturer.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('manufacturer/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->manufacturerModel->getValidationRules();
        $manufacturerItem = $this->manufacturerModel->find($id);

        $data['item'] = $manufacturerItem;
        return $this->viewAdmin('manufacturer/update', $data);
    }

    public function update($id){
        //var_dump($this->request);
        //exit;
        $this->rules = $this->manufacturerModel->getValidationRules();

        if($this->checkValidation()){
            $this->manufacturerService->updateManufacturer($id,$this->request);

            $message = "Update manufacturer success";
            return redirect()->route('admin.manufacturer.index')->with('message',$message);
        }else{
            return view('admin/manufacturer/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteManufacturer($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->manufacturerService->deleteManufacturer($ids);
            if($result) $message = "Delete manufacturer success";
        }
        return redirect()->route('admin.manufacturer.index')->with('message',$message);
    }

    public function downloadExcel(){

        ini_set('max_execution_time',600);
        $data = $this->manufacturerModel->getSearchExl(17000);
        //var_dump($data["lists"]);
        //exit;

        $headerColumns = [
            lang_manufacturer('excel_maker_seq'),
            lang_manufacturer('excel_maker_code'),
            lang_manufacturer('excel_name'),
            lang_manufacturer('excel_manufacturer_link'),
            lang_manufacturer('excel_manufacturer_content'),
            //lang_manufacturer('excel_manufacturer_image_dir'),
            //lang_manufacturer('excel_manufacturer_logo_dir'),
            //lang_manufacturer('excel_del_flg'),
            lang_manufacturer('excel_created_at'),
            lang_manufacturer('excel_updated_at')
        ];


        $dataColumns = [
            Manufacturer::MAKER_SEQ,
            Manufacturer::MAKER_CODE,
            Manufacturer::NAME,
            Manufacturer::MANUFACTURER_LINK,
            Manufacturer::MANUFACTURER_CONTENT,
            //Manufacturer::MANUFACTURER_IMAGE_DIR,
            //Manufacturer::MANUFACTURER_LOGO_DIR,
            //Manufacturer::DEL_FLG,
            Manufacturer::CREATED_AT,
            Manufacturer::UPDATED_AT
        ];

        $fileName = 'Manufacturer_List';
        $filePath = $this->excel->export($headerColumns, $data["lists"], $dataColumns,['file_name' => $fileName]);
        $this->setHeaderDownload($fileName.'.xlsx', PUBLIC_PATH . $filePath);
        exit;
    }


}
