<?php namespace App\Controllers\Admin;

use App\Entities\Product;
use App\Entities\ProductmpEvent;
use App\Helpers\FileHelper;
use App\Helpers\AuthHelpers;
use App\Models\ProductModel;
use App\Models\ProductExportModel;
use App\Entities\ProductsShipping;
use App\Models\ProductsShippingModel;
use App\Models\ManufacturerModel;
use App\Services\ProductService;

use App\Models\LocationinfoModel;
use App\Models\DisplayinfoModel;
use App\Models\EventinfoModel;
use App\Models\ApiinfoModel;

use App\Models\Categorylevel1Model;
use App\Models\Categorylevel2Model;
use App\Models\Categorylevel3Model;
use App\Models\StocklocationCategoryModel;
use App\Models\LeadtimeCategoryModel;
use App\Models\DeliverycodeModel;
use App\Models\ProductmpEventModel;

class NaverCommerceController extends BaseController
{
    protected $productModel;
    protected $productExportModel;
    protected $productsShippingModel;
    protected $productService;
    protected $manufacturerModel;
    protected $locationinfoModel;
    protected $displayinfoModel;
    protected $apiinfoModel;
    protected $eventinfoModel;
    protected $categorylevel1Model;
    protected $categorylevel2Model;
    protected $categorylevel3Model;
    protected $stocklocationCategoryModel;
    protected $leadtimeCategoryModel;
    protected $deliverycodesModel;
    protected $productmpEventModel;

    public function __construct()
    {
        $this->productModel = new ProductModel();
        $this->productExportModel = new ProductExportModel();
        $this->productService = new ProductService();
        $this->productsShippingModel = new ProductsShippingModel();
        $this->manufacturerModel = new ManufacturerModel();
        $this->locationinfoModel = new LocationinfoModel();
        $this->displayinfoModel = new DisplayinfoModel();
        $this->eventinfoModel = new EventinfoModel();
        $this->apiinfoModel = new ApiinfoModel();
        $this->categorylevel1Model = new Categorylevel1Model();
        $this->categorylevel2Model = new Categorylevel2Model();
        $this->categorylevel3Model = new Categorylevel3Model();
        $this->stocklocationCategoryModel = new StocklocationCategoryModel();
        $this->leadtimeCategoryModel = new LeadtimeCategoryModel();
        $this->deliverycodesModel = new DeliverycodeModel();
        $this->productmpEventModel = new ProductmpEventModel();
    }

    public function index()
    {
        //echo "Naver Commerce Controller Test";
        //exit;
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( isset($searchInput['part_number']) && $searchInput['part_number'] != '' ) $searchInput['is_search'] = true;
        $data = $this->productModel->getNavershopping($searchInput, $perPage);
        
        $nshoppingDataCount = count($this->productExportModel->getAdminTSV());
        $data['nshoppingDataCount'] = $nshoppingDataCount;
        $nshoppingNotpriceCount = count($this->productExportModel->getAdminTSVnotprice());
        $data['nshoppingNotpriceCount'] = $nshoppingNotpriceCount;
        $data['nshoppingCount'] = $nshoppingDataCount - $nshoppingNotpriceCount;
        $data['maxFiles'] = 5;
        $data['categorylevel1'] = $this->categorylevel1Model->orderBy('categorylevel1_name', 'ASC')->findAll();
		$data['categorylevel2'] = $this->categorylevel2Model->orderBy('categorylevel2_name', 'ASC')->findAll();
		$data['categorylevel3'] = $this->categorylevel3Model->orderBy('categorylevel3_name', 'ASC')->findAll();
        $data['manufacturers'] = $this->manufacturerModel->orderBy('name', 'ASC')->selectAll();
        
        return $this->viewAdmin('navercommerce/index',array_merge($data, $searchInput));
    }

   
    public function accept($strIds){
        // echo "test";
        $message = "";
        $page = $this->request->getGet('page');
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->productService->acceptProduct($ids);
            //if($result) $message = "Accept member success";
        }
        //return redirect()->to(route_to('admin.navercommerce.index').'?page=' . $page)->with('message',$message);
        return redirect()->to(route_to('admin.navercommerce.index').'?page=' . $page);
    }

    public function notAccept($strIds){
        //echo "test";
        $message = "";
        $page = $this->request->getGet('page');
        
        if(isset($strIds)){
            $ids = explode(',',$strIds);
             $result = $this->productService->notAcceptProduct($ids);
            //if($result) $message = "Not Accept member success";
        }
        //return redirect()->to(route_to('admin.member.index').'?page=' . $page)->with('message',$message);
        return redirect()->to(route_to('admin.navercommerce.index').'?page=' . $page);
    }


    public function downloadCSV() {
     // file name 
     $filename = 'exportCSV_'.date('Ymd').'.txt'; 
     //header('Content-Description: File Transfer');
     header('Content-Encoding: utf-8');
     header('Content-type: application/csv; charset=utf-8');
     header('Content-Disposition: attachment;filename="'.$filename.'"');

     // get data 
     $exportCSVData = $this->categorylevel1Model->findAll();
     //var_dump ($exportCSVData);
     //exit;

     // file creation 
     $file = fopen('php://output', 'w');
     $header = array("categorylevel1_id","categorylevel1_code","categorylevel1_name","categorylevel1_name_eng" ,"del_flg","created_at","updated_at"); 

     fputcsv($file, $header);
     foreach ($exportCSVData as $key=>$line){ 
        fputcsv($file,$line); 
     }
     fclose($file); 
     exit; 

   }

   public function supplierCodeInfo() {
    //echo "Supplier CodeInfo Controller Test";
    //exit;

    // file name 
    $filename = 'SupplierCodeInfo_'.date('Ymd').'.txt'; 
    //header('Content-Description: File Transfer');
    header('Content-Encoding: utf-8');
    header('Content-type: application/csv; charset=utf-8');
    header('Content-Disposition: attachment;filename="'.$filename.'"');

    // get data 
    $supplierCodeData = $this->productExportModel->getSupplierCode();

    // file creation 
    $file = fopen('php://output', 'w');
    $header = array("product_code","part_number","product_api_id"); 

    fputcsv($file, $header);
    foreach ($supplierCodeData as $key=>$line){ 
       fputcsv($file,$line); 
    }
    fclose($file); 
    exit; 
  }

   
   // 다운로드 형태
   public function downloadTSV() {
    // file name 
    // $filename = 'downloadTSV_'.date('Ymd').'.txt'; 
    $filename = 'downloadTSV_'.date('Ymd').'.tsv'; 

    //header("Content-Description: File Transfer"); 
    header('Content-Encoding: utf-8');
    header('Content-type: application/tsv; charset=utf-8');
    header('Content-Disposition: attachment;filename="'.$filename.'"');

    // get data 
    // $searchInput = $this->request->getGet();
    // $searchInput['navershop_chk'] = 1;

    $downloadTSVData = $this->productExportModel->getAdminTSV($searchInput);
    //var_dump ($downloadTSVData);
    //exit;

    // file creation 
    $file = fopen('php://output', 'w');
    $header = array("id","title","price_pc","price_mobile","normal_price","link","mobile_link","image_link","add_image_link","video_url","category_name1","category_name2","category_name3","category_name4","naver_category","naver_product_id","product_option_id","condition","import_flag","parallel_import","order_made",
                "product_flag","adult","goods_type","barcode","manufacture_define_number","brand","brand_certification","maker","origin","card_event","event_words","coupon","partner_coupon_download","interest_free_event","point","installation_costs","rental_info","search_tag","group_id","vendor_id","coordi_id",
                "minimum_purchase_quantity","review_count","shipping","delivery_grade","delivery_detail","attribute","option_detail","seller_id","age_group","gender","shipping_settings","fast_delivery","regular_delivery","dawn_delivery","npay_unable","npay_unable_acum","isbn","Class","update_time"); 

    fputcsv($file, $header, "\t");

    foreach ($downloadTSVData as $key=>$line){ 
        if ($line["price_pc"] > 0 && $line["image_link"]) {

            $line["product_flag"] = "도매";
            $selling_price = $line["price_pc"]*$line["minimum_purchase_quantity"]; // MOQ 수량가
            $line["price_pc"] = round($selling_price*1.1); // MOQ 수량가격 X 부가세...반올림가격

            // $moq_price_pc = $line["price_pc"]*$line["minimum_purchase_quantity"]; // MOQ 수량가격
            // $line["price_pc"] = round($moq_price_pc*1.1); // MOQ 수량가격 X 부가세...반올림가격

            if ($line["minimum_purchase_quantity"] > 1) {
                $line["title"] = $line["title"]." (".$line["minimum_purchase_quantity"]."개부터 구매 가능)";
            }

            // $line["link"] = "http://localhost/sale/detail/".$line["link"];
            $line["link"] = "https://chipdirect.co.kr/sale/detail/".$line["link"];
            if ($line["image_link"]) {
                $image_link_url = $line["image_link"];
                $url_chk = substr($image_link_url, 0, 4);
                if ($url_chk == "http"){
                    $line["image_link"] = $image_link_url;
                } else {
                    //$line["image_link"] = "http://localhost/".$image_link_url;
                    $line["image_link"] = "https://chipdirect.co.kr/".$image_link_url;
                }
            }

        fputcsv($file, $line, "\t");

        }
    }
    fclose($file); 
    exit; 
    
   }


   // 업로드 형태
   public function exportTSV() {
    // file name 
    $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
    $filepath = PUBLIC_PATH.$uploadpath.'/navershopping/';
    //$filename = 'exportTSV_'.date('Ymd'); 
    $filename = 'exportTSV'; 

    //$this->rmdir_all($filepath);
    @unlink($filepath.$filename.".tsv");

    $exportTSVData = $this->productExportModel->getAdminTSV($searchInput);

    // file creation 
    $file = fopen($filepath.$filename.".tsv", "a");

    $header = array("id","title","price_pc","price_mobile","normal_price","link","mobile_link","image_link","add_image_link","video_url","category_name1","category_name2","category_name3","category_name4","naver_category","naver_product_id","product_option_id","condition","import_flag","parallel_import","order_made",
                "product_flag","adult","goods_type","barcode","manufacture_define_number","brand","brand_certification","maker","origin","card_event","event_words","coupon","partner_coupon_download","interest_free_event","point","installation_costs","rental_info","search_tag","group_id","vendor_id","coordi_id",
                "minimum_purchase_quantity","review_count","shipping","delivery_grade","delivery_detail","attribute","option_detail","seller_id","age_group","gender","shipping_settings","fast_delivery","regular_delivery","dawn_delivery","npay_unable","npay_unable_acum","isbn","Class","update_time"); 

        $text = implode("\t",$header);  
        fwrite($file, $text."\n");

        foreach ($exportTSVData as $key=>$line){

            if ($line["price_pc"] > 0 && $line["image_link"]) {

                $line["product_flag"] = "도매";
                $selling_price = $line["price_pc"]*$line["minimum_purchase_quantity"]; // MOQ 수량가
                $line["price_pc"] = round($selling_price*1.1); // MOQ 수량가격 X 부가세...반올림가격

                // $moq_price_pc = $line["price_pc"]*$line["minimum_purchase_quantity"]; // MOQ 수량가격
                // $line["price_pc"] = round($moq_price_pc*1.1); // MOQ 수량가격 X 부가세...반올림가격

                if ($line["minimum_purchase_quantity"] > 1) {
                    $line["title"] = $line["title"]." (".$line["minimum_purchase_quantity"]."개부터 구매 가능)";
                }

                //$line["link"] = "http://localhost/sale/detail/".$line["link"];
                $line["link"] = "https://chipdirect.co.kr/sale/detail/".$line["link"];
                if ($line["image_link"]) {
                    $image_link_url = $line["image_link"];
                    $url_chk = substr($image_link_url, 0, 4);
                    if ($url_chk == "http"){
                        $line["image_link"] = $image_link_url;
                    } else {
                        //$line["image_link"] = "http://localhost/".$image_link_url;
                        $line["image_link"] = "https://chipdirect.co.kr/".$image_link_url;
                    }
                }

                $text = implode("\t",$line);  
                fwrite($file, $text."\n");
            }
        }

        fclose($file); 

        // SELECT * FROM `products` WHERE `navershop_status`="N"
        // UPDATE `products` SET `navershop_status` = '' WHERE `navershop_status`="N";

    $message = '네이버쇼핑 EP파일을 생성했습니다.';
    return redirect()->route('admin.navercommerce.index')->with('message', $message);
    // exit; 
   }


/*
   public function rmdir_all($delete_path) {
        $dirs = dir($delete_path);
        while(false !== ($entry = $dirs->read())) {
            // 디렉토리의 내용을 하나씩 읽는다.
            if(($entry != '.') && ($entry != '..')) {
                // 디렉토리의 내용중 현재폴더, 상위폴더가 아니면 (즉 파일 및 디렉토리)            
                if(is_dir($delete_path.'/'.$entry)) {
                    //디렉토리이면 재귀호출로 다시 삭제 시작.
                    rmdir_all($delete_path.'/'.$entry);
                } else {
                    //해당 파일 삭제
                    @unlink($delete_path.'/'.$entry);
                }
            }
        }
        $dirs->close();
        @rmdir($delete_path);
    }
*/


    public function downloadExcel(){
        ini_set('max_execution_time',600);
        // $data = $this->productModel->getSearch(null, 300000, true);
        $data = $this->productModel->getSearchExl(10000);
        //var_dump($data["lists"]);
        //exit;

        $headerColumns = [
            lang_product('excel_product_id'),
            lang_product('excel_product_code'),
            lang_product('excel_part_category'),
            lang_product('excel_part_category2'),
            lang_product('excel_part_category3'),
            lang_product('excel_maker_seq'),
            lang_product('excel_location_code'),
            lang_product('excel_display_set'),
            lang_product('excel_newproduct_chk'),
            lang_product('excel_bestproduct_chk'),
            lang_product('excel_recomproduct_chk'),
            lang_product('excel_brandproduct_chk'),
            lang_product('excel_event_set'),
            lang_product('excel_part_number'),
            lang_product('excel_part_number_sequence'),
            lang_product('excel_search_word'),
            lang_product('excel_brief_description'),
            lang_product('excel_situation'),
            lang_product('excel_exposure'),

            lang_product('excel_product_related'),
            lang_product('excel_date_code'),
            lang_product('excel_image_dir'),
            lang_product('excel_pdf_dir'),
            lang_product('excel_delivery_code'),
            lang_product('excel_api_flg'),
            lang_product('excel_api_code'),
            lang_product('excel_tariff_rate'),
            lang_product('excel_product_api_id'),
            lang_product('excel_qty'),
            lang_product('excel_packing_code'),
            lang_product('excel_wearing_price'),            
            lang_product('excel_price'),
            lang_product('excel_leadtime'),
            lang_product('excel_moq'),
            lang_product('excel_mpq'),
            lang_product('excel_stock_location'),
            lang_product('excel_taxable'),

            lang_product('excel_selling_price1'),
            lang_product('excel_margin_rate1'),
            lang_product('excel_unit_mini_quantity1'),
            lang_product('excel_unit_max_quantity1'),

            lang_product('excel_selling_price2'),
            lang_product('excel_margin_rate2'),
            lang_product('excel_unit_mini_quantity2'),
            lang_product('excel_unit_max_quantity2'),

            lang_product('excel_selling_price3'),
            lang_product('excel_margin_rate3'),
            lang_product('excel_unit_mini_quantity3'),
            lang_product('excel_unit_max_quantity3'),

            lang_product('excel_selling_price4'),
            lang_product('excel_margin_rate4'),
            lang_product('excel_unit_mini_quantity4'),
            lang_product('excel_unit_max_quantity4'),

            lang_product('excel_selling_price5'),
            lang_product('excel_margin_rate5'),
            lang_product('excel_unit_mini_quantity5'),
            lang_product('excel_unit_max_quantity5'),

            lang_product('excel_selling_price6'),
            lang_product('excel_margin_rate6'),
            lang_product('excel_unit_mini_quantity6'),
            lang_product('excel_unit_max_quantity6'),
            lang_product('excel_active_flg'),
            lang_product('excel_del_flg'),
            lang_product('excel_created_at'),
            lang_product('excel_updated_at')
        ];


        $dataColumns = [
            Product::PRODUCT_ID,
            Product::PRODUCT_CODE,
            Product::PART_CATEGORY,
            Product::PART_CATEGORY2,
            Product::PART_CATEGORY3,
            Product::MAKER_SEQ,
            Product::LOCATION_CODE,
            Product::DISPLAY_SET,
            Product::NEWPRODUCT_CHK,
            Product::BESTPRODUCT_CHK,
            Product::RECOMPRODUCT_CHK,
            Product::BRANDPRODUCT_CHK,
            Product::EVENT_SET,
            Product::PART_NUMBER,
            Product::part_number_sequence,
            Product::SEARCH_WORD,
            Product::BRIEF_DESCRIPTION,
            Product::SITUATION,
            Product::EXPOSURE,

            Product::PRODUCT_RELATED,
            Product::DATE_CODE,
            Product::IMAGE_DIR,

            Product::DELIVERY_CODE,
            Product::API_FLG,
            Product::API_CODE,
            Product::TARIFF_RATE,
            Product::PRODUCT_API_ID,
            Product::QTY,
            Product::PACKING_CODE,
            Product::WEARING_PRICE,
            Product::PRICE,
            Product::LEADTIME,
            Product::MOQ,
            Product::MPQ,
            Product::STOCK_LOCATION,
            Product::TAXABLE,

            Product::SELLING_PRICE1,
            Product::MARGIN_RATE1,
            Product::unit_mini_quantity1,
            Product::UNIT_MAX_QUANTITY1,

            Product::SELLING_PRICE2,
            Product::MARGIN_RATE2,
            Product::unit_mini_quantity2,
            Product::UNIT_MAX_QUANTITY2,

            Product::SELLING_PRICE3,
            Product::MARGIN_RATE3,
            Product::unit_mini_quantity3,
            Product::UNIT_MAX_QUANTITY3,

            Product::SELLING_PRICE4,
            Product::MARGIN_RATE4,
            Product::unit_mini_quantity4,
            Product::UNIT_MAX_QUANTITY4,

            Product::SELLING_PRICE5,
            Product::MARGIN_RATE5,
            Product::unit_mini_quantity5,
            Product::UNIT_MAX_QUANTITY5,

            Product::SELLING_PRICE6,
            Product::MARGIN_RATE6,
            Product::unit_mini_quantity6,
            Product::UNIT_MAX_QUANTITY6,
            Product::ACTIVE_FLG,
            Product::DEL_FLG,
            Product::CREATED_AT,
            Product::UPDATED_AT
        ];

        $fileName = 'Naver_EP_List';
        $filePath = $this->excel->export($headerColumns, $data["lists"], $dataColumns,['file_name' => $fileName]);
        $this->setHeaderDownload($fileName.'.xlsx', PUBLIC_PATH . $filePath);
        exit;
    }


    public function importID(){
        $files = $this->request->getFiles();

        if(isset($files)){
            $file_count= 1;
            foreach ($files as $file){
                $fileName = $file->getClientName();
                if(isset($fileName) && !empty($fileName)){
                    $filePath = FileHelper::saveCSVFile($file, FileHelper::FOLDER_PATCH_UPLOAD_APIIDCSV, $file_count);
                }
            }
        }

            // 디렉토리 갯수와 파일의 갯수 구하기
            $file_count = 0;

            $loopexcel_path =  PUBLIC_PATH. 'upload/apiidcsv/';
            $isDir = is_dir($loopexcel_path);
        
            if ($isDir) {
                
            $result = opendir($loopexcel_path); 
            while($file=readdir($result)) {
                if($file=="."||$file=="..") {continue;} // file명이 ".", ".." 이면 무시함
                $fileInfo = pathinfo($file);
                $fileExt = $fileInfo['extension']; // 파일의 확장자를 구함
                If (empty($fileExt)){
                $dir_count++; // 파일에 확장자가 없으면 디렉토리로 판단하여 dir_count를 증가시킴
                } else {
                $file_count++;// 파일에 확장자가 있으면 file_count를 증가시킴
                }
            }
        
            // echo"디렉토리 갯수는:".$dir_count."<br>";
            // echo"파일의 갯수는:".$file_count."<br>";
            // var_dump($file_count);
            // exit;
        
            // 디렉토리 갯수와 파일의 갯수 구하기 끝
            $file_countend = $file_count;
            
            for ($file_count =1;$file_count < $file_countend;$file_count ++) {
                $filecon = $file_count;
                $bs_filename = 'api_id_';

                $this->loop_file_check($bs_filename, $filecon, 'csv');
                $loopfilepath = $this->filePath;

                    $file = fopen($loopfilepath,"r");
                    $i = 0;
                    $numberOfFields = 1;
                    $csvArr = array();
                    while (($filedata = fgetcsv($file, 3000, ",")) !== FALSE) {
                        $num = count($filedata);
                        if($i > 0 && $num == $numberOfFields){ 

                            $getid = $this->productModel->findByProductSeq($filedata[0]);
                            $this->productService->acceptProductId($getid->product_id);

                        }
                        $i++;
                    }
                    fclose($file);
            }
    
            $count_all = $i - 1;
            $message = $count_all."개 상품을 네이버쇼핑 노출등록했습니다.";
            FileHelper::deleteCSVFile( FileHelper::FOLDER_PATCH_UPLOAD_APIIDCSV);
            return redirect()->route('admin.navercommerce.index')->with('message',$message);
        } else {
            $message = "등록된 파일이 없습니다.";
            return redirect()->route('admin.navercommerce.index')->with('message',$message);
        }

    }


    function loop_file_check($filename, $filecon, $fileexe){
		$cfg					= array();
		$cfg['allowed_types']	= $fileexe;
		$cfg['file_name']		= $filename.$filecon;
		$cfg['upload_path']	    =  PUBLIC_PATH. 'upload/apiidcsv/';
		$cfg['overwrite']		= TRUE;

		$this->fileName = $fileName;
		$this->filePath = $cfg['upload_path'] . $cfg['file_name'] . '.' . $cfg['allowed_types'];
	}

///////////////////////

function event_file_check($filename, $filecon, $fileexe){
    $cfg					= array();
    $cfg['allowed_types']	= $fileexe;
    $cfg['file_name']		= $filename.$filecon;
    $cfg['upload_path']	    =  PUBLIC_PATH. 'upload/eventexcel/';
    $cfg['overwrite']		= TRUE;
        $this->fileName = $fileName;
        $this->filePath = $cfg['upload_path'] . $cfg['file_name'] . '.' . $cfg['allowed_types'];

}

public function downloadEventTemp(){
    $fileName = 'event_data_sample.xlsx';
    $filePath = PUBLIC_PATH. 'upload/excel/'.$fileName;
    $this->setHeaderDownload($fileName, $filePath);
    exit;
}

public function importEventCsvToDb()
{
    // 디렉토리 갯수와 파일의 갯수 구하기
    $file_count =0;
    $loopexcel_path =  PUBLIC_PATH. 'upload/eventexcel/';
    $isDir = is_dir($loopexcel_path);

    if ($isDir) {
    $result = opendir($loopexcel_path); 

    while($file=readdir($result)) {
        if($file=="."||$file=="..") {continue;} // file명이 ".", ".." 이면 무시함
        $fileInfo = pathinfo($file);
        $fileExt = $fileInfo['extension']; // 파일의 확장자를 구함

        If (empty($fileExt)){
        $dir_count++;
        } else {
        $file_count++;
        }

    }

    $file_countend = $file_count;

    for ($file_count =1;$file_count < $file_countend;$file_count ++) {
            $filecon = $file_count;
            $bs_filename = 'loop_data_';

            $this->event_file_check($bs_filename, $filecon, 'csv');
            $loopfilepath = $this->filePath;

                $file = fopen($loopfilepath,"r");
                
                $i = 0;
                $numberOfFields = 3;
                $csvArr = array();
                
                while (($filedata = fgetcsv($file, 1000, ",")) !== FALSE) {
                    $num = count($filedata);

                    if($i > 0 && $num == $numberOfFields){ 
                        $csvArr[$i]['product_code'] = $filedata[0];
                        $csvArr[$i]['part_number'] = $filedata[1];
                        $csvArr[$i]['replacement_items'] = $filedata[2];

                    }
                    $i++;

                }
                fclose($file);

                $count = 0;
                $productmpevent = new ProductmpEvent();

                foreach($csvArr as $exceldata){
                        $productmpevent->product_code = $exceldata['product_code'];
                        $productmpevent->part_number = $exceldata['part_number'];
                        $productmpevent->replacement_items = $exceldata['replacement_items'];
                        if( $this->productmpEventModel->insert($productmpevent)){
                            $count++;
                        }
                }
                $count_all = $count_all + $count;
    }
        $message = $count_all."개의 제품이 임시등록되었습니다.";
        return redirect()->route('admin.navercommerce.index')->with('message',$message);
    } else {
        $message = "등록된 파일이 없습니다.";
        return redirect()->route('admin.navercommerce.index')->with('message',$message);
    }

}

public function NaverToInsert()
{
    // 디렉토리 갯수와 파일의 갯수 구하기
    $file_count =0;
    $loopexcel_path =  PUBLIC_PATH. 'upload/eventexcel/';
    $isDir = is_dir($loopexcel_path);

    if ($isDir) {
    $result = opendir($loopexcel_path); 

    while($file=readdir($result)) {
        if($file=="."||$file=="..") {continue;} // file명이 ".", ".." 이면 무시함
        $fileInfo = pathinfo($file);
        $fileExt = $fileInfo['extension']; // 파일의 확장자를 구함

        If (empty($fileExt)){
        $dir_count++;
        } else {
        $file_count++;
        }

    }

    $file_countend = $file_count;

    for ($file_count =1;$file_count < $file_countend;$file_count ++) {
            $filecon = $file_count;
            $bs_filename = 'loop_data_';

            $this->event_file_check($bs_filename, $filecon, 'csv');
            $loopfilepath = $this->filePath;

                $file = fopen($loopfilepath,"r");
                
                $i = 0;
                $numberOfFields = 3;
                $csvArr = array();
                
                while (($filedata = fgetcsv($file, 1000, ",")) !== FALSE) {
                    $num = count($filedata);

                    if($i > 0 && $num == $numberOfFields){ 
                        $csvArr[$i]['product_code'] = $filedata[0];
                        $csvArr[$i]['part_number'] = $filedata[1];
                        $csvArr[$i]['replacement_items'] = $filedata[2];

                    }
                    $i++;

                }
                fclose($file);

                $count = 0;
                foreach($csvArr as $exceldata){
                    $product_code = $exceldata['product_code'];

                    $allProduct = $this->productModel->countAll();
                    $totalproduct_count = $allProduct+1;
                    $codecount = str_pad($totalproduct_count, 9, "0", STR_PAD_LEFT);
                    $product_newcode = "C".$codecount;
                    $exchange_rat = "1400";

                    if( $this->productModel->naverToInsert($product_code, $product_newcode, $exchange_rat)){
                        $count++;
                    }
                }

    }

        FileHelper::deleteCSVFile( FileHelper::FOLDER_PATCH_UPLOAD_EVENTEXCEL);
        $message = "네이버쇼핑 상품이 등록되었습니다.";
        return redirect()->route('admin.navercommerce.index')->with('message',$message);
    } else {
        $message = "등록된 파일이 없습니다.";
        return redirect()->route('admin.navercommerce.index')->with('message',$message);
    }

}

public function uploadEvent(){
    $files = $this->request->getFiles();

    if(isset($files)){

        $file_count= 1;

        foreach ($files as $file){
            $fileName = $file->getClientName();

            if(isset($fileName) && !empty($fileName)){
                $filePath = FileHelper::saveExFile($file, FileHelper::FOLDER_PATCH_UPLOAD_EVENTEXCEL, $file_count);
            }

        }

    }

    return redirect()->route('admin.navercommerce.index');  
}

public function upNavershopItems(){
    $navershop_chk = $this->request->getPost('navershop_chk');

    if ($navershop_chk == '0') {
        $navershop_status = '';
    } elseif ($navershop_chk == '2') {
        $navershop_status = 'D';
    } elseif ($navershop_chk == '3') {
        $navershop_status = 'U';
    } else {
        $navershop_status = 'I';
    }

    $this->productmpEventModel->updatNavershopItems($navershop_chk, $navershop_status);
    return redirect()->route('admin.navercommerce.index');  
}

public function deleteEventFile(){
    FileHelper::deleteCSVFile( FileHelper::FOLDER_PATCH_UPLOAD_EVENTEXCEL);
    $this->productmpEventModel->eraseTempProducts();

    $message = "이전 작업파일을 삭제했습니다.";
    return redirect()->route('admin.navercommerce.index')->with('message',$message);;
}

//////////////////////



}
