<?php namespace App\Controllers\Admin;

use App\Entities\News;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\NewCategoryModel;
use App\Models\NewFileModel;
use App\Models\NewModel;
use App\Services\NewsService;

class NewsController extends BaseController
{
    protected $newsModel;
    protected $newsFileModel;
    protected $newsService;
    protected $newCategoryModel;

    public function __construct()
    {
        $this->newsModel = new NewModel();
        $this->newsFileModel = new NewFileModel();
        $this->newsService = new NewsService();
        $this->newCategoryModel = new NewCategoryModel();
    }

    public function index()
    {
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( ( isset($searchInput['category_id']) && $searchInput['category_id'] != '') || ( isset($searchInput['title']) && $searchInput['title'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $categories = $this->newCategoryModel->findAll();
        $data = $this->newsModel->getSearch($searchInput,$perPage);
        $data['categories'] = $categories;
        return $this->viewAdmin('news/index',array_merge($data,$searchInput));
    }

    protected function validationMapFieldLabels(){
        return [
            'title' => lang_common('title'),
            'content' => lang_common('content')
        ];
    }

    public function showCreate(){
        $this->rules = $this->newsModel->getValidationRules();
        $categories = $this->newCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['maxFiles'] = 10;
        return $this->viewAdmin('news/create',$data);
    }

    public function create(){
        $this->rules = $this->newsModel->getValidationRules();
        if($this->checkValidation()){
            $accountManger = AuthHelpers::getLoginInfoAdmin();
            $this->newsService->saveNews($this->request,$accountManger->account_id);
            $message = 'Create news success.';
            return redirect()->route('admin.news.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('news/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->newsModel->getValidationRules();
        $newsItem = $this->newsModel->find($id);
        $files = $this->newsFileModel->where('news_id',$id)->findAll();
        $categories = $this->newCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['item'] = $newsItem;
        $data['files'] = $files;
        $data['maxFiles'] = 10 - count($files);
        return $this->viewAdmin('news/update', $data);
    }

    public function update($id){
        $this->rules = $this->newsModel->getValidationRules();
        if($this->checkValidation()){
            $this->newsService->updateNews($id,$this->request);
            $message = "Update news success";
            return redirect()->route('admin.news.index')->with('message',$message);
        }else{
            return view('admin/news/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteNews($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->newsService->deleteNews($ids);
            if($result) $message = "Delete news success";
        }
        return redirect()->route('admin.news.index')->with('message',$message);
    }

    public function deleteFile($newsId,$fileNo){
        $this->newsFileModel->delete($fileNo);
        $message = "Delete file success";
        return redirect()->route('admin.news.update',[$newsId])->with('message',$message);;
    }

}
