<?php namespace App\Controllers\Admin;

use App\Entities\Popups;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\PopupCategoryModel;
use App\Models\PopupFileModel;
use App\Models\PopupModel;
use App\Services\PopupsService;

class PopupsController extends BaseController
{
    protected $popupsModel;
    protected $popupsFileModel;
    protected $popupsService;
    protected $popupCategoryModel;

    public function __construct()
    {
        $this->popupsModel = new PopupModel();
        $this->popupsFileModel = new PopupFileModel();
        $this->popupsService = new PopupsService();
        $this->popupCategoryModel = new PopupCategoryModel();
    }

    public function index()
    {
        // echo "POP UP Start. <br>";
        // exit;

        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( ( isset($searchInput['category_id']) && $searchInput['category_id'] != '') || ( isset($searchInput['title']) && $searchInput['title'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $categories = $this->popupCategoryModel->findAll();
        $data = $this->popupsModel->getSearch($searchInput,$perPage);
        $data['categories'] = $categories;
        //exit;
        return $this->viewAdmin('popups/index',array_merge($data,$searchInput));
    }

    protected function validationMapFieldLabels(){
        return [
            'title' => lang_common('title'),
            'sub_title' => lang_common('sub_title')
        ];
    }

    public function showCreate(){
        $this->rules = $this->popupsModel->getValidationRules();
        $categories = $this->popupCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['maxFiles'] = 10;
        return $this->viewAdmin('popups/create',$data);
    }

    public function create(){
        $this->rules = $this->popupsModel->getValidationRules();
        if($this->checkValidation()){
            $accountManger = AuthHelpers::getLoginInfoAdmin();
            $this->popupsService->savePopups($this->request,$accountManger->account_id);
            $message = 'Create popups success.';
            return redirect()->route('admin.popups.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('popups/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->popupsModel->getValidationRules();
        $popupsItem = $this->popupsModel->find($id);
        $files = $this->popupsFileModel->where('popups_id',$id)->findAll();
        $categories = $this->popupCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['item'] = $popupsItem;
        $data['files'] = $files;
        $data['maxFiles'] = 10 - count($files);
        return $this->viewAdmin('popups/update', $data);
    }

    public function update($id){
        $this->rules = $this->popupsModel->getValidationRules();
        if($this->checkValidation()){
            $this->popupsService->updatePopups($id,$this->request);
            $message = "Update popups success";
            return redirect()->route('admin.popups.index')->with('message',$message);
        }else{
            return view('admin/popups/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deletePopups($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->popupsService->deletePopups($ids);
            if($result) $message = "Delete popups success";
        }
        return redirect()->route('admin.popups.index')->with('message',$message);
    }

    public function deleteFile($popupsId,$fileNo){
        $this->popupsFileModel->delete($fileNo);
        $message = "Delete file success";
        return redirect()->route('admin.popups.update',[$popupsId])->with('message',$message);;
    }

}
