<?php namespace App\Controllers\Admin;

use App\Entities\ReasonreturnInfo;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\ReasonreturnInfoModel;
use App\Services\ReasonreturnInfoService;

class ReasonreturnInfoController extends BaseController
{
    protected $reasonreturnInfoModel;
    protected $reasonreturnInfoService;

    public function __construct()
    {
        $this->reasonreturnInfoModel = new ReasonreturnInfoModel();
        $this->reasonreturnInfoService = new ReasonreturnInfoService();
    }

    public function index()
    {
        // echo "Packaging Unit.";
        // exit;

        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if(( isset($searchInput['return_info']) && $searchInput['return_info'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $data = $this->reasonreturnInfoModel->getSearch($searchInput,$perPage);
        return $this->viewAdmin('reasonreturninfo/index',array_merge($data,$searchInput));
    }

    protected function validationMapFieldLabels(){
        return [
            'return_info' => lang_common('return_info')
        ];
    }

    public function showCreate(){
        $this->rules = $this->reasonreturnInfoModel->getValidationRules();
        return $this->viewAdmin('reasonreturninfo/create',$data);
    }

    public function create(){
        $this->rules = $this->reasonreturnInfoModel->getValidationRules();

        if($this->checkValidation()){
            $this->reasonreturnInfoService->saveReasonreturnInfo($this->request);
            $message = '반품사유 등록 성공!';
            return redirect()->route('admin.reasonreturninfo.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('reasonreturninfo/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($return_id){
        $this->rules = $this->reasonreturnInfoModel->getValidationRules();
        $shippingCompanyItem = $this->reasonreturnInfoModel->find($return_id);
        $data['item'] = $shippingCompanyItem;
        return $this->viewAdmin('reasonreturninfo/update', $data);
    }

    public function update($return_id){
        $this->rules = $this->reasonreturnInfoModel->getValidationRules();
        if($this->checkValidation()){
            $this->reasonreturnInfoService->updateReasonreturnInfo($return_id,$this->request);
            $message = "반품사유 수정 성공!";
            return redirect()->route('admin.reasonreturninfo.index')->with('message',$message);
        }else{
            return view('admin/reasonreturninfo/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function delete($strIds){
        $message = "";
        if(isset($strIds)){
            $return_ids = explode(',',$strIds);
            $result = $this->reasonreturnInfoService->deleteReasonreturnInfo($return_ids);
            if($result) $message = "반품사유 삭제 성공!";
        }
        return redirect()->route('admin.reasonreturninfo.index')->with('message',$message);
    }

}
