<?php namespace App\Controllers\Admin;

use App\Helpers\DateHelper;
use App\Helpers\FileHelper;
use App\Helpers\AuthHelpers;
use App\Entities\RefundInfo;
use App\Models\RefundInfoModel;
use App\Models\RefundPartinfoModel;
use App\Models\ReasonreturnInfoModel;
use App\Models\ProductModel;
use App\Models\StocklocationCategoryModel;
use App\Services\RefundInfoService;

class RefundinfoController extends BaseController
{
    protected $refundInfoModel;
    protected $refundPartinfoModel;
    protected $reasonreturnInfoModel;
    protected $refundInfoService;
    protected $productModel;
    protected $stocklocationCategoryModel;

    public function __construct()
    {
        $this->refundInfoModel = new RefundInfoModel();
        $this->refundPartinfoModel = new RefundPartinfoModel();
        $this->reasonreturnInfoModel = new ReasonreturnInfoModel();
        $this->productModel = new ProductModel();
        $this->stocklocationCategoryModel = new StocklocationCategoryModel();
        $this->refundInfoService = new RefundInfoService();
    }

    public function index()
    {
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if(isset($searchInput['from_date']) || isset($searchInput['to_date'])) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        if(!isset($searchInput['from_date'])) $searchInput['from_date'] = DateHelper::toTimeString(DateHelper::firstDayOfMonth(),'yy-MM-dd');
        if(!isset($searchInput['to_date'])) $searchInput['to_date'] = DateHelper::toTimeString(DateHelper::lastDayOfMonth(),'yy-MM-dd');
        $data = $this->refundInfoModel->getSearch($searchInput,$perPage);

        // exit;
        return $this->viewAdmin('refundinfo/index',array_merge($data,$searchInput));
    }

    public function showDetail($id){

        $refundInfo = $this->refundInfoModel->findInfoById($id);
        $refund_code = $refundInfo->refund_code;
        //var_dump($item->refund_code);
        //exit;

        $data = $this->refundPartinfoModel->getPartinfo($refund_code);
        $lists = $data['lists'];
        //var_dump($lists);
        //exit;

        foreach ($lists as $key => $item){
            $part_sequence =  $item->item_code;
            //echo $key." : ".$part_sequence."<br>";

            $now_product_info = $this->productModel->findByProductInfo($part_sequence);

            $nowinfo = [
            'product_code'   => $now_product_info ->product_code,
            'part_number' => $now_product_info ->part_number,
            'image_dir'   => $now_product_info ->image_dir,
            'api_flg'   => $now_product_info ->api_flg,
            'selling_price1' => $now_product_info ->selling_price1,
            'part_number_sequence' => $now_product_info ->part_number_sequence,
            'brief_description' => $now_product_info ->brief_description,
            'product_related' => $now_product_info ->product_related,
            'stock_location' => $now_product_info ->stock_location,
            'delivery_code' => $now_product_info ->delivery_code
        ];

            $lists[$key]->nowinfo = $nowinfo;
        }

        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
        $data['reasonreturninfo'] = $this->reasonreturnInfoModel->findAll();
        $data['refundInfo'] = $refundInfo;

        return $this->viewAdmin('refundinfo/detail', $data);

    }

    public function update($id){

       // $this->rules = $this->refundInfoModel->getValidationRules();

       // if($this->checkValidation()){
            $this->refundInfoService->updateRefundInfo($id,$this->request);
            $message = "Update refundInfo success";
            // return redirect()->route('admin.refundinfo.index')->with('message',$message);
            return redirect()->route('admin.refundinfo.detail',[$id])->with('message',$message);

        /*
        }else{
            $message = "No Update refundInfo.";
            return redirect()->route('admin.refundinfo.detail',[$id])->with('message',$message);
        }
        */
    }

    public function delete($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->refundInfoService->deleteSaleRefundinfo($ids);
            if($result) $message = "Delete refundinfo success";
        }
        return redirect()->route('admin.refundinfo.index')->with('message',$message);
    }

}
