<?php namespace App\Controllers\Admin;

use App\Entities\Review;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\ReviewCategoryModel;
use App\Models\ReviewFileModel;
use App\Models\ReviewModel;
use App\Services\ReviewService;
use App\Models\ProductModel;

class ReviewController extends BaseController
{
    protected $reviewModel;
    protected $reviewFileModel;
    protected $reviewService;
    protected $reviewCategoryModel;
    protected $productModel;

    public function __construct()
    {
        $this->reviewModel = new ReviewModel();
        $this->reviewFileModel = new ReviewFileModel();
        $this->reviewService = new ReviewService();
        $this->reviewCategoryModel = new ReviewCategoryModel();
        $this->productModel = new ProductModel();
    }

    public function index()
    {
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( ( isset($searchInput['category_id']) && $searchInput['category_id'] != '') || ( isset($searchInput['title']) && $searchInput['title'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $categories = $this->reviewCategoryModel->findAll();
        $data = $this->reviewModel->getSearch($searchInput,$perPage);
        $data['categories'] = $categories;
        return $this->viewAdmin('review/index',array_merge($data,$searchInput));
    }

    protected function validationMapFieldLabels(){
        return [
            'title' => lang_common('title'),
            'content' => lang_common('content')
        ];
    }

    public function showCreate(){
        $this->rules = $this->reviewModel->getValidationRules();
        $categories = $this->reviewCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['maxFiles'] = 10;
        return $this->viewAdmin('review/create',$data);
    }

    public function create(){
        $this->rules = $this->reviewModel->getValidationRules();
        if($this->checkValidation()){
            $accountManger = AuthHelpers::getLoginInfoAdmin();
            $this->reviewService->saveReview($this->request,$accountManger->account_id);
            $message = 'Create review success.';
            return redirect()->route('admin.review.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('review/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->reviewModel->getValidationRules();
        $reviewItem = $this->reviewModel->find($id);
        $files = $this->reviewFileModel->where('review_id',$id)->findAll();
        $data['item'] = $reviewItem;

        $item_code = $reviewItem->item_code;
        $productinfo = $this->productModel->findByProductCode($item_code);
        $data['productinfo'] = $productinfo;
        // var_dump ($data['productinfo']);
        // exit;

        $categories = $this->reviewCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['item'] = $reviewItem;
        $data['files'] = $files;
        $data['maxFiles'] = 10 - count($files);
        return $this->viewAdmin('review/update', $data);
    }

    public function update($id){
        $this->rules = $this->reviewModel->getValidationRules();
        if($this->checkValidation()){
            $this->reviewService->updateReview($id,$this->request);
            $message = "Update review success";
            return redirect()->route('admin.review.index')->with('message',$message);
        }else{
            return view('admin/review/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteReview($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->reviewService->deleteReview($ids);
            if($result) $message = "Delete review success";
        }
        return redirect()->route('admin.review.index')->with('message',$message);
    }

    public function deleteFile($reviewId,$fileNo){
        $this->reviewFileModel->delete($fileNo);
        $message = "Delete file success";
        return redirect()->route('admin.review.update',[$reviewId])->with('message',$message);;
    }

}
