<?php namespace App\Controllers\Admin;

use App\Entities\ShippingCompany;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\ShippingCompanyModel;
use App\Services\ShippingCompanyService;

class ShippingCompanyController extends BaseController
{
    protected $shippingCompanyModel;
    protected $shippingCompanyService;

    public function __construct()
    {
        $this->shippingCompanyModel = new ShippingCompanyModel();
        $this->shippingCompanyService = new ShippingCompanyService();
    }

    public function index()
    {
        // echo "Packaging Unit.";
        // exit;

        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if(( isset($searchInput['shipping_code']) && $searchInput['shipping_code'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $data = $this->shippingCompanyModel->getSearch($searchInput,$perPage);
        return $this->viewAdmin('shippingcompany/index',array_merge($data,$searchInput));
    }

    protected function validationMapFieldLabels(){
        return [
            'shipping_code' => lang_common('shipping_code'),
            'shipping_name' => lang_common('shipping_name')
        ];
    }

    public function showCreate(){
        // echo "Packaging Unit.";
        // exit;
        $this->rules = $this->shippingCompanyModel->getValidationRules();
        return $this->viewAdmin('shippingcompany/create',$data);
    }

    public function create(){
        $this->rules = $this->shippingCompanyModel->getValidationRules();

        if($this->checkValidation()){
            $this->shippingCompanyService->saveShippingCompany($this->request);
            $message = 'Create shippingCompany success.';
            return redirect()->route('admin.shippingcompany.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('shippingcompany/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($shipping_id){
        $this->rules = $this->shippingCompanyModel->getValidationRules();
        $shippingCompanyItem = $this->shippingCompanyModel->find($shipping_id);
        $data['item'] = $shippingCompanyItem;
        return $this->viewAdmin('shippingcompany/update', $data);
    }

    public function update($shipping_id){
        $this->rules = $this->shippingCompanyModel->getValidationRules();
        if($this->checkValidation()){
            $this->shippingCompanyService->updateShippingCompany($shipping_id,$this->request);
            $message = "Update shippingCompany success";
            return redirect()->route('admin.shippingcompany.index')->with('message',$message);
        }else{
            return view('admin/shippingcompany/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteShippingCompany($strIds){
        $message = "";
        if(isset($strIds)){
            $shipping_ids = explode(',',$strIds);
            $result = $this->shippingCompanyService->deleteShippingCompany($shipping_ids);
            if($result) $message = "Delete shippingCompany success";
        }
        return redirect()->route('admin.shippingcompany.index')->with('message',$message);
    }

}
