<?php namespace App\Controllers\Admin;

use App\Entities\Showwindow;
use App\Helpers\AuthHelpers;
use App\Models\ShowwindowModel;

use App\Models\ProductsShippingModel;
use App\Models\ManufacturerModel;
use App\Services\ShowWindowService;

use App\Models\LocationinfoModel;
use App\Models\DisplayinfoModel;
use App\Models\EventinfoModel;
use App\Models\ApiinfoModel;

use App\Models\Categorylevel1Model;
use App\Models\Categorylevel2Model;
use App\Models\Categorylevel3Model;
use App\Models\StocklocationCategoryModel;
use App\Models\LeadtimeCategoryModel;
use App\Models\DeliverycodeModel;
use App\Models\PackagingUnitModel;

class ShowWindowController extends BaseController
{
    protected $showwindowModel;
    protected $productsShippingModel;
    protected $showwindowService;
    protected $manufacturerModel;
    protected $locationinfoModel;
    protected $displayinfoModel;
    protected $apiinfoModel;
    protected $eventinfoModel;
    protected $categorylevel1Model;
    protected $categorylevel2Model;
    protected $categorylevel3Model;
    protected $stocklocationCategoryModel;
    protected $leadtimeCategoryModel;
    protected $deliverycodesModel;
    protected $packagingUnitModel;

    public function __construct()
    {
        $this->showwindowModel = new ShowwindowModel();
        $this->showwindowService = new ShowWindowService();
        $this->productsShippingModel = new ProductsShippingModel();
        $this->manufacturerModel = new ManufacturerModel();
        $this->locationinfoModel = new LocationinfoModel();
        $this->displayinfoModel = new DisplayinfoModel();
        $this->eventinfoModel = new EventinfoModel();
        $this->apiinfoModel = new ApiinfoModel();
        $this->categorylevel1Model = new Categorylevel1Model();
        $this->categorylevel2Model = new Categorylevel2Model();
        $this->categorylevel3Model = new Categorylevel3Model();
        $this->stocklocationCategoryModel = new StocklocationCategoryModel();
        $this->leadtimeCategoryModel = new LeadtimeCategoryModel();
        $this->deliverycodesModel = new DeliverycodeModel();
        $this->packagingUnitModel = new PackagingUnitModel();
    }

    public function index()
    {
        
        //echo "Test !!!";
        //exit;

        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( isset($searchInput['part_number']) && $searchInput['part_number'] != '' ) $searchInput['is_search'] = true;
        $data = $this->showwindowModel->getAdmin($searchInput, $perPage);
        return $this->viewAdmin('showwindow/index',array_merge($data, $searchInput));
    }

    protected function validationMapFieldLabels(){
        return [
            'part_number' => lang_product('list_part_number'),
            'qty' => lang_product('list_qty'),
            'id' => lang_product('list_manufacturer'),
            'pdf_file' => 'PDF file'
        ];
    }

    public function showCreate(){
        $this->rules = $this->showwindowModel->getValidationRules();
        $this->showwindowModel->getMaxLengthRules();
        $data['manufacturers'] = $this->manufacturerModel->orderBy('name', 'ASC')->selectAll();
        $data['locationinfos'] = $this->locationinfoModel->selectAll();
        $data['displayinfos'] = $this->displayinfoModel->selectAll();
        $data['eventinfos'] = $this->eventinfoModel->getEventinfo();
        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
        $data['leadtimecategorys'] = $this->leadtimeCategoryModel->findAll();
        $data['deliverycodes'] = $this->deliverycodesModel->findAll();
        $data['apiinfos'] = $this->apiinfoModel->selectAll();
        $data['packagingunits'] = $this->packagingUnitModel->findAll();

        $categorylevel1Model = new Categorylevel1Model();
		$data['categorylevel1'] = $categorylevel1Model->orderBy('categorylevel1_name', 'ASC')->findAll();

        AuthHelpers::clearProdCode();
        $product_code = AuthHelpers::getProdCode();
        
        if(!$product_code) {
        $timestr = date(time());
        $codestr = substr($timestr, 4);
        $countInsert = 0;
        $codecount = str_pad($countInsert, 6, "0", STR_PAD_LEFT);
        $productcode = "CD".$codestr.$codecount;
        
        AuthHelpers::setProdCode($productcode);
        }

        return $this->viewAdmin('showwindow/create',$data);
    }

    public function create(){
        $insertId = $this->showwindowService->saveShowwindowList($this->request);

        $message = '제품정보를 등록 했습니다.';
        return redirect()->route('admin.productcreate.create_ok')->with('message', $message);

    }


    public function createOk(){

        return $this->viewAdmin('showwindow/createok', $data);

    }

    
    public function showUpdate($id){
        $product = $this->showwindowModel->find($id);
        $product_code = $product->product_code;        

        $productdetail = $this->productdetailModel->where('product_code',$product_code)->first();
        $productsshipping = $this->productsShippingModel->getProductsshipping($product_code);

        // var_dump($productdetail);
        // exit;
        
        $this->rules = $this->showwindowModel->getValidationRules();

        $data['manufacturers'] =$this->manufacturerModel->orderBy('name', 'ASC')->selectAll();
		$data['categorylevel1'] = $this->categorylevel1Model->orderBy('categorylevel1_name', 'ASC')->findAll();
		$data['categorylevel2'] = $this->categorylevel2Model->orderBy('categorylevel2_name', 'ASC')->findAll();
		$data['categorylevel3'] = $this->categorylevel3Model->orderBy('categorylevel3_name', 'ASC')->findAll();
        $data['locationinfos'] = $this->locationinfoModel->selectAll();
        $data['eventinfos'] = $this->eventinfoModel->getEventinfo();
        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
        $data['leadtimecategorys'] = $this->leadtimeCategoryModel->findAll();
        $data['deliverycodes'] = $this->deliverycodesModel->findAll();
        $data['apiinfos'] = $this->apiinfoModel->selectAll();
        $data['packagingunits'] = $this->packagingUnitModel->findAll();

        $data['product'] = $product;
        $data['productdetail'] = $productdetail;
        $data['productsshipping'] = $productsshipping;

        return $this->viewAdmin('showwindow/update', $data);
    }

    public function update($id){
            $this->showwindowService->uploadProductList($id,$this->request);

            $message = '제품정보를 업데이트 했습니다.';

            return redirect()->route('admin.showwindow.index')->with('message', $message);

    }


    public function upshowwindow($id){
        $showwindow_mode = $this->request->getPost('showwindow_mode');
        $this->showwindowModel->insertShowwindow($id,$showwindow_mode);
        // exit;

        $message = '제품정보를 메인페이지 추가했습니다.';
        return redirect()->route('admin.showwindow.index')->with('message', $message);
    }


    public function delete($strIds){

        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            // var_dump($ids);
            // exit;

            $result = $this->showwindowService->deleteProduct($ids);
            if($result) $message = "제품정보를 삭제했습니다.";
        }
        return redirect()->route('admin.showwindow.index')->with('message',$message);
    }

    public function deleteAll(){
        $message = "제품정보를 모두 삭제했습니다.";
        $this->showwindowService->deleteAllProduct();
        return redirect()->route('admin.showwindow.index')->with('message',$message);
    }

}
