<?php namespace App\Controllers\Admin;

use App\Helpers\DateHelper;
use App\Helpers\FileHelper;
use App\Helpers\AuthHelpers;
use App\Entities\TaxInvoice;
use App\Services\NaverPayService;
use App\Models\OrderInfoModel;
use App\Models\ShippingCompanyModel;
use App\Models\OrderPartinfoModel;
use App\Models\ProductModel;
use App\Models\StocklocationCategoryModel;
use App\Services\OrderInfoService;
use App\Models\OrderStatusModel;
use App\Models\ApiinfoModel;

use App\Models\TaxinvoiceStatusModel;

class TaxInvoiceController extends BaseController
{
    protected $naverPayService;
    protected $orderInfoModel;
    protected $orderPartinfoModel;
    protected $orderInfoService;
    protected $shippingCompanyModel;
    protected $productModel;
    protected $stocklocationCategoryModel;
    protected $orderStatusModel;
    protected $apiinfoModel;
    protected $taxinvoiceStatusModel;

    public function __construct()
    {
        $this->naverPayService = new NaverPayService();
        $this->orderInfoModel = new OrderInfoModel();
        $this->orderPartinfoModel = new OrderPartinfoModel();
        $this->productModel = new ProductModel();
        $this->shippingCompanyModel = new ShippingCompanyModel();
        $this->stocklocationCategoryModel = new StocklocationCategoryModel();
        $this->orderInfoService = new OrderInfoService();
        $this->orderStatusModel = new OrderStatusModel();
        $this->apiinfoModel = new ApiinfoModel();
        $this->taxinvoiceStatusModel = new TaxinvoiceStatusModel();
    }

    public function index()
    {
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        $keyword_item = $searchInput['keyword_item'];

        if ($keyword_item) {

            if ($keyword_item == "orderer_partnumber") {
                $data = $this->orderInfoModel->getSearchPartinfoTax($searchInput,$perPage);
            } else {
                $data = $this->orderInfoModel->getSearchKeywordTax($searchInput,$perPage);
            }

        } else {
        
        if(isset($searchInput['from_date']) || isset($searchInput['to_date'])) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $data = $this->orderInfoModel->getSearchTax($searchInput,$perPage);

        }

        $data['orderstatus'] = $this->orderStatusModel->findAll();
        $data['taxinvoicestatus'] = $this->taxinvoiceStatusModel->findAll();
        return $this->viewAdmin('taxinvoice/index',array_merge($data,$searchInput));
    }

    public function showDetail($id){

        $orderInfo = $this->orderInfoModel->findInfoById($id);
        $order_code = $orderInfo->order_code;
        //var_dump($item->order_code);
        //exit;

        $data = $this->orderPartinfoModel->getPartinfo($order_code);
        $lists = $data['lists'];
        //var_dump($lists);
        //exit;

        foreach ($lists as $key => $item){
            $part_sequence =  $item->item_code;
            //echo $key." : ".$part_sequence."<br>";

            $now_product_info = $this->productModel->findByProductInfo($part_sequence);
            //var_dump ($now_product_info);
            //exit;

            $nowinfo = [
            'product_code'   => $now_product_info ->product_code,
            'part_number' => $now_product_info ->part_number,
            'image_dir'   => $now_product_info ->image_dir,
            'api_flg'   => $now_product_info ->api_flg,
            'selling_price1' => $now_product_info ->selling_price1,
            'part_number_sequence' => $now_product_info ->part_number_sequence,
            'brief_description' => $now_product_info ->brief_description,
            'product_related' => $now_product_info ->product_related,
            'stock_location' => $now_product_info ->stock_location,
            'api_code' => $now_product_info ->api_code,
            'product_api_id' => $now_product_info ->product_api_id,
            'delivery_code' => $now_product_info ->delivery_code
        ];

            $lists[$key]->nowinfo = $nowinfo;
        }

        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
        $data['orderstatus'] = $this->orderStatusModel->findAll();
        $data['apiinfos'] = $this->apiinfoModel->selectAll();
        $data['shippingcompany'] = $this->shippingCompanyModel->findAll();
        $data['orderInfo'] = $orderInfo;

        return $this->viewAdmin('taxinvoice/detail', $data);

    }

    public function update($id){

       // $this->rules = $this->orderInfoModel->getValidationRules();

       // if($this->checkValidation()){
            $orderInfo = $this->orderInfoModel->findInfoById($id);
            $order_status = $this->request->getPost('order_status');
            $orderstatus = $this->orderStatusModel->findAll();

            foreach ($orderstatus as $order_prevstatus) {
                if($orderInfo->order_status == $order_prevstatus->status_code) {
                    $previously_status = $order_prevstatus->status_info;
                    // echo $previously_status."<br>";
                }
            }

            foreach ($orderstatus as $order_nextstatus) {
                if($order_status == $order_nextstatus->status_code) {
                    $change_status = $order_nextstatus->status_info;
                    // echo $change_status."<br>";
                }
            }

            // exit;
            $this->orderInfoService->updateOrderInfo($id,$this->request);

            if ($order_status == 5 || $order_status == 6) {
            $data = $this->orderPartinfoModel->getPartinfo($orderInfo->order_code);
            $lists = $data['lists'];
            $partlists = "<br><p><table style='border: 1px solid;'>";
            $partlists .= "<tr><th style='border: 1px solid; margin: auto;'>샵 제품번호</th><th style='border: 1px solid; margin: auto;'>제품명</th><th style='border: 1px solid; margin: auto;'>제조사</th><th style='border: 1px solid; margin: auto;'>배송회사</th><th style='border: 1px solid; margin: auto;'>송장번호</th><th style='border: 1px solid; margin: auto;'>송장등록일시</th><tr>";
             
            foreach ($lists as $key => $item){
                $item_code = $item->item_code;
                $part_number = $item->part_number;
                $manufacturer_name = $item->manufacturer_name;
                $qty = $item->qty;
                $item_status = $item->order_status;
                $modify_qty = $item->modify_qty;

                // $ship_company = $item->ship_company;
                $shippingcompany = $this->shippingCompanyModel->findAll();

                foreach ($shippingcompany as $shipping_company) {
                    if($item->ship_company == $shipping_company->shipping_id) {
                        $ship_company = $shipping_company->shipping_name;
                        // echo $ship_company."<br>";
                    }
                }

                /*
                if ($item->ship_company == 1) {
                    $ship_company = "롯데택베";
                } elseif ($item->ship_company == 2) {
                    $ship_company = "우체국택";
                }
                */

                $invoice_num = $item->invoice_num;
                $ship_date = $item->ship_date;
                $partlists .= "<tr><td style='border: 1px solid; margin: auto;'>$item_code</td><td style='border: 1px solid; margin: auto;'>$part_number</td><td style='border: 1px solid; margin: auto;'>$manufacturer_name</td><td style='border: 1px solid; margin: auto;'>$ship_company</td><td style='border: 1px solid; margin: auto;'>$invoice_num</td><td style='border: 1px solid; margin: auto;'>$ship_date</td><tr>";
            }

            $partlists .= "</table></p><br>";
            }

            if ($order_status > 1) {

            $email = \Config\Services::email();

            $config['protocol'] = 'html';
            $config['mailPath'] = '/usr/sbin/sendmail -t -i';
            $config['fromEmail'] = 'kyungyeon.jung@gmail.com';
            $config['fromName'] = 'ChipDirect';
    
            $email->initialize($config);
            $email->setFrom('pixel@mediain.co.kr', 'ChipDirect');
            $email->setTo($orderInfo->orderer_email);
            $email->setSubject('[구매정보] 주문번호 ['. $orderInfo->order_code .']의 주문내역이 변경 되었습니다.');
            $email->setMessage('저희 칩다이렉트 쇼핑몰을 이용해 주셔서 감사합니다.<br>

            고객님의 주문번호 ['. $orderInfo->order_code .']의 상태가 <font style="background-color:powderblue; font-weight: bold;">'. $previously_status .'에서 '. $change_status .'으로  변경</font>되었습니다.<br>
            '. $partlists .'
            자세한 내역은 "<a href="https://chipdirect.co.kr/orderinfo">주문내역</a>"에서 확인하실 수 있습니다.<br>
            감사합니다.');



        /****************** 메시지 시작 ******************/
        if ($order_status == 5 || $order_status == 6) {
            $handphone = $orderInfo->orderer_phone;
            $member_name = $orderInfo->orderer_name;

            if ($order_status == 6) {
                $content = "\n상품이 부분발송되었습니다. 관련정보를 주문내역에서 확인하세요.";                
            } else {
                $content = "\n상품이 발송되었습니다. 관련정보를 주문내역에서 확인하세요.";
            }

            if ($handphone) {
                $receiver_name = $member_name;
                $receiver_phone = str_replace('-','',$handphone);
            
                /****************** 인증정보 시작 ******************/
                $sms_url = "https://apis.aligo.in/send/"; // 전송요청 URL
                $sms['user_id'] = "chipdirect"; // SMS 아이디
                $sms['key'] = "5iomz2bals7kofy7siiynx33sxo5nxtp";//인증키
                /****************** 인증정보 끝 ********************/
                /****************** 전송정보 설정시작 ****************/
                $_POST['msg'] = '%고객명% '.$member_name.'님. '.$content; // 메세지 내용 : euc-kr로 치환이 가능한 문자열만 사용하실 수 있습니다. (이모지 사용불가능)
                $_POST['receiver'] = $receiver_phone; // 수신번호
                $_POST['destination'] = $receiver_phone.'|'.$receiver_name; // 수신인 %고객명% 치환
                $_POST['sender'] =""; // 발신번호
                $_POST['rdate'] = ''; // 예약일자 - 20161004 : 2016-10-04일기준
                $_POST['rtime'] = ''; // 예약시간 - 1930 : 오후 7시30분
                $_POST['testmode_yn'] = 'N'; // Y 인경우 실제문자 전송X , 자동취소(환불) 처리
                $_POST['subject'] = '테스트 발송'; //  LMS, MMS 제목 (미입력시 본문중 44Byte 또는 엔터 구분자 첫라인)
                // $_POST['image'] = '/tmp/pic_57f358af08cf7_sms_.jpg'; // MMS 이미지 파일 위치 (저장된 경로)
                $_POST['msg_type'] = 'SMS'; //  SMS, LMS, MMS등 메세지 타입을 지정
                // ※ msg_type 미지정시 글자수/그림유무가 판단되어 자동변환됩니다. 단, 개행문자/특수문자등이 2Byte로 처리되어 SMS 가 LMS로 처리될 가능성이 존재하므로 반드시 msg_type을 지정하여 사용하시기 바랍니다.
                /****************** 전송정보 설정끝 ***************/
                $sms['msg'] = stripslashes($_POST['msg']);
                $sms['receiver'] = $_POST['receiver'];
                $sms['destination'] = $_POST['destination'];
                $sms['sender'] = $_POST['sender'];
                $sms['rdate'] = $_POST['rdate'];
                $sms['rtime'] = $_POST['rtime'];
                $sms['testmode_yn'] = empty($_POST['testmode_yn']) ? '' : $_POST['testmode_yn'];
                $sms['title'] = $_POST['subject'];
                $sms['msg_type'] = $_POST['msg_type'];
                // 만일 $_FILES 로 직접 Request POST된 파일을 사용하시는 경우 move_uploaded_file 로 저장 후 저장된 경로를 사용하셔야 합니다.
                if(!empty($_FILES['image']['tmp_name'])) {
                    $tmp_filetype = mime_content_type($_FILES['image']['tmp_name']); 
                    if($tmp_filetype != 'image/png' && $tmp_filetype != 'image/jpg' && $tmp_filetype != 'image/jpeg') $_POST['image'] = '';
                    else {
                        $_savePath = "./".uniqid(); // PHP의 권한이 허용된 디렉토리를 지정
                        if(move_uploaded_file($_FILES['file']['tmp_name'], $_savePath)) {
                            $_POST['image'] = $_savePath;
                        }
                    }
                }
                // 이미지 전송 설정
                if(!empty($_POST['image'])) {
                    if(file_exists($_POST['image'])) {
                        $tmpFile = explode('/',$_POST['image']);
                        $str_filename = $tmpFile[sizeof($tmpFile)-1];
                        $tmp_filetype = mime_content_type($_POST['image']);
                        if ((version_compare(PHP_VERSION, '5.5') >= 0)) { // PHP 5.5버전 이상부터 적용
                            $sms['image'] = new CURLFile($_POST['image'], $tmp_filetype, $str_filename);
                            curl_setopt($oCurl, CURLOPT_SAFE_UPLOAD, true);
                        } else {
                            $sms['image'] = '@'.$_POST['image'].';filename='.$str_filename. ';type='.$tmp_filetype;
                        }
                    }
                }
                /*****/
                $host_info = explode("/", $sms_url);
                $port = $host_info[0] == 'https:' ? 443 : 80;
                $oCurl = curl_init();
                curl_setopt($oCurl, CURLOPT_PORT, $port);
                curl_setopt($oCurl, CURLOPT_URL, $sms_url);
                curl_setopt($oCurl, CURLOPT_POST, 1);
                curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sms);
                curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, FALSE);
                $ret = curl_exec($oCurl);
                curl_close($oCurl);
                $responseData["smslog"] = json_decode($ret);
            }
        }
        /****************** 메시지 끝 ******************/

        $message = $change_status.'으로 주문내역이 변경되었습니다.'; //테스트 작업용.
        return redirect()->route('admin.taxinvoice.detail',[$id])->with('message',$message);    
    
        /*    
            if($email->send(false)){
                $message = $change_status.'으로 주문내역이 변경되었습니다.';
                return redirect()->route('admin.taxinvoice.detail',[$id])->with('message',$message);    
            }else{
                echo "메일 전송에 문제가 있습니다.";
            }
        */
        
        }else{
            $message = $change_status.'으로 주문내역이 변경되었습니다.';
            return redirect()->route('admin.taxinvoice.detail',[$id])->with('message',$message);   
        }

    }

    public function updatewin($id){
             $this->orderInfoService->updateOrderInfo($id,$this->request);
             $message = "Update orderInfo success";
             return redirect()->route('admin.taxinvoice.detailwin',[$id])->with('message',$message);
     }

    public function updatePartInfo($id){
            $order_code = $this->request->getPost('order_code');
            $chk_shipcompany = $this->request->getPost('chk_shipcompany');
            $chk_invoicenum = $this->request->getPost('chk_invoicenum');
            $chk_orderstatus = $this->request->getPost('chk_orderstatus');

            if ($chk_orderstatus == "5" || $chk_orderstatus == "6") {
                $chk_ship_date = date('Y-m-d h:i:s ', time());
            }

            $dataRow = $this->request->getPost('orderpart_count');
            // var_dump($chk_shipcompany);

            for($i=1;$i <= $dataRow;$i++):
                $order_id = $this->request->getPost('order_id'.$i);
                $modify_qty = $this->request->getPost('modify_qty'.$i);
                $price = $this->request->getPost('price'.$i);

                if ($order_id) {
                    $partinfoItem =  $this->orderPartinfoModel->find($order_id);

                    if(isset($partinfoItem)){
                        if ($chk_shipcompany) {
                            $partinfoItem->ship_company =  $chk_shipcompany;
                        }
                        
                        if ($chk_invoicenum) {
                            $partinfoItem->invoice_num =  $chk_invoicenum;
                        }

                        if ($chk_orderstatus) {
                            $partinfoItem->order_status =  $chk_orderstatus;
                        }

                        if ($chk_ship_date) {
                            $partinfoItem->ship_date =  $chk_ship_date;
                        }

                        if ($modify_qty) {
                            $partinfoItem->modify_qty =  $modify_qty;

                            $supply_price = $modify_qty*$price;
                            $partinfoItem->supply_price = $supply_price;

                            $price_vat = $supply_price*0.1;
                            $partinfoItem->vat = $price_vat;

                            $amount_price = $supply_price+$price_vat;
                            $partinfoItem->amount = $amount_price;
                        }

                        if ($chk_shipcompany || $chk_invoicenum || $chk_orderstatus || $modify_qty) {

                        $order_type = $partinfoItem->order_type;
                        // var_dump($order_type);

                        if ($order_type == "NAV") {
                            $seller_order_refer_no = $partinfoItem->nav_productorder_code;

                            if ($partinfoItem->ship_company  == "1") {
                                $seller_deliver_code = "HYUNDAI";
                            } elseif ($partinfoItem->ship_company  == "2") {
                                $seller_deliver_code = "EPOST";
                            }

                            $seller_invoice_code = $partinfoItem->invoice_num;
                            // var_dump($seller_invoice_code);
                            $responseDelivery = $this->naverPayService->setDelivery($seller_order_refer_no,$seller_deliver_code,$seller_invoice_code);
                            $ResponseType = $responseDelivery->soapenvBody->nShipProductOrderResponse->n1ResponseType;
                            $ResponseMessage = $responseDelivery->soapenvBody->nShipProductOrderResponse->n1Error->n1Message;
                            
                        }

                        // echo "<br>";
                        // var_dump($partinfoItem);
                        // exit;

                        $this->orderPartinfoModel->save($partinfoItem);
                        }
                    }
                }
    
            endfor;

            $this->orderInfoService->updateOrderInfo($id,$this->request);

            if ($ResponseType == "ERROR") {
                $message = $ResponseType."! ".$ResponseMessage;
            } else {
                $message = "Update orderInfo success";
            }

            return redirect()->route('admin.taxinvoice.detail',[$id])->with('message',$message);

            $orderInfo = $this->orderInfoModel->findInfoById($id);
            var_dump ($orderInfo);
            exit;

            $order_status = $this->request->getPost('order_status');
            $this->orderInfoService->updateOrderInfo($id,$this->request);

            $email = \Config\Services::email();

            $config['protocol'] = 'html';
            $config['mailPath'] = '/usr/sbin/sendmail -t -i';
            $config['fromEmail'] = 'kyungyeon.jung@gmail.com';
            $config['fromName'] = 'ChipDirect';

            $email->initialize($config);
            $email->setFrom('pixel@mediain.co.kr', 'ChipDirect');
            $email->setTo($inquiry->orderer_email);
            $email->setSubject('[구매정보] 주문번호 ['. $order_code .']의 주문내역이 변경 되었습니다.');
            $email->setMessage('저희 칩다이렉트 쇼핑몰을 이용해 주셔서 감사합니다.<br>
            고객님의 주문번호 ['. $order_code .']의 주문내역은 "<a href="https://chipdirect.co.kr/orderinfo">주문내역</a>"에서 확인하실 수 있습니다.<br>
            주문서 상태변경 : '. $order_status .'<br>
            감사합니다.');

            if($email->send(false)){
                $message = "Update orderInfo success";
                return redirect()->route('admin.taxinvoice.detail',[$id])->with('message',$message);
            }else{
                echo "메일 전송에 문제가 있습니다.";
            }


     }


    public function updatePartInfoWin($id){
        $order_code = $this->request->getPost('order_code');
        $chk_shipcompany = $this->request->getPost('chk_shipcompany');
        $chk_invoicenum = $this->request->getPost('chk_invoicenum');
        $chk_orderstatus = $this->request->getPost('chk_orderstatus');

        if ($chk_orderstatus == "5" || $chk_orderstatus == "6") {
            $chk_ship_date = date('Y-m-d h:i:s ', time());
        }

        $dataRow = $this->request->getPost('orderpart_count');
        for($i=1;$i <= $dataRow;$i++):
            $order_id = $this->request->getPost('order_id'.$i);
            $modify_qty = $this->request->getPost('modify_qty'.$i);
            $price = $this->request->getPost('price'.$i);

            if ($order_id) {
                $partinfoItem =  $this->orderPartinfoModel->find($order_id);

                if(isset($partinfoItem)){
                    if ($chk_shipcompany) {
                        $partinfoItem->ship_company =  $chk_shipcompany;
                    }
                    if ($chk_invoicenum) {
                        $partinfoItem->invoice_num =  $chk_invoicenum;
                    }
                    if ($chk_orderstatus) {
                        $partinfoItem->order_status =  $chk_orderstatus;
                    }
                    if ($chk_ship_date) {
                        $partinfoItem->ship_date =  $chk_ship_date;
                    }
                    if ($modify_qty) {
                        $partinfoItem->modify_qty =  $modify_qty;

                        $supply_price = $modify_qty*$price;
                        $partinfoItem->supply_price = $supply_price;

                        $price_vat = $supply_price*0.1;
                        $partinfoItem->vat = $price_vat;

                        $amount_price = $supply_price+$price_vat;
                        $partinfoItem->amount = $amount_price;
                    }
                    if ($chk_shipcompany || $chk_invoicenum || $chk_orderstatus || $modify_qty) {
                    $this->orderPartinfoModel->save($partinfoItem);
                    }
                }
            }

        endfor;
        
        $this->orderInfoService->updateOrderInfo($id,$this->request);
        $message = "Update orderInfo success";
        return redirect()->route('admin.taxinvoice.detailwin',[$id])->with('message',$message);
    }


    public function delete($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->orderInfoService->deleteSaleTaxInvoice($ids);
            if($result) $message = "Delete orderinfo success";
        }
        return redirect()->route('admin.taxinvoice.index')->with('message',$message);
    }


    public function downtofile($strIds){
        $message = "";
        if(isset($strIds)) {
            $ids = explode(',',$strIds);

            if(isset($ids)){
                foreach ($ids as $key => $id){
                    $item = $this->orderInfoModel->find($id);

                    if(isset($item)){
                        $item->taxinvoice_status = "3";
                        $item->taxinvoice_created = date('Y-m-d h:i:s ', time());;
                        $this->orderInfoModel->save($item);
                    }

                    $item_id_array[$key] = $id;
                }
                $this->makeTaxinvoice($item_id_array);
            }
            $message = "Success";
        }
        return redirect()->route('admin.taxinvoice.index')->with('message',$message);
    }


    public function makeTaxinvoice($item_id_array){
        $data = $this->orderInfoModel->getTexExcel($item_id_array);

        $headerEmptys = [
            lang_taxinvoice('empty')
        ];

        $headerColumns = [
            lang_taxinvoice('label1'),
            lang_taxinvoice('label2'),
            lang_taxinvoice('label3'),
            lang_taxinvoice('label4'),
            lang_taxinvoice('label5'),
            lang_taxinvoice('label6'),
            lang_taxinvoice('label7'),
            lang_taxinvoice('label8'),
            lang_taxinvoice('label9'),
            lang_taxinvoice('label10'),
            lang_taxinvoice('label11'),
            lang_taxinvoice('label12'),
            lang_taxinvoice('label13'),
            lang_taxinvoice('label14'),
            lang_taxinvoice('label15'),
            lang_taxinvoice('label16'),
            lang_taxinvoice('label17'),
            lang_taxinvoice('label18'),
            lang_taxinvoice('label19'),
            lang_taxinvoice('label20'),
            lang_taxinvoice('label21'),
            lang_taxinvoice('label22'),
            lang_taxinvoice('label23'),
            lang_taxinvoice('label24'),
            lang_taxinvoice('label25'),
            lang_taxinvoice('label26'),
            lang_taxinvoice('label27'),
            lang_taxinvoice('label28'),
            lang_taxinvoice('label29'),
            lang_taxinvoice('label30'),
            lang_taxinvoice('label31'),
            lang_taxinvoice('label32'),
            lang_taxinvoice('label33'),
            lang_taxinvoice('label34'),
            lang_taxinvoice('label35'),
            lang_taxinvoice('label36'),
            lang_taxinvoice('label37'),
            lang_taxinvoice('label38'),
            lang_taxinvoice('label39'),
            lang_taxinvoice('label40'),
            lang_taxinvoice('label41'),
            lang_taxinvoice('label42'),
            lang_taxinvoice('label43'),
            lang_taxinvoice('label44'),
            lang_taxinvoice('label45'),
            lang_taxinvoice('label46'),
            lang_taxinvoice('label47'),
            lang_taxinvoice('label48'),
            lang_taxinvoice('label49'),
            lang_taxinvoice('label50'),
            lang_taxinvoice('label51'),
            lang_taxinvoice('label52'),
            lang_taxinvoice('label53'),
            lang_taxinvoice('label54'),
            lang_taxinvoice('label55'),
            lang_taxinvoice('label56'),
            lang_taxinvoice('label57'),
            lang_taxinvoice('label58'),
            lang_taxinvoice('label59')
        ];

        $dataColumns = [
            TaxInvoice::LABEL1,
            TaxInvoice::LABEL2,
            TaxInvoice::LABEL3,
            TaxInvoice::LABEL4,
            TaxInvoice::LABEL5,
            TaxInvoice::LABEL6,
            TaxInvoice::LABEL7,
            TaxInvoice::LABEL8,
            TaxInvoice::LABEL9,
            TaxInvoice::LABEL10,
            TaxInvoice::LABEL11,
            TaxInvoice::LABEL12,
            TaxInvoice::LABEL13,
            TaxInvoice::LABEL14,
            TaxInvoice::LABEL15,
            TaxInvoice::LABEL16,
            TaxInvoice::LABEL17,
            TaxInvoice::LABEL18,
            TaxInvoice::LABEL19,
            TaxInvoice::LABEL20,
            TaxInvoice::LABEL21,
            TaxInvoice::LABEL22,
            TaxInvoice::LABEL23,
            TaxInvoice::LABEL24,
            TaxInvoice::LABEL25,
            TaxInvoice::LABEL26,
            TaxInvoice::LABEL27,
            TaxInvoice::LABEL28,
            TaxInvoice::LABEL29,
            TaxInvoice::LABEL30,
            TaxInvoice::LABEL31,
            TaxInvoice::LABEL32,
            TaxInvoice::LABEL33,
            TaxInvoice::LABEL34,
            TaxInvoice::LABEL35,
            TaxInvoice::LABEL36,
            TaxInvoice::LABEL37,
            TaxInvoice::LABEL38,
            TaxInvoice::LABEL39,
            TaxInvoice::LABEL40,
            TaxInvoice::LABEL41,
            TaxInvoice::LABEL42,
            TaxInvoice::LABEL43,
            TaxInvoice::LABEL44,
            TaxInvoice::LABEL45,
            TaxInvoice::LABEL46,
            TaxInvoice::LABEL47,
            TaxInvoice::LABEL48,
            TaxInvoice::LABEL49,
            TaxInvoice::LABEL50,
            TaxInvoice::LABEL51,
            TaxInvoice::LABEL52,
            TaxInvoice::LABEL53,
            TaxInvoice::LABEL54,
            TaxInvoice::LABEL55,
            TaxInvoice::LABEL56,
            TaxInvoice::LABEL57,
            TaxInvoice::LABEL58,
            TaxInvoice::LABEL59
        ];

        $fileName = 'Taxinvoice_List';
        $filePath = $this->excel->export2($headerEmptys, $headerColumns, $data["lists"], $dataColumns,['file_name' => $fileName]);
        $this->setHeaderDownload($fileName.'.xlsx', PUBLIC_PATH . $filePath);
        exit;
    }


    /*
    public function downloadExcel(){
        $searchInput = $this->request->getGet();
        ini_set('max_execution_time',600);
        $data = $this->orderInfoModel->getSearchExcel($searchInput, 30000, true);
       // $data = $this->orderInfoModel->getSearchExcel(null, 30000, true);

        $headerColumns = [
            // lang_orderinfo('order_no'),
            lang_orderinfo('order_code'),
            lang_orderinfo('status'),
            lang_orderinfo('payment_flg'),
            lang_orderinfo('member_code'),
            lang_orderinfo('name'),
            lang_orderinfo('orderer_email'),
            lang_orderinfo('orderer_phone'),
            lang_orderinfo('invoice_num'),
            lang_orderinfo('shipping_name'),
            lang_orderinfo('delivery_phone'),
            lang_orderinfo('shipping_phone'),
            lang_orderinfo('company_name'),
            lang_orderinfo('shipping_zipocode'),
            lang_orderinfo('shipping_add1'),
            lang_orderinfo('shipping_add2'),
            lang_orderinfo('shipping_messag'),
            lang_orderinfo('firstitem_number'),
            lang_orderinfo('item_counts'),
            lang_orderinfo('supply_price'),
            lang_orderinfo('vat'),
            lang_orderinfo('amount_total'),
            lang_orderinfo('delivery_fee'),
            lang_orderinfo('delivery_date'),
            lang_orderinfo('insert_date')
        ];
        $dataColumns = [
            // OrderInfo::INFO_ID,
            OrderInfo::ORDER_CODE,
            OrderInfo::ORDER_STATUS,
            OrderInfo::PAYMENT_FLG,
            OrderInfo::MEMBER_CODE,
            OrderInfo::ORDERER_NAME,
            OrderInfo::ORDERER_EMAIL,
            OrderInfo::ORDERER_PHONE,
            OrderInfo::INVOICE_NUM,
            OrderInfo::SHIPPING_NAME,
            OrderInfo::DELIVERY_PHONE,
            OrderInfo::SHIPPING_PHONE,
            OrderInfo::COMPANY_NAME,
            OrderInfo::SHIPPING_ZIPCODE,
            OrderInfo::SHIPPING_ADD1,
            OrderInfo::SHIPPING_ADD2,
            OrderInfo::SHIPPING_MESSAG,
            OrderInfo::FIRSTITEM_NUMBER,
            OrderInfo::ITEM_COUNTS,
            OrderInfo::SUPPLY_PRICE,
            OrderInfo::VAT,
            OrderInfo::AMOUNT_TOTAL,
            OrderInfo::DELIVERY_FEE,
            OrderInfo::DELIVERY_DATE,
            OrderInfo::CREATED_AT
        ];
        $fileName = 'Order_List';
        $filePath = $this->excel->export($headerColumns, $data, $dataColumns,['file_name' => $fileName]);
        $this->setHeaderDownload($fileName.'.xlsx', PUBLIC_PATH . $filePath);
        exit;

    }
    */

}
