<?php 
namespace App\Controllers\Guest;

use CodeIgniter\RESTful\ResourceController;
use CodeIgniter\API\ResponseTrait;
use CodeIgniter\HTTP\RequestInterface;

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

use App\Entities\MembersApppush;
use App\Helpers\FileHelper;
use App\Services\MemberService;
use App\Models\Missionlevel2Model;


/**
 * @OA\Info(title="SHOP API", version="1.0")
 * @OA\Schemes(format="http")
 * @OA\SecurityScheme(
 *     type="http",
 *     description="Login with email and password to get the authentication token",
 *     name="Token based Based",
 *     in="header",
 *     scheme="bearer",
 *     bearerFormat="JWT",
 *     securityScheme="apiAuth",
 * )
 * 
 */



class ApiController extends BaseController
{

    protected $memberModel;
    protected $memberPhotoModel;
    protected $memberCategoryModel;
    protected $memberService;


    public function __construct()
    {
        $this->memberModel = new MemberModel();
        $this->membersPhotoModel = new MembersPhotoModel();
        $this->memberCategoryModel = new MemberCategoryModel();
        $this->memberService = new MemberService();

    }


    /**
     * Return an array of resource objects, themselves in array format
     *
     * @return mixed
     */
    use ResponseTrait;
    

    public function validationMapFieldLabels()
    {
        return [
            'memo_content' => 'Memo Content'
        ];
    }

    public function index(){
        $memberCode = AuthHelpers::getLoginInfoGuest()->member_code;
        echo $memberCode;
        //echo "Test Ok!";
    }


    /**
    * @OA\Post(path="/digikeyapi/oauth_token", tags={"Oauth2 Token API"},
     *   description="<b>Session Check API</b><p>",
     *   @OA\RequestBody(
     *     required=true,
     *     @OA\MediaType(
     *       mediaType="application/json",
     *       @OA\Schema(
     *         @OA\Property(
     *           property="client_id",
     *           description="Client ID",
     *           type="string",
     *  			default="V00Aoq1AdpWwN4QnNLyeTXVtF4A4CDX1",
     *         ),
     *         @OA\Property(
     *           property="client_secret",
     *           description="Client Secret",
     *           type="string",
     *  			default="7PDMLIdmfaNVZhHp",
     *         ),
     *         @OA\Property(
     *           property="grant_type",
     *           description="Grant Type",
     *           type="string",
     *  			default="client_credentials",
     *         ),
     *       ),
     *     ),
     *   ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */
    public function sessions(){
        //$memberCode = AuthHelpers::getLoginInfoGuest()->member_code;
        //echo $memberCode;

        $responseData["sessions"] = AuthHelpers::getLoginInfoGuest();
        echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
        //echo "Test Ok!";
    }


    /**
    * @OA\Post(path="/api/login_api", tags={"App Login API"},
     *   description="<b>User Login API</b><p>
    <b>[Parameters]</b><br>
    member_email : User I.D<br>
    password : User Password<br>
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="application/json",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="member_email",
    *           description="User I.D",
    *           type="string",
    *  			default="pixel@korea.com",
    *         ),
    *         @OA\Property(
    *           property="password",
    *           description="User Password",
    *           type="string",
    *  			default="D9pD2gZvqY",
    *         ),
    *       ),
    *     ),
    *   ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

     public function login_api()
     {
         helper(['form']);
 
         //echo esc(\CodeIgniter\CodeIgniter::CI_VERSION);
         //exit;
         $this->rules = [
            'member_email' => 'required',
            'password' => 'required'
        ];
        if( $this->checkValidation() ){
            $email = $this->request->getVar('member_email');
            $password = $this->request->getVar('password');
            $remember = $this->request->getVar('remember');

            if($account = $this->memberModel->checkLogin($email, $password)){
                $account->last_login_date = DateHelper::now();
                $this->memberModel->save($account);
                $account->remember = isset($remember) ? 1 : 0;
                AuthHelpers::setLoginGuest($account->toSession());
                if($account->remember == REMEMBER_FLG_ON){
                    AuthHelpers::setCookieLoginGuest($account,$this->redirectResponse);
                }

                $user = $this->memberModel->where("member_email", $this->request->getVar('member_email'))->first();
                //var_dump($user);
                //exit;
    
                if(!$user) return $this->failNotFound('일치하는 E-Mail주소가 없습니다.');
    
                if(md5($password) != $user->password) {
                    return $this->fail('일치하지 않습니다.');
                }
    
                    $key = getenv('TOKEN_SECRET');
                    //var_dump($key);
    
                    $payload = array(
                        "iat" => 1356999524,
                        "nbf" => 1357000000,
                        "uid" => $user->member_id,
                        "code" => $user->member_code,
                        "handphone" => $user->handphone
                    );
                    //var_dump($payload);
            
                    $token = JWT::encode($payload, $key, 'HS256');
                    //var_dump($token);
                    //exit;


                $memberCode = AuthHelpers::getLoginInfoGuest()->member_code;
                $responseData["memberCode"] = $memberCode;
                $memberName = AuthHelpers::getLoginInfoGuest()->member_name;
                $responseData["memberName"] = $memberName;

                $responseData["token"] = $token;

                $responseData["status"] = '2001';
                $responseData["message"] = "OK : 인증성공";
                echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

            }else{
                $responseData["status"] = '4001';
                $responseData["message"] = "Error : 입력 값 문제";
                echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
            }
        }else{
            $responseData["status"] = '4000';
            $responseData["message"] = "Error : 입력 값 오류";
            echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
        }

     }

     
    /**
    * @OA\Post(path="/api/hplogin_api", tags={"App Login API"},
     *   description="<b>User Login API - Handphone</b><p>
    <b>[Parameters]</b><br>
    handphone : User Handphone<br>
    password : User Password<br>
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="application/json",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="handphone",
    *           description="User Handphone",
    *           type="string",
    *  			default="010-9028-7124",
    *         ),
    *         @OA\Property(
    *           property="password",
    *           description="User Password",
    *           type="string",
    *  			default="D9pD2gZvqY",
    *         ),
    *       ),
    *     ),
    *   ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

     public function hplogin_api()
     {
         helper(['form']);
 
         //echo esc(\CodeIgniter\CodeIgniter::CI_VERSION);
         //exit;
         $this->rules = [
            'handphone' => 'required',
            'password' => 'required'
        ];
        if( $this->checkValidation() ){
            $handphone = $this->request->getVar('handphone');
            $password = $this->request->getVar('password');
            $remember = $this->request->getVar('remember');

            if($account = $this->memberModel->checkhpLogin($handphone, $password)){
                $account->last_login_date = DateHelper::now();
                $this->memberModel->save($account);
                $account->remember = isset($remember) ? 1 : 0;
                AuthHelpers::setLoginGuest($account->toSession());
                if($account->remember == REMEMBER_FLG_ON){
                    AuthHelpers::setCookieLoginGuest($account,$this->redirectResponse);
                }

            $user = $this->memberModel->where("handphone", $this->request->getVar('handphone'))->first();
            //var_dump($user);
            //exit;

            if(!$user) return $this->failNotFound('일치하는 전화번호가 없습니다.');

            if(md5($password) != $user->password) {
                return $this->fail('일치하지 않습니다.');
            }

                $key = getenv('TOKEN_SECRET');
                //var_dump($key);

                $payload = array(
                    "iat" => 1356999524,
                    "nbf" => 1357000000,
                    "uid" => $user->member_id,
                    "code" => $user->member_code,
                    "handphone" => $user->handphone
                );
                //var_dump($payload);
        
                $token = JWT::encode($payload, $key, 'HS256');
                //var_dump($token);
                //exit;

                $memberId = AuthHelpers::getLoginInfoGuest()->member_id;
                $responseData["memberId"] = $memberId;
                $memberCode = AuthHelpers::getLoginInfoGuest()->member_code;
                $responseData["memberCode"] = $memberCode;
                $memberName = AuthHelpers::getLoginInfoGuest()->member_name;
                $responseData["memberName"] = $memberName;

                $responseData["token"] = $token;

                $responseData["status"] = '2001';
                $responseData["message"] = "OK : 인증성공";
                echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

            }else{
                $responseData["status"] = '4001';
                $responseData["message"] = "Error : 입력 값 문제";
                echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
            }
        }else{
            $responseData["status"] = '4000';
            $responseData["message"] = "Error : 입력 값 오류";
            echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
        }

     }

     
    /**
    * @OA\Post(path="/api/modifyPW_api", tags={"App Modify Password API"},
     *   description="<b>App Modify Password API</b><p>
    <b>[Parameters]</b><br>
    member_email : User I.D<br>
    password : User Password<br>
    password_new : New Password<br>
    confpassword_new : Conf New Password<br>
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="application/json",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="member_email",
    *           description="User I.D",
    *           type="string",
    *  			default="pixel@korea.com",
    *         ),
    *         @OA\Property(
    *           property="password",
    *           description="User Password",
    *           type="string",
    *  			default="D9pD2gZvqY",
    *         ),
    *         @OA\Property(
    *           property="password_new",
    *           description="New Password",
    *           type="string",
    *  			default="test12345",
    *         ),
    *         @OA\Property(
    *           property="confpassword_new",
    *           description="Conf New Password",
    *           type="string",
    *  			default="test12345",
    *         ),
    *       ),
    *     ),
    *   ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

     public function modifyPW_api()
     {
         helper(['form']);
 
         //echo esc(\CodeIgniter\CodeIgniter::CI_VERSION);
         //exit;
         $this->rules = [
            'member_email' => 'required',
            'password' => 'required',
            'password_new' => 'required|min_length[6]',
            'confpassword_new' => 'matches[password_new]'
        ];
        if( $this->checkValidation() ){
            $email = $this->request->getVar('member_email');
            $password = $this->request->getVar('password');
            $password_new = $this->request->getVar('password_new');


            if($account = $this->memberModel->checkLogin($email, $password)){
                //$account->last_login_date = DateHelper::now();
                //$this->memberModel->save($account);

                $account->password = md5( $password_new);
                $this->memberModel->save($account);

                $responseData["status"] = '2001';
                $responseData["message"] = "OK : 비밀번호가 변경되었습니다.";
                echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

            }else{
                $responseData["status"] = '4001';
                $responseData["message"] = "Error : 입력 값 문제";
                echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
            }
        }else{
            $responseData["status"] = '4000';
            $responseData["message"] = "Error : 입력 값 오류";
            echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
        }

     }


    /**
    * @OA\Post(path="/api/hpmodifyPW_api", tags={"App Modify Password API"},
     *   description="<b>App Modify Password API - Handphone</b><p>
    <b>[Parameters]</b><br>
    handphone : User Handphone<br>
    password : User Password<br>
    password_new : New Password<br>
    confpassword_new : Conf New Password<br>
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="application/json",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="handphone",
    *           description="User Handphone",
    *           type="string",
    *  			default="010-9028-7124",
    *         ),
    *         @OA\Property(
    *           property="password",
    *           description="User Password",
    *           type="string",
    *  			default="D9pD2gZvqY",
    *         ),
    *         @OA\Property(
    *           property="password_new",
    *           description="New Password",
    *           type="string",
    *  			default="test12345",
    *         ),
    *         @OA\Property(
    *           property="confpassword_new",
    *           description="Conf New Password",
    *           type="string",
    *  			default="test12345",
    *         ),
    *       ),
    *     ),
    *   ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

     public function hpmodifyPW_api()
     {
         helper(['form']);
 
         //echo esc(\CodeIgniter\CodeIgniter::CI_VERSION);
         //exit;
         $this->rules = [
            'handphone' => 'required',
            'password' => 'required',
            'password_new' => 'required|min_length[6]',
            'confpassword_new' => 'matches[password_new]'
        ];
        if( $this->checkValidation() ){
            $handphone = $this->request->getVar('handphone');
            $password = $this->request->getVar('password');
            $password_new = $this->request->getVar('password_new');


            if($account = $this->memberModel->checkhpLogin($handphone, $password)){
                //$account->last_login_date = DateHelper::now();
                //$this->memberModel->save($account);

                $account->password = md5( $password_new);
                $this->memberModel->save($account);

                $responseData["status"] = '2001';
                $responseData["message"] = "OK : 비밀번호가 변경되었습니다.";
                echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

            }else{
                $responseData["status"] = '4001';
                $responseData["message"] = "Error : 입력 값 문제";
                echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
            }
        }else{
            $responseData["status"] = '4000';
            $responseData["message"] = "Error : 입력 값 오류";
            echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
        }

     }



    /**
    * @OA\Post(path="/api/codeModifyPW_api", tags={"App Modify Password API"},
     *   description="<b>App Modify Password API - Member Code</b><p>
    <b>[Parameters]</b><br>
    member_code : Member Code<br>
    password : User Password<br>
    password_new : New Password<br>
    confpassword_new : Conf New Password<br>
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="application/json",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="member_code",
    *           description="Member Code",
    *           type="string",
    *  			default="20030185",
    *         ),
    *         @OA\Property(
    *           property="password",
    *           description="User Password",
    *           type="string",
    *  			default="D9pD2gZvqY",
    *         ),
    *         @OA\Property(
    *           property="password_new",
    *           description="New Password",
    *           type="string",
    *  			default="test12345",
    *         ),
    *         @OA\Property(
    *           property="confpassword_new",
    *           description="Conf New Password",
    *           type="string",
    *  			default="test12345",
    *         ),
    *       ),
    *     ),
    *   ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

     public function codeModifyPW_api()
     {
         helper(['form']);

         $this->rules = [
            'member_code' => 'required',
            'password' => 'required',
            'password_new' => 'required|min_length[6]',
            'confpassword_new' => 'matches[password_new]'
        ];
        if( $this->checkValidation() ){
            $member_code = $this->request->getVar('member_code');
            $password = $this->request->getVar('password');
            $password_new = $this->request->getVar('password_new');


            if($account = $this->memberModel->checkCodeLogin($member_code, $password)){
                $account->password = md5( $password_new);
                $this->memberModel->save($account);

                $responseData["status"] = '2001';
                $responseData["message"] = "OK : 비밀번호가 변경되었습니다.";
                echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

            }else{
                $responseData["status"] = '4001';
                $responseData["message"] = "Error : 입력 값 문제";
                echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
            }
        }else{
            $responseData["status"] = '4000';
            $responseData["message"] = "Error : 입력 값 오류";
            echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
        }

     }


     
    /**
    * @OA\Post(path="/api/idModifyPW_api", tags={"App Modify Password API"},
     *   description="<b>App Modify Password API - Member ID</b><p>
    <b>[Parameters]</b><br>
    member_id : Member ID<br>
    password : User Password<br>
    password_new : New Password<br>
    confpassword_new : Conf New Password<br>
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="application/json",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="member_id",
    *           description="Member ID",
    *           type="string",
    *  			default="918",
    *         ),
    *         @OA\Property(
    *           property="password",
    *           description="User Password",
    *           type="string",
    *  			default="D9pD2gZvqY",
    *         ),
    *         @OA\Property(
    *           property="password_new",
    *           description="New Password",
    *           type="string",
    *  			default="test12345",
    *         ),
    *         @OA\Property(
    *           property="confpassword_new",
    *           description="Conf New Password",
    *           type="string",
    *  			default="test12345",
    *         ),
    *       ),
    *     ),
    *   ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

     public function idModifyPW_api()
     {
         helper(['form']);

         $this->rules = [
            'member_id' => 'required',
            'password' => 'required',
            'password_new' => 'required|min_length[6]',
            'confpassword_new' => 'matches[password_new]'
        ];
        if( $this->checkValidation() ){
            $member_id = $this->request->getVar('member_id');
            $password = $this->request->getVar('password');
            $password_new = $this->request->getVar('password_new');


            if($account = $this->memberModel->checkIdLogin($member_id, $password)){
                $account->password = md5( $password_new);
                $this->memberModel->save($account);

                $responseData["status"] = '2001';
                $responseData["message"] = "OK : 비밀번호가 변경되었습니다.";
                echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

            }else{
                $responseData["status"] = '4001';
                $responseData["message"] = "Error : 입력 값 문제";
                echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
            }
        }else{
            $responseData["status"] = '4000';
            $responseData["message"] = "Error : 입력 값 오류";
            echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
        }

     }


     /*** 비밀번호 리셋 ***/

    /**
    * @OA\Post(path="/api/resetPassword_api", tags={"App Modify Password API"},
    *   description="<b>App Reset Password API</b><p>
    <b>[Parameters]</b><br>
    member_name : Member Name<br>
    handphone : Member Handphone<br>
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="application/json",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="member_name",
    *           description="User Name",
    *           type="string",
    *  			default="정경연",
    *         ),
    *         @OA\Property(
    *           property="handphone",
    *           description="User Handphone",
    *           type="string",
    *  			default="010-9028-7124",
    *         ),
    *       ),
    *     ),
    *   ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

     public function resetPassword_api(){

        helper(['form']);

        $this->rules = [
           'member_name' => 'required',
           'handphone' => 'required'
       ];

       if( $this->checkValidation() ){

        $member_name = $this->request->getVar('member_name');
        $handphone = $this->request->getVar('handphone');

        ini_set('display_errors',1);
        $member = $this->memberModel->findByName($member_name, $handphone);
        //var_dump ($member->member_name);
        //var_dump ($member->handphone);
        //exit;

        if($member){

        if(isset($member)){

            // $pass = $digitsRandom = NumberHelper::generateRandom(); // 비번발생합수
            $pass = mt_rand(100000, 999999); // 난수발생함수
            $passMd5 = md5($pass);
            $member->password = $passMd5;
            $member->password_random = $pass;
            $this->memberModel->save($member);

        }

        $receiver_name = $member->member_name;
        $receiver_phone = str_replace('-','',$member->handphone);

        /****************** 인증정보 시작 ******************/
        $sms_url = "https://apis.aligo.in/send/"; // 전송요청 URL
        $sms['user_id'] = "chipdirect"; // SMS 아이디
        $sms['key'] = "5iomz2bals7kofy7siiynx33sxo5nxtp";//인증키
        /****************** 인증정보 끝 ********************/

        /****************** 전송정보 설정시작 ****************/
        $_POST['msg'] = '%고객명%성도님. 인증번호를 [ '.$pass.' ]로 전달해 드립니다. 접속시 입력하시기 바랍니다.'; // 메세지 내용 : euc-kr로 치환이 가능한 문자열만 사용하실 수 있습니다. (이모지 사용불가능)
        // $_POST['receiver'] = '01090287124,01111111112'; // 수신번호
        // $_POST['destination'] = '01090287124|담당자,01111111112|홍길동'; // 수신인 %고객명% 치환
        $_POST['receiver'] = $receiver_phone; // 수신번호
        $_POST['destination'] = $receiver_phone.'|'.$receiver_name; // 수신인 %고객명% 치환
        $_POST['sender'] ="02-2676-7171"; // 발신번호
        $_POST['rdate'] = ''; // 예약일자 - 20161004 : 2016-10-04일기준
        $_POST['rtime'] = ''; // 예약시간 - 1930 : 오후 7시30분
        $_POST['testmode_yn'] = 'N'; // Y 인경우 실제문자 전송X , 자동취소(환불) 처리
        $_POST['subject'] = '테스트 발송'; //  LMS, MMS 제목 (미입력시 본문중 44Byte 또는 엔터 구분자 첫라인)
        // $_POST['image'] = '/tmp/pic_57f358af08cf7_sms_.jpg'; // MMS 이미지 파일 위치 (저장된 경로)
        $_POST['msg_type'] = 'SMS'; //  SMS, LMS, MMS등 메세지 타입을 지정
        // ※ msg_type 미지정시 글자수/그림유무가 판단되어 자동변환됩니다. 단, 개행문자/특수문자등이 2Byte로 처리되어 SMS 가 LMS로 처리될 가능성이 존재하므로 반드시 msg_type을 지정하여 사용하시기 바랍니다.
        /****************** 전송정보 설정끝 ***************/

        $sms['msg'] = stripslashes($_POST['msg']);
        $sms['receiver'] = $_POST['receiver'];
        $sms['destination'] = $_POST['destination'];
        $sms['sender'] = $_POST['sender'];
        $sms['rdate'] = $_POST['rdate'];
        $sms['rtime'] = $_POST['rtime'];
        $sms['testmode_yn'] = empty($_POST['testmode_yn']) ? '' : $_POST['testmode_yn'];
        $sms['title'] = $_POST['subject'];
        $sms['msg_type'] = $_POST['msg_type'];
        // 만일 $_FILES 로 직접 Request POST된 파일을 사용하시는 경우 move_uploaded_file 로 저장 후 저장된 경로를 사용하셔야 합니다.
        if(!empty($_FILES['image']['tmp_name'])) {
            $tmp_filetype = mime_content_type($_FILES['image']['tmp_name']); 
            if($tmp_filetype != 'image/png' && $tmp_filetype != 'image/jpg' && $tmp_filetype != 'image/jpeg') $_POST['image'] = '';
            else {
                $_savePath = "./".uniqid(); // PHP의 권한이 허용된 디렉토리를 지정
                if(move_uploaded_file($_FILES['file']['tmp_name'], $_savePath)) {
                    $_POST['image'] = $_savePath;
                }
            }
        }
        // 이미지 전송 설정
        if(!empty($_POST['image'])) {
            if(file_exists($_POST['image'])) {
                $tmpFile = explode('/',$_POST['image']);
                $str_filename = $tmpFile[sizeof($tmpFile)-1];
                $tmp_filetype = mime_content_type($_POST['image']);
                if ((version_compare(PHP_VERSION, '5.5') >= 0)) { // PHP 5.5버전 이상부터 적용
                    $sms['image'] = new CURLFile($_POST['image'], $tmp_filetype, $str_filename);
                    curl_setopt($oCurl, CURLOPT_SAFE_UPLOAD, true);
                } else {
                    $sms['image'] = '@'.$_POST['image'].';filename='.$str_filename. ';type='.$tmp_filetype;
                }
            }
        }
        /*****/
        $host_info = explode("/", $sms_url);
        $port = $host_info[0] == 'https:' ? 443 : 80;

        $oCurl = curl_init();
        curl_setopt($oCurl, CURLOPT_PORT, $port);
        curl_setopt($oCurl, CURLOPT_URL, $sms_url);
        curl_setopt($oCurl, CURLOPT_POST, 1);
        curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sms);
        curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, FALSE);
        $ret = curl_exec($oCurl);
        curl_close($oCurl);

        //echo $ret;
        //$retArr = json_decode($ret); // 결과배열


        $responseData["smslog"] = json_decode($ret);
        $responseData["status"] = '2001';
        $responseData["message"] = "OK : 문자로 인증번호가 전달되었습니다.";
        echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
        
        }else{
            $responseData["status"] = '4001';
            $responseData["message"] = "Error : 입력 값 문제";
            echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
        }

        }else{
            $responseData["status"] = '4000';
            $responseData["message"] = "Error : 입력 값 오류";
            echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
        }

    }

        
    /**
    * @OA\Post(path="/api/memberCRUD_api", tags={"Dimode Member API"},
    *   description="<b>Dimode Member CRUD API - Member Info.</b><p>
    <b>[Parameters]</b><br>
    Process : Process INFO<br>
    ID : ID INFO<br>
    NAME : NAME INFO<br>
    NAMEDISTINCT : NAMEDISTINCT INFO<br>
    SEX : SEX INFO<br>
    AGE : AGE INFO<br>
    ...
    <!--br>
    SOLAR : SOLAR INFO<br>
    BIRTH : BIRTH INFO<br>
    CBIRTH : CBIRTH INFO<br>
    PERSNALID : PERSNALID INFO<br>
    HID : HID INFO<br>
    CORE : CORE INFO<br>
    RELATIVE : RELATIVE INFO<br>
    RELAORD : RELAORD INFO<br>
    SIDO : SIDO INFO<br>
    GUGUN : GUGUN INFO<br>
    DONG : DONG INFO<br>
    BUNJI : BUNJI INFO<br>
    ZIPCODE : ZIPCODE INFO<br>
    ADDR : ADDR INFO<br>
    ST : ST INFO<br>
    CITY : CITY INFO<br>
    BORNFROM : BORNFROM INFO<br>
    TEL : TEL INFO<br>
    HANDPHONE : HANDPHONE INFO<br>
    EMAIL : EMAIL INFO<br>
    HOMEPAGE : HOMEPAGE INFO<br>
    TOPRANGE : TOPRANGE INFO<br>
    RANGE : RANGE INFO<br>
    RANGE1 : RANGE1 INFO<br>
    RANGECODE : RANGECODE INFO<br>
    RANGE2 : RANGE2 INFO<br>
    RANGE2CODE : RANGE2CODE INFO<br>
    RVNAME : RVNAME INFO<br>
    RVORD : RVORD INFO<br>
    FIRSTVISITDAY : FIRSTVISITDAY INFO<br>
    CELLMEMBERDAY : CELLMEMBERDAY INFO<br>
    CELLATT : CELLATT INFO<br>
    XMOTIVE : XMOTIVE INFO<br>
    SCHOOL : SCHOOL INFO<br>
    SCHOOLYEAR : SCHOOLYEAR INFO<br>
    MAJOR : MAJOR INFO<br>
    LASTSCHOOL : LASTSCHOOL INFO<br>
    RELINLAW : RELINLAW INFO<br>
    MARDAY : MARDAY INFO<br>
    SALVATION : SALVATION INFO<br>
    GRADE : GRADE INFO<br>
    BAPTDAY : BAPTDAY INFO<br>
    HBAPTDAY : HBAPTDAY INFO<br>
    BAPTIST : BAPTIST INFO<br>
    BAPTCHURCH : BAPTCHURCH INFO<br>
    FIRSTINPUTDAY : FIRSTINPUTDAY INFO<br>
    REGDAY : REGDAY INFO<br>
    REGMOTIVE : REGMOTIVE INFO<br>
    STATE : STATE INFO<br>
    STATE1 : STATE1 INFO<br>
    STATEDAY : STATEDAY INFO<br>
    STATEMOTIVE : STATEMOTIVE INFO<br>
    STATEGRADE : STATEGRADE INFO<br>
    LEADERID : LEADERID INFO<br>
    LEADER1ID : LEADER1ID INFO<br>
    LEADER2ID : LEADER2ID INFO<br>
    LEADER : LEADER INFO<br>
    LEADER1 : LEADER1 INFO<br>
    LEADER2 : LEADER2 INFO<br>
    OCCU : OCCU INFO<br>
    OCCU1 : OCCU1 INFO<br>
    SHOPNAME : SHOPNAME INFO<br>
    OFFICE : OFFICE INFO<br>
    OFFICE1 : OFFICE1 INFO<br>
    OFFNAME : OFFNAME INFO<br>
    OFFZIP : OFFZIP INFO<br>
    OFFTEL : OFFTEL INFO<br>
    OFFGRADE : OFFGRADE INFO<br>
    WHRREC : WHRREC INFO<br>
    CVNAME : CVNAME INFO<br>
    CVNAME1 : CVNAME1 INFO<br>
    CVNAME2 : CVNAME2 INFO<br>
    APPOINTCHURCH : APPOINTCHURCH INFO<br>
    CVDAY : CVDAY INFO<br>
    CARKIND : CARKIND INFO<br>
    CARNUM : CARNUM INFO<br>
    ETC : ETC INFO<br>
    FAMILY : FAMILY INFO<br>
    PRECHURCH : PRECHURCH INFO<br>
    PRECVNAME : PRECVNAME INFO<br>
    SLEEP : SLEEP INFO<br>
    USRNAME : USRNAME INFO<br>
    SDATE : SDATE INFO<br>
    RID : RID INFO<br>
    RCORE : RCORE INFO<br>
    RREL : RREL INFO<br>
    HOBBY : HOBBY INFO<br>
    SPECIALTY : SPECIALTY INFO<br>
    YOUTH : YOUTH INFO<br>
    YOUTH1 : YOUTH1 INFO<br>
    YOUTH2 : YOUTH2 INFO<br>
    YOUTH3 : YOUTH3 INFO<br>
    YOUTHSTATE : YOUTHSTATE INFO<br>
    GNAME : GNAME INFO<br>
    GNAME1 : GNAME1 INFO<br>
    GNAME2 : GNAME2 INFO<br>
    GNAMESTATE : GNAMESTATE INFO<br>
    GCODE : GCODE INFO<br>
    NEWCHECK : NEWCHECK INFO<br>
    TACHURCH : TACHURCH INFO<br>
    RAN2 : RAN2 INFO<br>
    PARTNER : PARTNER INFO<br>
    PARTNERID : PARTNERID INFO<br>
    G : G INFO<br>
    G1 : G1 INFO<br>
    SRANGE : SRANGE INFO<br>
    SRANGE1 : SRANGE1 INFO<br>
    SRANGECODE : SRANGECODE INFO<br>
    SRANGE2 : SRANGE2 INFO<br>
    SRANGE2CODE : SRANGE2CODE INFO<br>
    SRVNAME : SRVNAME INFO<br>
    SCELLATT : SCELLATT INFO<br>
    SRVORD : SRVORD INFO<br>
    UPDATEDATE : UPDATEDATE INFO<br>
    STATE3 : STATE3 INFO<br>
    MASTER : MASTER INFO<br>
    MASTERID : MASTERID INFO<br>
    RAN1 : RAN1 INFO<br>
    CHKSMS : CHKSMS INFO<br-->
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="application/json",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="Process",
    *           description="Process",
    *           type="string",
    *  			default="MOD",
    *         ),

    *         @OA\Property(property="ID", description="ID INFO", type="string", default="20030185",),
    *         @OA\Property(property="NAME", description="NAME INFO", type="string", default="정경연",),
    *         @OA\Property(property="NAMEDISTINCT", description="NAMEDISTINCT INFO", type="string", default="A",),
    *         @OA\Property(property="SEX", description="SEX INFO", type="string", default="남",),
    *         @OA\Property(property="AGE", description="AGE INFO", type="string", default="57",),
    *         @OA\Property(property="SOLAR", description="SOLAR INFO", type="string", default="양",),
    *         @OA\Property(property="BIRTH", description="BIRTH INFO", type="string", default="1967-12-25",),
    *         @OA\Property(property="CBIRTH", description="CBIRTH INFO", type="string", default="2023-12-25",),
    *         @OA\Property(property="PERSNALID", description="PERSNALID INFO", type="string", default="null",),
    *         @OA\Property(property="HID", description="HID INFO", type="string", default="20030185",),
    *         @OA\Property(property="CORE", description="CORE INFO", type="string", default="정경연",),
    *         @OA\Property(property="RELATIVE", description="RELATIVE INFO", type="string", default="본인",),
    *         @OA\Property(property="RELAORD", description="RELAORD INFO", type="string", default="0",),
    *         @OA\Property(property="SIDO", description="SIDO INFO", type="string", default="인천광역시",),
    *         @OA\Property(property="GUGUN", description="GUGUN INFO", type="string", default="계양구 ",),
    *         @OA\Property(property="DONG", description="DONG INFO", type="string", default="주부토로",),
    *         @OA\Property(property="BUNJI", description="BUNJI INFO", type="string", default="528 (계산동 삼보아파트) 6-516",),
    *         @OA\Property(property="ZIPCODE", description="ZIPCODE INFO", type="string", default="21059",),
    *         @OA\Property(property="ADDR", description="ADDR INFO", type="string", default="인천광역시 계양구 주부토로 528 (계산동 삼보아파트) 6-516",),
    *         @OA\Property(property="ST", description="ST INFO", type="string", default="Y",),
    *         @OA\Property(property="CITY", description="CITY INFO", type="string", default="null",),
    *         @OA\Property(property="BORNFROM", description="BORNFROM INFO", type="string", default="null",),
    *         @OA\Property(property="TEL", description="TEL INFO", type="string", default="032-524-1015",),
    *         @OA\Property(property="HANDPHONE", description="HANDPHONE INFO", type="string", default="010-9028-7124",),
    *         @OA\Property(property="EMAIL", description="EMAIL INFO", type="string", default="pixel@korea.com",),
    *         @OA\Property(property="HOMEPAGE", description="HOMEPAGE INFO", type="string", default="http",),
    *         @OA\Property(property="TOPRANGE", description="TOPRANGE INFO", type="string", default="null",),
    *         @OA\Property(property="RANGE", description="RANGE INFO", type="string", default="제5교구",),
    *         @OA\Property(property="RANGE1", description="RANGE1 INFO", type="string", default="523구역",),
    *         @OA\Property(property="RANGECODE", description="RANGECODE INFO", type="string", default="106000000",),
    *         @OA\Property(property="RANGE2", description="RANGE2 INFO", type="string", default="null",),
    *         @OA\Property(property="RANGE2CODE", description="RANGE2CODE INFO", type="string", default="null",),
    *         @OA\Property(property="RVNAME", description="RVNAME INFO", type="string", default="null",),
    *         @OA\Property(property="RVORD", description="RVORD INFO", type="string", default="999999",),
    *         @OA\Property(property="FIRSTVISITDAY", description="FIRSTVISITDAY INFO", type="string", default="null",),
    *         @OA\Property(property="CELLMEMBERDAY", description="CELLMEMBERDAY INFO", type="string", default="null",),
    *         @OA\Property(property="CELLATT", description="CELLATT INFO", type="string", default="null",),
    *         @OA\Property(property="XMOTIVE", description="XMOTIVE INFO", type="string", default="null",),
    *         @OA\Property(property="SCHOOL", description="SCHOOL INFO", type="string", default=" ",),
    *         @OA\Property(property="SCHOOLYEAR", description="SCHOOLYEAR INFO", type="string", default="null",),
    *         @OA\Property(property="MAJOR", description="MAJOR INFO", type="string", default="경제학",),
    *         @OA\Property(property="LASTSCHOOL", description="LASTSCHOOL INFO", type="string", default=" ",),
    *         @OA\Property(property="RELINLAW", description="RELINLAW INFO", type="string", default="기혼",),
    *         @OA\Property(property="MARDAY", description="MARDAY INFO", type="string", default=" ",),
    *         @OA\Property(property="SALVATION", description="SALVATION INFO", type="string", default="null",),
    *         @OA\Property(property="GRADE", description="GRADE INFO", type="string", default="세례",),
    *         @OA\Property(property="BAPTDAY", description="BAPTDAY INFO", type="string", default="1985-11-24",),
    *         @OA\Property(property="HBAPTDAY", description="HBAPTDAY INFO", type="string", default="null",),
    *         @OA\Property(property="BAPTIST", description="BAPTIST INFO", type="string", default="허남기목사",),
    *         @OA\Property(property="BAPTCHURCH", description="BAPTCHURCH INFO", type="string", default="영은카테고리2",),
    *         @OA\Property(property="FIRSTINPUTDAY", description="FIRSTINPUTDAY INFO", type="string", default="null",),
    *         @OA\Property(property="REGDAY", description="REGDAY INFO", type="string", default="2003-10-14",),
    *         @OA\Property(property="REGMOTIVE", description="REGMOTIVE INFO", type="string", default="null",),
    *         @OA\Property(property="STATE", description="STATE INFO", type="string", default="교인",),
    *         @OA\Property(property="STATE1", description="STATE1 INFO", type="string", default="장년부",),
    *         @OA\Property(property="STATEDAY", description="STATEDAY INFO", type="string", default="null",),
    *         @OA\Property(property="STATEMOTIVE", description="STATEMOTIVE INFO", type="string", default="null",),
    *         @OA\Property(property="STATEGRADE", description="STATEGRADE INFO", type="string", default="null",),
    *         @OA\Property(property="LEADERID", description="LEADERID INFO", type="string", default="0",),
    *         @OA\Property(property="LEADER1ID", description="LEADER1ID INFO", type="string", default="0",),
    *         @OA\Property(property="LEADER2ID", description="LEADER2ID INFO", type="string", default="0",),
    *         @OA\Property(property="LEADER", description="LEADER INFO", type="string", default="null",),
    *         @OA\Property(property="LEADER1", description="LEADER1 INFO", type="string", default="null",),
    *         @OA\Property(property="LEADER2", description="LEADER2 INFO", type="string", default="null",),
    *         @OA\Property(property="OCCU", description="OCCU INFO", type="string", default="회사원",),
    *         @OA\Property(property="OCCU1", description="OCCU1 INFO", type="string", default="null",),
    *         @OA\Property(property="SHOPNAME", description="SHOPNAME INFO", type="string", default="null",),
    *         @OA\Property(property="OFFICE", description="OFFICE INFO", type="string", default=" ",),
    *         @OA\Property(property="OFFICE1", description="OFFICE1 INFO", type="string", default="null",),
    *         @OA\Property(property="OFFNAME", description="OFFNAME INFO", type="string", default="승전상사",),
    *         @OA\Property(property="OFFZIP", description="OFFZIP INFO", type="string", default=" ",),
    *         @OA\Property(property="OFFTEL", description="OFFTEL INFO", type="string", default="02-391-6800",),
    *         @OA\Property(property="OFFGRADE", description="OFFGRADE INFO", type="string", default=" ",),
    *         @OA\Property(property="WHRREC", description="WHRREC INFO", type="string", default="0",),
    *         @OA\Property(property="CVNAME", description="CVNAME INFO", type="string", default="집사",),
    *         @OA\Property(property="CVNAME1", description="CVNAME1 INFO", type="string", default="서리집사",),
    *         @OA\Property(property="CVNAME2", description="CVNAME2 INFO", type="string", default="null",),
    *         @OA\Property(property="APPOINTCHURCH", description="APPOINTCHURCH INFO", type="string", default="영은카테고리2",),
    *         @OA\Property(property="CVDAY", description="CVDAY INFO", type="string", default="1999-01-01",),
    *         @OA\Property(property="CARKIND", description="CARKIND INFO", type="string", default="소나타",),
    *         @OA\Property(property="CARNUM", description="CARNUM INFO", type="string", default="317버8563",),
    *         @OA\Property(property="ETC", description="ETC INFO", type="string", default="null",),
    *         @OA\Property(property="FAMILY", description="FAMILY INFO", type="string", default="null",),
    *         @OA\Property(property="PRECHURCH", description="PRECHURCH INFO", type="string", default=" ",),
    *         @OA\Property(property="PRECVNAME", description="PRECVNAME INFO", type="string", default="null",),
    *         @OA\Property(property="SLEEP", description="SLEEP INFO", type="string", default=" ",),
    *         @OA\Property(property="USRNAME", description="USRNAME INFO", type="string", default="디모데",),
    *         @OA\Property(property="SDATE", description="SDATE INFO", type="string", default="2018-01-18",),
    *         @OA\Property(property="RID", description="RID INFO", type="string", default="377",),
    *         @OA\Property(property="RCORE", description="RCORE INFO", type="string", default="정경연",),
    *         @OA\Property(property="RREL", description="RREL INFO", type="string", default="본인",),
    *         @OA\Property(property="HOBBY", description="HOBBY INFO", type="string", default="null",),
    *         @OA\Property(property="SPECIALTY", description="SPECIALTY INFO", type="string", default="null",),
    *         @OA\Property(property="YOUTH", description="YOUTH INFO", type="string", default="null",),
    *         @OA\Property(property="YOUTH1", description="YOUTH1 INFO", type="string", default="null",),
    *         @OA\Property(property="YOUTH2", description="YOUTH2 INFO", type="string", default="null",),
    *         @OA\Property(property="YOUTH3", description="YOUTH3 INFO", type="string", default="null",),
    *         @OA\Property(property="YOUTHSTATE", description="YOUTHSTATE INFO", type="string", default="null",),
    *         @OA\Property(property="GNAME", description="GNAME INFO", type="string", default="null",),
    *         @OA\Property(property="GNAME1", description="GNAME1 INFO", type="string", default="null",),
    *         @OA\Property(property="GNAME2", description="GNAME2 INFO", type="string", default="null",),
    *         @OA\Property(property="GNAMESTATE", description="GNAMESTATE INFO", type="string", default="null",),
    *         @OA\Property(property="GCODE", description="GCODE INFO", type="string", default="0",),
    *         @OA\Property(property="NEWCHECK", description="NEWCHECK INFO", type="string", default="0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",),
    *         @OA\Property(property="TACHURCH", description="TACHURCH INFO", type="string", default="null",),
    *         @OA\Property(property="RAN2", description="RAN2 INFO", type="string", default="null",),
    *         @OA\Property(property="PARTNER", description="PARTNER INFO", type="string", default="브이티란A",),
    *         @OA\Property(property="PARTNERID", description="PARTNERID INFO", type="string", default="20130323",),
    *         @OA\Property(property="G", description="G INFO", type="string", default="남선카테고리2",),
    *         @OA\Property(property="G1", description="G1 INFO", type="string", default="3남선카테고리2",),
    *         @OA\Property(property="SRANGE", description="SRANGE INFO", type="string", default="null",),
    *         @OA\Property(property="SRANGE1", description="SRANGE1 INFO", type="string", default="null",),
    *         @OA\Property(property="SRANGECODE", description="SRANGECODE INFO", type="string", default="999999999",),
    *         @OA\Property(property="SRANGE2", description="SRANGE2 INFO", type="string", default="null",),
    *         @OA\Property(property="SRANGE2CODE", description="SRANGE2CODE INFO", type="string", default="999999999",),
    *         @OA\Property(property="SRVNAME", description="SRVNAME INFO", type="string", default="null",),
    *         @OA\Property(property="SCELLATT", description="SCELLATT INFO", type="string", default="null",),
    *         @OA\Property(property="SRVORD", description="SRVORD INFO", type="string", default="0",),
    *         @OA\Property(property="UPDATEDATE", description="UPDATEDATE INFO", type="string", default="\/Date(1676525075000)\/",),
    *         @OA\Property(property="STATE3", description="STATE3 INFO", type="string", default="null",),
    *         @OA\Property(property="MASTER", description="MASTER INFO", type="string", default="null",),
    *         @OA\Property(property="MASTERID", description="MASTERID INFO", type="string", default="0",),
    *         @OA\Property(property="RAN1", description="RAN1 INFO", type="string", default="정경연A 브이티란A 정치호 윤미자A 정지혜B",),
    *         @OA\Property(property="CHKSMS", description="CHKSMS INFO", type="string", default="0",),

    *       ),
    *     ),
    *   ),
    *
    *     @OA\Response(
    *         response="200",
    *         description="Success",
    *         content={
    *             @OA\MediaType(
    *                 mediaType="application/json",
    *                 @OA\Schema(
    *                     @OA\Property(
    *                         property="Status",
    *                         type="integer",
    *                         description="응답 받은 코드"
    *                     ),
    *                     @OA\Property(
    *                         property="Message",
    *                         type="string",
    *                         description="응답 받은 메시지"
    *                     ),
    *                     example={
    *                           "status":  "2001",
    *                           "message": "OK"
    *                     }
    *                 )
    *             )
    *         }
    *     ),
    * @OA\Response(response="201", description="Created"),
    * @OA\Response(response="401", description="Unauthorized"),
    * @OA\Response(response="403", description="Forbidden"),
    * @OA\Response(response="404", description="Not Found"),
    *
	* )
	*/

     public function memberCRUD_api()
     {
         helper(['form']);

         $this->rules = [
            'Process' => 'required',
            'ID' => 'required',
            'NAME' => 'required'
        ];


        if( $this->checkValidation() ){
            $Process = $this->request->getVar('Process');

            if($Process == "ADD"){

                $member = new Member();

                $member->member_code = $this->request->getVar('ID');
                $member->member_name = $this->request->getVar('NAME');
                $member->namedistinct = $this->request->getVar('NAMEDISTINCT');
                $member->member_email = $this->request->getVar('EMAIL');
                $member->member_phone = $this->request->getVar('TEL');
                $member->handphone = $this->request->getVar('HANDPHONE');
                $member->homepage = $this->request->getVar('HOMEPAGE');
                $member->toprange = $this->request->getVar('TOPRANGE');
                $member->hid = $this->request->getVar('HID');
                $member->core = $this->request->getVar('CORE');
                $member->relative = $this->request->getVar('RELATIVE');
                $member->relaord = $this->request->getVar('RELAORD');
                $member->address1 = $this->request->getVar('SIDO');
                $member->address2 = $this->request->getVar('GUGUN');
                $member->address3 = $this->request->getVar('DONG');
                $member->address4 = $this->request->getVar('BUNJI');
                $member->zipcode = $this->request->getVar('ZIPCODE');
                $member->addr = $this->request->getVar('ADDR');
                $member->gender = $this->request->getVar('SEX');
                $member->lunar_calendar = $this->request->getVar('SOLAR');
                $member->birth_date = $this->request->getVar('BIRTH');
                $member->cbirth = $this->request->getVar('CBIRTH');
                $member->age = $this->request->getVar('AGE');
                $member->st = $this->request->getVar('ST');
                $member->city = $this->request->getVar('CITY');
                $member->bornfrom = $this->request->getVar('BORNFROM');
                $member->range = $this->request->getVar('RANGE');
                $member->range1 = $this->request->getVar('RANGE1');
                $member->rangecode = $this->request->getVar('RANGECODE');
                $member->range2 = $this->request->getVar('RANGE2');
                $member->range2code = $this->request->getVar('RANGE2CODE');
                $member->rvname = $this->request->getVar('RVNAME');
                $member->rvord = $this->request->getVar('RVORD');
                $member->firstvisitday = $this->request->getVar('FIRSTVISITDAY');
                $member->cellmemberday = $this->request->getVar('CELLMEMBERDAY');
                $member->cellatt = $this->request->getVar('CELLATT');
                $member->xmotive = $this->request->getVar('XMOTIVE');
                $member->school = $this->request->getVar('SCHOOL');
                $member->schoolyear = $this->request->getVar('SCHOOLYEAR');
                $member->major = $this->request->getVar('MAJOR');
                $member->lastschool = $this->request->getVar('LASTSCHOOL');
                $member->relinlaw = $this->request->getVar('RELINLAW');
                $member->marday = $this->request->getVar('MARDAY');
                $member->salvation = $this->request->getVar('SALVATION');
                $member->grade = $this->request->getVar('GRADE');
                $member->baptday = $this->request->getVar('BAPTDAY');
                $member->hbaptday = $this->request->getVar('HBAPTDAY');
                $member->baptist = $this->request->getVar('BAPTIST');
                $member->baptchurch = $this->request->getVar('BAPTCHURCH');
                $member->firstinputday = $this->request->getVar('FIRSTINPUTDAY');
                $member->regday = $this->request->getVar('REGDAY');
                $member->regmotive = $this->request->getVar('REGMOTIVE');
                $member->state = $this->request->getVar('STATE');
                $member->state1 = $this->request->getVar('STATE1');
                $member->stateday = $this->request->getVar('STATEDAY');
                $member->statemotive = $this->request->getVar('STATEMOTIVE');
                $member->stategrade = $this->request->getVar('STATEGRADE');
                $member->leaderid = $this->request->getVar('LEADERID');
                $member->leader1id = $this->request->getVar('LEADER1ID');
                $member->leader2id = $this->request->getVar('LEADER2ID');
                $member->leader = $this->request->getVar('LEADER');
                $member->leader1 = $this->request->getVar('LEADER1');
                $member->leader2 = $this->request->getVar('LEADER2');
                $member->occu = $this->request->getVar('OCCU');
                $member->occu1 = $this->request->getVar('OCCU1');
                $member->shopname = $this->request->getVar('SHOPNAME');
                $member->office = $this->request->getVar('OFFICE');
                $member->office1 = $this->request->getVar('OFFICE1');
                $member->offname = $this->request->getVar('OFFNAME');
                $member->offzip = $this->request->getVar('OFFZIP');
                $member->offtel = $this->request->getVar('OFFTEL');
                $member->offgrade = $this->request->getVar('OFFGRADE');
                $member->whrrec = $this->request->getVar('WHRREC');
                $member->cvname = $this->request->getVar('CVNAME');
                $member->cvname1 = $this->request->getVar('CVNAME1');
                $member->cvname2 = $this->request->getVar('CVNAME2');
                $member->appointchurch = $this->request->getVar('APPOINTCHURCH');
                $member->cvday = $this->request->getVar('CVDAY');
                $member->carkind = $this->request->getVar('CARKIND');
                $member->carnum = $this->request->getVar('CARNUM');
                $member->etc = $this->request->getVar('ETC');
                $member->family = $this->request->getVar('FAMILY');
                $member->prechurch = $this->request->getVar('PRECHURCH');
                $member->precvname = $this->request->getVar('PRECVNAME');
                $member->sleep = $this->request->getVar('SLEEP');
                $member->usrname = $this->request->getVar('USRNAME');
                $member->sdate = $this->request->getVar('SDATE');
                $member->rid = $this->request->getVar('RID');
                $member->rcore = $this->request->getVar('RCORE');
                $member->rrel = $this->request->getVar('RREL');
                $member->hobby = $this->request->getVar('HOBBY');
                $member->specialty = $this->request->getVar('SPECIALTY');
                $member->youth = $this->request->getVar('YOUTH');
                $member->youth1 = $this->request->getVar('YOUTH1');
                $member->youth2 = $this->request->getVar('YOUTH2');
                $member->youth3 = $this->request->getVar('YOUTH3');
                $member->youthstate = $this->request->getVar('YOUTHSTATE');
                $member->gname = $this->request->getVar('GNAME');
                $member->gname1 = $this->request->getVar('GNAME1');
                $member->gname2 = $this->request->getVar('GNAME2');
                $member->gnamestate = $this->request->getVar('GNAMESTATE');
                $member->gcode = $this->request->getVar('GCODE');
                $member->newcheck = $this->request->getVar('NEWCHECK');
                $member->tachurch = $this->request->getVar('TACHURCH');
                $member->ran2 = $this->request->getVar('RAN2');
                $member->partner = $this->request->getVar('PARTNER');
                $member->partnerid = $this->request->getVar('PARTNERID');
                $member->g = $this->request->getVar('G');
                $member->g1 = $this->request->getVar('G1');
                $member->srange = $this->request->getVar('SRANGE');
                $member->srange1 = $this->request->getVar('SRANGE1');
                $member->srangecode = $this->request->getVar('SRANGECODE');
                $member->srange2 = $this->request->getVar('SRANGE2');
                $member->srange2code = $this->request->getVar('SRANGE2CODE');
                $member->srvname = $this->request->getVar('SRVNAME');
                $member->scellatt = $this->request->getVar('SCELLATT');
                $member->srvord = $this->request->getVar('SRVORD');
                $member->updatedate = $this->request->getVar('UPDATEDATE');
                $member->state3 = $this->request->getVar('STATE3');
                $member->master = $this->request->getVar('MASTER');
                $member->masterid = $this->request->getVar('MASTERID');
                $member->ran1 = $this->request->getVar('RAN1');
                $member->chksms = $this->request->getVar('CHKSMS');
                $member->access_flg = "1";
                $member->active_flg = "1";

                $insertId = $this->memberModel->save($member);
             
                if($insertId){
                    $responseData["status"] = '2001';
                    $responseData["message"] = "OK : 정보가 등록되었습니다.";
                    echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

                }else{
                    $responseData["status"] = '4001';
                    $responseData["message"] = "Error : 입력 값 문제";
                    echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
                }

            } elseif($Process == "MOD"){
                $member_code = $this->request->getVar('ID');

                if($account = $this->memberModel->findByMemberCode($member_code)){

                $account->member_name = $this->request->getVar('NAME');
                $account->namedistinct = $this->request->getVar('NAMEDISTINCT');
                $account->member_email = $this->request->getVar('EMAIL');
                $account->member_phone = $this->request->getVar('TEL');
                $account->handphone = $this->request->getVar('HANDPHONE');
                $account->homepage = $this->request->getVar('HOMEPAGE');
                $account->toprange = $this->request->getVar('TOPRANGE');
                $account->hid = $this->request->getVar('HID');
                $account->core = $this->request->getVar('CORE');
                $account->relative = $this->request->getVar('RELATIVE');
                $account->relaord = $this->request->getVar('RELAORD');
                $account->address1 = $this->request->getVar('SIDO');
                $account->address2 = $this->request->getVar('GUGUN');
                $account->address3 = $this->request->getVar('DONG');
                $account->address4 = $this->request->getVar('BUNJI');
                $account->zipcode = $this->request->getVar('ZIPCODE');
                $account->addr = $this->request->getVar('ADDR');
                $account->gender = $this->request->getVar('SEX');
                $account->lunar_calendar = $this->request->getVar('SOLAR');
                $account->birth_date = $this->request->getVar('BIRTH');
                $account->cbirth = $this->request->getVar('CBIRTH');
                $account->age = $this->request->getVar('AGE');
                $account->st = $this->request->getVar('ST');
                $account->city = $this->request->getVar('CITY');
                $account->bornfrom = $this->request->getVar('BORNFROM');
                $account->range = $this->request->getVar('RANGE');
                $account->range1 = $this->request->getVar('RANGE1');
                $account->rangecode = $this->request->getVar('RANGECODE');
                $account->range2 = $this->request->getVar('RANGE2');
                $account->range2code = $this->request->getVar('RANGE2CODE');
                $account->rvname = $this->request->getVar('RVNAME');
                $account->rvord = $this->request->getVar('RVORD');
                $account->firstvisitday = $this->request->getVar('FIRSTVISITDAY');
                $account->cellmemberday = $this->request->getVar('CELLMEMBERDAY');
                $account->cellatt = $this->request->getVar('CELLATT');
                $account->xmotive = $this->request->getVar('XMOTIVE');
                $account->school = $this->request->getVar('SCHOOL');
                $account->schoolyear = $this->request->getVar('SCHOOLYEAR');
                $account->major = $this->request->getVar('MAJOR');
                $account->lastschool = $this->request->getVar('LASTSCHOOL');
                $account->relinlaw = $this->request->getVar('RELINLAW');
                $account->marday = $this->request->getVar('MARDAY');
                $account->salvation = $this->request->getVar('SALVATION');
                $account->grade = $this->request->getVar('GRADE');
                $account->baptday = $this->request->getVar('BAPTDAY');
                $account->hbaptday = $this->request->getVar('HBAPTDAY');
                $account->baptist = $this->request->getVar('BAPTIST');
                $account->baptchurch = $this->request->getVar('BAPTCHURCH');
                $account->firstinputday = $this->request->getVar('FIRSTINPUTDAY');
                $account->regday = $this->request->getVar('REGDAY');
                $account->regmotive = $this->request->getVar('REGMOTIVE');
                $account->state = $this->request->getVar('STATE');
                $account->state1 = $this->request->getVar('STATE1');
                $account->stateday = $this->request->getVar('STATEDAY');
                $account->statemotive = $this->request->getVar('STATEMOTIVE');
                $account->stategrade = $this->request->getVar('STATEGRADE');
                $account->leaderid = $this->request->getVar('LEADERID');
                $account->leader1id = $this->request->getVar('LEADER1ID');
                $account->leader2id = $this->request->getVar('LEADER2ID');
                $account->leader = $this->request->getVar('LEADER');
                $account->leader1 = $this->request->getVar('LEADER1');
                $account->leader2 = $this->request->getVar('LEADER2');
                $account->occu = $this->request->getVar('OCCU');
                $account->occu1 = $this->request->getVar('OCCU1');
                $account->shopname = $this->request->getVar('SHOPNAME');
                $account->office = $this->request->getVar('OFFICE');
                $account->office1 = $this->request->getVar('OFFICE1');
                $account->offname = $this->request->getVar('OFFNAME');
                $account->offzip = $this->request->getVar('OFFZIP');
                $account->offtel = $this->request->getVar('OFFTEL');
                $account->offgrade = $this->request->getVar('OFFGRADE');
                $account->whrrec = $this->request->getVar('WHRREC');
                $account->cvname = $this->request->getVar('CVNAME');
                $account->cvname1 = $this->request->getVar('CVNAME1');
                $account->cvname2 = $this->request->getVar('CVNAME2');
                $account->appointchurch = $this->request->getVar('APPOINTCHURCH');
                $account->cvday = $this->request->getVar('CVDAY');
                $account->carkind = $this->request->getVar('CARKIND');
                $account->carnum = $this->request->getVar('CARNUM');
                $account->etc = $this->request->getVar('ETC');
                $account->family = $this->request->getVar('FAMILY');
                $account->prechurch = $this->request->getVar('PRECHURCH');
                $account->precvname = $this->request->getVar('PRECVNAME');
                $account->sleep = $this->request->getVar('SLEEP');
                $account->usrname = $this->request->getVar('USRNAME');
                $account->sdate = $this->request->getVar('SDATE');
                $account->rid = $this->request->getVar('RID');
                $account->rcore = $this->request->getVar('RCORE');
                $account->rrel = $this->request->getVar('RREL');
                $account->hobby = $this->request->getVar('HOBBY');
                $account->specialty = $this->request->getVar('SPECIALTY');
                $account->youth = $this->request->getVar('YOUTH');
                $account->youth1 = $this->request->getVar('YOUTH1');
                $account->youth2 = $this->request->getVar('YOUTH2');
                $account->youth3 = $this->request->getVar('YOUTH3');
                $account->youthstate = $this->request->getVar('YOUTHSTATE');
                $account->gname = $this->request->getVar('GNAME');
                $account->gname1 = $this->request->getVar('GNAME1');
                $account->gname2 = $this->request->getVar('GNAME2');
                $account->gnamestate = $this->request->getVar('GNAMESTATE');
                $account->gcode = $this->request->getVar('GCODE');
                $account->newcheck = $this->request->getVar('NEWCHECK');
                $account->tachurch = $this->request->getVar('TACHURCH');
                $account->ran2 = $this->request->getVar('RAN2');
                $account->partner = $this->request->getVar('PARTNER');
                $account->partnerid = $this->request->getVar('PARTNERID');
                $account->g = $this->request->getVar('G');
                $account->g1 = $this->request->getVar('G1');
                $account->srange = $this->request->getVar('SRANGE');
                $account->srange1 = $this->request->getVar('SRANGE1');
                $account->srangecode = $this->request->getVar('SRANGECODE');
                $account->srange2 = $this->request->getVar('SRANGE2');
                $account->srange2code = $this->request->getVar('SRANGE2CODE');
                $account->srvname = $this->request->getVar('SRVNAME');
                $account->scellatt = $this->request->getVar('SCELLATT');
                $account->srvord = $this->request->getVar('SRVORD');
                $account->updatedate = $this->request->getVar('UPDATEDATE');
                $account->state3 = $this->request->getVar('STATE3');
                $account->master = $this->request->getVar('MASTER');
                $account->masterid = $this->request->getVar('MASTERID');
                $account->ran1 = $this->request->getVar('RAN1');
                $account->chksms = $this->request->getVar('CHKSMS');

                $this->memberModel->save($account);

                    $responseData["status"] = '2001';
                    $responseData["message"] = "OK : 정보가 수정되었습니다.";
                    echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

                }else{
                    $responseData["status"] = '4001';
                    $responseData["message"] = "Error : 입력 값 문제";
                    echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
                }

            } elseif($Process == "DEL"){
                $member_code = $this->request->getVar('ID');
                $memberInfo = $this->memberModel->findByMemberCode($member_code);

                $deleteId = $this->memberModel->delete($memberInfo->member_id);

            if($deleteId){

                $responseData["status"] = '2001';
                $responseData["message"] = "OK : 정보가 삭제되었습니다.";
                echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

            }else{
                $responseData["status"] = '4001';
                $responseData["message"] = "Error : 입력 값 문제";
                echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
            }
            }
            
        }else{
            $responseData["status"] = '4000';
            $responseData["message"] = "Error : 입력 값 오류";
            echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
        }

     }



    /**
    * @OA\Post(path="/api/memberPhoto_api", tags={"Dimode Member API"},
    *   description="<b>Dimode Member Photo API - Member Info.</b><p>
    <b>[Parameters]</b><br>
    member_code : 사용자ID<br>
    image_file : 이미지파일<br>
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="multipart/form-data",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="Process",
    *           description="Process",
    *           type="string",
    *  			default="MOD",
    *         ),
    *         @OA\Property(
    *           property="member_code",
    *           description="사용자ID",
    *           type="string",
    *  			default="20030185",
    *         ),
    *         @OA\Property(
    *           property="image_file",
    *           description="이미지파일",
    *           type="string",
    *           format="binary",
    *  			default="TEST1234",
    *         ),
    *       ),
    *     ),
    *   ),

     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK : 전송 성공"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

     public function memberPhoto_api()
     {
         // { member_code : 사용자ID, width : 폭(Pixel), height : 높이(Pixel), file_name : 파일명, file_dir : 파일위치 }
         
         $this->rules = [
            'Process' => 'required',
            'member_code' => 'required'
         ];
 
         if( $this->checkValidation() ){
         
                 $photo = $this->request->getVar();
                 $Process = $this->request->getVar('Process');

            if($Process == "ADD"){

                 $member_code = $this->request->getVar('member_code');
                 $fileImage =  $this->request->getFile('image_file');

                $photoCount = $this->membersPhotoModel->getPhotoCount($member_code);
                // var_dump($photoCount);
                // exit;

                if ($photoCount == 0) {

                    if(isset($fileImage) && !empty($fileImage->getClientName())){
    
                        $filePath = FileHelper::saveMemFile($fileImage, $member_code, FileHelper::FOLDER_PATCH_UPLOAD_MEMBER_PIC);
                        // $photo["file_name"] = $fileImage->getClientName();
                        chmod($filePath, 0777);
                        $ext = pathinfo($fileImage->getClientName(),PATHINFO_EXTENSION);
                        $photo["file_name"] = $member_code.'.'.$ext;
                        $photo["file_dir"] = $filePath;
    
                        $this->membersPhotoModel->save($photo);
                        // var_dump($fileImage);
                        // exit;

                    }

                    $responseData["status"] = '2001';
                    $responseData["message"] = "OK : 사진 등록 성공";
                    echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

                }else{

                    $responseData["status"] = '4002';
                    $responseData["message"] = "Error : 교적번호의 사진이 있습니다.";
                    echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

                }
 
            } elseif($Process == "MOD"){

                $member_code = $this->request->getVar('member_code');
                $fileImage =  $this->request->getFile('image_file');

                $photoCount = $this->membersPhotoModel->getPhotoCount($member_code);

                if ($photoCount == 1) {
                $photo_info = $this->membersPhotoModel->findByMemberCode($member_code);
                //var_dump($photo_info);
                //exit;
                unlink($photo_info->file_dir);
                $this->membersPhotoModel->delete($photo_info->id);

                if(isset($fileImage) && !empty($fileImage->getClientName())){
                    $filePath = FileHelper::saveMemFile($fileImage, $member_code, FileHelper::FOLDER_PATCH_UPLOAD_MEMBER_PIC);
                    chmod($filePath, 0777);

                    $ext = pathinfo($fileImage->getClientName(),PATHINFO_EXTENSION);
                    $photo["file_name"] = $member_code.'.'.$ext;
                    $photo["file_dir"] = $filePath;
                    //var_dump($photo);
                    //exit;
                    $this->membersPhotoModel->save($photo);
                }

                $responseData["status"] = '2001';
                $responseData["message"] = "OK : 사진 수정 성공";
                echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

            }else{

                $responseData["status"] = '4002';
                $responseData["message"] = "Error : 교적번호의 등록사진이 없습니다.";
                echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

            }

            } elseif($Process == "DEL"){

                $member_code = $this->request->getVar('member_code');
                $photo = $this->membersPhotoModel->findByMemberCode($member_code);
                
            if ($photo) {
                //var_dump($photo->file_dir);
                //exit;
                unlink($photo->file_dir);
                $this->membersPhotoModel->delete($photo->id);

                $responseData["status"] = '2001';
                $responseData["message"] = "OK : 사진 삭제 성공";
                echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

            }else{

                $responseData["status"] = '4002';
                $responseData["message"] = "Error : 교적번호의 등록정보가 없습니다.";
                echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

            }

            }
      
         }else{
             $responseData["status"] = '4001';
             $responseData["message"] = "Error : 입력 값 문제";
             echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
         }
 
 
     }


          /*************/
    
    /**
     * @OA\Get(path="/api/memsearch_api", tags={"검색 리스트 API"},
     *  description="<b>Field & Member Data API</b><p>
    <b>[Parameters]</b><br>
    search_field : Search Field<br>
    keyword : Keyword<br>
    perpage : Per Pages<br>
    page : Pages<br>
     ",
     *      @OA\Parameter(
     *    		name="search_field",
     *    		in="query",
     *    		required=false,
     *          allowEmptyValue=false, 
     *    		description="분류 [직분: cvname | 직분2:cvname1 | 소속: g | 소속2:g1 | 교구: range | 지역:range1 | 청년부: youth | 청년부1:youth1 | 청년부2: youth2 | 청년부3:youth3 | 차량번호: carnum ]",
     *          @OA\Schema(
     *              type="string", 
     *              enum= {"cvname","cvname1","g","g1","range","range1","youth","youth1","youth2","youth3","carnum"},
     *              default="member_name"
     *          ),
     *    	),
     *    	@OA\Parameter(
     *    		name="field_name",
     *    		in="query",
     *    		required=false,
     *    		description="검색어",
     *    		@OA\Schema(
     *    			type="string",
     *    			default="서리집사",
     *    			description="기본",
     *    		),
     *    	),
     *      @OA\Parameter(
     *    		name="gender",
     *    		in="query",
     *    		required=false,
     *          allowEmptyValue=false, 
     *    		description="분류 [남 | 여 ]",
     *          @OA\Schema(
     *              type="string", 
     *              enum= {"남","여"},
     *              default=""
     *          ),
     *    	),
     *    	@OA\Parameter(
     *    		name="keyword",
     *    		in="query",
     *    		required=false,
     *    		description="검색어 (이름, 전화번호, 차량번호)",
     *    		@OA\Schema(
     *    			type="string",
     *    			default="정경연",
     *    			description="기본",
     *    		),
     *    	),
     *     	@OA\Parameter(
     *    		name="perpage",
     *    		in="query",
     *    		required=true,
     *    		description="페페이지",
     *    		@OA\Schema(
     *    			type="string",
     *    			default="20",
     *    			description="기본",
     *    		),
     *    	),
     *     	@OA\Parameter(
     *    		name="page",
     *    		in="query",
     *    		required=true,
     *    		description="페이지",
     *    		@OA\Schema(
     *    			type="string",
     *    			default="1",
     *    			description="기본",
     *    		),
     *    	),
     * 
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK : 전송 성공"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

     public function memsearch_api()
     {
 
         $this->rules = [
             'search_field' => 'required'
         ];
 
         if( $this->checkValidation() ){
         
             $perPage = $this->request->getGet('perpage');
             $page = $this->request->getGet('page');

             $searchInput = $this->request->getGet();
 
             //$responseData["data"] = $this->memberModel->getApiSearch($searchInput,$perPage);
             //var_dump ($data);
             //exit;
 
             $getmemberinfo = $this->memberModel->getApiMemSearch($searchInput,$perPage);
                         
             $i=0;
             foreach($getmemberinfo['lists'] as $key => $item)
             {
                 $member['member_id']   = $item->member_id;
                 $member['member_code']  = $item->member_code;
                 if ($item->namedistinct == "A") {
                        $member['member_name']  = $item->member_name;
                    } else {
                        $member['member_name']  = $item->member_name.$item->namedistinct;
                    }
                /*
                 $member['gender'] = $item->gender;
                 $member['cvname'] = $item->cvname;
                 $member['cvname1'] = $item->cvname1;
                 $member['g'] = $item->g;
                 $member['g1'] = $item->g1;
                 $member['range'] = $item->range;
                 $member['range1'] = $item->range1;
                 $member['youth'] = $item->youth;
                 $member['youth1'] = $item->youth1;
                 $member['youth2'] = $item->youth2;
                 $member['youth3'] = $item->youth3;
                 $member['carnum'] = $item->carnum;
                */

                 if ($item->gender == "null") {
                    $member['gender'] = "";
                } else {
                    $member['gender'] = $item->gender;
                }

                if ($item->cvname == "null") {
                    $member['cvname'] = "";
                } else {
                    $member['cvname'] = $item->cvname;
                }

                if ($item->cvname1 == "null") {
                    $member['cvname1'] = "";
                } else {
                    $member['cvname1'] = $item->cvname1;
                }

                if ($item->g == "null") {
                    $member['g'] = "";
                } else {
                    $member['g'] = $item->g;
                }

                if ($item->g1 == "null") {
                    $member['g1'] = "";
                } else {
                    $member['g1'] = $item->g1;
                }

                if ($item->range == "null") {
                    $member['range'] = "";
                } else {
                    $member['range'] = $item->range;
                }

                if ($item->range1 == "null") {
                    $member['range1'] = "";
                } else {
                    $member['range1'] = $item->range1;
                }

                if ($item->youth == "null") {
                    $member['youth'] = "";
                } else {
                    $member['youth'] = $item->youth;
                }

                if ($item->youth1 == "null") {
                    $member['youth1'] = "";
                } else {
                    $member['youth1'] = $item->youth1;
                }

                if ($item->youth2 == "null") {
                    $member['youth2'] = "";
                } else {
                    $member['youth2'] = $item->youth2;
                }

                if ($item->youth3 == "null") {
                    $member['youth3'] = "";
                } else {
                    $member['youth3'] = $item->youth3;
                }

                 $member['photo'] = $item->file_dir;
                 $member['created_at'] = $item->created_at;
 
                 $memberinfo[$i] = $member;
                 $i++;
             }
             
             $responseData["data"] = $memberinfo;
             $responseData["totalRow"] = str_replace(',', '',$getmemberinfo['totalRowStr']);
 
             $responseData["status"] = '2001';
             $responseData["message"] = "OK : 전송 성공";
             echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
     
         }else{
             $responseData["status"] = '4001';
             $responseData["message"] = "Error : 입력 값 문제";
             echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
         }
 
 
     }

     /*************/

    /**
     * @OA\Get(path="/api/memlist_api", tags={"검색 리스트 API"},
     *  description="<b>Member Data API</b><p>
    <b>[Parameters]</b><br>
    search_field : Search Field<br>
    keyword : Keyword<br>
    perpage : Per Pages<br>
    page : Pages<br>
     ",
     *      @OA\Parameter(
     *    		name="search_field",
     *    		in="query",
     *    		required=false,
     *          allowEmptyValue=false, 
     *    		description="분류 [이름: member_name | 전화번호 : handphone | 직분: cvname | 직분2:cvname1 | 소속: g | 소속2:g1 | 교구: range | 지역:range1 | 청년부: youth | 청년부1:youth1 | 청년부2: youth2 | 청년부3:youth3 | 차량번호: carnum ]",
     *          @OA\Schema(
     *              type="string", 
     *              enum= {"member_name","handphone","cvname","cvname1","g","g1","range","range1","youth","youth1","youth2","youth3","carnum"},
     *              default=""
     *          ),
     *    	),
     *      @OA\Parameter(
     *    		name="gender",
     *    		in="query",
     *    		required=false,
     *          allowEmptyValue=false, 
     *    		description="분류 [남 | 여 ]",
     *          @OA\Schema(
     *              type="string", 
     *              enum= {"남","여"},
     *              default=""
     *          ),
     *    	),
     *    	@OA\Parameter(
     *    		name="keyword",
     *    		in="query",
     *    		required=false,
     *    		description="검색어 (이름 또는 전화번호)",
     *    		@OA\Schema(
     *    			type="string",
     *    			default="",
     *    			description="기본",
     *    		),
     *    	),
     *      @OA\Parameter(
     *    		name="sort",
     *    		in="query",
     *    		required=false,
     *          allowEmptyValue=false, 
     *    		description="정렬 [오름차순: desc | 내림차순 : asc]",
     *          @OA\Schema(
     *              type="string", 
     *              enum= {"desc","asc"},
     *              default="desc"
     *          ),
     *    	),
     *    	@OA\Parameter(
     *    		name="year",
     *    		in="query",
     *    		required=false,
     *    		description="년",
     *    		@OA\Schema(
     *    			type="string",
     *    			default="",
     *    			description="기본",
     *    		),
     *    	),
     *      @OA\Parameter(
     *    		name="month",
     *    		in="query",
     *    		required=false,
     *          allowEmptyValue=false, 
     *    		description="월 [1월: 01 | 2월: 02 | 3월: 03 | 4월: 04 | 5월: 05 | 6월: 06 | 7월: 07 | 8월: 08 | 9월: 09 | 10월: 10 | 11월: 11 | 12월: 12 ]",
     *          @OA\Schema(
     *              type="string", 
     *              enum= {"01","02","03","04","05","06","07","08","09","10","11","12"},
     *              default=""
     *          ),
     *    	),
     *     	@OA\Parameter(
     *    		name="perpage",
     *    		in="query",
     *    		required=true,
     *    		description="페페이지",
     *    		@OA\Schema(
     *    			type="string",
     *    			default="20",
     *    			description="기본",
     *    		),
     *    	),
     *     	@OA\Parameter(
     *    		name="page",
     *    		in="query",
     *    		required=true,
     *    		description="페이지",
     *    		@OA\Schema(
     *    			type="string",
     *    			default="1",
     *    			description="기본",
     *    		),
     *    	),
     * 
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK : 전송 성공"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

    public function memlist_api()
    {

        $this->rules = [
            'search_field' => 'required'
        ];

            //if( $this->checkValidation() ){
            $perPage = $this->request->getGet('perpage');
            $page = $this->request->getGet('page');

            $searchInput = $this->request->getGet();
            //var_dump ($searchInput);
            //exit;

            $getmemberinfo = $this->memberModel->getApiSearch($searchInput,$perPage);

            $i=0;
            foreach($getmemberinfo['lists'] as $key => $item)
            {
                $photo_info = $this->membersPhotoModel->findByMemberCode($item->member_code);

                $member['member_id']   = $item->member_id;
                $member['member_code']  = $item->member_code;
                if ($item->namedistinct == "A") {
                    $member['member_name']  = $item->member_name;
                } else {
                    $member['member_name']  = $item->member_name.$item->namedistinct;
                }

                /*
                $member['gender'] = $item->gender;
                $member['cvname'] = $item->cvname;
                $member['cvname1'] = $item->cvname1;
                $member['g'] = $item->g;
                $member['g1'] = $item->g1;
                $member['range'] = $item->range;
                $member['range1'] = $item->range1;
                $member['youth'] = $item->youth;
                $member['youth1'] = $item->youth1;
                $member['youth2'] = $item->youth2;
                $member['youth3'] = $item->youth3;
                */

                if ($item->gender == "null") {
                    $member['gender'] = "";
                } else {
                    $member['gender'] = $item->gender;
                }

                if ($item->cvname == "null") {
                    $member['cvname'] = "";
                } else {
                    $member['cvname'] = $item->cvname;
                }

                if ($item->cvname1 == "null") {
                    $member['cvname1'] = "";
                } else {
                    $member['cvname1'] = $item->cvname1;
                }

                if ($item->g == "null") {
                    $member['g'] = "";
                } else {
                    $member['g'] = $item->g;
                }

                if ($item->g1 == "null") {
                    $member['g1'] = "";
                } else {
                    $member['g1'] = $item->g1;
                }

                if ($item->range == "null") {
                    $member['range'] = "";
                } else {
                    $member['range'] = $item->range;
                }

                if ($item->range1 == "null") {
                    $member['range1'] = "";
                } else {
                    $member['range1'] = $item->range1;
                }

                if ($item->youth == "null") {
                    $member['youth'] = "";
                } else {
                    $member['youth'] = $item->youth;
                }

                if ($item->youth1 == "null") {
                    $member['youth1'] = "";
                } else {
                    $member['youth1'] = $item->youth1;
                }

                if ($item->youth2 == "null") {
                    $member['youth2'] = "";
                } else {
                    $member['youth2'] = $item->youth2;
                }

                if ($item->youth3 == "null") {
                    $member['youth3'] = "";
                } else {
                    $member['youth3'] = $item->youth3;
                }

                $member['photo'] = $photo_info->file_dir;
                $member['created_at'] = $item->created_at;

                $memberinfo[$i] = $member;
                $i++;
            }
            
            $responseData["data"] = $memberinfo;
            $responseData["totalRow"] = str_replace(',', '',$getmemberinfo['totalRowStr']);

            $responseData["status"] = '2001';
            $responseData["message"] = "OK : 전송 성공";
            echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
    
        /*
        }else{
            $responseData["status"] = '4001';
            $responseData["message"] = "Error : 입력 값 문제";
            echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
        }
        */
    }

    /**
     * @OA\Post(path="/api/memdetail_api", tags={"검색 상세 API"},
     *  description="<b>Member Data API</b><p>
    <b>[Parameters]</b><br>
    member_id : Member ID<br>
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="multipart/form-data",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="member_id",
    *           description="Member ID",
    *           type="string",
    *  			default="918",
    *         ),
    *       ),
    *     ),
    *   ),

     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK : 전송 성공"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

     public function memdetail_api()
     {
 
         $this->rules = [
             'member_id' => 'required'
         ];
 
         if( $this->checkValidation() ){
         
             $member_id = $this->request->getVar('member_id');
             $responseData["item"] = $this->memberModel->findApiById($member_id);

             // echo $responseData["item"]->state1; //장년부, 카테고리2학교, 청년부
             // exit;

             if ($responseData["item"]->namedistinct == "A") {
                $responseData["item"]->namedistinct = "";
            }

            if ($responseData["item"]->handphone == "null") {
                $responseData["item"]->handphone = "";
            }

            if ($responseData["item"]->member_phone == "null") {
                $responseData["item"]->member_phone = "";
            }
            if ($responseData["item"]->member_email == "null") {
                $responseData["item"]->member_email = "";
            }

            if ($responseData["item"]->gender == "null") {
                $responseData["item"]->gender = "";
            }

            if ($responseData["item"]->cvname == "null") {
                $responseData["item"]->cvname = "";
            }

            if ($responseData["item"]->cvname1 == "null") {
                $responseData["item"]->cvname1 = "";
            }

            if ($responseData["item"]->state == "null") {
                $responseData["item"]->state = "";
            }
            if ($responseData["item"]->state1 == "null") {
                $responseData["item"]->state1 = "";
            }

            if ($responseData["item"]->gname == "null") {
                $responseData["item"]->gname = "";
            }
            if ($responseData["item"]->gname1 == "null") {
                $responseData["item"]->gname1 = "";
            }
            if ($responseData["item"]->gname2 == "null") {
                $responseData["item"]->gname2 = "";
            }

            if ($responseData["item"]->g == "null") {
                $responseData["item"]->g = "";
            }

            if ($responseData["item"]->g1 == "null") {
                $responseData["item"]->g1 = "";
            }
            if ($responseData["item"]->range == "null") {
                $responseData["item"]->range = "";
            }

            if ($responseData["item"]->range1 == "null") {
                $responseData["item"]->range1 = "";
            }

            if ($responseData["item"]->youth == "null") {
                $responseData["item"]->youth = "";
            }

            if ($responseData["item"]->youth1 == "null") {
                $responseData["item"]->youth1 = "";
            }

            if ($responseData["item"]->youth2 == "null") {
                $responseData["item"]->youth2 = "";
            }

            if ($responseData["item"]->youth3 == "null") {
                $responseData["item"]->youth3 = "";
            }

            if ($responseData["item"]->ran1 == "null") {
                $responseData["item"]->ran1 = "";
            }

             if ($responseData["item"]->state1 == "장년부") {
                $responseData["item"]->g = $responseData["item"]->state1." > ".$responseData["item"]->g;
                $responseData["item"]->g1 = $responseData["item"]->g1;
            } elseif ($responseData["item"]->state1 == "청년부") {
                $responseData["item"]->g = $responseData["item"]->state1." > ".$responseData["item"]->youth1;
                $responseData["item"]->g1 = $responseData["item"]->youth2." > ".$responseData["item"]->youth3;
             } elseif ($responseData["item"]->state1 == "카테고리2학교") {
                $responseData["item"]->g = $responseData["item"]->state1." > ".$responseData["item"]->gname1;
                $responseData["item"]->g1 = $responseData["item"]->gname2;
             } else {
                $responseData["item"]->g = $responseData["item"]->state1." > ".$responseData["item"]->g;
                $responseData["item"]->g1 = $responseData["item"]->g1;
             }

             $member_name  = $responseData["item"]->member_name.$responseData["item"]->namedistinct;
             $responseData["item"]->member_name = $member_name;

             $photo_info = $this->membersPhotoModel->findByMemberCode($responseData["item"]->member_code);
             $responseData["item"]->photo = $photo_info->file_dir;
 
             $responseData["status"] = '2001';
             $responseData["message"] = "OK : 출력성공";
             echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
     
         }else{
             $responseData["status"] = '4001';
             $responseData["message"] = "Error : 입력 값 문제";
             echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
         }
 
 
     }
 
     
    /**
     * @OA\Post(path="/api/codedetail_api", tags={"검색 상세 API"},
     *  description="<b>Member Code Data API</b><p>
    <b>[Parameters]</b><br>
    member_code : Member Code<br>
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="multipart/form-data",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="member_code",
    *           description="Member Code",
    *           type="string",
    *  			default="20030185",
    *         ),
    *       ),
    *     ),
    *   ),

     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK : 전송 성공"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

     public function codedetail_api()
     {
 
         $this->rules = [
             'member_code' => 'required'
         ];
 
         if( $this->checkValidation() ){
         
             $member_code = $this->request->getVar('member_code');
             $responseData["item"] = $this->memberModel->findApiByCode($member_code);

             if ($responseData["item"]->namedistinct == "A") {
                $responseData["item"]->namedistinct = "";
            }

            if ($responseData["item"]->handphone == "null") {
                $responseData["item"]->handphone = "";
            }

            if ($responseData["item"]->member_phone == "null") {
                $responseData["item"]->member_phone = "";
            }
            if ($responseData["item"]->member_email == "null") {
                $responseData["item"]->member_email = "";
            }

            if ($responseData["item"]->gender == "null") {
                $responseData["item"]->gender = "";
            }

            if ($responseData["item"]->cvname == "null") {
                $responseData["item"]->cvname = "";
            }

            if ($responseData["item"]->cvname1 == "null") {
                $responseData["item"]->cvname1 = "";
            }

            if ($responseData["item"]->state == "null") {
                $responseData["item"]->state = "";
            }
            if ($responseData["item"]->state1 == "null") {
                $responseData["item"]->state1 = "";
            }

            if ($responseData["item"]->gname == "null") {
                $responseData["item"]->gname = "";
            }
            if ($responseData["item"]->gname1 == "null") {
                $responseData["item"]->gname1 = "";
            }
            if ($responseData["item"]->gname2 == "null") {
                $responseData["item"]->gname2 = "";
            }

            if ($responseData["item"]->g == "null") {
                $responseData["item"]->g = "";
            }

            if ($responseData["item"]->g1 == "null") {
                $responseData["item"]->g1 = "";
            }
            if ($responseData["item"]->range == "null") {
                $responseData["item"]->range = "";
            }

            if ($responseData["item"]->range1 == "null") {
                $responseData["item"]->range1 = "";
            }

            if ($responseData["item"]->youth == "null") {
                $responseData["item"]->youth = "";
            }

            if ($responseData["item"]->youth1 == "null") {
                $responseData["item"]->youth1 = "";
            }

            if ($responseData["item"]->youth2 == "null") {
                $responseData["item"]->youth2 = "";
            }

            if ($responseData["item"]->youth3 == "null") {
                $responseData["item"]->youth3 = "";
            }

            if ($responseData["item"]->ran1 == "null") {
                $responseData["item"]->ran1 = "";
            }
            
            if ($responseData["item"]->state1 == "장년부") {
                $responseData["item"]->g = $responseData["item"]->state1." > ".$responseData["item"]->g;
                $responseData["item"]->g1 = $responseData["item"]->g1;
            } elseif ($responseData["item"]->state1 == "청년부") {
                $responseData["item"]->g = $responseData["item"]->state1." > ".$responseData["item"]->youth1;
                $responseData["item"]->g1 = $responseData["item"]->youth2." > ".$responseData["item"]->youth3;
             } elseif ($responseData["item"]->state1 == "카테고리2학교") {
                $responseData["item"]->g = $responseData["item"]->state1." > ".$responseData["item"]->gname1;
                $responseData["item"]->g1 = $responseData["item"]->gname2;
             } else {
                $responseData["item"]->g = $responseData["item"]->state1." > ".$responseData["item"]->g;
                $responseData["item"]->g1 = $responseData["item"]->g1;
             }
             

             $member_name  = $responseData["item"]->member_name.$responseData["item"]->namedistinct;
             $responseData["item"]->member_name = $member_name;

             $photo_info = $this->membersPhotoModel->findByMemberCode($member_code);
             $responseData["item"]->photo = $photo_info->file_dir;
             
             //var_dump($responseData["item"]->member_code);
             //exit;
 
             $responseData["status"] = '2001';
             $responseData["message"] = "OK : 출력성공";
             echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
     
         }else{
             $responseData["status"] = '4001';
             $responseData["message"] = "Error : 입력 값 문제";
             echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
         }
 
 
     }


     /**
     * @OA\Post(path="/api/namedetail_api", tags={"검색 상세 API"},
     *  description="<b>Member Name Data API</b><p>
    <b>[Parameters]</b><br>
    member_name : Member Name<br>
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="multipart/form-data",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="member_name",
    *           description="Member Name",
    *           type="string",
    *  			default="정지혜B",
    *         ),
    *       ),
    *     ),
    *   ),

     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK : 전송 성공"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

     public function namedetail_api()
     {
 
         $this->rules = [
             'member_name' => 'required'
         ];
 
         if( $this->checkValidation() ){
            $member_name = $this->request->getVar('member_name');

            $patternhan = '/[\x{1100}-\x{11FF}\x{3130}-\x{318F}\x{AC00}-\x{D7AF}]+/u';
            preg_match_all($patternhan,$member_name,$matchhan);
            $pattern = '/[a-zA-Z]/';
            preg_match_all($pattern,$member_name,$match);

            $member_name = implode(" ",$matchhan[0]);
            $namedistinct = implode(" ",$match[0]);

            $responseData["item"] = $this->memberModel->findApiByName($member_name,$namedistinct);
             //$member_name  = $responseData["item"]->member_name.$responseData["item"]->namedistinct;
             //$responseData["item"]->member_name = $member_name;

            if ($responseData["item"] ) {
             $photo_info = $this->membersPhotoModel->findByMemberCode($responseData["item"]->member_code);
             $responseData["item"]->photo = $photo_info->file_dir;

             $responseData["status"] = '2001';
             $responseData["message"] = "OK : 출력성공";
             echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

            }else{
                $responseData["status"] = '4002';
                $responseData["message"] = "Error : 해당 정보 없음";
                echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
            }

         }else{
             $responseData["status"] = '4001';
             $responseData["message"] = "Error : 입력 값 문제";
             echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
         }
 
 
     }


     /**
	 * @OA\Get(path="/api/arealevel_api", tags={"검색 리스트 API"},
     *   description="교구 리스트(3단계) API",
     *      @OA\Response(
     *          response=200,
     *          description="Donec sollicitudin molestie malesuada."
     *      ),
     *      @OA\Response(
     *          response="default",
     *          description="An error has occurred."
     *      )
	 * )
	 */
    
    public function arealevel_api()
    {

        
		$arealevel1data = $this->arealevel1Model->orderBy('arealevel1_id', 'ASC')->findAll(); //내림차순
		$i=1;
		foreach ($arealevel1data as $menu){

			$arealevel1_code = $menu['arealevel1_code'];
			//$data[$i] = $menu;

            //$data[$i]['arealevel1_id']   = $menu['arealevel1_id'];
            //$data[$i]['arealevel1_code']  = $menu['arealevel1_code'];
            $data[$i]['arealevel1_name']  = $menu['arealevel1_name'];
            $data[$i]['incharge']  = $menu['incharge']." 목사";

				$arealevel2data = $this->arealevel2Model->where('arealevel1_code', $arealevel1_code)->orderBy('arealevel2_id', 'ASC')->findAll();
				$j=1;

				foreach ($arealevel2data as $menu2){

					$arealevel2_code = $menu2['arealevel2_code'];
					//$data[$i]['arealevel2'][$j] = $menu2;

                    //$data[$i]['arealevel2'][$j]['arealevel2_id']   = $menu2['arealevel2_id'];
                    //$data[$i]['arealevel2'][$j]['arealevel2_code']  = $menu2['arealevel2_code'];
                    $data[$i]['arealevel2'][$j]['arealevel2_name']  = $menu2['arealevel2_name'];
                    $data[$i]['arealevel2'][$j]['manager']  = $menu2['manager']." 장로";
                    $data[$i]['arealevel2'][$j]['assistant']  = $menu2['assistant'];

                        $arealevel3data = $this->arealevel3Model->where('arealevel2_code', $arealevel2_code)->findAll();
						$k=1;
						
						foreach ($arealevel3data as $menu3){
							$data[$i]['arealevel2'][$j]['arealevel3'][$k]['arealevel3_name'] = $menu3['arealevel3_name'];
						$k++;
						}
                        


				$j++;
				}

		$i++;
		}

		//var_dump ($data);
		//exit;

        $responseData["data"] = $data;
        $responseData["status"] = '2001';
        $responseData["message"] = "OK : 출력성공";
        echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
            
    }


    /**
     * @OA\Get(path="/api/arealist_api", tags={"검색 리스트 API"},
     *  description="<b>Member Data API</b><p>
    <b>[Parameters]</b><br>
    search_field : Search Field<br>
    keyword : Keyword<br>
    perpage : Per Pages<br>
    page : Pages<br>
     ",
     *    	@OA\Parameter(
     *    		name="keyword",
     *    		in="query",
     *    		required=false,
     *    		description="검색어 (구역명)",
     *    		@OA\Schema(
     *    			type="string",
     *    			default="523구역",
     *    			description="기본",
     *    		),
     *    	),
     *     	@OA\Parameter(
     *    		name="perpage",
     *    		in="query",
     *    		required=true,
     *    		description="페페이지",
     *    		@OA\Schema(
     *    			type="string",
     *    			default="20",
     *    			description="기본",
     *    		),
     *    	),
     *     	@OA\Parameter(
     *    		name="page",
     *    		in="query",
     *    		required=true,
     *    		description="페이지",
     *    		@OA\Schema(
     *    			type="string",
     *    			default="1",
     *    			description="기본",
     *    		),
     *    	),
     * 
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK : 전송 성공"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */
    

    public function arealist_api()
    {

        $this->rules = [
            'keyword' => 'required'
        ];

        //if( $this->checkValidation() ){

            $perPage = $this->request->getGet('perpage');
            $page = $this->request->getGet('page');

            $searchInput['search_field'] = "range1";
            $searchInput['keyword'] = $this->request->getGet('keyword');
            //var_dump ($searchInput);
            //exit;

            $arealevel3info = $this->arealevel3Model->findByCategoryName($searchInput['keyword']);
            //var_dump ($arealevel3info);
            //exit;

            $getmemberinfo = $this->memberModel->getApiSearch($searchInput,$perPage);

            $i=0;
            foreach($getmemberinfo['lists'] as $key => $item)
            {
                $photo_info = $this->membersPhotoModel->findByMemberCode($item->member_code);

                $member['member_id']   = $item->member_id;
                $member['member_code']  = $item->member_code;
                if ($item->namedistinct == "A") {
                    $member['member_name']  = $item->member_name;
                } else {
                    $member['member_name']  = $item->member_name.$item->namedistinct;
                }
                /*
                $member['gender'] = $item->gender;
                $member['cvname'] = $item->cvname;
                $member['cvname1'] = $item->cvname1;
                $member['g'] = $item->g;
                $member['g1'] = $item->g1;
                $member['range'] = $item->range;
                $member['range1'] = $item->range1;
                $member['youth'] = $item->youth;
                $member['youth1'] = $item->youth1;
                $member['youth2'] = $item->youth2;
                $member['youth3'] = $item->youth3;
                */

                if ($item->gender == "null") {
                    $member['gender'] = "";
                } else {
                    $member['gender'] = $item->gender;
                }

                if ($item->cvname == "null") {
                    $member['cvname'] = "";
                } else {
                    $member['cvname'] = $item->cvname;
                }

                if ($item->cvname1 == "null") {
                    $member['cvname1'] = "";
                } else {
                    $member['cvname1'] = $item->cvname1;
                }

                if ($item->g == "null") {
                    $member['g'] = "";
                } else {
                    $member['g'] = $item->g;
                }

                if ($item->g1 == "null") {
                    $member['g1'] = "";
                } else {
                    $member['g1'] = $item->g1;
                }

                if ($item->range == "null") {
                    $member['range'] = "";
                } else {
                    $member['range'] = $item->range;
                }

                if ($item->range1 == "null") {
                    $member['range1'] = "";
                } else {
                    $member['range1'] = $item->range1;
                }

                if ($item->youth == "null") {
                    $member['youth'] = "";
                } else {
                    $member['youth'] = $item->youth;
                }

                if ($item->youth1 == "null") {
                    $member['youth1'] = "";
                } else {
                    $member['youth1'] = $item->youth1;
                }

                if ($item->youth2 == "null") {
                    $member['youth2'] = "";
                } else {
                    $member['youth2'] = $item->youth2;
                }

                if ($item->youth3 == "null") {
                    $member['youth3'] = "";
                } else {
                    $member['youth3'] = $item->youth3;
                }

                $member['photo'] = $photo_info->file_dir;
                $member['created_at'] = $item->created_at;

                $memberinfo[$i] = $member;
                $i++;
            }
            
            $class_manager_name = $arealevel3info["class_manager"];
            $patternhan = '/[\x{1100}-\x{11FF}\x{3130}-\x{318F}\x{AC00}-\x{D7AF}]+/u';
            preg_match_all($patternhan,$class_manager_name,$matchhan);
            $pattern = '/[a-zA-Z]/';
            preg_match_all($pattern,$class_manager_name,$match);

            $class_manager_name = implode(" ",$matchhan[0]);
            $namedistinct = implode(" ",$match[0]);

            $class_manager_item = $this->memberModel->findApiByName($class_manager_name,$namedistinct);

            $responseData["data"]["class_manager"] = $arealevel3info["class_manager"];
            $responseData["data"]["class_manager_id"] = $class_manager_item->member_code;

            $photo_info = $this->membersPhotoModel->findByMemberCode($class_manager_item->member_code);
            if ($photo_info->file_dir) {
                $responseData["data"]["class_manager_photo"] = $photo_info->file_dir;
            } else {
                $responseData["data"]["class_manager_photo"] = 'upload/memphoto/00000000.jpg';
            }

            $regional_manager_name = $arealevel3info["regional_manager"];
            $patternhan = '/[\x{1100}-\x{11FF}\x{3130}-\x{318F}\x{AC00}-\x{D7AF}]+/u';
            preg_match_all($patternhan,$regional_manager_name,$matchhan);
            $pattern = '/[a-zA-Z]/';
            preg_match_all($pattern,$regional_manager_name,$match);
            
            $regional_manager_name = implode(" ",$matchhan[0]);
            $namedistinct = implode(" ",$match[0]);
            
            $regional_manager_item = $this->memberModel->findApiByName($regional_manager_name,$namedistinct);
            
            $responseData["data"]["regional_manager"] = $arealevel3info["regional_manager"];
            $responseData["data"]["regional_manager_id"] = $regional_manager_item->member_code;
            
            $photo_info = $this->membersPhotoModel->findByMemberCode($regional_manager_item->member_code);
            if ($photo_info->file_dir) {
                $responseData["data"]["regional_manager_photo"] = $photo_info->file_dir;
            } else {
                $responseData["data"]["regional_manager_photo"] = 'upload/memphoto/00000000.jpg';
            }

            $advisor_name = $arealevel3info["advisor"];
            $patternhan = '/[\x{1100}-\x{11FF}\x{3130}-\x{318F}\x{AC00}-\x{D7AF}]+/u';
            preg_match_all($patternhan,$advisor_name,$matchhan);
            $pattern = '/[a-zA-Z]/';
            preg_match_all($pattern,$advisor_name,$match);

            $advisor_name = implode(" ",$matchhan[0]);
            $namedistinct = implode(" ",$match[0]);

            $advisor_item = $this->memberModel->findApiByName($advisor_name,$namedistinct);

            $responseData["data"]["advisor"] = $arealevel3info["advisor"];
            $responseData["data"]["advisor_id"] = $advisor_item->member_code;

            $photo_info = $this->membersPhotoModel->findByMemberCode($advisor_item->member_code);
            if ($photo_info->file_dir) {
                $responseData["data"]["advisor_photo"] = $photo_info->file_dir;
            } else {
                $responseData["data"]["advisor_photo"] = 'upload/memphoto/00000000.jpg';
            }

            $responseData["data"]["area_info"] = $arealevel3info["area_info"];
            $responseData["data"]["memlist"] = $memberinfo;
            $responseData["totalRow"] = str_replace(',', '',$getmemberinfo['totalRowStr']);

            $responseData["status"] = '2001';
            $responseData["message"] = "OK : 출력성공";
            echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
    
        // }else{
        //     $responseData["status"] = '4001';
        //     $responseData["message"] = "Error : 입력 값 문제";
        //     echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
        // }
    }


    /**
	 * @OA\Get(path="/api/missionlevel_api", tags={"검색 리스트 API"},
     *   description="선카테고리2 리스트(2단계) API",
     *      @OA\Response(
     *          response=200,
     *          description="Donec sollicitudin molestie malesuada."
     *      ),
     *      @OA\Response(
     *          response="default",
     *          description="An error has occurred."
     *      )
	 * )
	 */

    public function missionlevel_api()
    {

        
        $missionlevel1data = $this->missionlevel1Model->orderBy('missionlevel1_id', 'ASC')->findAll(); //내림차순
        $i=1;
        foreach ($missionlevel1data as $menu){

            $missionlevel1_code = $menu['missionlevel1_code'];
            //$data[$i] = $menu;

            //$data[$i]['missionlevel1_id']   = $menu['missionlevel1_id'];
            //$data[$i]['missionlevel1_code']  = $menu['missionlevel1_code'];
            $data[$i]['missionlevel1_name']  = $menu['missionlevel1_name'];

                $missionlevel2data = $this->missionlevel2Model->where('missionlevel1_code', $missionlevel1_code)->orderBy('missionlevel2_id', 'ASC')->findAll();
                $j=1;

                foreach ($missionlevel2data as $menu2){

                    $missionlevel2_code = $menu2['missionlevel2_code'];
                    //$data[$i]['missionlevel2'][$j] = $menu2;

                    //$data[$i]['missionlevel2'][$j]['missionlevel2_id']   = $menu2['missionlevel2_id'];
                    //$data[$i]['missionlevel2'][$j]['missionlevel2_code']  = $menu2['missionlevel2_code'];
                    $data[$i]['missionlevel2'][$j]['missionlevel2_name']  = $menu2['missionlevel2_name'];

                        /*
                        $missionlevel3data = $this->missionlevel3Model->where('missionlevel2_code', $missionlevel2_code)->findAll();
                        $k=1;
                        
                        foreach ($missionlevel3data as $menu3){
                            $data[$i]['missionlevel2'][$j]['missionlevel3'][$k] = $menu3;
                        
                        $k++;
                        }
                        */


                $j++;
                }

        $i++;
        }

        //var_dump ($data);
        //exit;

        $responseData["data"] = $data;
        $responseData["status"] = '2001';
        $responseData["message"] = "OK : 출력성공";
        echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
            
    }


    
    /**
	 * @OA\Get(path="/api/youthlevel_api", tags={"검색 리스트 API"},
     *   description="청년부 리스트(3단계) API",
     *      @OA\Response(
     *          response=200,
     *          description="Donec sollicitudin molestie malesuada."
     *      ),
     *      @OA\Response(
     *          response="default",
     *          description="An error has occurred."
     *      )
	 * )
	 */

     public function youthlevel_api()
     {
 
         
         $youthlevel1data = $this->youthlevel1Model->orderBy('youthlevel1_id', 'ASC')->findAll(); //내림차순
         $i=1;
         foreach ($youthlevel1data as $menu){
            $member_code =$menu['leader_memcode'];
            $leader_photo = $this->membersPhotoModel->findByMemberCode($member_code);

             $youthlevel1_code = $menu['youthlevel1_code'];
             //$data[$i] = $menu;
 
             //$data[$i]['youthlevel1_id']   = $menu['youthlevel1_id'];
             //$data[$i]['youthlevel1_code']  = $menu['youthlevel1_code'];
             $data[$i]['youthlevel1_name']  = $menu['youthlevel1_name'];
             $data[$i]['leader_memname']  = $menu['leader_memname'];

             $data[$i]['leader_memcode']  = $menu['leader_memcode'];

             if($leader_photo->file_dir) {
                $data[$i]['leader_photo'] = $leader_photo->file_dir;
             } else {
                $data[$i]['leader_photo'] = "upload/memphoto/".$menu['leader_memcode'].".jpg";
             }

                 $youthlevel2data = $this->youthlevel2Model->where('youthlevel1_code', $youthlevel1_code)->orderBy('youthlevel2_id', 'ASC')->findAll();
                 $j=1;
 
                 foreach ($youthlevel2data as $menu2){
 
                    $member_code =$menu2['leader_memcode'];
                    $leader2_photo = $this->membersPhotoModel->findByMemberCode($member_code);

                     $youthlevel2_code = $menu2['youthlevel2_code'];
                     //$data[$i]['youthlevel2'][$j] = $menu2;
 
                     //$data[$i]['youthlevel2'][$j]['youthlevel2_id']   = $menu2['youthlevel2_id'];
                     //$data[$i]['youthlevel2'][$j]['youthlevel2_code']  = $menu2['youthlevel2_code'];
                     $data[$i]['youthlevel2'][$j]['youthlevel2_name']  = $menu2['youthlevel2_name'];
                     $data[$i]['youthlevel2'][$j]['leader_memname']  = $menu2['leader_memname'];
                     $data[$i]['youthlevel2'][$j]['leader_memcode']  = $menu2['leader_memcode'];

                     if($leader2_photo->file_dir) {
                        $data[$i]['youthlevel2'][$j]['leader_photo'] = $leader2_photo->file_dir;
                     } else {
                        $data[$i]['youthlevel2'][$j]['leader_photo'] = "upload/memphoto/".$menu2['leader_memcode'].".jpg";
                     }

                         $youthlevel3data = $this->youthlevel3Model->where('youthlevel2_code', $youthlevel2_code)->findAll();
                         $k=1;
                         
                         foreach ($youthlevel3data as $menu3){
                            $member_code =$menu3['leader_memcode'];
                            $leader3_photo = $this->membersPhotoModel->findByMemberCode($member_code);
                             //$data[$i]['youthlevel2'][$j]['youthlevel3'][$k] = $menu3;

                             //$data[$i]['youthlevel2'][$j]['youthlevel3'][$k]['youthlevel3_id']   = $menu3['youthlevel3_id'];
                             //$data[$i]['youthlevel2'][$j]['youthlevel3'][$k]['youthlevel3_code']  = $menu3['youthlevel3_code'];
                             $data[$i]['youthlevel2'][$j]['youthlevel3'][$k]['youthlevel3_name']  = $menu3['youthlevel3_name'];
                             $data[$i]['youthlevel2'][$j]['youthlevel3'][$k]['leader_memname']  = $menu3['leader_memname'];
                             $data[$i]['youthlevel2'][$j]['youthlevel3'][$k]['leader_memcode']  = $menu3['leader_memcode'];

                             if($leader3_photo->file_dir) {
                                $data[$i]['youthlevel2'][$j]['youthlevel3'][$k]['leader_photo'] = $leader3_photo->file_dir;
                             } else {
                                $data[$i]['youthlevel2'][$j]['youthlevel3'][$k]['leader_photo'] = "upload/memphoto/".$menu3['leader_memcode'].".jpg";
                             } 

                         $k++;
                         }
 
                 $j++;
                 }
 
         $i++;
         }
 
         //var_dump ($data);
         //exit;
 
         $responseData["data"] = $data;
         $responseData["status"] = '2001';
         $responseData["message"] = "OK : 출력성공";
         echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
             
     }


/**
	 * @OA\Get(path="/api/sodalitylevel_api", tags={"검색 리스트 API"},
     *   description="제직회 리스트(2단계) API",
     *      @OA\Response(
     *          response=200,
     *          description="Donec sollicitudin molestie malesuada."
     *      ),
     *      @OA\Response(
     *          response="default",
     *          description="An error has occurred."
     *      )
	 * )
	 */

     public function sodalitylevel_api()
     {
 
         $sodalitylevel1data = $this->sodalitylevel1Model->orderBy('sodalitylevel1_id', 'ASC')->findAll(); //내림차순
         $i=1;
         foreach ($sodalitylevel1data as $menu){
 
             $sodalitylevel1_code = $menu['sodalitylevel1_code'];
             //$data[$i] = $menu;
 
             //$data[$i]['sodalitylevel1_id']   = $menu['sodalitylevel1_id'];
             //$data[$i]['sodalitylevel1_code']  = $menu['sodalitylevel1_code'];
             $data[$i]['sodalitylevel1_name']  = $menu['sodalitylevel1_name'];
 
                 $sodalitylevel2data = $this->sodalitylevel2Model->where('sodalitylevel1_code', $sodalitylevel1_code)->orderBy('sodalitylevel2_id', 'ASC')->findAll();
                 $j=1;
 
                 foreach ($sodalitylevel2data as $menu2){
 
                     $sodalitylevel2_code = $menu2['sodalitylevel2_code'];
                     //$data[$i]['sodalitylevel2'][$j] = $menu2;
 
                     //$data[$i]['sodalitylevel2'][$j]['sodalitylevel2_id']   = $menu2['sodalitylevel2_id'];
                     $data[$i]['sodalitylevel2'][$j]['sodalitylevel2_code']  = $menu2['sodalitylevel2_code'];
                     $data[$i]['sodalitylevel2'][$j]['sodalitylevel2_name']  = $menu2['sodalitylevel2_name'];    
                     /*                
                     $data[$i]['sodalitylevel2'][$j]['director']  = $menu2['director'];
                     $data[$i]['sodalitylevel2'][$j]['conductor1']  = $menu2['conductor1'];
                     $data[$i]['sodalitylevel2'][$j]['conductor2']  = $menu2['conductor2'];
                     $data[$i]['sodalitylevel2'][$j]['member1']  = $menu2['member1'];
                     $data[$i]['sodalitylevel2'][$j]['member2']  = $menu2['member2'];
                     */
 
 
                         /*
                         $sodalitylevel3data = $this->sodalitylevel3Model->where('sodalitylevel2_code', $sodalitylevel2_code)->findAll();
                         $k=1;
                         
                         foreach ($sodalitylevel3data as $menu3){
                             $data[$i]['sodalitylevel2'][$j]['sodalitylevel3'][$k] = $menu3;
                         
                         $k++;
                         }
                         */
 
 
                 $j++;
                 }
 
         $i++;
         }
 
         //var_dump ($data);
         //exit;
 
         $responseData["data"] = $data;
         $responseData["status"] = '2001';
         $responseData["message"] = "OK : 출력성공";
         echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
             
     }


    /**
     * @OA\Post(path="/api/sodalitydetail_api", tags={"검색 리스트 API"},
     *  description="<b>제직회 상세정보 APII</b><p>
    <b>[Parameters]</b><br>
    sodality_category2_code : Sodality Code<br>
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="multipart/form-data",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="sodality_category2_code",
    *           description="Sodality Code",
    *           type="string",
    *  			default="101",
    *         ),
    *       ),
    *     ),
    *   ),

     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK : 전송 성공"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

     public function sodalitydetail_api()
     {
         $this->rules = [
             'sodality_category2_code' => 'required'
         ];
 
         if( $this->checkValidation() ){
         
             $sodality_category2_code = $this->request->getVar('sodality_category2_code');
             $responseData["item"] = $this->sodalitylevel2Model->findByCategoryName($sodality_category2_code);

             $responseData["status"] = '2001';
             $responseData["message"] = "OK : 출력성공";
             echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
     
         }else{
             $responseData["status"] = '4001';
             $responseData["message"] = "Error : 입력 값 문제";
             echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
         }
     }



    /**
	 * @OA\Get(path="/api/servantlevel_api", tags={"검색 리스트 API"},
     *   description="봉사 리스트(3단계) API",
     *      @OA\Response(
     *          response=200,
     *          description="Donec sollicitudin molestie malesuada."
     *      ),
     *      @OA\Response(
     *          response="default",
     *          description="An error has occurred."
     *      )
	 * )
	 */

     public function servantlevel_api()
     {
 
         
         $servantlevel1data = $this->servantlevel1Model->orderBy('servantlevel1_id', 'ASC')->findAll(); //내림차순
         $i=1;
         foreach ($servantlevel1data as $menu){
 
             $servantlevel1_code = $menu['servantlevel1_code'];
             //$data[$i] = $menu;
 
             //$data[$i]['servantlevel1_id']   = $menu['servantlevel1_id'];
             //$data[$i]['servantlevel1_code']  = $menu['servantlevel1_code'];
             $data[$i]['servantlevel1_name']  = $menu['servantlevel1_name'];

                 $servantlevel2data = $this->servantlevel2Model->where('servantlevel1_code', $servantlevel1_code)->orderBy('servantlevel2_id', 'ASC')->findAll();
                 $j=1;
 
                 foreach ($servantlevel2data as $menu2){
 
                     $servantlevel2_code = $menu2['servantlevel2_code'];
                     //$data[$i]['servantlevel2'][$j] = $menu2;
 
                     //$data[$i]['servantlevel2'][$j]['servantlevel2_id']   = $menu2['servantlevel2_id'];
                     //$data[$i]['servantlevel2'][$j]['servantlevel2_code']  = $menu2['servantlevel2_code'];
                     $data[$i]['servantlevel2'][$j]['servantlevel2_name']  = $menu2['servantlevel2_name'];
                     $data[$i]['servantlevel2'][$j]['servantlevel2_contents']  = $menu2['contents'];
                      
                         $servantlevel3data = $this->servantlevel3Model->where('servantlevel2_code', $servantlevel2_code)->findAll();
                         $k=1;
                         
                         foreach ($servantlevel3data as $menu3){
                             //$data[$i]['servantlevel2'][$j]['servantlevel3'][$k] = $menu3;

                             //$data[$i]['servantlevel2'][$j]['servantlevel3'][$k]['servantlevel3_id']   = $menu3['servantlevel3_id'];
                             $data[$i]['servantlevel2'][$j]['servantlevel3'][$k]['servantlevel3_code']  = $menu3['servantlevel3_code'];
                             $data[$i]['servantlevel2'][$j]['servantlevel3'][$k]['servantlevel3_name']  = $menu3['servantlevel3_name'];
                         
                         $k++;
                         }
 
                 $j++;
                 }
 
         $i++;
         }
 
         //var_dump ($data);
         //exit;
 
         $responseData["data"] = $data;
         $responseData["status"] = '2001';
         $responseData["message"] = "OK : 출력성공";
         echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
             
     }


    /**
     * @OA\Post(path="/api/servantdetail_api", tags={"검색 리스트 API"},
     *  description="<b>봉사자 상세정보 APII</b><p>
    <b>[Parameters]</b><br>
    servant_category3_code : Servant Code<br>
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="multipart/form-data",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="servant_category3_code",
    *           description="Servant Code",
    *           type="string",
    *  			default="10304",
    *         ),
    *       ),
    *     ),
    *   ),

     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK : 전송 성공"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

     public function servantdetail_api()
     {
         $this->rules = [
             'servant_category3_code' => 'required'
         ];
 
         if( $this->checkValidation() ){
         
             $servant_category3_code = $this->request->getVar('servant_category3_code');
             $responseData["item"] = $this->servantlevel3Model->findByCategoryName($servant_category3_code);

             $responseData["status"] = '2001';
             $responseData["message"] = "OK : 출력성공";
             echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
     
         }else{
             $responseData["status"] = '4001';
             $responseData["message"] = "Error : 입력 값 문제";
             echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
         }
     }

    /**
    * @OA\Post(path="/api/memberInfoModify_api", tags={"검색 상세 API"},
    *   description="<b>Dimode Member Info Modify API</b><p>
    <b>[Parameters]</b><br>
    ID : 교적번호<br>
    NAME : 이름<br>
    SOLAR : 음/양력<br>
    BIRTH : 생일<br>
    SIDO : 시/도<br>
    GUGUN : 구<br>
    DONG : 길<br>
    BUNJI : 상세주소<br>
    ZIPCODE : 우편번호<br>
    TEL : 전화번호<br>
    HANDPHONE : 이동전화<br>
    EMAIL : EMAIL<br>
    OCCU : 직종<br>
    OFFNAME : 회사명<br>
    OFFZIP : 회사우편번호<br>
    OFFTEL : 회사주소<br>
    OFFGRADE : 직급<br>
    CARKIND : 차종<br>
    CARNUM : 차량번호<br>
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="application/json",
    *       @OA\Schema(
    *         @OA\Property(property="ID", description="ID INFO", type="string", default="20030185",),
    *         @OA\Property(property="NAME", description="NAME INFO", type="string", default="정경연",),
    *         @OA\Property(property="SOLAR", description="SOLAR INFO", type="string", default="양",),
    *         @OA\Property(property="BIRTH", description="BIRTH INFO", type="string", default="1967-12-25",),
    *         @OA\Property(property="SIDO", description="SIDO INFO", type="string", default="인천광역시",),
    *         @OA\Property(property="GUGUN", description="GUGUN INFO", type="string", default="계양구 ",),
    *         @OA\Property(property="DONG", description="DONG INFO", type="string", default="주부토로",),
    *         @OA\Property(property="BUNJI", description="BUNJI INFO", type="string", default="528 (계산동 삼보아파트) 6-516",),
    *         @OA\Property(property="ZIPCODE", description="ZIPCODE INFO", type="string", default="21059",),
    *         @OA\Property(property="TEL", description="TEL INFO", type="string", default="032-524-1015",),
    *         @OA\Property(property="HANDPHONE", description="HANDPHONE INFO", type="string", default="010-9028-7124",),
    *         @OA\Property(property="EMAIL", description="EMAIL INFO", type="string", default="pixel@korea.com",),
    *         @OA\Property(property="OCCU", description="OCCU INFO", type="string", default="회사원",),
    *         @OA\Property(property="OFFNAME", description="OFFNAME INFO", type="string", default="승전상사",),
    *         @OA\Property(property="OFFZIP", description="OFFZIP INFO", type="string", default=" ",),
    *         @OA\Property(property="OFFTEL", description="OFFTEL INFO", type="string", default="02-391-6800",),
    *         @OA\Property(property="OFFGRADE", description="OFFGRADE INFO", type="string", default=" ",),
    *         @OA\Property(property="CARKIND", description="CARKIND INFO", type="string", default="소나타",),
    *         @OA\Property(property="CARNUM", description="CARNUM INFO", type="string", default="317버8563",),
    *       ),
    *     ),
    *   ),
    *
    *     @OA\Response(
    *         response="200",
    *         description="Success",
    *         content={
    *             @OA\MediaType(
    *                 mediaType="application/json",
    *                 @OA\Schema(
    *                     @OA\Property(
    *                         property="Status",
    *                         type="integer",
    *                         description="응답 받은 코드"
    *                     ),
    *                     @OA\Property(
    *                         property="Message",
    *                         type="string",
    *                         description="응답 받은 메시지"
    *                     ),
    *                     example={
    *                           "status":  "2001",
    *                           "message": "OK"
    *                     }
    *                 )
    *             )
    *         }
    *     ),
    * @OA\Response(response="201", description="Created"),
    * @OA\Response(response="401", description="Unauthorized"),
    * @OA\Response(response="403", description="Forbidden"),
    * @OA\Response(response="404", description="Not Found"),
    *
	* )
	*/

    public function memberInfoModify_api()
    {
        helper(['form']);

        $this->rules = [
           'ID' => 'required',
           'NAME' => 'required'
       ];

       if( $this->checkValidation() ){

               $member_code = $this->request->getVar('ID');
               $handphone = $this->request->getVar('HANDPHONE');

               if($account = $this->memberModel->findByCode($handphone, $member_code)){

               $account->member_name = $this->request->getVar('NAME');
               $account->lunar_calendar = $this->request->getVar('SOLAR');
               $account->birth_date = $this->request->getVar('BIRTH');
               $account->address1 = $this->request->getVar('SIDO');
               $account->address2 = $this->request->getVar('GUGUN');
               $account->address3 = $this->request->getVar('DONG');
               $account->address4 = $this->request->getVar('BUNJI');
               $account->zipcode = $this->request->getVar('ZIPCODE');
               $account->addr = $account->address1." ".$account->address2." ".$account->address3." ".$account->address4;
               $account->member_email = $this->request->getVar('EMAIL');
               $account->member_phone = $this->request->getVar('TEL');
               $account->handphone = $this->request->getVar('HANDPHONE');
               $account->occu = $this->request->getVar('OCCU');
               $account->offname = $this->request->getVar('OFFNAME');
               $account->offzip = $this->request->getVar('OFFZIP');
               $account->offtel = $this->request->getVar('OFFTEL');
               $account->offgrade = $this->request->getVar('OFFGRADE');
               $account->carkind = $this->request->getVar('CARKIND');
               $account->carnum = $this->request->getVar('CARNUM');

               $this->memberModel->save($account);

                   $responseData["status"] = '2001';
                   $responseData["message"] = "OK : 정보가 수정되었습니다.";
                   echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

               }else{
                   $responseData["status"] = '4001';
                   $responseData["message"] = "Error : 입력 값 문제";
                   echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
               }
           
       }else{
           $responseData["status"] = '4000';
           $responseData["message"] = "Error : 입력 값 오류";
           echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
       }

    }

    
    /**
	 * @OA\Get(path="/api/bannertop_api", tags={"베너정보 API"},
     *   description="메인 탑베너 API",
     *      @OA\Response(
     *          response=200,
     *          description="Donec sollicitudin molestie malesuada."
     *      ),
     *      @OA\Response(
     *          response="default",
     *          description="An error has occurred."
     *      )
	 * )
	 */

     public function bannertop_api()
     {
 
        $bannertop = $this->bannertopsModel->getApiMainbanner(1);
        $today = date("Y-m-d");
        
        $i=0;
        foreach($bannertop['lists'] as $key => $item)
        {

            $start_date = substr($item->start_date, 0, 10); 
            $end_date = substr($item->end_date, 0, 10); 

            if ($today >= $start_date && $today <= $end_date) {
                $banner['image_dir']  = $item->image_dir;
                $banner['tabimage_dir']  = $item->tabimage_dir;
                // $banner['goto_URL'] = $item->goto_URL;
                // $banner['title'] = $item->title;
                // $banner['sub_title'] = $item->sub_title;
                $banner['start_date'] = substr($item->start_date, 0, 10); 
                $banner['end_date'] = substr($item->end_date, 0, 10); 

            $mainbanner[$i] = $banner;
            }

            $i++;
        }

         $responseData["data"] = $mainbanner;
         $responseData["refresh_sec"] = 30;
         $responseData["update_day"] = 2;
         $responseData["status"] = '2001';
         $responseData["message"] = "OK : 출력성공";
         echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
             
     }


    /**
	 * @OA\Get(path="/api/bannermain_api", tags={"베너정보 API"},
     *   description="메인 베너 리스트 API",
     *      @OA\Response(
     *          response=200,
     *          description="Donec sollicitudin molestie malesuada."
     *      ),
     *      @OA\Response(
     *          response="default",
     *          description="An error has occurred."
     *      )
	 * )
	 */

     public function bannermain_api()
     {
 
        $bannermain = $this->bannermainsModel->getApiMainbanner(4);
        $today = date("Y-m-d");
        
        $i=0;
        foreach($bannermain['lists'] as $key => $item)
        {

            $start_date = substr($item->start_date, 0, 10); 
            $end_date = substr($item->end_date, 0, 10); 

            if ($today >= $start_date && $today <= $end_date) {
                $banner['image_dir']  = $item->image_dir;
                $banner['tabimage_dir']  = $item->tabimage_dir;
                $banner['goto_URL'] = $item->goto_URL;
                $banner['title'] = $item->title;
                $banner['sub_title'] = $item->sub_title;
                $banner['start_date'] = substr($item->start_date, 0, 10); 
                $banner['end_date'] = substr($item->end_date, 0, 10); 

            $mainbanner[$i] = $banner;
            }

            $i++;
        }

         $responseData["data"] = $mainbanner;
         $responseData["refresh_sec"] = 3;
         $responseData["update_hour"] = 168;
         $responseData["status"] = '2001';
         $responseData["message"] = "OK : 출력성공";
         echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
             
     }


    /**
	 * @OA\Get(path="/api/youtubeLive", tags={"유튜브정보 API"},
     *   description="유튜브 정보 API",
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
	 * )
	 */


     /*
     public function youtubeLive_v001()
     {
        
        # API URL
        $url = 'https://www.googleapis.com/youtube/v3/search';

        $params = array(
            "key"=>"AIzaSyBiQitELVL0T4nJsnMF5-79Bh9T5rMPmkE",   // 유튜브 API KEY 영은테스트
            "part"=>"snippet",
            "channelId"=>"UCCTaL1SAsYm2kvBkCo1NGIA",    // 유튜브 채널 ID
            // "eventType"=>"live", //활성 브로드캐스트만
            "maxResults"=>1,
            "order"=>"date",
            "q"=>""
        );

        $paramsUrl = '';
        foreach ($params as $k=>$v) $paramsUrl .= (!$paramsUrl?'?':'&').$k.'='.$v;
        $resultJsonData = @file_get_contents($url.$paramsUrl);

        // echo $resultJsonData;
        if ($resultJsonData) {
            $resultArrayData = @json_decode($resultJsonData, true);
            $itemArray = array();
            if (count($resultArrayData['items'])>0) {
                foreach ($resultArrayData['items'] as $item) {
                    array_push($itemArray, array(
                        'videoLink'=>"https://www.youtube.com/embed/".$item['id']['videoId'],
                        'videoId'=>$item['id']['videoId'],
                        'title'=>$item['snippet']['title'],
                        'description'=>$item['snippet']['description'],
                        'thumbnail'=>$item['snippet']['thumbnails']['high']['url'],
                        'publish'=>$item['snippet']['publishedAt'],
                    ));
                }
            }
        }

         $responseData["data"] = $itemArray;
         $responseData["status"] = '2001';
         $responseData["message"] = "OK : 출력성공";
         echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
             
     }

     public function youtubeLive_v002()
     {
        
        # API URL
        $url = 'https://www.googleapis.com/youtube/v3/search';

        $params = array(
            "key"=>"AIzaSyBiQitELVL0T4nJsnMF5-79Bh9T5rMPmkE",   // 유튜브 API KEY 영은테스트
            "part"=>"snippet",
            "channelId"=>"UCCTaL1SAsYm2kvBkCo1NGIA",    // 유튜브 채널 ID
            // "eventType"=>"live", //활성 브로드캐스트만
            "maxResults"=>50,
            "order"=>"date",
            "q"=>""
        );

        $paramsUrl = '';
        foreach ($params as $k=>$v) $paramsUrl .= (!$paramsUrl?'?':'&').$k.'='.$v;
        $resultJsonData = @file_get_contents($url.$paramsUrl);

        //echo $resultJsonData;
        if ($resultJsonData) {
            $resultArrayData = @json_decode($resultJsonData, true);
            if (count($resultArrayData['items'])>0) {

                foreach ($resultArrayData['items'] as $item) {

                    $videoId = $item['id']['videoId'];
                    
                    $videoIdCount =  count($this->worshipvideoModel->like('video_id',$videoId)->findAll());

                    if ($videoIdCount == 0) {
                        
                        $categoryTxt = $item['snippet']['title'];
                        $categoryTxt = str_replace(" ", "", $categoryTxt); 
                        $categoryTxt = str_replace("-", "", $categoryTxt); 
                        $categoryTxt = str_replace("영은카테고리2", "", $categoryTxt); 
                        $categoryTxt = str_replace("전체실황", "", $categoryTxt); 
                        $categoryTxt = str_replace("경배와찬양", "", $categoryTxt); 
                        $categoryTxt = str_replace("ㅣ", "|", $categoryTxt); 
                        $category_array = explode("|", $categoryTxt);

                        $today = date("Ymd");
                        $nowtime = date("H");

                        if ($category_array[0] == $today){

                            if ($category_array[1] == "새벽기도회") {
                                if ($nowtime == "05"  || $nowtime == "06"){
                                    $itemArray = array();
                                    array_push($itemArray, array(
                                        'videoLink'=>"https://www.youtube.com/embed/".$item['id']['videoId'],
                                        'videoId'=>$item['id']['videoId'],
                                        'title'=>$item['snippet']['title'],
                                        'description'=>$item['snippet']['description'],
                                        'thumbnail'=>$item['snippet']['thumbnails']['high']['url'],
                                        'publish'=>$item['snippet']['publishedAt'],
                                    ));

                                    $responseData["data"] = $itemArray;
                                    $responseData["status"] = '2001';
                                    $responseData["message"] = "OK : 출력성공";
                                    echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
                                }

                            } elseif ($category_array[1] == "3부예배") {
                                if ($nowtime == "11"  || $nowtime == "12"){
                                    $itemArray = array();
                                    array_push($itemArray, array(
                                        'videoLink'=>"https://www.youtube.com/embed/".$item['id']['videoId'],
                                        'videoId'=>$item['id']['videoId'],
                                        'title'=>$item['snippet']['title'],
                                        'description'=>$item['snippet']['description'],
                                        'thumbnail'=>$item['snippet']['thumbnails']['high']['url'],
                                        'publish'=>$item['snippet']['publishedAt'],
                                    ));

                                    $responseData["data"] = $itemArray;
                                    $responseData["status"] = '2001';
                                    $responseData["message"] = "OK : 출력성공";
                                    echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
                                }

                            } elseif ($category_array[1] == "4부예배") {
                                if ($nowtime == "13"  || $nowtime == "14"){
                                    $itemArray = array();
                                    array_push($itemArray, array(
                                        'videoLink'=>"https://www.youtube.com/embed/".$item['id']['videoId'],
                                        'videoId'=>$item['id']['videoId'],
                                        'title'=>$item['snippet']['title'],
                                        'description'=>$item['snippet']['description'],
                                        'thumbnail'=>$item['snippet']['thumbnails']['high']['url'],
                                        'publish'=>$item['snippet']['publishedAt'],
                                    ));

                                    $responseData["data"] = $itemArray;
                                    $responseData["status"] = '2001';
                                    $responseData["message"] = "OK : 출력성공";
                                    echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
                                }

                            } elseif ($category_array[1] == "오후예배") {
                                if ($nowtime == "15"  || $nowtime == "16"){
                                    $itemArray = array();
                                    array_push($itemArray, array(
                                        'videoLink'=>"https://www.youtube.com/embed/".$item['id']['videoId'],
                                        'videoId'=>$item['id']['videoId'],
                                        'title'=>$item['snippet']['title'],
                                        'description'=>$item['snippet']['description'],
                                        'thumbnail'=>$item['snippet']['thumbnails']['high']['url'],
                                        'publish'=>$item['snippet']['publishedAt'],
                                    ));

                                    $responseData["data"] = $itemArray;
                                    $responseData["status"] = '2001';
                                    $responseData["message"] = "OK : 출력성공";
                                    echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
                                }

                            } elseif ($category_array[1] == "금요기도회") {
                                if ($nowtime == "20"  || $nowtime == "21"){
                                    $itemArray = array();
                                    array_push($itemArray, array(
                                        'videoLink'=>"https://www.youtube.com/embed/".$item['id']['videoId'],
                                        'videoId'=>$item['id']['videoId'],
                                        'title'=>$item['snippet']['title'],
                                        'description'=>$item['snippet']['description'],
                                        'thumbnail'=>$item['snippet']['thumbnails']['high']['url'],
                                        'publish'=>$item['snippet']['publishedAt'],
                                    ));

                                    $responseData["data"] = $itemArray;
                                    $responseData["status"] = '2001';
                                    $responseData["message"] = "OK : 출력성공";
                                    echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
                                }

                            } elseif ($category_array[1] == "수요예배") {
                                if ($nowtime == "19"  || $nowtime == "20"){
                                    $itemArray = array();
                                    array_push($itemArray, array(
                                        'videoLink'=>"https://www.youtube.com/embed/".$item['id']['videoId'],
                                        'videoId'=>$item['id']['videoId'],
                                        'title'=>$item['snippet']['title'],
                                        'description'=>$item['snippet']['description'],
                                        'thumbnail'=>$item['snippet']['thumbnails']['high']['url'],
                                        'publish'=>$item['snippet']['publishedAt'],
                                    ));

                                    $responseData["data"] = $itemArray;
                                    $responseData["status"] = '2001';
                                    $responseData["message"] = "OK : 출력성공";
                                    echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
                                }

                            }

                        }

                    }

                }
            }

        }

     }

     public function youtubeLive_v003()
     {        
        # API URL
        $url = 'https://www.googleapis.com/youtube/v3/search';

        $params = array(
            "key"=>"AIzaSyBiQitELVL0T4nJsnMF5-79Bh9T5rMPmkE",   // 유튜브 API KEY 영은테스트
            "part"=>"snippet",
            "channelId"=>"UCCTaL1SAsYm2kvBkCo1NGIA",    // 유튜브 채널 ID
            // "eventType"=>"live", //활성 브로드캐스트만
            "maxResults"=>1,
            "order"=>"date",
            "q"=>""
        );

        $paramsUrl = '';
        foreach ($params as $k=>$v) $paramsUrl .= (!$paramsUrl?'?':'&').$k.'='.$v;
        $resultJsonData = @file_get_contents($url.$paramsUrl);
        // echo $resultJsonData;

        $curr = date("Ymd H:i:s");
        $week = date("w");
        $today = date("Ymd");

        if ($week == "3") {
            if ( $curr > $today.' 19:30:00' && $curr < $today.' 20:40:00') {
                $liveChk = "OnAir";
            }
        } elseif ($week == "5") {
            if ( $curr > $today.' 20:30:00' && $curr < $today.' 21:40:00') {
                $liveChk = "OnAir";
            }
        } elseif ($week == "0") {
            if ( $curr > $today.' 07:30:00' && $curr < $today.' 08:40:00' || $curr > $today.' 09:00:00' && $curr < $today.' 10:10:00' || $curr > $today.' 11:30:00' && $curr < $today.' 12:10:00' || $curr > $today.' 13:30:00' && $curr < $today.' 14:40:00' || $curr > $today.' 15:30:00' && $curr < $today.' 16:50:00') {
                $liveChk = "OnAir";
            }
        } else {
            if ( $curr > $today.' 05:30:00' && $curr < $today.' 06:30:00') {
                $liveChk = "OnAir";
            }
        }

        // $liveChk = "OnAir";
        // echo $liveChk;

        if ($liveChk == "OnAir") {

            if ($resultJsonData) {
                $resultArrayData = @json_decode($resultJsonData, true);
                $itemArray = array();
                if (count($resultArrayData['items'])>0) {
                    foreach ($resultArrayData['items'] as $item) {
                        array_push($itemArray, array(
                            'videoLink'=>"https://www.youtube.com/embed/".$item['id']['videoId'],
                            'videoId'=>$item['id']['videoId'],
                            'title'=>$item['snippet']['title'],
                            'description'=>$item['snippet']['description'],
                            'thumbnail'=>$item['snippet']['thumbnails']['high']['url'],
                            'publish'=>$item['snippet']['publishedAt'],
                        ));
                    }
                }
            }

            $responseData["data"] = $itemArray;
            $responseData["status"] = '2001';
            $responseData["message"] = "OK : 출력성공";
            echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

        }
             
     }

     public function youtubeLive_v004()
     {
        
        # API URL
        $url = 'https://www.googleapis.com/youtube/v3/search';

        $params = array(
            "key"=>"AIzaSyBiQitELVL0T4nJsnMF5-79Bh9T5rMPmkE",   // 유튜브 API KEY 영은테스트
            "part"=>"snippet",
            "channelId"=>"UCCTaL1SAsYm2kvBkCo1NGIA",    // 유튜브 채널 ID
            // "eventType"=>"live", //활성 브로드캐스트만
            "maxResults"=>5,
            "order"=>"date",
            "q"=>""
        );

        $paramsUrl = '';
        foreach ($params as $k=>$v) $paramsUrl .= (!$paramsUrl?'?':'&').$k.'='.$v;
        $resultJsonData = @file_get_contents($url.$paramsUrl);
        //echo $resultJsonData;

        if ($resultJsonData) {
            $resultArrayData = @json_decode($resultJsonData, true);
            if (count($resultArrayData['items'])>0) {

                foreach ($resultArrayData['items'] as $item) {

                    $videoId = $item['id']['videoId'];
                    
                    $videoIdCount =  count($this->worshipvideoModel->like('video_id',$videoId)->findAll());

                    if ($videoIdCount == 0) {
                        
                        $categoryTxt = $item['snippet']['title'];
                        $categoryTxt = str_replace(" ", "", $categoryTxt); 
                        $categoryTxt = str_replace("-", "", $categoryTxt); 
                        $categoryTxt = str_replace("영은카테고리2", "", $categoryTxt); 
                        $categoryTxt = str_replace("전체실황", "", $categoryTxt); 
                        $categoryTxt = str_replace("경배와찬양", "", $categoryTxt); 
                        $categoryTxt = str_replace("ㅣ", "|", $categoryTxt); 
                        $category_array = explode("|", $categoryTxt);

                        $curr = date("Ymd H:i:s");
                        $week = date("w");
                        $today = date("Ymd");
                        $nowtime = date("H");

                        if ($week == "3") {
                            if ( $curr > $today.' 19:30:00' && $curr < $today.' 20:40:00') {
                                $liveChk = "OnAir";
                            }
                        } elseif ($week == "5") {
                            if ( $curr > $today.' 20:30:00' && $curr < $today.' 21:40:00') {
                                $liveChk = "OnAir";
                            }
                        } elseif ($week == "0") {
                            if ( $curr > $today.' 07:30:00' && $curr < $today.' 08:40:00' || $curr > $today.' 09:00:00' && $curr < $today.' 10:10:00' || $curr > $today.' 11:30:00' && $curr < $today.' 12:10:00' || $curr > $today.' 13:30:00' && $curr < $today.' 14:40:00' || $curr > $today.' 15:30:00' && $curr < $today.' 16:50:00') {
                                $liveChk = "OnAir";
                            }
                        } else {
                            if ( $curr > $today.' 05:30:00' && $curr < $today.' 06:30:00') {
                                $liveChk = "OnAir";
                            }
                        }
                
                        // $liveChk = "OnAir";
                        // echo $liveChk;
                        // $today = '20240121';

                        if ($category_array[0] == $today){
                            if ($liveChk == "OnAir") {

                                if(str_contains($category_array[1], '예배') || str_contains($category_array[1], '기도회') || str_contains($category_array[1], '설교')) {

                                    $itemArray = array();
                                    array_push($itemArray, array(
                                        'videoLink'=>"https://www.youtube.com/embed/".$item['id']['videoId'],
                                        'videoId'=>$item['id']['videoId'],
                                        'title'=>$item['snippet']['title'],
                                        'description'=>$item['snippet']['description'],
                                        'thumbnail'=>$item['snippet']['thumbnails']['high']['url'],
                                        'publish'=>$item['snippet']['publishedAt'],
                                    ));

                                    $responseData["data"] = $itemArray;
                                    $responseData["status"] = '2001';
                                    $responseData["message"] = "OK : 출력성공";
                                    echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
                                }

                            }
                        }

                    }

                }
            }

        }

     }
    */

    public function youtubeLive()
    {
       # API URL
       $url = 'https://www.googleapis.com/youtube/v3/search';
       $params = array(
           "key"=>"AIzaSyBiQitELVL0T4nJsnMF5-79Bh9T5rMPmkE",   // 유튜브 API KEY 영은테스트
           "part"=>"snippet",
           "channelId"=>"UCCTaL1SAsYm2kvBkCo1NGIA",    // 유튜브 채널 ID
           "type"=>"video",
           "eventType"=>"live", //활성 브로드캐스트만
           // "eventType"=>"completed", //완료된 브로드캐스트만
           "maxResults"=>1,
           "order"=>"date",
           "q"=>""
       );

       $paramsUrl = '';
       foreach ($params as $k=>$v) $paramsUrl .= (!$paramsUrl?'?':'&').$k.'='.$v;
       $resultJsonData = @file_get_contents($url.$paramsUrl);
       // echo $resultJsonData;
       if ($resultJsonData) {
           $resultArrayData = @json_decode($resultJsonData, true);
           $itemArray = array();
           if (count($resultArrayData['items'])>0) {
               foreach ($resultArrayData['items'] as $item) {
                   array_push($itemArray, array(
                       'videoLink'=>"https://www.youtube.com/embed/".$item['id']['videoId'],
                       'videoId'=>$item['id']['videoId'],
                       'title'=>$item['snippet']['title'],
                       'description'=>$item['snippet']['description'],
                       'thumbnail'=>$item['snippet']['thumbnails']['high']['url'],
                       'publish'=>$item['snippet']['publishedAt'],
                   ));
               }
           }
       }

        $responseData["data"] = $itemArray;
        $responseData["status"] = '2001';
        $responseData["message"] = "OK : 출력성공";
        echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
            
    }



    /**
    * @OA\Post(path="/api/readThroughCheck_api", tags={"성경 통독 API"},
    *   description="<b>성경 통독 체크 API</b><p>
    <b>[Parameters]</b><br>
    member_code : Member Code Info<br>
    comment : Comment Info<br>
    ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="application/json",
    *       @OA\Schema(
    *         @OA\Property(property="member_code", description="Member Code Info", type="string", default="20030185",),
    *         @OA\Property(property="comment", description="Comment Info", type="string", default="남선카테고리2 통독(참여자 정경연 외)",),
    *       ),
    *     ),
    *   ),
    *
    *     @OA\Response(
    *         response="200",
    *         description="Success",
    *         content={
    *             @OA\MediaType(
    *                 mediaType="application/json",
    *                 @OA\Schema(
    *                     @OA\Property(
    *                         property="Status",
    *                         type="integer",
    *                         description="응답 받은 코드"
    *                     ),
    *                     @OA\Property(
    *                         property="Message",
    *                         type="string",
    *                         description="응답 받은 메시지"
    *                     ),
    *                     example={
    *                           "status":  "2001",
    *                           "message": "OK"
    *                     }
    *                 )
    *             )
    *         }
    *     ),
    * @OA\Response(response="201", description="Created"),
    * @OA\Response(response="401", description="Unauthorized"),
    * @OA\Response(response="403", description="Forbidden"),
    * @OA\Response(response="404", description="Not Found"),
    *
	* )
	*/

    public function readThroughCheck_api()
    {
        helper(['form']);

        $this->rules = [
           'member_code' => 'required'
       ];

       if( $this->checkValidation() ){

               $readThrough = new ReadThrough();

               $readThrough->member_code = $this->request->getVar('member_code');
               $readThrough->comment = $this->request->getVar('comment');
               $readThrough->active_flg = "1";

              $insertId = $this->readThroughModel->save($readThrough);
            
               if($insertId){
                   $responseData["status"] = '2001';
                   $responseData["message"] = "OK : 정보가 등록되었습니다.";
                   echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

               }else{
                   $responseData["status"] = '4001';
                   $responseData["message"] = "Error : 입력 값 문제";
                   echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
               }
               
       }else{
           $responseData["status"] = '4000';
           $responseData["message"] = "Error : 입력 값 오류";
           echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
       }

    }


    
    /**
     * @OA\Post(path="/api/readThroughList_api", tags={"성경 통독 API"},
     *  description="<b>성경 통독 이력 API</b><p>
    <b>[Parameters]</b><br>
    member_id : Member ID<br>
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="multipart/form-data",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="member_code",
    *           description="Member Code",
    *           type="string",
    *  			default="20030185",
    *         ),
    *       ),
    *     ),
    *   ),

     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK : 전송 성공"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

     public function readThroughList_api()
     {
         $this->rules = [
             'member_code' => 'required'
         ];
 
         if( $this->checkValidation() ){
         
             $member_code = $this->request->getVar('member_code');
             $findreadthrough = $this->readThroughModel->getApiSearch($member_code, 20);

             $i=0;
             foreach($findreadthrough['lists'] as $key => $item)
             {

                 $dreadthrough['id']   = $item->id;
                 $dreadthrough['member_code']  = $item->member_code;
                 $dreadthrough['comment']  = $item->comment;
                 $dreadthrough['created_at'] = $item->created_at;
 
                 $readthroughinfo[$i] = $dreadthrough;
                 $i++;
             }
             
             $responseData["data"] = $readthroughinfo;
             $responseData["totalRow"] = str_replace(',', '', $findreadthrough['totalRowStr']);

             $responseData["status"] = '2001';
             $responseData["message"] = "OK : 출력성공";
             echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
     
         }else{
             $responseData["status"] = '4001';
             $responseData["message"] = "Error : 입력 값 문제";
             echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
         }
 
 
     }



     
     /**
	 * @OA\Post(path="/api/fcmTokenAdd", tags={"앱 푸시 API"},
         *   description="<b>앱 FCM 토큰등록</b><p>
    <b>[Parameters]</b><br>
    member_code : 교적번호<br>
    device_token_id : FCM 앱토큰<br>
    os_type_cd : OS 구분(AA : 안드로이드, IA : iOS)<br>
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="application/json",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="member_code",
    *           description="교적번호",
    *    		type="string",
    *    		default="20030185",
    *         ),
    *         @OA\Property(
    *           property="device_token_id",
    *           description="FCM 앱토큰",
    *    		type="string",
    *           default="d2LtcCunSbK4bmiyd2MmyF:APA91bFiM0MxGUxaYw4Z3uXBIQzNCE4awkM929-t7fos4z_srsbQ7xeYL3WV5da1nsoHY1AVfimhSItrPVZj0D_lfNrr1vDAumsIx3o3kqzODv8ILayyTwO32aiP3UAo27e8hcU_xTkc",
    *         ),
    *         @OA\Property(
    *           property="os_type_cd",
    *           description="OS 구분(AA : 안드로이드, IA : iOS)",
    *    		type="string",
    *    		default="AA",
    *    		description="기본",
    *         ),
    *       ),
    *     ),
    *   ),
     *
     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK : 전송 성공"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

     public function fcmTokenAdd()
     {
        helper(['form']);
        
        $this->rules = [
            'member_code'      => 'required',
            'device_token_id'  => 'required',
            'os_type_cd'       => 'required'
        ];

        if($this->checkValidation()) {

                $membersApppush = new MembersApppush();
                $membersApppush->member_code = $this->request->getVar('member_code');
                $membersApppush->device_token_id = $this->request->getVar('device_token_id');
                $membersApppush->os_type_cd = $this->request->getVar('os_type_cd');

                $tokenchk = $this->membersApppushModel->getApppushCount($membersApppush->member_code, $membersApppush->device_token_id);

                //var_dump ($tokenchk);
                //exit;

            if ($tokenchk == 0) {

                    $insertId = $this->membersApppushModel->save($membersApppush);

                    if($insertId){
                        $responseData["status"] = '2001';
                        $responseData["message"] = "OK : 푸시 토큰이 등록되었습니다.";
                        echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

                    }else{
                        $responseData["status"] = '4001';
                        $responseData["message"] = "Error : 입력 값 문제";
                        echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
                    }

                }else{
                    $responseData["status"] = '4011';
                    $responseData["message"] = "Error : 동일한 푸시 토큰이 있습니다.";
                    echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
                }

        }else{
            $responseData["status"] = '4000';
            $responseData["message"] = "Error : 입력 값 오류";
            echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
        }


    }


     /**
	 * @OA\Post(path="/api/fcmActive", tags={"앱 푸시 API"},
         *   description="<b>푸시알림 체크</b><p>
    <b>[Parameters]</b><br>
    member_code : 교적번호<br>
    device_token_id : FCM 앱토큰<br>
    active_flg : 푸시알림 체크(ON : 1, OFF : 0)<br>
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="application/json",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="member_code",
    *           description="교적번호",
    *    		type="string",
    *    		default="20030185",
    *         ),
    *         @OA\Property(
    *           property="device_token_id",
    *           description="FCM 앱토큰",
    *    		type="string",
    *           default="chXd92JN-EyLk9I8VZV_OW:APA91bGns91gqxTnRi_CTvHG2y6-zBe1m06EOEt7P6EqlrYozlBbb9DGUWrRgsKlj8IS1mr_MSCsifDbePkv7gYfqtVfIlhj4YZufqhSgg0N2hfgfglGFmlyCJxzLhGT-Wd--VnfrhdD",
    *         ),
    *         @OA\Property(
    *           property="active_flg",
    *           description="푸시알림 체크(ON : 1, OFF : 0)",
    *    		type="string",
    *    		default="1",
    *    		description="기본",
    *         ),
    *       ),
    *     ),
    *   ),
     *
     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK : 전송 성공"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

     public function fcmActive()
     {
        helper(['form']);
        
        $this->rules = [
            'member_code'      => 'required',
            'device_token_id'  => 'required',
            'active_flg'       => 'required'
        ];

        if($this->checkValidation()) {

                $member_code = $this->request->getVar('member_code');
                $device_token_id = $this->request->getVar('device_token_id');
                $active_flg = $this->request->getVar('active_flg');


                $this->membersApppushModel->updateActive($member_code, $device_token_id, $active_flg);

                
                // if($insertId){
                    $responseData["status"] = '2001';
                    $responseData["message"] = "OK : 푸시 알림이 변경되었습니다.";
                    echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

                /*
                }else{
                    $responseData["status"] = '4001';
                    $responseData["message"] = "Error : 입력 값 문제";
                    echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
                }
                */

        }else{
            $responseData["status"] = '4000';
            $responseData["message"] = "Error : 입력 값 오류";
            echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
        }

    }

    /**
	 * @OA\Post(path="/api/sendFcmMessage", tags={"앱 푸시 API"},
         *   description="<b>앱 푸시 메시지 전송</b><p>
    <b>[Parameters]</b><br>
    token_id : FCM 앱토큰<br>
    body_doc : FCM 메시지 내용
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="application/json",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="token_id",
    *           description="FCM 앱토큰",
    *    		type="string",
    *           default="d7ko7pr87EdOvDNyoZmVxu:APA91bG7LfLMZY7Ncwe_AyO0g5nTYnMUqCKUHpX0QNkOwKAVRPwHBb7_DGAWXknt6xOEzFRjn1bJzcVHc1TwSXgJcUKEu2nV-PeSPZgh1PXdMKpqmlDfclG0aAZqp1BTy5an4Kl-gI3A",
    *         ),
    *         @OA\Property(
    *           property="body_doc",
    *           description="FCM 메시지 내용",
    *           type="string",
    *  			default="영은카테고리2 앱 푸시가 성공적으로 발송되었습니다.",
    *         ),

    *       ),
    *     ),
    *   ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK : 전송 성공"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

    public function sendFcmMessage()
    {

        helper(['form']);
        
        $this->rules = [
            'token_id'  => 'required',
            'body_doc'  => 'required',
        ];

        if($this->checkValidation()) {

            $token_id = $this->request->getVar('token_id');
            $body_doc = $this->request->getVar('body_doc');
            $SERVER_API_KEY = 'AAAAhLQs4r0:APA91bGZhDCdlExc2My2L8xx-DnvnYZmliBQh7x4KoEZ3FTsBVNcPDSMyMWjTABP8GwjsiTMhMuIDFKPhLcg1YeZILkFG3mWKBBav0eW82oCcOFcWqadz07sMITxoe5O0pQ28dE7Q1dt';

            $title = "앱 푸시 테스트 전송";
            $subtitle = "앱 푸시 서브 타이틀";
            // $body = "영은카테고리2 앱 푸시가 성공적으로 발송되었습니다.";
            $body = $body_doc;
            $sound = "default";

            $image = "http://youngeun.or.kr/UserData/youngeun/Layouts/youngeun2022_Layout/Images/top_logo_B.png";
            $link = "http://youngeun.or.kr";
         
            $data = [
                "notification" => [
                    "title" => $title,
                    "subtitle" => $subtitle,
                    "body"  => $body,
                    "sound" => $sound
                ],
                "priority" =>  "high",
                "data" => [
                    
                    "click_action"  =>  "FLUTTER_NOTIFICATION_CLICK",
                    "id"            =>  "1",
                    "status"        =>  "done",
                    "info"          =>  [
                        "title"  => $title,
                        "link"   => $link,
                        "image"  => $image
                    ]

                ],
                "to" => $token_id
            ];
        
            $ch = curl_init();
        
            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            curl_setopt($ch, CURLOPT_POST, 1);
        
            $headers = array();
            $headers[] = 'Content-Type: application/json';
            $headers[] = 'Authorization: key='.$SERVER_API_KEY;
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        
            $response = curl_exec($ch);
            curl_close ($ch);
            
            return $response;

/*
            $message = [
                "title" => "PUSH TEST",
                "message" => "FCM 메시지 테스트 전송하고 있습니다."
            ];

            $SERVER_API_KEY = 'AAAAhLQs4r0:APA91bGZhDCdlExc2My2L8xx-DnvnYZmliBQh7x4KoEZ3FTsBVNcPDSMyMWjTABP8GwjsiTMhMuIDFKPhLcg1YeZILkFG3mWKBBav0eW82oCcOFcWqadz07sMITxoe5O0pQ28dE7Q1dt';
            $data = [
                "to" => $token_id,
                "data" => $message
            ];

            $dataString = json_encode($data,JSON_UNESCAPED_UNICODE);
        
            $headers = [
                'Authorization: key=' . $SERVER_API_KEY,
                'Content-Type: application/json',
            ];
        
            $ch = curl_init();
        
            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
                
            $response = curl_exec($ch);
            if ($response === FALSE) {
                die('Curl failed: ' . curl_error($ch));
            }
            curl_close($ch);
        
            return $response;
*/

        } else {
            $responseData["status"] = '4000';
            $responseData["message"] = "Error : 입력 값 오류";
            echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
        }

    }


     /**
	 * @OA\Get(path="/api/appTokenLive", tags={"앱 푸시 API"},
     *   description="<b>App토큰체커</b><p>
     <b>[Parameters]</b><br>
     member_code : 교적번호(헤더의 토큰에서 추출)<p>
     ",
     *  security={{ "apiAuth": {} }},
     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "ok"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

     public function appTokenLive()
     {

    $key = getenv('TOKEN_SECRET');
    $header = $this->request->getServer('HTTP_AUTHORIZATION');
    if(!$header) return $this->failUnauthorized('Token Required');
    $token = explode(' ', $header)[1];

        try {
    
            $decoded = JWT::decode($token, new Key($key, 'HS256'));

        //var_dump($decoded);
        //exit;

            $response = [
                'member_id' => $decoded->uid,
                'member_code' => $decoded->code,
                'handphone' => $decoded->handphone
            ];

            $responseData["status"] = '2001';
            $responseData["message"] = "OK : 앱 토큰이 있습니다.";
            $responseData["memberInfo"] = $response;
            echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

        } catch (\Throwable $th) {

            $responseData["status"] = '4005';
            $responseData["message"] = "Error : 앱 토큰이 없습니다.";
            echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

        }
    
    }

     
    /**
    * @OA\Post(path="/api/kakaotalk_api", tags={"카톡  & 문자  전송 API"},
     *   description="<b>Kakaotalk 송신 API</b><p>
    <b>[Parameters]</b><br>
    member_code : 회원코드<br>
    password : 비밀번호<br>
    handphone : 핸드폰번호<br>
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="application/json",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="member_code",
    *           description="Member Code",
    *           type="string",
    *  			default="20030185",
    *         ),
    *         @OA\Property(
    *           property="password",
    *           description="User Password",
    *           type="string",
    *  			default="D9pD2gZvqY",
    *         ),
    *         @OA\Property(
    *           property="handphone",
    *           description="User Handphone",
    *           type="string",
    *  			default="010-9028-7124",
    *         ),
    *       ),
    *     ),
    *   ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK : 카톡전송 성공"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */


     public function kakaotalk_api()
     {
 
         $this->rules = [
             'member_code' => 'required',
             'password' => 'required'
         ];
 
         if( $this->checkValidation() ){
             $member_code = $this->request->getVar('member_code');
             $password = $this->request->getVar('password');
             $handphone  = $this->request->getVar('handphone');
 
             if($account = $this->memberModel->checkCodeLogin($member_code, $password)){
                 $account->last_login_date = DateHelper::now();
                 $this->memberModel->save($account);
                 $account->remember = isset($remember) ? 1 : 0;
                 AuthHelpers::setLoginGuest($account->toSession());
                 if($account->remember == REMEMBER_FLG_ON){
                     AuthHelpers::setCookieLoginGuest($account,$this->redirectResponse);
                 }
 
                 $data = [
                     'member_code'   => $this->request->getVar('member_code'),
                     'password'   => $this->request->getVar('password'),
                     'handphone'   => $this->request->getVar('handphone')
                     ];
         
                    // var_dump($data);
                    // echo "There is a Test.";
                    // exit;
         
           /* 
           -----------------------------------------------------------------------------------
           알림톡 전송
           -----------------------------------------------------------------------------------
           버튼의 경우 템플릿에 버튼이 있을때만 버튼 파라메더를 입력하셔야 합니다.
           버튼이 없는 템플릿인 경우 버튼 파라메더를 제외하시기 바랍니다.
           */
         
           $_apiURL    =	'https://kakaoapi.aligo.in/akv10/alimtalk/send/';
           $_hostInfo  =	parse_url($_apiURL);
           $_port      =	(strtolower($_hostInfo['scheme']) == 'https') ? 443 : 80;
           $_variables =	array(
             'apikey'      => '5iomz2bals7kofy7siiynx33sxo5nxtp', 
             'userid'      => 'pixel25', 
             'token'       => '19196da9e6d344cd5225d944f2037ee00a2d3692d742de7c09981762d5c883b065f441580d8213b70240b3f22544c682f36c9edaf9726e29fb1aaaee2659433bXWmWH5KuHjTtSu93xlWYSxJSuzuCSXz+QwxcEa0TQYPAoX7Qm3Lyqy/QtAPmtnRbacImzKWaXyrbAKG8O8DNWA==', 
             'senderkey'   => '6c781a72571a29a7b56ac6eb4d2cc2017e7c0963', 
             'tpl_code'    => 'TK_5792',
             'sender'      => '010-9028-7124',
             'recvname_1'  => '성도님',
             'subject_1'   => '알림정보 전송',
            );
 
            $membername = "영은카테고리2";
            $memberid = $member_code;
 
            // var_dump($memberid);
            // exit;
 
           $_variables["message_1"] = "안녕하세요. ".$membername."입니다.
 요청하신 저희 ".$membername."의 알림정보 입니다.
 
 아래 내용을 누르고 버튼을 선택,
 주문하시면 됩니다.
 감사합니다.";
 
           $_variables["receiver_1"] = $handphone;
           $_variables["button_1"] = "{\"button\":[{\"name\":\"주문하기\",\"linkType\":\"WL\",\"linkP\":\"http://talk.mediain.co.kr/sale?memberid=".$memberid."&phone=".$handphone."\", \"linkM\": \"http://talk.mediain.co.kr/sale?memberid=".$memberid."&phone=".$handphone."\"}]}";
         
           $oCurl = curl_init();
           curl_setopt($oCurl, CURLOPT_PORT, $_port);
           curl_setopt($oCurl, CURLOPT_URL, $_apiURL);
           curl_setopt($oCurl, CURLOPT_POST, 1);
           curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
           curl_setopt($oCurl, CURLOPT_POSTFIELDS, http_build_query($_variables));
           curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, FALSE);
         
           $ret = curl_exec($oCurl);
           $error_msg = curl_error($oCurl);
           curl_close($oCurl);
         
           // 리턴 JSON 문자열 확인
           //print_r($ret . PHP_EOL);
         
           // JSON 문자열 배열 변환
           //$retArr = json_decode($ret);
         
           // 결과값 출력
           //print_r($retArr);
         
           /*
           code : 0 성공, 나머지 숫자는 에러
           message : 결과 메시지
           */
         
                    $responseData["data"] = $data;
                    $responseData["kakaolog"] = json_decode($ret);
                    $responseData["status"] = '2001';
                    $responseData["message"] = "OK : 카톡전송 성공";
                
             echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
 
 
             }else{
                 $responseData["status"] = '4002';
                 $responseData["message"] = "Error : 회원정보 불일치";
                 echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
             }
         }else{
             $responseData["status"] = '4001';
             $responseData["message"] = "Error : 입력 값 문제";
             echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
         }
 
 
     }


    /**
    * @OA\Post(path="/api/sms_api", tags={"카톡  & 문자  전송 API"},
     *   description="<b>Kakaotalk 송신 API</b><p>
    <b>[Parameters]</b><br>
    member_code : 회원코드<br>
    password : 비밀번호<br>
    handphone : 핸드폰번호<br>
     ",
    *   @OA\RequestBody(
    *     required=true,
    *     @OA\MediaType(
    *       mediaType="application/json",
    *       @OA\Schema(
    *         @OA\Property(
    *           property="member_code",
    *           description="Member Code",
    *           type="string",
    *  			default="20030185",
    *         ),
    *         @OA\Property(
    *           property="password",
    *           description="User Password",
    *           type="string",
    *  			default="D9pD2gZvqY",
    *         ),
    *         @OA\Property(
    *           property="handphone",
    *           description="User Handphone",
    *           type="string",
    *  			default="010-9028-7124",
    *         ),
    *       ),
    *     ),
    *   ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="Success",
     *         content={
     *             @OA\MediaType(
     *                 mediaType="application/json",
     *                 @OA\Schema(
     *                     @OA\Property(
     *                         property="Status",
     *                         type="integer",
     *                         description="응답 받은 코드"
     *                     ),
     *                     @OA\Property(
     *                         property="Message",
     *                         type="string",
     *                         description="응답 받은 메시지"
     *                     ),
     *                     example={
     *                           "status":  "2001",
     *                           "message": "OK : 문자전송 성공"
     *                     }
     *                 )
     *             )
     *         }
     *     ),
     * @OA\Response(response="201", description="Created"),
     * @OA\Response(response="401", description="Unauthorized"),
     * @OA\Response(response="403", description="Forbidden"),
     * @OA\Response(response="404", description="Not Found"),
     *
	 * )
	 */

     public function sms_api()
     {

                     $this->rules = [
                        'member_code' => 'required',
                        'password' => 'required'
                    ];
            
                    if( $this->checkValidation() ){
                        $member_code = $this->request->getVar('member_code');
                        $password = $this->request->getVar('password');
                        $handphone  = $this->request->getVar('handphone');
            
                        if($account = $this->memberModel->checkCodeLogin($member_code, $password)){
                            $account->last_login_date = DateHelper::now();
                            $this->memberModel->save($account);
                            $account->remember = isset($remember) ? 1 : 0;
                            AuthHelpers::setLoginGuest($account->toSession());
                            if($account->remember == REMEMBER_FLG_ON){
                                AuthHelpers::setCookieLoginGuest($account,$this->redirectResponse);
                            }
            
                            $data = [
                                'member_code'   => $this->request->getVar('member_code'),
                                'password'   => $this->request->getVar('password'),
                                'handphone'   => $this->request->getVar('handphone')
                                ];

            /**************** 문자전송하기 예제 필독항목 ******************/
        /* 동일내용의 문자내용을 다수에게 동시 전송하실 수 있습니다
        /* 대량전송시에는 반드시 컴마분기하여 1천건씩 설정 후 이용하시기 바랍니다. (1건씩 반복하여 전송하시면 초당 10~20건정도 발송되며 컨텍팅이 지연될 수 있습니다.)
        /* 전화번호별 내용이 각각 다른 문자를 다수에게 보내실 경우에는 send 가 아닌 send_mass(예제:curl_send_mass.html)를 이용하시기 바랍니다.

        /****************** 인증정보 시작 ******************/
        $sms_url = "https://apis.aligo.in/send/"; // 전송요청 URL
        $sms['user_id'] = "chipdirect"; // SMS 아이디
        $sms['key'] = "5iomz2bals7kofy7siiynx33sxo5nxtp";//인증키
        /****************** 인증정보 끝 ********************/

        /****************** 전송정보 설정시작 ****************/
        $_POST['msg'] = '%고객명%님. 안녕하세요. API TEST SEND'; // 메세지 내용 : euc-kr로 치환이 가능한 문자열만 사용하실 수 있습니다. (이모지 사용불가능)
        // $_POST['receiver'] = '01090287124,01111111112'; // 수신번호
        // $_POST['destination'] = '01090287124|담당자,01111111112|홍길동'; // 수신인 %고객명% 치환
        $_POST['receiver'] = '01090287124'; // 수신번호
        $_POST['destination'] = '01090287124|정경연'; // 수신인 %고객명% 치환
        $_POST['sender'] ="02-2676-7171"; // 발신번호
        $_POST['rdate'] = ''; // 예약일자 - 20161004 : 2016-10-04일기준
        $_POST['rtime'] = ''; // 예약시간 - 1930 : 오후 7시30분
        $_POST['testmode_yn'] = 'N'; // Y 인경우 실제문자 전송X , 자동취소(환불) 처리
        $_POST['subject'] = '테스트 발송'; //  LMS, MMS 제목 (미입력시 본문중 44Byte 또는 엔터 구분자 첫라인)
        // $_POST['image'] = '/tmp/pic_57f358af08cf7_sms_.jpg'; // MMS 이미지 파일 위치 (저장된 경로)
        $_POST['msg_type'] = 'SMS'; //  SMS, LMS, MMS등 메세지 타입을 지정
        // ※ msg_type 미지정시 글자수/그림유무가 판단되어 자동변환됩니다. 단, 개행문자/특수문자등이 2Byte로 처리되어 SMS 가 LMS로 처리될 가능성이 존재하므로 반드시 msg_type을 지정하여 사용하시기 바랍니다.
        /****************** 전송정보 설정끝 ***************/

        $sms['msg'] = stripslashes($_POST['msg']);
        $sms['receiver'] = $_POST['receiver'];
        $sms['destination'] = $_POST['destination'];
        $sms['sender'] = $_POST['sender'];
        $sms['rdate'] = $_POST['rdate'];
        $sms['rtime'] = $_POST['rtime'];
        $sms['testmode_yn'] = empty($_POST['testmode_yn']) ? '' : $_POST['testmode_yn'];
        $sms['title'] = $_POST['subject'];
        $sms['msg_type'] = $_POST['msg_type'];
        // 만일 $_FILES 로 직접 Request POST된 파일을 사용하시는 경우 move_uploaded_file 로 저장 후 저장된 경로를 사용하셔야 합니다.
        if(!empty($_FILES['image']['tmp_name'])) {
            $tmp_filetype = mime_content_type($_FILES['image']['tmp_name']); 
            if($tmp_filetype != 'image/png' && $tmp_filetype != 'image/jpg' && $tmp_filetype != 'image/jpeg') $_POST['image'] = '';
            else {
                $_savePath = "./".uniqid(); // PHP의 권한이 허용된 디렉토리를 지정
                if(move_uploaded_file($_FILES['file']['tmp_name'], $_savePath)) {
                    $_POST['image'] = $_savePath;
                }
            }
        }
        // 이미지 전송 설정
        if(!empty($_POST['image'])) {
            if(file_exists($_POST['image'])) {
                $tmpFile = explode('/',$_POST['image']);
                $str_filename = $tmpFile[sizeof($tmpFile)-1];
                $tmp_filetype = mime_content_type($_POST['image']);
                if ((version_compare(PHP_VERSION, '5.5') >= 0)) { // PHP 5.5버전 이상부터 적용
                    $sms['image'] = new CURLFile($_POST['image'], $tmp_filetype, $str_filename);
                    curl_setopt($oCurl, CURLOPT_SAFE_UPLOAD, true);
                } else {
                    $sms['image'] = '@'.$_POST['image'].';filename='.$str_filename. ';type='.$tmp_filetype;
                }
            }
        }
        /*****/
        $host_info = explode("/", $sms_url);
        $port = $host_info[0] == 'https:' ? 443 : 80;

        $oCurl = curl_init();
        curl_setopt($oCurl, CURLOPT_PORT, $port);
        curl_setopt($oCurl, CURLOPT_URL, $sms_url);
        curl_setopt($oCurl, CURLOPT_POST, 1);
        curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sms);
        curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, FALSE);
        $ret = curl_exec($oCurl);
        curl_close($oCurl);

        //echo $ret;
        //$retArr = json_decode($ret); // 결과배열

        //print_r($retArr); // Response 출력 (연동작업시 확인용)

        /**** Response 항목 안내 ****
        // result_code : 전송성공유무 (성공:1 / 실패: -100 부터 -999)
        // message : success (성공시) / reserved (예약성공시) / 그외 (실패상세사유가 포함됩니다)
        // msg_id : 메세지 고유ID = 고유값을 반드시 기록해 놓으셔야 sms_list API를 통해 전화번호별 성공/실패 유무를 확인하실 수 있습니다
        // error_cnt : 에러갯수 = receiver 에 포함된 전화번호중 문자전송이 실패한 갯수
        // success_cnt : 성공갯수 = 이동통신사에 전송요청된 갯수
        // msg_type : 전송된 메세지 타입 = SMS / LMS / MMS (보내신 타입과 다른경우 로그로 기록하여 확인하셔야 합니다)
        /**** Response 예문 끝 ****/

    //$responseData["data"] = $data;

    $responseData["smslog"] = json_decode($ret);
    $responseData["status"] = '2001';
    $responseData["message"] = "OK : 문자전송 성공";

    echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

    } else {
    $responseData["status"] = '4002';
    $responseData["message"] = "Error : 회원정보 불일치";
    echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
    }

    } else {
    $responseData["status"] = '4001';
    $responseData["message"] = "Error : 입력 값 문제";
    echo json_encode($responseData, JSON_UNESCAPED_UNICODE);
    }


    }

 
}
