<?php namespace App\Controllers\Guest\Auth;

use App\Controllers\Guest\BaseController;
use App\Entities\Member;
use App\Helpers\ArrayHelper;
use App\Helpers\AuthHelpers;
use App\Helpers\Common\EmailHelper;
use App\Helpers\DateHelper;
use App\Helpers\NumberHelper;
use App\Models\MemberModel;
use Config\Services;

class LoginController extends BaseController
{

    protected $memberModel;
    protected $emailHelper;

    public function __construct()
    {
        $this->memberModel = new MemberModel();
        $this->emailHelper = new EmailHelper();
    }

    public function validationMapFieldLabels()
    {
        return [
            'member_email' => '아이디(E-Mail)',
            'password' => '비번번호'
        ];
    }

    public function index(){
        $this->rules = [
            'member_email' => 'required',
            'password' => 'required'
        ];
        //Set Back url login page
        $refererUrl = $_SERVER['HTTP_REFERER'];
        if(!strpos($refererUrl, 'login')){
            AuthHelpers::getSession()->set(AuthHelpers::BACK_URL_LOGIN,$refererUrl);
        }

        // echo $refererUrl;
        return $this->viewGuest('auth/login');
    }

    public function login(){
        $this->rules = [
            'member_email' => 'required',
            'password' => 'required'
        ];
        if( $this->checkValidation() ){
            $email = $this->request->getVar('member_email');
            $password = $this->request->getVar('password');
            $remember = $this->request->getVar('remember');
            if($account = $this->memberModel->checkLogin($email, $password)){
                $account->last_login_date = DateHelper::now();
                $this->memberModel->save($account);
                $account->remember = isset($remember) ? 1 : 0;
                AuthHelpers::setLoginGuest($account->toSession());
                if($account->remember == REMEMBER_FLG_ON){
                    AuthHelpers::setCookieLoginGuest($account,$this->redirectResponse);
                }
                $refererUrl =  AuthHelpers::getSession()->get(AuthHelpers::BACK_URL_LOGIN);
                $arrayNotBack = ['forgot-password', 'login', 'register'];
                if(ArrayHelper::searchValueContainArray($refererUrl,$arrayNotBack) === false ){
                    AuthHelpers::getSession()->remove(AuthHelpers::BACK_URL_LOGIN);
                    return redirect()->to($refererUrl);
                }
                return redirect()->route('guest.home')->withInput();
            }else{
                $refererUrl = $_SERVER['HTTP_REFERER'];
                session()->setFlashdata('status_text', '아이디와 비밀번호가 일치하지 않습니다.');
                return redirect()->to($refererUrl)
                    ->with('status_icon', 'warning')
                    ->with('status', '회원정보를 확인하세요.');
            }
        }else{
            return redirect('guest.login')->withInput();
        }
    }

    public function loginCatall(){
        $this->rules = [
            'member_email' => 'required',
            'password' => 'required'
        ];
        if( $this->checkValidation() ){
            $email = $this->request->getVar('member_email');
            $password = $this->request->getVar('password');
            $remember = $this->request->getVar('remember');

            if($account = $this->memberModel->checkLogin($email, $password)){
                $account->last_login_date = DateHelper::now();
                $this->memberModel->save($account);
                $account->remember = isset($remember) ? 1 : 0;
                AuthHelpers::setLoginGuest($account->toSession());
                if($account->remember == REMEMBER_FLG_ON){
                    AuthHelpers::setCookieLoginGuest($account,$this->redirectResponse);
                }
                return redirect()->route('guest.cart')->withInput();
            }else{
                return redirect()->route('guest.cart')->withInput();
                /*
                $refererUrl = $_SERVER['HTTP_REFERER'];
                session()->setFlashdata('status_text', '아이디와 비밀번호가 일치하지 않습니다.');
                return redirect()->to($refererUrl)
                    ->with('status_icon', 'warning')
                    ->with('status', '회원정보를 확인하세요.');
                */
            }
        }else{
            return redirect('guest.login')->withInput();
        }
    }

    public function loginCat(){
        $this->rules = [
            'member_email' => 'required',
            'password' => 'required'
        ];
        if( $this->checkValidation() ){
            $email = $this->request->getVar('member_email');
            $password = $this->request->getVar('password');
            $remember = $this->request->getVar('remember');
            if($account = $this->memberModel->checkLogin($email, $password)){
                $account->last_login_date = DateHelper::now();
                $this->memberModel->save($account);
                $account->remember = isset($remember) ? 1 : 0;
                AuthHelpers::setLoginGuest($account->toSession());
                if($account->remember == REMEMBER_FLG_ON){
                    AuthHelpers::setCookieLoginGuest($account,$this->redirectResponse);
                }
                return redirect()->route('guest.cart.sheet')->withInput();
            }else{
                $refererUrl = $_SERVER['HTTP_REFERER'];
                session()->setFlashdata('status_text', '아이디와 비밀번호가 일치하지 않습니다.');
                return redirect()->to($refererUrl)
                    ->with('status_icon', 'warning')
                    ->with('status', '회원정보를 확인하세요.');
            }
        }else{
            return redirect('guest.login')->withInput();
        }
    }


    public function loginBuynow(){
        $this->rules = [
            'member_email' => 'required',
            'password' => 'required'
        ];
        if( $this->checkValidation() ){
            $email = $this->request->getVar('member_email');
            $password = $this->request->getVar('password');
            $remember = $this->request->getVar('remember');
            if($account = $this->memberModel->checkLogin($email, $password)){
                $account->last_login_date = DateHelper::now();
                $this->memberModel->save($account);
                $account->remember = isset($remember) ? 1 : 0;
                AuthHelpers::setLoginGuest($account->toSession());
                if($account->remember == REMEMBER_FLG_ON){
                    AuthHelpers::setCookieLoginGuest($account,$this->redirectResponse);
                }
                return redirect()->route('guest.cart.buynow')->withInput();
            }else{
                $refererUrl = $_SERVER['HTTP_REFERER'];
                session()->setFlashdata('status_text', '아이디와 비밀번호가 일치하지 않습니다.');
                return redirect()->to($refererUrl)
                    ->with('status_icon', 'warning')
                    ->with('status', '회원정보를 확인하세요.');
            }
        }else{
            return redirect('guest.login')->withInput();
        }
    }

    public function loginEstimate(){
        $this->rules = [
            'member_email' => 'required',
            'password' => 'required'
        ];
        if( $this->checkValidation() ){
            $email = $this->request->getVar('member_email');
            $password = $this->request->getVar('password');
            $remember = $this->request->getVar('remember');
            if($account = $this->memberModel->checkLogin($email, $password)){
                $account->last_login_date = DateHelper::now();
                $this->memberModel->save($account);
                $account->remember = isset($remember) ? 1 : 0;
                AuthHelpers::setLoginGuest($account->toSession());
                if($account->remember == REMEMBER_FLG_ON){
                    AuthHelpers::setCookieLoginGuest($account,$this->redirectResponse);
                }
                return redirect()->route('guest.estimate.create')->withInput();
            }else{
                $refererUrl = $_SERVER['HTTP_REFERER'];
                session()->setFlashdata('status_text', '아이디와 비밀번호가 일치하지 않습니다.');
                return redirect()->to($refererUrl)
                    ->with('status_icon', 'warning')
                    ->with('status', '회원정보를 확인하세요.');
            }
        }else{
            return redirect('guest.login')->withInput();
        }
    }


    public function logout(){
        AuthHelpers::clearLoginGuest($this->redirectResponse);
        return redirect()->route('guest.login')->withInput();
    }

    public function showForgotPassword(){
        $this->rules = [
            'member_email' => 'required|valid_email',
        ];
        return $this->viewGuest('auth/forgot_password');
    }

    public function sendForgotPassword(){

        $this->rules = [
            'member_email' => 'required|valid_email',
        ];

        if( $this->checkValidation() ){
            $member_email =  $this->request->getVar('member_email');
            $member = $this->memberModel->findByEmail($member_email );

            $handphone = $member->member_phone;
            $member_name = $member->member_name;

        $email = \Config\Services::email();
        
        $config['protocol'] = 'html';
        $config['mailPath'] = '/usr/sbin/sendmail -t -i';
        $config['fromEmail'] = 'chipdirectmall@gmail.com';
        $config['fromName'] = 'ChipDirect';

        $pass = $digitsRandom = NumberHelper::generateRandom();
        $passMd5 = md5($pass);
        $member->password = $passMd5;
        $this->memberModel->save($member);

        $email->initialize($config);
        $email->setFrom('chip@selpasemicom.com', 'ChipDirect');
        $email->setTo($member_email);
        $email->setSubject('[비밀번호 발급] 임시 비밀번호를 전송했습니다.');
        $email->setMessage('새 비밀번호가 발급되었습니다.<br>로그인 후 비밀번호를 변경해 사용하세요.<br>임시 비밀번호 : '. $pass);


        /****************** 메시지 시작 ******************/
        $content = "\n임시 비밀번호[ $pass ]가 발급되었습니다. 로그인 후 변경하세요.";

        if ($handphone) {
            $receiver_name = $member_name;
            $receiver_phone = str_replace('-','',$handphone);
    
            /****************** 인증정보 시작 ******************/
            $sms_url = "https://apis.aligo.in/send/"; // 전송요청 URL
            $sms['user_id'] = "chipdirect"; // SMS 아이디
            $sms['key'] = "5iomz2bals7kofy7siiynx33sxo5nxtp";//인증키
            /****************** 인증정보 끝 ********************/
            /****************** 전송정보 설정시작 ****************/
            $_POST['msg'] = '%고객명% '.$member_name.'님. '.$content; // 메세지 내용 : euc-kr로 치환이 가능한 문자열만 사용하실 수 있습니다. (이모지 사용불가능)
            $_POST['receiver'] = $receiver_phone; // 수신번호
            $_POST['destination'] = $receiver_phone.'|'.$receiver_name; // 수신인 %고객명% 치환
            $_POST['sender'] =""; // 발신번호
            $_POST['rdate'] = ''; // 예약일자 - 20161004 : 2016-10-04일기준
            $_POST['rtime'] = ''; // 예약시간 - 1930 : 오후 7시30분
            $_POST['testmode_yn'] = 'N'; // Y 인경우 실제문자 전송X , 자동취소(환불) 처리
            $_POST['subject'] = '테스트 발송'; //  LMS, MMS 제목 (미입력시 본문중 44Byte 또는 엔터 구분자 첫라인)
            // $_POST['image'] = '/tmp/pic_57f358af08cf7_sms_.jpg'; // MMS 이미지 파일 위치 (저장된 경로)
            $_POST['msg_type'] = 'SMS'; //  SMS, LMS, MMS등 메세지 타입을 지정
            // ※ msg_type 미지정시 글자수/그림유무가 판단되어 자동변환됩니다. 단, 개행문자/특수문자등이 2Byte로 처리되어 SMS 가 LMS로 처리될 가능성이 존재하므로 반드시 msg_type을 지정하여 사용하시기 바랍니다.
            /****************** 전송정보 설정끝 ***************/
            $sms['msg'] = stripslashes($_POST['msg']);
            $sms['receiver'] = $_POST['receiver'];
            $sms['destination'] = $_POST['destination'];
            $sms['sender'] = $_POST['sender'];
            $sms['rdate'] = $_POST['rdate'];
            $sms['rtime'] = $_POST['rtime'];
            $sms['testmode_yn'] = empty($_POST['testmode_yn']) ? '' : $_POST['testmode_yn'];
            $sms['title'] = $_POST['subject'];
            $sms['msg_type'] = $_POST['msg_type'];
            // 만일 $_FILES 로 직접 Request POST된 파일을 사용하시는 경우 move_uploaded_file 로 저장 후 저장된 경로를 사용하셔야 합니다.
            if(!empty($_FILES['image']['tmp_name'])) {
                $tmp_filetype = mime_content_type($_FILES['image']['tmp_name']); 
                if($tmp_filetype != 'image/png' && $tmp_filetype != 'image/jpg' && $tmp_filetype != 'image/jpeg') $_POST['image'] = '';
                else {
                    $_savePath = "./".uniqid(); // PHP의 권한이 허용된 디렉토리를 지정
                    if(move_uploaded_file($_FILES['file']['tmp_name'], $_savePath)) {
                        $_POST['image'] = $_savePath;
                    }
                }
            }
            // 이미지 전송 설정
            if(!empty($_POST['image'])) {
                if(file_exists($_POST['image'])) {
                    $tmpFile = explode('/',$_POST['image']);
                    $str_filename = $tmpFile[sizeof($tmpFile)-1];
                    $tmp_filetype = mime_content_type($_POST['image']);
                    if ((version_compare(PHP_VERSION, '5.5') >= 0)) { // PHP 5.5버전 이상부터 적용
                        $sms['image'] = new CURLFile($_POST['image'], $tmp_filetype, $str_filename);
                        curl_setopt($oCurl, CURLOPT_SAFE_UPLOAD, true);
                    } else {
                        $sms['image'] = '@'.$_POST['image'].';filename='.$str_filename. ';type='.$tmp_filetype;
                    }
                }
            }
            /*****/
            $host_info = explode("/", $sms_url);
            $port = $host_info[0] == 'https:' ? 443 : 80;
            $oCurl = curl_init();
            curl_setopt($oCurl, CURLOPT_PORT, $port);
            curl_setopt($oCurl, CURLOPT_URL, $sms_url);
            curl_setopt($oCurl, CURLOPT_POST, 1);
            curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sms);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, FALSE);
            $ret = curl_exec($oCurl);
            curl_close($oCurl);
            $responseData["smslog"] = json_decode($ret);
        }
        /****************** 메시지 끝 ******************/


        if($email->send(false)){
            $data['message'] = '임시 비밀번호를 회원님의 이메일(ID)과 문자로 전달했습니다. 확인하십시오.';
            return $this->viewGuest('auth/forgot_send_mail_success',$data);
            	
        }else{
            echo "이메일 전송에 문제가 있습니다.";
        }

        }

        return $this->viewGuest('auth/forgot_password');
    }
}
