<?php namespace App\Controllers\Guest\Auth;

use App\Controllers\Guest\BaseController;
use App\Entities\Member;
use App\Entities\MemberGet;
use App\Entities\MemberSub;
use App\Entities\MemberFile;
use App\Helpers\Common\EmailHelper;
use App\Helpers\NumberHelper;
use App\Models\MemberModel;
use App\Models\MemberSubModel;
use App\Helpers\FileHelper;
use App\Models\MemberFileModel;



class RegisterController extends BaseController
{

    protected $memberModel;
    protected $memberSubModel;
    protected $memberFileModel;
    protected $emailHelper;

    public function __construct()
    {
        $this->memberModel = new MemberModel();
        $this->memberSubModel = new MemberSubModel();
        $this->memberFileModel = new MemberFileModel();
        $this->emailHelper = new EmailHelper();
    }

    public function validationMapFieldLabels()
    {
        return [
            'member_name' => lang_register('name'),
            'member_email' => lang_register('email'),
            'password' => lang_register('password'),
            'pass_confirm' => lang_register('confirm_password')
        ];
    }

    public function index()
    {
        return $this->viewGuest('auth/register_type', $data);
    }

    public function showCreate(){
        $api_type = $this->request->getPost('api_type');
        $category_id = $this->request->getPost('category_id');
        //var_dump($category_id);
        //exit;

        $this->rules = $this->memberModel->getValidationRules();
        $data['maxFiles'] = 3;
        $data['memCategory'] = $category_id;
        $data['member_name'] = $this->request->getPost('member_name');
        $data['member_email'] = $this->request->getPost('member_email');
        $data['member_phone'] = $this->request->getPost('member_phone');
        $data['api_type'] = $this->request->getPost('api_type');
        

        $member_phone = $this->request->getPost('member_phone');
        
        if($member_phone){

            $certification = mt_rand(100000, 999999); // 난수발생함수
            $certificationMd5 = md5($certification);
            $data['certificationMd5'] = $certificationMd5;
            $data['certification'] = $certification;

            $receiver_name =  "회원";
            $receiver_phone = str_replace('-','',$member_phone);

            $sms_url = "https://apis.aligo.in/send/"; // 전송요청 URL
            $sms['user_id'] = "chipdirect"; // SMS 아이디
            $sms['key'] = "5iomz2bals7kofy7siiynx33sxo5nxtp";//인증키

            $_POST['msg'] = '[칩다이렉트]%고객명%님. 인증번호를 [ '.$certification.' ]로 전달드립니다. 입력하셔서 진행하시기 바랍니다.'; // 메세지 내용 : euc-kr로 치환이 가능한 문자열만 사용하실 수 있습니다. (이모지 사용불가능)

            $_POST['receiver'] = $receiver_phone; // 수신번호
            $_POST['destination'] = $receiver_phone.'|'.$receiver_name; // 수신인 %고객명% 치환
            $_POST['sender'] =""; // 발신번호
            $_POST['rdate'] = ''; // 예약일자 - 20161004 : 2016-10-04일기준
            $_POST['rtime'] = ''; // 예약시간 - 1930 : 오후 7시30분
            $_POST['testmode_yn'] = 'N'; // Y 인경우 실제문자 전송X , 자동취소(환불) 처리
            $_POST['subject'] = '테스트 발송'; //  LMS, MMS 제목 (미입력시 본문중 44Byte 또는 엔터 구분자 첫라인)
            // $_POST['image'] = '/tmp/pic_57f358af08cf7_sms_.jpg'; // MMS 이미지 파일 위치 (저장된 경로)
            $_POST['msg_type'] = 'SMS'; //  SMS, LMS, MMS등 메세지 타입을 지정

            $sms['msg'] = stripslashes($_POST['msg']);
            $sms['receiver'] = $_POST['receiver'];
            $sms['destination'] = $_POST['destination'];
            $sms['sender'] = $_POST['sender'];
            $sms['rdate'] = $_POST['rdate'];
            $sms['rtime'] = $_POST['rtime'];
            $sms['testmode_yn'] = empty($_POST['testmode_yn']) ? '' : $_POST['testmode_yn'];
            $sms['title'] = $_POST['subject'];
            $sms['msg_type'] = $_POST['msg_type'];
            // 만일 $_FILES 로 직접 Request POST된 파일을 사용하시는 경우 move_uploaded_file 로 저장 후 저장된 경로를 사용하셔야 합니다.
            if(!empty($_FILES['image']['tmp_name'])) {
                $tmp_filetype = mime_content_type($_FILES['image']['tmp_name']); 
                if($tmp_filetype != 'image/png' && $tmp_filetype != 'image/jpg' && $tmp_filetype != 'image/jpeg') $_POST['image'] = '';
                else {
                    $_savePath = "./".uniqid(); // PHP의 권한이 허용된 디렉토리를 지정
                    if(move_uploaded_file($_FILES['file']['tmp_name'], $_savePath)) {
                        $_POST['image'] = $_savePath;
                    }
                }
            }
            // 이미지 전송 설정
            if(!empty($_POST['image'])) {
                if(file_exists($_POST['image'])) {
                    $tmpFile = explode('/',$_POST['image']);
                    $str_filename = $tmpFile[sizeof($tmpFile)-1];
                    $tmp_filetype = mime_content_type($_POST['image']);
                    if ((version_compare(PHP_VERSION, '5.5') >= 0)) { // PHP 5.5버전 이상부터 적용
                        $sms['image'] = new CURLFile($_POST['image'], $tmp_filetype, $str_filename);
                        curl_setopt($oCurl, CURLOPT_SAFE_UPLOAD, true);
                    } else {
                        $sms['image'] = '@'.$_POST['image'].';filename='.$str_filename. ';type='.$tmp_filetype;
                    }
                }
            }

            $host_info = explode("/", $sms_url);
            $port = $host_info[0] == 'https:' ? 443 : 80;
    
            $oCurl = curl_init();
            curl_setopt($oCurl, CURLOPT_PORT, $port);
            curl_setopt($oCurl, CURLOPT_URL, $sms_url);
            curl_setopt($oCurl, CURLOPT_POST, 1);
            curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sms);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, FALSE);
            $ret = curl_exec($oCurl);
            curl_close($oCurl);

            $data["smslog"] = json_decode($ret);
            //echo $ret;
            //$retArr = json_decode($ret); // 결과배열
            
        }


        // var_dump($data);
        // exit;

        if ($api_type == 1){
            if ($category_id == 1){
                return $this->viewGuest('auth/register_sns_per', $data);
            } elseif ($category_id == 2){
                return $this->viewGuest('auth/register_sns_com', $data);
            } elseif ($category_id == 3){
                return $this->viewGuest('auth/register_sns_com', $data);
            }
        } else {
            if ($category_id == 1){
                return $this->viewGuest('auth/register_per', $data);
            } elseif ($category_id == 2){
                return $this->viewGuest('auth/register_com', $data);
            } elseif ($category_id == 3){
                return $this->viewGuest('auth/register_com', $data);
            }
        }

    }

    public function register(){

            // echo "테스트 중.";
            // exit;
        
            $memberGet = new MemberGet();
            $member = new Member();
            $memberSub = new MemberSub();
            $memberGet->fill($this->request->getPost());

            $member->category_id = $memberGet->category_id;
            $member->api_type = $memberGet->api_type;
            $member->member_name = $memberGet->member_name;
            $member->member_code = $memberGet->member_code;
            $member->member_email = $memberGet->member_email;
            $member->member_phone = $memberGet->member_phone;
            $member->password = md5($memberGet->password);
            $member->pass_confirm = $memberGet->pass_confirm;

            if ($memberGet->member_address1) {
            $member->member_zipcode = $memberGet->member_zipcode;
            $member->member_address1 = $memberGet->member_address1;
            $member->member_address2 = $memberGet->member_address2;
            } else {
            $member->member_zipcode = $memberGet->com_zipcode;
            $member->member_address1 = $memberGet->com_address1;
            $member->member_address2 = $memberGet->com_address2;                
            }

            $certification = $memberGet->certification;
            $certificationMd5 = $memberGet->certificationMd5;
            $certificationsns = $memberGet->certificationsns;
            /*
            var_dump(md5($certification));
            var_dump($member);
            exit;
            */

            if ($certificationsns == "sns") {

                $member->active_flg = "1";
                $member->submit = "";

                $this->memberModel->save($member);

                $memberSub->member_code = $memberGet->member_code;
                $memberSub->com_name = $memberGet->com_name;
                $memberSub->com_englishname	= $memberGet->com_englishname;
                $memberSub->biz_number = $memberGet->biz_number;
                $memberSub->ceo_name = $memberGet->ceo_name;
                $memberSub->com_zipcode = $memberGet->com_zipcode;
                $memberSub->com_address1 = $memberGet->com_address1;
                $memberSub->com_address2 = $memberGet->com_address2;
                $memberSub->com_phone = $memberGet->com_phone;
                $memberSub->com_fax	= $memberGet->com_fax;
                $memberSub->invoice_email = $memberGet->invoice_email;
                $memberSub->homepage = $memberGet->homepage;
                $memberSub->sectors = $memberGet->sectors;
                $memberSub->condition = $memberGet->condition;
                $memberSub->account_bankname = $memberGet->account_bankname;
                $memberSub->account_number = $memberGet->account_number;
                $memberSub->account_depositor = $memberGet->account_depositor;
                $memberSub->submit = "";

                $insertId = $this->memberSubModel->save($memberSub, true);
                $membercode = $memberGet->member_code;

                if($insertId > 0){
                    $files = $this->request->getFiles();

                    if(isset($files)){
                        foreach ($files as $file){
                            $fileName = $file->getClientName();
                            if(isset($fileName) && !empty($fileName)){
                                $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATCH_UPLOAD_MEMBER_ATC, $membercode);
                                $membersFile = new MemberFile([
                                    'members_id' => esc($membercode),
                                    'file_name' => esc($fileName),
                                    'file_dir' => esc($filePath)
                                ]);

                                $this->memberFileModel->save($membersFile);
                            }
                        }
                    }
                    
                }
            
                if ($member->category_id == 1) {
                    $member_category  = "개인 회원";
                } elseif ($member->category_id == 2) {
                    $member_category  = "기업/단체 회원";
                } elseif ($member->category_id == 3) {
                    $member_category  = "딜러 회원";
                }



                $email = \Config\Services::email();
                
                $config['protocol'] = 'html';
                $config['mailPath'] = '/usr/sbin/sendmail -t -i';
                $config['fromEmail'] = 'chipdirectmall@gmail.com';
                $config['fromName'] = 'ChipDirect';
            
                $email->initialize($config);
                $email->setFrom('chip@selpasemicom.com', 'ChipDirect');
                $email->setTo($member->member_email);
                $email->setSubject('[칩다이렉트] 회원 가입을 환영합니다.');
                $email->setMessage('안녕하세요. '. $member->member_name .' 회원님<br>
                대한민국 대표 전자부품 쇼핑몰"<a href="https://chipdirect.co.kr">칩다이렉트</a>" 회원 가입을 환영합니다.<br>
                <p>
                회원님께서 가입하신 정보는 다음과 같습니다.<br>
                회원번호 : '.  $member->member_code .'<br>
                회원아이디 : '. $member->member_email .'<br>
                회원분류 : '. $member_category .'<br>
                </p>
                <p>
                본 메일은 관련법령에 따른 정보통신서비스 제공자의 고지의무 준수를 위하여 회원님의 E-mail 광고성 정보 수신동의 여부에 관계없이 발송 되었습니다.');

                if($email->send(false)){
                    $message = '회원등록을 성공적으로 마쳤습니다. 이메일을 확인해 주세요.';
                    return redirect()->route('guest.register.complete')->with('message',$message);
            
                }else{
                    echo "메일 전송에 문제가 있습니다.";
                }

                $message = '회원등록을 성공적으로 마쳤습니다.';
                return redirect()->route('guest.register.complete')->with('message',$message);


            } else {

            if (md5($certification) == $certificationMd5) {

                    $member->active_flg = "1";
                    $member->submit = "";

                    $this->memberModel->save($member);

                    $memberSub->member_code = $memberGet->member_code;
                    $memberSub->com_name = $memberGet->com_name;
                    $memberSub->com_englishname	= $memberGet->com_englishname;
                    $memberSub->biz_number = $memberGet->biz_number;
                    $memberSub->ceo_name = $memberGet->ceo_name;
                    $memberSub->com_zipcode = $memberGet->com_zipcode;
                    $memberSub->com_address1 = $memberGet->com_address1;
                    $memberSub->com_address2 = $memberGet->com_address2;
                    $memberSub->com_phone = $memberGet->com_phone;
                    $memberSub->com_fax	= $memberGet->com_fax;
                    $memberSub->invoice_email = $memberGet->invoice_email;
                    $memberSub->homepage = $memberGet->homepage;
                    $memberSub->sectors = $memberGet->sectors;
                    $memberSub->condition = $memberGet->condition;
                    $memberSub->account_bankname = $memberGet->account_bankname;
                    $memberSub->account_number = $memberGet->account_number;
                    $memberSub->account_depositor = $memberGet->account_depositor;
                    $memberSub->submit = "";

                    $insertId = $this->memberSubModel->save($memberSub, true);
                    $membercode = $memberGet->member_code;

                    if($insertId > 0){
                        $files = $this->request->getFiles();

                        if(isset($files)){
                            foreach ($files as $file){
                                $fileName = $file->getClientName();
                                if(isset($fileName) && !empty($fileName)){
                                    $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATCH_UPLOAD_MEMBER_ATC, $membercode);
                                    $membersFile = new MemberFile([
                                        'members_id' => esc($membercode),
                                        'file_name' => esc($fileName),
                                        'file_dir' => esc($filePath)
                                    ]);

                                    $this->memberFileModel->save($membersFile);
                                }
                            }
                        }
                        
                    }

                    if ($member->category_id == 1) {
                        $member_category  = "개인 회원";
                    } elseif ($member->category_id == 2) {
                        $member_category  = "기업/단체 회원";
                    } elseif ($member->category_id == 3) {
                        $member_category  = "딜러 회원";
                    }

                    $email = \Config\Services::email();
                    
                    $config['protocol'] = 'html';
                    $config['mailPath'] = '/usr/sbin/sendmail -t -i';
                    $config['fromEmail'] = 'chipdirectmall@gmail.com';
                    $config['fromName'] = 'ChipDirect';
                
                    $email->initialize($config);
                    $email->setFrom('chip@selpasemicom.com', 'ChipDirect');
                    $email->setTo($member->member_email);
                    $email->setSubject('[칩다이렉트] 회원 가입을 환영합니다.');
                    $email->setMessage('안녕하세요. '. $member->member_name .' 회원님<br>
                    대한민국 대표 전자부품 쇼핑몰"<a href="https://chipdirect.co.kr">칩다이렉트</a>" 회원 가입을 환영합니다.<br>
                    <p>
                    회원님께서 가입하신 정보는 다음과 같습니다.<br>
                    회원번호 : '.  $member->member_code .'<br>
                    회원아이디 : '. $member->member_email .'<br>
                    회원분류 : '. $member_category .'<br>
                    </p>
                    <p>
                    본 메일은 관련법령에 따른 정보통신서비스 제공자의 고지의무 준수를 위하여 회원님의 E-mail 광고성 정보 수신동의 여부에 관계없이 발송 되었습니다.');

                    if($email->send(false)){
                        $message = '회원등록을 성공적으로 마쳤습니다. 이메일을 확인해 주세요.';
                        return redirect()->route('guest.register.complete')->with('message',$message);
                
                    }else{
                        echo "메일 전송에 문제가 있습니다.";
                    }


                    $message = '회원등록을 성공적으로 마쳤습니다.';
                    return redirect()->route('guest.register.complete')->with('message',$message);

            } else {

                $refererUrl = "/register";

                session()->setFlashdata('status_text', '잘 못된 인증키를 입력하셨습니다. 회원등록을 다시 진행합니다.');
                return redirect()->to($refererUrl)
                    ->with('status_icon', 'warning')
                    ->with('status', '휴대전화 인증 실패');
            }

        }

    }


    public function phoneCheck(){

        echo "Phone Check <br>";

        $request = new Member($this->request->getPost());

        /*
        $qty = $inquiry->qty;
        $price = $inquiry->price;
        $part_sequence =  $inquiry->part_sequence;
        $inquiry_code =  $inquiry->inquiry_code;
        */

        $data = [
            'member_code'  => '21111',
            'category_id'  => '1',
            'api_type'     => '0',
        ];




        return redirect()->route('guest.register.show_create', '', $data);

        /*
        exit;

        return redirect()->route('guest.register.show_create', $data)->with('message',$message);
        //return redirect('guest.register.show_create')->withInput(Input::all());

        $refererUrl = $_SERVER['HTTP_HOST'].$this->request->getPost();
        // exit;

        session()->setFlashdata('status_text', '입력하신 전화번호로 인증키를 전송했습니다.');
        return redirect()->to($refererUrl)
            ->with('status_icon', 'success')
            ->with('status', '메시지를 확인하세요.');
        */
    
    }


    public function complete(){
        return $this->viewGuest('auth/complete',$message);
    }

    public function accessCode($accessCode){
        $member = $this->memberModel->findByAccessCode($accessCode);
        if(isset($member)){
            $member->active_flg = MEMBER_ACCEPT_ON;
            $member->access_code = '';
            $member->access_flg = 0;
            $this->memberModel->save($member);
            return $this->viewGuest('auth/register_access_code_success');
        }
        return redirect()->route('guest.home');
    }

    //--------------------------------------------------------------------

}
