<?php 
namespace App\Controllers\Guest;

use App\Controllers\Guest\BaseController;
// use App\Entities\Member;
use App\Helpers\ArrayHelper;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Helpers\NumberHelper;
use App\Helpers\FileHelper;
use App\Models\DigikeyApiPndataModel;
use App\Entities\DigikeyApiProductinfo;
use App\Models\DigikeyApiProductinfoModel;
use App\Models\ExchangeInfoModel;
// use App\Models\MemberModel;
use Config\Services;

class DigikeyApiController extends BaseController
{
    // protected $memberModel;
    protected $digikeyApiPndata;
    protected $digikeyApiProductinfoModel;
    protected $exchangeInfoModel;

    public function __construct()
    {
        // $this->memberModel = new MemberModel();
        $this->digikeyApiPndata = new DigikeyApiPndataModel();
        $this->digikeyApiProductinfoModel = new DigikeyApiProductinfoModel();
        $this->exchangeInfoModel = new ExchangeInfoModel();
    }


    public function index(){   
        echo "There is a Digikey Api Intro.";
        exit;
    }

    
    public function productRecommended(){   

        $code_type = $_GET["code"];

        if (!$code_type) {
            return redirect()->to('https://api.digikey.com/v1/oauth2/authorize?response_type=code&client_id=45FD9NJx2dipaO0CV6viRaAEK8472bBG&redirect_uri=https%3A%2F%2Fchipdirect.co.kr%2Fdigikeyapi%2Frecommended');
        }

        $client_id = "45FD9NJx2dipaO0CV6viRaAEK8472bBG";
        $client_secret = "l5f2Jyo1uB6dwCno";
        $redirect_uri = "https://chipdirect.co.kr/digikeyapi/recommended";

        $grant_type = "authorization_code";
        $url = 'https://api.digikey.com/v1/oauth2/token';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded';
        $headers[] = 'Accept: application/json';
        $headers[] = 'Cache-Control: no-cache';

        $host_info = explode("/", $url);
        $port = $host_info[0] == 'https:' ? 443 : 80;
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_PORT, $port);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, 'code='.$code_type.'&client_id='.$client_id.'&client_secret='.$client_secret.'&redirect_uri='.$redirect_uri.'&grant_type='.$grant_type);

        $response = curl_exec($ch);
        curl_close($ch);

        if (!$response) {
        echo 'no response';
        exit;
        }

        $jsonDecoded = json_decode($response,true);
        $accessToken = $jsonDecoded["access_token"];

        $url_headers[] = 'Accept: application/json';
        $url_headers[] = 'authorization: Bearer '.$accessToken;
        $url_headers[] = 'Accept-Encoding: gzip, deflate, br';
        $url_headers[] = 'Connection: Keep-Alive';
        $url_headers[] = 'X-DIGIKEY-Locale-Site: KR';
        $url_headers[] = 'X-DIGIKEY-Locale-Language: KO';
        $url_headers[] = 'X-DIGIKEY-Locale-Currency: USD';
        $url_headers[] = 'X-DIGIKEY-Client-Id: '.$client_id;

        $curl = curl_init();

        // $Keywords = "PIC18F25Q10T-I/ML";
        $url = 'https://api.digikey.com/products/v4/search/PIC18F25Q10T-I%2fML/recommendedproducts';

        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, $url_headers);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_ENCODING, "");
        curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
        curl_setopt($curl, CURLOPT_TIMEOUT, 30);
        curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "GET");

        $curl_response = curl_exec($curl);
        $err = curl_error($curl);

        if ($err) {
        echo "cURL Error #:" . $err;
        curl_close($curl);
        } else {
        curl_close($curl);

        echo " [Recommended 정보 ]<br>";
        var_dump ($curl_response);
        }

    }

 
    public function productDetails(){   

        $code_type = $_GET["code"];

        if (!$code_type) {
            return redirect()->to('https://api.digikey.com/v1/oauth2/authorize?response_type=code&client_id=yP3QHQa0KraZ6dXCE4zFkNWwPDKbxXWP&redirect_uri=https%3A%2F%2Fchipdirect.co.kr%2Fdigikeyapi%2Fdetails');
        }

        $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
        $pathFile = FileHelper::FOLDER_PATCH_DKAPI_TOTEXT;
        $filepath = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';

        $result=opendir($filepath);

        while($file=readdir($result)) {
           if($file=="."||$file=="..") {continue;}
           $fileInfo = pathinfo($file);
           $fileExt = $fileInfo['extension'];
      
           If (empty($fileExt)){
              $dir_count++;
           } else {
              $file_count++;
           }
         }

        $filenum = $file_count+1;

        $client_id = "yP3QHQa0KraZ6dXCE4zFkNWwPDKbxXWP";
        $client_secret = "s8rKoYosc2Obqyfc";
        $redirect_uri = "https://chipdirect.co.kr/digikeyapi/details";

        $grant_type = "authorization_code";
        $url = 'https://api.digikey.com/v1/oauth2/token';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded';
        $headers[] = 'Accept: application/json';
        $headers[] = 'Cache-Control: no-cache';

        $host_info = explode("/", $url);
        $port = $host_info[0] == 'https:' ? 443 : 80;
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_PORT, $port);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, 'code='.$code_type.'&client_id='.$client_id.'&client_secret='.$client_secret.'&redirect_uri='.$redirect_uri.'&grant_type='.$grant_type);

        $response = curl_exec($ch);
        curl_close($ch);

        if (!$response) {
        echo 'no response';
        exit;
        }

        $jsonDecoded = json_decode($response,true);
        $accessToken = $jsonDecoded["access_token"];

        $url_headers[] = 'Accept: application/json';
        $url_headers[] = 'authorization: Bearer '.$accessToken;
        $url_headers[] = 'Accept-Encoding: gzip, deflate, br';
        $url_headers[] = 'Connection: Keep-Alive';
        $url_headers[] = 'X-DIGIKEY-Locale-Site: KR';
        $url_headers[] = 'X-DIGIKEY-Locale-Language: KO';
        $url_headers[] = 'X-DIGIKEY-Locale-Currency: KRW';
        $url_headers[] = 'X-DIGIKEY-Client-Id: '.$client_id;


        $incount = "500"; // chipdirect.co.kr_test
        //$incount = "500";
        $api_code = "DK";
        $dkApiIds = $this->digikeyApiPndata->getDigikeyApiId($api_code);
        //var_dump (count($dkApiIds));
        //exit;

        if (count($dkApiIds) > 0) {

            foreach ($dkApiIds as $key => $itemId):
        
                if  ($incount > $key) {
                    $maker_partnumber = $itemId->maker_partnumber;
                    $url_partnumber = urlencode($maker_partnumber);
                    // echo $url_partnumber."<br>";

                    // $Keywords = "PIC18F25Q10T-I/ML";
                    $url = 'https://api.digikey.com/products/v4/search/'.$url_partnumber.'/productdetails';

                    $curl = curl_init();

                    curl_setopt($curl, CURLOPT_URL, $url);
                    curl_setopt($curl, CURLOPT_HTTPHEADER, $url_headers);
                    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($curl, CURLOPT_ENCODING, "");
                    curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
                    curl_setopt($curl, CURLOPT_TIMEOUT, 30);
                    curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
                    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "GET");

                    $curl_response = curl_exec($curl);
                    $err = curl_error($curl);

                    if ($err) {
                        echo "cURL Error #:" . $err;
                        curl_close($curl);
                    } else {
                        curl_close($curl);

                        // echo "[ productdetails 정보 ]<br>";
                        // var_dump ($curl_response);
                        $details = json_decode($curl_response,true);
                        $Variations = $details["Product"]["ProductVariations"];


                        if ($Variations) {
                            foreach($Variations as $Variationsdata){

                                $part_category2 = $details["Product"]["Category"]["Name"];
                                $part_category3 = $details["Product"]["BaseProductNumber"]["Name"];
                                $id = $details["Product"]["Manufacturer"]["Name"];
                                $part_number = $details["Product"]["ManufacturerProductNumber"];
                                $brief_description =$details["Product"]["Description"]["ProductDescription"]." / ".$details["Product"]["Description"]["DetailedDescription"];
                                $image_dir = $details["Product"]["PhotoUrl"];
                                $pdf_dir = $details["Product"]["DatasheetUrl"];
                                $api_flg = "1";
                                $api_code = "DK";
                                $dk_part_number = $Variationsdata["DigiKeyProductNumber"];
                                $qty = $details["Product"]["QuantityAvailable"];
                                $packing_code = $Variationsdata["PackageType"]["Name"];
                                $packsize = $Variationsdata["QuantityAvailableforPackageType"];
                                $price = $details["Product"]["UnitPrice"];
                                $moq = $Variationsdata["MinimumOrderQuantity"];

                                    $StandardPricing = $Variationsdata["StandardPricing"];
                                    $PricingData = "";

                                    foreach($StandardPricing as $key => $StandardPricingdata){
                                        $price = $StandardPricingdata["UnitPrice"];
                                        $mini_quantity = $StandardPricingdata["BreakQuantity"];
                                        // echo "<br>";
                                        // var_dump ($StandardPricingdata["TotalPrice"]);
                                        $PricingData .= $price.','.$mini_quantity.',';
                                    }

                                // echo "<br>";
                                // var_dump ($Variationsdata["Supplier"]["Name"]);
                                // echo "<br>";
                                // var_dump ($Variationsdata["MaxQuantityForDistribution"]);
                                // echo $PricingData ."<br>";
                                
                                $arr = explode(',', $PricingData);
                                for ($i=0; $i<11; $i++) {
                                    if ($arr[0]) {$price1 = $arr[0];} else {$price1 = "0";}
                                    if ($arr[1]) {$mini_quantity1 = $arr[1];} else {$mini_quantity1 = "0";}
                                    if ($arr[2]) {$price2 = $arr[2];} else {$price2 = "0";}
                                    if ($arr[3]) {$mini_quantity2 = $arr[3];} else {$mini_quantity2 = "0";}
                                    if ($arr[4]) {$price3 = $arr[4];} else {$price3 = "0";}
                                    if ($arr[5]) {$mini_quantity3 = $arr[5];} else {$mini_quantity3 = "0";}
                                    if ($arr[6]) {$price4 = $arr[6];} else {$price4 = "0";}
                                    if ($arr[7]) {$mini_quantity4 = $arr[7];} else {$mini_quantity4 = "0";}
                                    if ($arr[8]) {$price5 = $arr[8];} else {$price5 = "0";}
                                    if ($arr[9]) {$mini_quantity5 = $arr[9];} else {$mini_quantity5 = "0";}
                                    if ($arr[10]) {$price6 = $arr[10];} else {$price6 = "0";}
                                    if ($arr[11]) {$mini_quantity6 = $arr[11];} else {$mini_quantity6 = "0";}
                                }

                                // echo $pData ."<br>";
                                // echo $price1.','.$mini_quantity1.','.$price2.','.$mini_quantity2.','.$price3.','.$mini_quantity3.','.$price4.','.$mini_quantity4.','.$price5.','.$mini_quantity5.','.$price6.','.$mini_quantity6 ."<br>";
                                // $PricingData = $price1.','.$mini_quantity1.','.$price2.','.$mini_quantity2.','.$price3.','.$mini_quantity3.','.$price4.','.$mini_quantity4.','.$price5.','.$mini_quantity5.','.$price6.','.$mini_quantity6;

                                $description = $details["Product"]["Series"]["Name"]."<br>";
                                $description .= $details["Product"]["Description"]["ProductDescription"]." / ".$details["Product"]["Description"]["DetailedDescription"]."<br>";

                                $Parameters = $details["Product"]["Parameters"];
                                foreach($Parameters as $Parametersdata){
                                    $description .= $Parametersdata["ParameterText"]." : ".$Parametersdata["ValueText"]."<br>";
                                }
                                $description .= $details["Product"]["Category"]["SeoDescription"]."<br>";
                                $description .= $details["Product"]["ProductUrl"];
                                
                                $active_flg = $details["Product"]["ProductStatus"]["Status"];

                                $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
                                $pathFile = FileHelper::FOLDER_PATCH_DKAPI_TOTEXT;
                                $filepath = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';
                                $filename = "digikeyapitext".$filenum;
                        
                                $fp = fopen($filepath.$filename.".csv", "a");
                                $text = $part_category2.',"'.$part_category3.'","'.$id.'","'.$part_number.'","'.$brief_description.'","'.$description.'","'.$image_dir.'","'.$pdf_dir.'",'.$api_flg.',"'.$api_code.'","'.$dk_part_number.'","'.$packing_code.'","'.$packsize.'",'.$price.','.$qty.','.$moq.','.$active_flg.','.$price1.','.$mini_quantity1.','.$price2.','.$mini_quantity2.','.$price3.','.$mini_quantity3.','.$price4.','.$mini_quantity4.','.$price5.','.$mini_quantity5.','.$price6.','.$mini_quantity6;
                                fwrite($fp, $text."\n");
                                fclose($fp);

                                $this->digikeyApiPndata->updateActiveFlg($maker_partnumber);

                            }
                            //exit;
                        } else {

                            echo "[에러 발생]<br>";
                            echo "M.P.N : ".$maker_partnumber;
                            echo "<br>";
                            echo "URL : ".$url;

                        }
                    }

                }
                
            endforeach;

        }
        //exit;

    }


    function loop_file_check($filename, $filecon, $fileexe){

		$cfg					= array();
		$cfg['allowed_types']	= $fileexe;
		$cfg['file_name']		= $filename.$filecon;

        $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
        $pathFile = FileHelper::FOLDER_PATCH_DKAPI_TOTEXT;
		$cfg['upload_path']	    = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';
		$cfg['overwrite']		= TRUE;

			$this->fileName = $fileName;
			$this->filePath = $cfg['upload_path'] . $cfg['file_name'] . '.' . $cfg['allowed_types'];

	}


    public function moveCsvFile()
    {
        $file_count = 0;
        $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
        $pathFile = FileHelper::FOLDER_PATCH_DKAPI_TOTEXT;
        $loopexcel_path = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';
        $pathFileBackup = FileHelper::FOLDER_PATCH_DKAPI_TOTEXT_BACKUP;
        $apifilebackup_path = PUBLIC_PATH.$uploadpath.'/'.$pathFileBackup.'/';       
        $backup_day = date('Ymd');
        $result = opendir($loopexcel_path);

		while($file=readdir($result)) {
			if($file=="."||$file=="..") {continue;}
			$fileInfo = pathinfo($file);
			$fileExt = $fileInfo['extension'];

			If (empty($fileExt)){
			    $dir_count++;
			} else {
			    $file_count++;
			}
		}

        $file_countend = $file_count+1;
        for ($file_count =1;$file_count < $file_countend;$file_count ++) {
                $filecon = $file_count;
                $bs_filename = 'digikeyapitext';
                $this->loop_file_check($bs_filename, $filecon, 'csv');
                $loopfilepath = $this->filePath;
                $apifilebakpath = $apifilebackup_path.$backup_day."_".$bs_filename.$filecon.".csv";

                //echo $loopfilepath;
                //echo"<br>";
                //echo $apifilebakpath;
                //exit;

                if(file_exists($loopfilepath)) {
                    exec("mv ".$loopfilepath." ".$apifilebakpath);	
                }
                // $this->disikeyApiProductinfoModel->truncate(); //ApiProductinfo 테이블 초기화
        }
    }
    

    public function importCsvToDb()
    {

        $file_count = 0;
        $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
        $pathFile = FileHelper::FOLDER_PATCH_DKAPI_TOTEXT;
        $loopexcel_path = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';

        $isDir = is_dir($loopexcel_path);
        $result = opendir($loopexcel_path); 

		while($file=readdir($result)) {            
			if($file=="."||$file=="..") {continue;}
			$fileInfo = pathinfo($file);
			$fileExt = $fileInfo['extension'];
			If (empty($fileExt)){
			$dir_count++;
			} else {
			$file_count++;
			}
		}

        $file_countend = $file_count+1;

        for ($file_count =1;$file_count < $file_countend;$file_count ++) {
                
                $filecon = $file_count;
                $bs_filename = 'digikeyapitext';

                $this->loop_file_check($bs_filename, $filecon, 'csv');
                $loopfilepath = $this->filePath;

                    $file = fopen($loopfilepath,"r");
                    
                    $i = 1;
                    $numberOfFields = 29;
                    $csvArr = array();
                    while (($filedata = fgetcsv($file, 10000, ",")) !== FALSE) {
                        $num = count($filedata);

                        if($i > 0 && $num == $numberOfFields){ 
                            $csvArr[$i]['part_category2'] = $filedata[0];
                            $csvArr[$i]['part_category3'] = $filedata[1];
                            $csvArr[$i]['manufacturer'] = $filedata[2];
                            $csvArr[$i]['part_number'] = $filedata[3];
                            $csvArr[$i]['brief_description'] = $filedata[4];
                            $csvArr[$i]['description'] = $filedata[5];
                            $csvArr[$i]['image_dir'] = $filedata[6];
                            $csvArr[$i]['pdf_dir'] = $filedata[7];
                            $csvArr[$i]['api_flg'] = $filedata[8];
                            $csvArr[$i]['api_code'] = $filedata[9];
                            $csvArr[$i]['dk_part_number'] = $filedata[10];
                            $csvArr[$i]['packing_code'] = $filedata[11];
                            $csvArr[$i]['packsize'] = $filedata[12];
                            $csvArr[$i]['price'] = $filedata[13];
                            $csvArr[$i]['qty'] = $filedata[14];
                            $csvArr[$i]['moq'] = $filedata[15];
                            $csvArr[$i]['active_flg'] = $filedata[16];
                            $csvArr[$i]['price1'] = $filedata[17];
                            $csvArr[$i]['mini_qty1'] = $filedata[18];
                            $csvArr[$i]['price2'] = $filedata[19];
                            $csvArr[$i]['mini_qty2'] = $filedata[20];
                            $csvArr[$i]['price3'] = $filedata[21];
                            $csvArr[$i]['mini_qty3'] = $filedata[22];
                            $csvArr[$i]['price4'] = $filedata[23];
                            $csvArr[$i]['mini_qty4'] = $filedata[24];
                            $csvArr[$i]['price5'] = $filedata[25];
                            $csvArr[$i]['mini_qty5'] = $filedata[26];
                            $csvArr[$i]['price6'] = $filedata[27];
                            $csvArr[$i]['mini_qty6'] = $filedata[28];

                        }
                        $i++;

                    }
                
                    fclose($file);
                   
                    $count = 0;
                    $apiproductinfo = new DigikeyApiProductinfo();

                    foreach($csvArr as $exceldata){
                            $apiproductinfo->api_code = $exceldata['api_code'];
                            $apiproductinfo->part_category2 = $exceldata['part_category2'];
                            $apiproductinfo->part_category3 = $exceldata['part_category3'];
                            $apiproductinfo->dk_pn = $exceldata['dk_part_number'];
                            $apiproductinfo->manufacturer = $exceldata['manufacturer'];
                            $apiproductinfo->manufacturer_pn = $exceldata['part_number'];
                            $apiproductinfo->brief_description = $exceldata['brief_description'];
                            $apiproductinfo->description = $exceldata['description'];
                            $apiproductinfo->image_dir = $exceldata['image_dir'];
                            $apiproductinfo->pdf_dir = $exceldata['pdf_dir'];
                            $apiproductinfo->api_flg = $exceldata['api_flg'];
                            $apiproductinfo->packing_code = $exceldata['packing_code'];
                            $apiproductinfo->packsize = $exceldata['packsize'];
                            $apiproductinfo->price = $exceldata['price'];
                            $apiproductinfo->qty = $exceldata['qty'];
                            $apiproductinfo->moq = $exceldata['moq'];
                            $apiproductinfo->active_flg = $exceldata['active_flg'];
                            $apiproductinfo->price1 = $exceldata['price1'];
                            $apiproductinfo->mini_qty1 = $exceldata['mini_qty1'];
                            $apiproductinfo->price2 = $exceldata['price2'];
                            $apiproductinfo->mini_qty2 = $exceldata['mini_qty2'];
                            $apiproductinfo->price3 = $exceldata['price3'];
                            $apiproductinfo->mini_qty3 = $exceldata['mini_qty3'];
                            $apiproductinfo->price4 = $exceldata['price4'];
                            $apiproductinfo->mini_qty4 = $exceldata['mini_qty4'];
                            $apiproductinfo->price5 = $exceldata['price5'];
                            $apiproductinfo->mini_qty5 = $exceldata['mini_qty5'];
                            $apiproductinfo->price6 = $exceldata['price6'];
                            $apiproductinfo->mini_qty6 = $exceldata['mini_qty6'];
                            $apiproductinfo->del_flg = '0';

                            //var_dump($apiproductinfo);
                            //exit;

                            if($this->digikeyApiProductinfoModel->insert($apiproductinfo)){
                                 $count++;
                            }
                    }
                $count_all = $count_all + $count;
        }
    
        //$this->digikeyApiProductinfoModel->updateProducts(); //API정보 부품정보에 반영.
        $this->moveCsvFile();
        
    }


}
