<?php 
namespace App\Controllers\Guest;
use App\Controllers\Guest\BaseController;

use App\Helpers\ArrayHelper;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Helpers\NumberHelper;
use App\Helpers\FileHelper;

use App\Entities\CategorysCollect;
use App\Models\CategorysCollectModel;
use App\Models\LcscProductinfoModel;
use App\Models\ExchangeInfoModel;
use App\Models\ApiPndataModel;

use Config\Services;

class LcscApiController extends BaseController
{
    protected $categorysCollectModel;
    protected $lcscProductinfoModel;
    protected $exchangeInfoModel;
    protected $apiPndataModel;

    public function __construct()
    {
        $this->categorysCollectModel = new CategorysCollectModel();
        $this->lcscProductinfoModel = new LcscProductinfoModel();
        $this->exchangeInfoModel = new ExchangeInfoModel();
        $this->apiPndataModel = new ApiPndataModel();

    }


    public function index(){   
        echo "There is a Lcsc Api Info.";
        exit;
    }


    public function categoryCollect () {
        // echo "There is a Category Collect.";
        $key = "BsC95BSUFCR95DftYEpz0bCAUvMK7OD";
        $secret = "O3PsFLzjbVQNaj7Eqn4uf5WFT5AwTIlfSR4FJ";
        $nonce = "63yeike7dy6c2kjd";

        $timestamp = time();
        $str = 'key='.$key.'&nonce='.$nonce.'&secret='.$secret.'&timestamp='.$timestamp;
        $str_encode = sha1($str);

        $url = 'https://ips.lcsc.com/rest/wmsc2agent/category?key='.$key.'&nonce='.$nonce.'&timestamp='.$timestamp.'&signature='.$str_encode;;
        $headers[] = 'Accept: application/json';
        $headers[] = 'Cache-Control: no-cache';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $ch_response = curl_exec($ch);
        $err = curl_error($ch);

        if ($err) {
        echo "cURL Error #:" . $err;
        curl_close($ch);
        } else {
        curl_close($ch);
        // echo "받은 정보 : <br>";
        // var_dump ($ch_response);

            $details = json_decode($ch_response,true);
            $results = $details["result"];

            if ($results) {
                foreach($results as $resultsdata){
                    /*
                    var_dump ($resultsdata["id"]);
                    echo "<br>";
                    var_dump ($resultsdata["name"]);
                    echo "<br>";
                    var_dump ($resultsdata["product_quantity"]);
                    exit;
                    */
                    
                    $childrens = $resultsdata["children"];

                    foreach($childrens as $childrensdata){

                        $categorysCollect = new CategorysCollect();

                            $categorysCollect->level1_id = $resultsdata["id"];
                            $categorysCollect->level1_name = $resultsdata["name"];
                            $categorysCollect->level1_product_quantity = $resultsdata["product_quantity"];
                            $categorysCollect->level2_id = $childrensdata["id"];
                            $categorysCollect->level2_name = $childrensdata["name"];
                            $categorysCollect->level2_product_quantity = $childrensdata["product_quantity"];

                        $this->categorysCollectModel->insert($categorysCollect);
                    }
                }
            }
        }
    }


    public function itemToTxt() {

        $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
        $pathFile = FileHelper::FOLDER_PATCH_LCSC_TOTEXT;
        $filepath = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';

        $dir_count = 0;
        $file_count = 0;

        $result=opendir($filepath);

        while($file=readdir($result)) {
            if($file=="."||$file=="..") {continue;}
            $fileInfo = pathinfo($file);
            $fileExt = $fileInfo['extension'];

            If (empty($fileExt)){
                $dir_count++;
            } else {
                $file_count++;
            }
        }


        $filenum = $file_count+1;
        $incount = "2"; // test
        $api_code = "LC";

        $apiSeqIds = $this->apiPndataModel->getApiId($api_code, $incount);

         // $counrty_code = "USD";
         // $ExchangeRat = $this->exchangeInfoModel->where('counrty_code',$counrty_code)->orderBy('created_at desc')->first();
         // $exchange_rat = $ExchangeRat->standard_amount;
         // var_dump($exchange_rat);

        foreach ($apiSeqIds["lists"] as $key => $item){

            $key = "BsC95BSUFCR95DftYEpz0bCAUvMK7OD";
            $secret = "O3PsFLzjbVQNaj7Eqn4uf5WFT5AwTIlfSR4FJ";
            $nonce = "63yeike7dy6c2kjd";
            $item_num = $item->api_partnumber;
            // var_dump($item_num);
            // echo "<br>";

            $timestamp = time();

            $str = 'key='.$key.'&nonce='.$nonce.'&secret='.$secret.'&timestamp='.$timestamp;
            $str_encode = sha1($str);

            $url = 'https://ips.lcsc.com/rest/wmsc2agent/product/info/'.$item_num.'?key='.$key.'&nonce='.$nonce.'&timestamp='.$timestamp.'&signature='.$str_encode;;
            $headers[] = 'Accept: application/json';
            $headers[] = 'Cache-Control: no-cache';

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $ch_response = curl_exec($ch);
            $err = curl_error($ch);

            if ($err) {
            echo "cURL Error #:" . $err;
            curl_close($ch);
            } else {
            curl_close($ch);

            // echo "Product Number : ".$item_num;
            // echo "<br><br>";
            // echo "받은 정보 : <br>";
            var_dump ($ch_response);
            echo "<br><br>";

            $details = json_decode($ch_response,true);
            $results = $details["result"];
            $upqty = $results["quantity"];
            $prices_array = $results["prices"];

            // var_dump ($results);
            // echo "<br><br>";

            $qty = $upqty;
            $prices_price1 = $prices_array[0]["price"];
            $prices_currency1 = $prices_array[0]["currency"];
            $unit_mini_quantity1 = $prices_array[0]["min_qty"];
            $unit_max_quantity1 = $prices_array[0]["max_qty"];
            $prices_price2 = $prices_array[1]["price"];
            $prices_currency2 = $prices_array[1]["currency"];
            $unit_mini_quantity2 = $prices_array[1]["min_qty"];
            $unit_max_quantity2 = $prices_array[1]["max_qty"];
            $prices_price3 = $prices_array[2]["price"];
            $prices_currency3 = $prices_array[2]["currency"];
            $unit_mini_quantity3 = $prices_array[2]["min_qty"];
            $unit_max_quantity3 = $prices_array[2]["max_qty"];
            $prices_price4 = $prices_array[3]["price"];
            $prices_currency4 = $prices_array[3]["currency"];
            $unit_mini_quantity4 = $prices_array[3]["min_qty"];
            $unit_max_quantity4 = $prices_array[3]["max_qty"];
            $prices_price5 = $prices_array[4]["price"];
            $prices_currency5 = $prices_array[4]["currency"];
            $unit_mini_quantity5 = $prices_array[4]["min_qty"];
            $unit_max_quantity5 = $prices_array[4]["max_qty"];
            $prices_price6 = $prices_array[5]["price"];
            $prices_currency6 = $prices_array[5]["currency"];
            $unit_mini_quantity6 = $prices_array[5]["min_qty"];

            // if ($qty) {

                $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
                $pathFile = FileHelper::FOLDER_PATCH_LCSC_TOTEXT;
                $filepath = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';
                $filename = $api_code."_itemstext".$filenum;

                $fp = fopen($filepath.$filename.".csv", "a");
                $text = '"'.$item_num.'","'.$qty.'","'.$prices_price1.'","'.$prices_currency1.'","'.$unit_mini_quantity1.'","'.$unit_max_quantity1.'","'.$prices_price2.'","'.$prices_currency2.'","'.$unit_mini_quantity2.'","'.$unit_max_quantity2.'","'.$prices_price3.'","'.$prices_currency3.'","'.$unit_mini_quantity3.'","'.$unit_max_quantity3.'","'.$prices_price4.'","'.$prices_currency4.'","'.$unit_mini_quantity4.'","'.$unit_max_quantity4.'","'.$prices_price5.'","'.$prices_currency5.'","'.$unit_mini_quantity5.'","'.$unit_max_quantity5.'","'.$prices_price6.'","'.$prices_currency6.'","'.$unit_mini_quantity6.'","'.$unit_max_quantity6.'"';
                fwrite($fp, $text."\n");
                fclose($fp);
                
            //    }

            }

        }

        exit;

    }
    

    public function itemList () {
        $key = "BsC95BSUFCR95DftYEpz0bCAUvMK7OD";
        $secret = "O3PsFLzjbVQNaj7Eqn4uf5WFT5AwTIlfSR4FJ";
        $nonce = "63yeike7dy6c2kjd";

        $category_id = "612";

        $end_current_page = 8;
        // $current_page = 50;

        $dataRow = 99;
        $timestamp = time();

        for($current_page=1;$current_page <= $end_current_page;$current_page++):

        $str = 'key='.$key.'&nonce='.$nonce.'&secret='.$secret.'&timestamp='.$timestamp;
        $str_encode = sha1($str);
        $url = 'https://ips.lcsc.com/rest/wmsc2agent/category/product/'.$category_id.'?key='.$key.'&nonce='.$nonce.'&timestamp='.$timestamp.'&signature='.$str_encode.'&current_page='.$current_page;
        $headers[] = 'Accept: application/json';
        $headers[] = 'Cache-Control: no-cache';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $ch_response = curl_exec($ch);
        $err = curl_error($ch);

        if ($err) {
        echo "cURL Error #:" . $err;
        curl_close($ch);
        } else {
        curl_close($ch);
            $details = json_decode($ch_response,true);
            $results = $details["result"];

            if ($results) {
                for($i=0;$i <= $dataRow;$i++):

                foreach($results as $resultsdata){

                    $item_id = $resultsdata[$i]["id"];
                    $item_number = $resultsdata[$i]["number"];
                    $category_id1 = $resultsdata[$i]["category"]["id1"];
                    $category_name1 = $resultsdata[$i]["category"]["name1"];
                    $category_id2 = $resultsdata[$i]["category"]["id2"];
                    $category_name2 = $resultsdata[$i]["category"]["name2"];
                    $manufacturer_id = $resultsdata[$i]["manufacturer"]["id"];
                    $manufacturer_name = $resultsdata[$i]["manufacturer"]["name"];
                    $package = $resultsdata[$i]["package"];
                    $title = $resultsdata[$i]["title"];
                    $mpn = $resultsdata[$i]["mpn"];
                    $quantity = $resultsdata[$i]["quantity"];
                    $whs_js = $resultsdata[$i]["whs-js"];
                    $whs_zh = $resultsdata[$i]["whs-zh"];
                    $whs_hk = $resultsdata[$i]["whs-hk"];
                    $moq = $resultsdata[$i]["moq"];
                    $order_multiple = $resultsdata[$i]["order_multiple"];
                    $weight= $resultsdata[$i]["weight"];
                    $packaging = $resultsdata[$i]["packaging"];
                    $sell_unit = $resultsdata[$i]["sell_unit"];
                    $packing_num = $resultsdata[$i]["packing_num"];
                    $packing_unit = $resultsdata[$i]["packing_unit"];
                    $prices0_min_qty = $resultsdata[$i]["prices"][0]["min_qty"];
                    $prices0_max_qty = $resultsdata[$i]["prices"][0]["max_qty"];
                    $prices0_currency = $resultsdata[$i]["prices"][0]["currency"];
                    $prices0_price = $resultsdata[$i]["prices"][0]["price"];
                    $prices1_min_qty = $resultsdata[$i]["prices"][1]["min_qty"];
                    $prices1_max_qty = $resultsdata[$i]["prices"][1]["max_qty"];
                    $prices1_currency = $resultsdata[$i]["prices"][1]["currency"];
                    $prices1_price = $resultsdata[$i]["prices"][1]["price"];
                    $prices2_min_qty = $resultsdata[$i]["prices"][2]["min_qty"];
                    $prices2_max_qty = $resultsdata[$i]["prices"][2]["max_qty"];
                    $prices2_currency = $resultsdata[$i]["prices"][2]["currency"];
                    $prices2_price = $resultsdata[$i]["prices"][2]["price"];
                    $prices3_min_qty = $resultsdata[$i]["prices"][3]["min_qty"];
                    $prices3_max_qty = $resultsdata[$i]["prices"][3]["max_qty"];
                    $prices3_currency = $resultsdata[$i]["prices"][3]["currency"];
                    $prices3_price = $resultsdata[$i]["prices"][3]["price"];
                    $prices4_min_qty = $resultsdata[$i]["prices"][4]["min_qty"];
                    $prices4_max_qty = $resultsdata[$i]["prices"][4]["max_qty"];
                    $prices4_currency = $resultsdata[$i]["prices"][4]["currency"];
                    $prices4_price = $resultsdata[$i]["prices"][4]["price"];
                    $prices5_min_qty = $resultsdata[$i]["prices"][5]["min_qty"];
                    $prices5_max_qty = $resultsdata[$i]["prices"][5]["max_qty"];
                    $prices5_currency = $resultsdata[$i]["prices"][5]["currency"];
                    $prices5_price = $resultsdata[$i]["prices"][5]["price"];
                    $datasheet_pdf = $resultsdata[$i]["datasheet"]["pdf"];
                    $images0 = $resultsdata[$i]["images"][0]["900x900"];
                    $images1 = $resultsdata[$i]["images"][1]["900x900"];
                    $images2 = $resultsdata[$i]["images"][2]["900x900"];
                    $rohs = $resultsdata[$i]["rohs"];
                    $description = $resultsdata[$i]["description"];
                    $isPreSale = $resultsdata[$i]["isPreSale"];

                    if ($item_id) {
                    $text = $item_id.','.$item_number.','.$category_id1.','.$category_name1.','.$category_id2.','.$category_name2.','.$manufacturer_id.',"'.$manufacturer_name.'",'.$package.',"'.$title.'",'.$mpn.','.$quantity.','.$whs_js.','.$whs_zh.','.$whs_hk.','.$moq.','.$order_multiple.','.$weight.','.$packaging.','.$sell_unit.','.$packing_num.','.$packing_unit.','.$prices0_min_qty.','.$prices0_max_qty.','.$prices0_currency.','.$prices0_price.','.$prices1_min_qty.','.$prices1_max_qty.','.$prices1_currency.','.$prices1_price.','.$prices2_min_qty.','.$prices2_max_qty.','.$prices2_currency.','.$prices2_price.','.$prices3_min_qty.','.$prices3_max_qty.','.$prices3_currency.','.$prices3_price.','.$prices4_min_qty.','.$prices4_max_qty.','.$prices4_currency.','.$prices4_price.','.$prices5_min_qty.','.$prices5_max_qty.','.$prices5_currency.','.$prices5_price.','.$datasheet_pdf.','.$images0.','.$images1.','.$images2.','.$rohs.',"'.$description.'",'.$isPreSale;
                    echo $text."<br>";
                    }

                }
                endfor;
            }
        }
        endfor;
    }
    

    public function inCode(){

        $dataRow = "500";

        for($i=1;$i <= $dataRow;$i++){
            $lcscProductItem = $this->lcscProductinfoModel->where('product_code','0')->first();
            $id = $lcscProductItem->id;
            $categorylevel2_code = $lcscProductItem->categorylevel2_code;

            $insertcount = count($this->lcscProductinfoModel->where('categorylevel2_code',$categorylevel2_code)->where('product_code !=','0')->findAll())+1;
            $product_code = "CD".$categorylevel2_code.sprintf('%06d',$insertcount);

            $this->lcscProductinfoModel->updateCategoryCode($id, $product_code);

            echo $categorylevel2_code." / ".$id." / ".$product_code."<br>";
        }
    exit;

    }


}