<?php 
namespace App\Controllers\Guest;

use App\Controllers\Guest\BaseController;
use App\Entities\Member;
use App\Helpers\ArrayHelper;
use App\Helpers\AuthHelpers;
use App\Helpers\Common\EmailHelper;
use App\Helpers\DateHelper;
use App\Helpers\NumberHelper;
use App\Models\MemberModel;
use App\Services\NaverPayService;
use App\Models\OrderPartinfoModel;

class NaverCommerceController extends BaseController
{

    protected $memberModel;
    protected $emailHelper;
    protected $naverPayService;
    protected $orderpartinfoModel;   

    public function __construct()
    {
        $this->memberModel = new MemberModel();
        $this->emailHelper = new EmailHelper();
        $this->naverPayService = new NaverPayService();
        $this->orderpartinfoModel = new OrderPartinfoModel();
    }

    public function index(){   
        echo "There is a Naver Commerce Intro.";
        exit;
        //return $this->viewGuest('naverapi/index');
    }

    /*
    주문 수집 api : https://chipdirect.co.kr/npay_api/GetOrder.php
    발주 처리 api : https://chipdirect.co.kr/npay_api/AllowOrder.php?seller_order_refer_no={order no}
    송장 연동 api : https://chipdirect.co.kr/npay_api/SetDelivery.php?seller_order_refer_no={order no}&seller_deliver_code=CH1&seller_invoice_code={invoice code}
    취소 주문 수집 api : https://chipdirect.co.kr/npay_api/GetCancel.php
    반품 주문 수집 api : https://chipdirect.co.kr/npay_api/GetReturn.php
    */

    /*
    신규주문수집 https://chipdirect.co.kr/navercommerce/ncgetorder
    발주처리(수동) https://chipdirect.co.kr/navercommerce/ncalloworder?seller_order_refer_no=2025032710080130
    발주처리(자동) https://chipdirect.co.kr/navercommerce/ncautoorder
    송장등록 https://chipdirect.co.kr/navercommerce/ncsetdelivery?seller_order_refer_no={order no}&seller_deliver_code=CH1&seller_invoice_code={invoice code}
    취소주문수집 https://chipdirect.co.kr/navercommerce/ncgetcancel
    반품주문수집 https://chipdirect.co.kr/navercommerce/ncgetreturn
    */

    /*주문 수집 api*/
    public function ncGetorder(){

        $this->naverPayService->getOrder_get();

    }

    /*발주 처리 api*/    
    public function ncAllowOrder(){

        $seller_order_refer_no = $_GET['seller_order_refer_no'];
        $this->naverPayService->allowOrder($seller_order_refer_no);

    }

     /*자동발주 처리 api*/    
    public function ncAutoOrder(){

        $npay_newinfo = $this->orderpartinfoModel->where('orderchk_flg', "0")->Like('order_type',"NAV")->select("nav_productorder_code")->findAll();
        // var_dump($npay_newinfo);
        // exit;

        foreach ($npay_newinfo as $key => $item){
            $seller_order_refer_no =  $item->nav_productorder_code;
            $this->naverPayService->allowOrder($seller_order_refer_no);
        }

    }

    /*송장 연동 apii*/
    public function ncSetDelivery(){

        // return $this->viewGuest('navercommerce/SetDelivery');
        $seller_order_refer_no = $_GET['seller_order_refer_no'];
        $seller_deliver_code = $_GET['seller_deliver_code'];
        $seller_invoice_code = $_GET['seller_invoice_code'];

        $this->naverPayService->setDelivery($seller_order_refer_no,$seller_deliver_code,$seller_invoice_code);

    }

    /*취소 주문 수집 api*/
    public function ncGetCancel(){   

        $this->naverPayService->getCancel_get();
    }

    /*반품 주문 수집 api*/
    public function ncGetReturn(){   

        $this->naverPayService->getReturn_get();

    }

}
