<?php namespace App\Controllers\Guest;

use App\Entities\MemberInquiry;
use App\Helpers\AuthHelpers;
use App\Models\AppInfoModel;
use App\Models\MemberInquiryModel;
use App\Models\NewFileModel;
use App\Models\NewModel;
use App\Models\NewCategoryModel;

class NewsController extends BaseController
{
    protected $memberInquiryModel;
    protected $newsModel;
    protected $newsFileModel;
    protected $newCategoryModel;

    public function __construct()
    {
        $this->memberInquiryModel = new MemberInquiryModel();
        $this->newsModel = new NewModel();
        $this->newsFileModel = new NewFileModel();
        $this->appInfoModel = new AppInfoModel();
        $this->newCategoryModel = new NewCategoryModel();
    }

    public function news(){
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( isset($searchInput['title']) && $searchInput['title'] != '' ) $searchInput['is_search'] = true;
        $data = $this->newsModel->getSearch($searchInput,$perPage);
        return $this->viewGuest('news/news', array_merge($data,$searchInput));
    }

    public function newsDetail($newsId){
        $item = $this->newsModel->findInfoById($newsId);
        $files = $this->newsFileModel->where('news_id',$newsId)->findAll();
        $data['item'] = $item;
        $data['files'] = $files;
        //increase hit
        $isViewSession = AuthHelpers::getSession()->get(AuthHelpers::SESSION_INCREASE_HIT_NEW);
        if(!isset($isViewSession) || (is_array($isViewSession) && !in_array($newsId, $isViewSession))){
            if(!isset($isViewSession)) $isViewSession = [];
            $isViewSession[] = $newsId;
            AuthHelpers::getSession()->set(AuthHelpers::SESSION_INCREASE_HIT_NEW, $isViewSession);
            $this->newsModel->update(['id' => $newsId], ['hit_number' => $item->hit_number + 1]);
        }
        return $this->viewGuest('news/news_detail', $data);
    }

    /*
    public function showCreate(){
        $this->rules = $this->newsModel->getValidationRules();
        $categories = $this->newCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['maxFiles'] = 10;
        return $this->viewGuest('news/news_create', $data);
    }

    public function create(){
        $this->rules = $this->newsModel->getValidationRules();
        if($this->checkValidation()){
            $accountManger = AuthHelpers::getLoginInfoAdmin();
            $this->newsService->saveNews($this->request,$accountManger->account_id);
            $message = 'Create news success.';
            return redirect()->route('guest.news.news')->with('message' , $message);
        }else{
            return $this->viewGuest('news/news_create', [
                'validator' => $this->validator
            ]);
        }
    }
    */

    public function viewFile($newsId, $fileId){
        $file = $this->newsFileModel->findNewsFile($newsId, $fileId);
        if(isset($file)){
            $pdfPath = $file->file_dir;
            $filename = "$file->file_name";
            $this->setHeaderViewFile($filename,PUBLIC_PATH . $pdfPath);
        }
        exit;
    }

}
