<?php 
namespace App\Controllers\Guest;

// use App\Entities\MemberInquiry;
use App\Entities\One2one;
use App\Helpers\AuthHelpers;
// use App\Models\AppInfoModel;
// use App\Models\MemberInquiryModel;
use App\Models\One2oneModel;
use App\Models\One2oneCategoryModel;
use App\Services\One2oneService;
use App\Helpers\FileHelper;
use App\Models\One2oneFileModel;
use App\Entities\One2oneFile;

class One2oneController extends BaseController
{
    // protected $memberInquiryModel;
    protected $one2oneModel;
    protected $one2oneFileModel;
    protected $one2oneCategoryModel;
    protected $one2oneService;

    public function __construct()
    {
        // $this->memberInquiryModel = new MemberInquiryModel();
        // $this->appInfoModel = new AppInfoModel();

        $this->one2oneModel = new One2oneModel();
        $this->one2oneFileModel = new One2oneFileModel();
        $this->one2oneCategoryModel = new One2oneCategoryModel();
        $this->one2oneService = new One2oneService();
    }

    public function validationMapFieldLabels()
    {
        return [
            'memo_content' => 'Memo'
        ];
    }

    public function index(){        
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        $searchInput['member_code'] = AuthHelpers::getLoginInfoGuest()->member_code;
        if( isset($searchInput['title']) && $searchInput['title'] != '' ) $searchInput['is_search'] = true;
        $data = $this->one2oneModel->getSearchMem($searchInput,$perPage);

        $data['situation1'] = $this->one2oneModel->getSearchMemCount($searchInput,1);
        $data['situation3'] = $this->one2oneModel->getSearchMemCount($searchInput,3);
        // var_dump ($situation1);
        // exit;

        return $this->viewGuest('one2one/index', array_merge($data,$searchInput));
    }

    public function detail($one2oneId){
        $item = $this->one2oneModel->findInfoById($one2oneId);
        $password = $item->password;

        /*
        var_dump ($password);
        echo "<br>";
        var_dump ($getpassword);
        exit;
        */

        if (!$password) {

        $files = $this->one2oneFileModel->where('one2one_id',$one2oneId)->findAll();
        $data['item'] = $item;
        $data['files'] = $files;
        //increase hit
        $isViewSession = AuthHelpers::getSession()->get(AuthHelpers::SESSION_INCREASE_HIT_ONE2ONE);
        if(!isset($isViewSession) || (is_array($isViewSession) && !in_array($one2oneId, $isViewSession))){
            if(!isset($isViewSession)) $isViewSession = [];
            $isViewSession[] = $one2oneId;
            AuthHelpers::getSession()->set(AuthHelpers::SESSION_INCREASE_HIT_ONE2ONE, $isViewSession);
            $this->one2oneModel->update(['id' => $one2oneId], ['hit_number' => $item->hit_number + 1]);
        }
        return $this->viewGuest('one2one/one2one_detail', $data);

        } else {


            session()->setFlashdata('status_text', '비밀글의 접근경로가 바르지 않습니다. 다시 확인 하시기 바랍니다.');
            return redirect()->to('/one2one')
                ->with('status_icon', 'warning')
                ->with('status', '접근경로 오류');

            //$msg = '비밀글의 접근경로가 바르지 않습니다. 다시 확인 하시기 바랍니다.';
            //echo "<script type=\"text/javascript\">alert('$msg');</script>";           
            //echo "<script type=\"text/javascript\">alert(\"$msg\");history.go(-1);</script>";

        }
    }

    public function detaillogin($one2oneId){
        $data['one2oneId'] = $one2oneId;
        // var_dump ($one2oneId);
        // var_dump ($data);
        // exit;

        return $this->viewGuest('one2one/one2one_login', $data);
    }

    public function detailpost($one2oneId){   
        $item = $this->one2oneModel->findInfoById($one2oneId);

        $password = $item->password;
        $getpassword = md5($this->request->getPost('password'));

        /*
        var_dump ($password);
        echo "<br>";
        var_dump ($getpassword);
        exit;
        */

        if ($password == $getpassword) {
            $files = $this->one2oneFileModel->where('one2one_id',$one2oneId)->findAll();
            $data['item'] = $item;
            $data['files'] = $files;
            //increase hit
            $isViewSession = AuthHelpers::getSession()->get(AuthHelpers::SESSION_INCREASE_HIT_ONE2ONE);
            if(!isset($isViewSession) || (is_array($isViewSession) && !in_array($one2oneId, $isViewSession))){
                if(!isset($isViewSession)) $isViewSession = [];
                $isViewSession[] = $one2oneId;
                AuthHelpers::getSession()->set(AuthHelpers::SESSION_INCREASE_HIT_ONE2ONE, $isViewSession);
                $this->one2oneModel->update(['id' => $one2oneId], ['hit_number' => $item->hit_number + 1]);
            }
            return $this->viewGuest('one2one/one2one_detail', $data);

        } else {

                        // To Back url page
            $refererUrl = $_SERVER['HTTP_REFERER'];

            session()->setFlashdata('status_text', '비밀번호가 없거나 일치하지 않습니다.');
            return redirect()->to($refererUrl)
                ->with('status_icon', 'warning')
                ->with('status', '비밀번호 불일치');

        }
    }

    public function showCreate(){
        $this->rules = $this->one2oneModel->getValidationRules();

        $categories = $this->one2oneCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['maxFiles'] = 10;
        // var_dump ($data);
        // exit;
        
        $account = AuthHelpers::getLoginInfoGuest();
        // var_dump ($account);
        // exit;
        $data['memberName'] = '';
        $data['memberEmail'] = '';
        $data['memberPhone'] = '';
        $data['memberCode'] = '';
        if(isset($account)){
            $data['memberName'] = $account->member_name;
            $data['memberEmail'] = $account->member_email;
            $data['memberPhone'] = $account->member_phone;
            $data['memberCode'] = $account->member_code;
        }

        return $this->viewGuest('one2one/one2one_create', $data);
    }

    public function create(){
        $this->rules = $this->one2oneModel->getValidationRules();

        if($this->checkValidation()){
            $one2one = new One2one($this->request->getPost());
            // var_dump($one2one->password);
            // exit;

            if ($one2one->password != "") {
                $one2one->password = md5($one2one->password);
            }

            $insertId = $this->one2oneModel->insert($one2one, true);

            if($insertId > 0){
                $files = $this->request->getFiles();
                // var_dump($files);
                // exit;

                if(isset($files)){
                    foreach ($files as $file){
                        $fileName = $file->getClientName();
                        if(isset($fileName) && !empty($fileName)){
                            $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_ONE2ONE, $insertId);
                            $one2oneFile = new One2oneFile([
                                'one2one_id' => esc($insertId),
                                'file_name' => esc($fileName),
                                'file_dir' => esc($filePath)
                            ]);
                            $this->one2oneFileModel->save($one2oneFile);
                        }
                    }
                }
            }
                
            $emailSubject ='[1:1 상담] 신규 1:1 상담가 도착했습니다.';
            $emailtMessage = '사이트에 새로운 1:1 상담가 도착했습니다.<br>관리자 페이지에서 1:1 상담 내용을 확인하세요.<br>감사합니다.';

            $this->toEmail($emailSubject, $emailtMessage);

            $message = 'Create one2one success.';
            return redirect()->route('guest.one2one')->with('message' , $message);
        }else{
            return $this->viewGuest('one2one/one2one_create', [
                'validator' => $this->validator
            ]);
        }

    }

    public function showUpdate($id){
        $this->rules = $this->one2oneModel->getValidationRules();
        $one2oneItem = $this->one2oneModel->find($id);
        $files = $this->one2oneFileModel->where('one2one_id',$id)->findAll();
        $categories = $this->one2oneCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['item'] = $one2oneItem;
        $data['files'] = $files;
        $data['maxFiles'] = 10 - count($files);
        // var_dump($data);
        // exit;

        return $this->viewGuest('one2one/update', $data);
    }

    public function update($id){
        $this->rules = $this->one2oneModel->getValidationRules();

        if($this->checkValidation()){
            // $this->one2oneService->updateOne2one($id,$this->request);
            $one2oneItem = $this->one2oneModel->find($id);

            if(isset($one2oneItem)){
                $inputs = $this->request->getPost();

                $inputs['public_flg'] = get_public_id($inputs['public_flg']);
                $one2oneItem->fill($inputs);

                //var_dump($one2oneItem);
                //exit;

                $this->one2oneModel->save($one2oneItem);
                $files = $this->request->getFiles();
                // var_dump($files);
                // exit;

                if(isset($files)){
                    foreach ($files as $file){
                        $fileName = $file->getClientName();
                        if(isset($fileName) && !empty($fileName)){
                            $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_ONE2ONE, $insertId);
                            $one2oneFile = new One2oneFile([
                                'one2one_id' => esc($id),
                                'file_name' => esc($fileName),
                                'file_dir' => esc($filePath)
                            ]);
                            $this->one2oneFileModel->save($one2oneFile);
                        }
                    }
                }

            }


            $message = "Update one2one success";
            return redirect()->route('guest.one2one')->with('message',$message);
        }else{
            return view('one2one/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteNews($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->one2oneService->deleteNews($ids);
            if($result) $message = "Delete one2one success";
        }
        return redirect()->route('guest.one2one')->with('message',$message);
    }

    public function deleteFile($one2oneId,$fileNo){
        $this->one2oneFileModel->delete($fileNo);
        $message = "Delete file success";
        return redirect()->route('guest.one2one.update',[$one2oneId])->with('message',$message);;
    }

    public function viewFile($one2oneId, $fileId){
        $file = $this->one2oneFileModel->findOne2oneFile($one2oneId, $fileId);
        if(isset($file)){
            $pdfPath = $file->file_dir;
            $filename = "$file->file_name";
            $this->setHeaderViewFile($filename,PUBLIC_PATH . $pdfPath);
        }
        exit;
    }

    public function toEmail($emailSubject, $emailtMessage) {

        $email = \Config\Services::email();
        
        $config['protocol'] = 'html';
        $config['mailPath'] = '/usr/sbin/sendmail -t -i';
        $config['fromEmail'] = 'chipdirectmall@gmail.com';
        $config['fromName'] = 'ChipDirect';

        $email->initialize($config);
        $email->setFrom('chip@selpasemicom.com', 'ChipDirect');
        $email->setTo('chip@selpasemicom.com, pixel@mediain.co.kr');
        $email->setSubject($emailSubject);
        $email->setMessage($emailtMessage);
        $email->send();

    }
}
