<?php 
namespace App\Controllers\Guest;

use App\Entities\OrderInfo;
use App\Helpers\AuthHelpers;
use App\Models\OrderInfoModel;
use App\Models\OrderPartinfoModel;
use App\Services\OrderInfoService;
use App\Helpers\FileHelper;
use App\Models\ProductModel;
use App\Models\StocklocationCategoryModel;
use App\Models\OrderStatusModel;
use App\Models\ShippingCompanyModel;
use App\Entities\RefundInfo;
use App\Entities\RefundPartinfo;
use App\Models\RefundInfoModel;
use App\Models\RefundPartinfoModel;
use App\Services\RefundInfoService;


class OrderInfoController extends BaseController
{
    protected $orderInfoModel;
    protected $orderPartinfoModel;
    protected $orderInfoService;
    private $productModel;
    protected $stocklocationCategoryModel;
    protected $orderStatusModel;
    protected $shippingCompanyModel;
    protected $refundInfoModel;
    protected $refundPartinfoModel;
    protected $refundInfoService;

    public function __construct()
    {
        $this->orderInfoModel = new OrderInfoModel();
        $this->orderPartinfoModel = new OrderPartinfoModel();
        $this->orderInfoService = new OrderInfoService();
        $this->productModel = new ProductModel();
        $this->stocklocationCategoryModel = new StocklocationCategoryModel();
        $this->orderStatusModel = new OrderStatusModel();
        $this->shippingCompanyModel = new ShippingCompanyModel();
        $this->refundInfoModel = new RefundInfoModel();
        $this->refundPartinfoModel = new RefundPartinfoModel();
    }

    /*
    public function validationMapFieldLabels()
    {
        return [
            'memo_content' => 'Memo'
        ];
    }
    */

    public function index(){        
        $perPage = $this->request->getGet('perpage');
        $condition = $this->request->getGet();
        $condition['member_code'] = AuthHelpers::getLoginInfoGuest()->member_code;
        //var_dump ($member_code);
        //exit;

        if( isset($condition['order_code']) && $condition['order_code'] != '' ) $condition['is_search'] = true;
        $data = $this->orderInfoModel->getSearchMem($condition,$perPage);
        $data['orderstatus'] = $this->orderStatusModel->findAll();
        // var_dump ($data['lists']);
        // exit;

        return $this->viewGuest('orderinfo/index', array_merge($data,$condition));
    }

    public function findOrder(){
        $this->rules = [
            'order_code' => 'required',
            'order_email' => 'required'
        ];
        if( $this->checkValidation() ){
            $order_code = $this->request->getVar('order_code');
            $order_email = $this->request->getVar('order_email');

            $finddata = $this->orderInfoModel->findOrder($order_code,$order_email);
            $orderInfoId = $finddata->info_id;

            return redirect()->route('guest.orderinfo.detail',[$orderInfoId])->withInput();
        }else{
            return redirect('guest.orderinfo')->withInput();
        }
    }

    public function detail($orderInfoId){
        $orderInfo = $this->orderInfoModel->findInfoById($orderInfoId);
        $order_code = $orderInfo->order_code;
        //var_dump($orderInfo->member_code);

        $member_code = AuthHelpers::getLoginInfoGuest()->member_code;
        //var_dump ($member_code);

        $data = $this->orderPartinfoModel->getPartinfo($order_code);
        $lists = $data['lists'];
        //var_dump($lists);
        //exit;

        foreach ($lists as $key => $item){
            $part_sequence =  $item->item_code;
            //echo $key." : ".$part_sequence."<br>";
 
            $now_product_info = $this->productModel->findByProductInfo($part_sequence);
 
            $nowinfo = [
             'product_code'   => $now_product_info ->product_code,
             'part_number' => $now_product_info ->part_number,
             'image_dir'   => $now_product_info ->image_dir,
             'api_flg'   => $now_product_info ->api_flg,
             'selling_price1' => $now_product_info ->selling_price1,
             'part_number_sequence' => $now_product_info ->part_number_sequence,
             'brief_description' => $now_product_info ->brief_description,
             'product_related' => $now_product_info ->product_related,
             'stock_location' => $now_product_info ->stock_location,
             'delivery_code' => $now_product_info ->delivery_code
         ];
 
            $lists[$key]->nowinfo = $nowinfo;
        }
 
        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
        $data['orderstatus'] = $this->orderStatusModel->findAll();
        $data['shippingcompany'] = $this->shippingCompanyModel->findAll();
        $data['orderInfo'] = $orderInfo;
        
       //var_dump($data['lists']);
       //var_dump($data['orderInfo']);
       //exit;

        return $this->viewGuest('orderinfo/detail', $data);
    }

    
    public function printOrderinfo($orderInfoId){
        $orderInfo = $this->orderInfoModel->findInfoById($orderInfoId);
        $order_code = $orderInfo->order_code;
        //var_dump($orderInfo->member_code);

        $member_code = AuthHelpers::getLoginInfoGuest()->member_code;
        //var_dump ($member_code);

        $data = $this->orderPartinfoModel->getPartinfo($order_code);
        $lists = $data['lists'];
        //var_dump($lists);
        //exit;

        foreach ($lists as $key => $item){
            $part_sequence =  $item->item_code;
            //echo $key." : ".$part_sequence."<br>";
 
            $now_product_info = $this->productModel->findByProductInfo($part_sequence);
 
            $nowinfo = [
             'product_code'   => $now_product_info ->product_code,
             'part_number' => $now_product_info ->part_number,
             'image_dir'   => $now_product_info ->image_dir,
             'api_flg'   => $now_product_info ->api_flg,
             'selling_price1' => $now_product_info ->selling_price1,
             'part_number_sequence' => $now_product_info ->part_number_sequence,
             'brief_description' => $now_product_info ->brief_description,
             'product_related' => $now_product_info ->product_related,
             'stock_location' => $now_product_info ->stock_location,
             'delivery_code' => $now_product_info ->delivery_code
         ];
 
            $lists[$key]->nowinfo = $nowinfo;
        }
 
        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
        $data['orderstatus'] = $this->orderStatusModel->findAll();
        $data['shippingcompany'] = $this->shippingCompanyModel->findAll();
        $data['orderInfo'] = $orderInfo;
        
       //var_dump($data['lists']);
       //var_dump($data['orderInfo']);
       //exit;

        return $this->viewGuest('orderinfo/printorderinfo', $data);
    }

        
    public function mailOrderinfo(){
        $username = $this->request->getPost("orderer_name");
        $useremail = $this->request->getPost("orderer_email");
        $orderinfomessage = $this->request->getPost("orderinfomessage");

        $email = \Config\Services::email();

        $config['protocol'] = 'html';
        $config['mailPath'] = '/usr/sbin/sendmail -t -i';
        $config['fromEmail'] = 'kyungyeon.jung@gmail.com';
        $config['fromName'] = 'ChipDirect';

        $email->initialize($config);
        $email->setFrom('pixel@mediain.co.kr', 'ChipDirect');
        $email->setTo($useremail);
        $email->setSubject('[거래명세서정보]'. $username .'님이 요청하신 거래명세서정보입니다.');
        $email->setMessage($username .'님이 요청하신 저희 칩다이렉트의 거래명세서정보입니다.<br>'. $orderinfomessage);

        if($email->send(false)){
            echo "<!DOCTYPE html><html lang='ko'>
                <head>
                    <meta charset='UTF-8'>
                    <meta http-equiv='X-UA-Compatible' content='IE=edge'>
                    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
                    <title>거래명세서가 메일로 전달</title>
                </head><body>
                    <div>
                        <p>거래명세서가 메일로 전달했습니다.</p>
                    </div>
                    <div>
                        <button onclick='closeTabClick()'>확인</button>
                    </div>
                    <script>
                        function newTabClick() {
                            window.open('new-tab.html', '_blank');
                        }
                        function closeTabClick() {
                            window.close();
                        }
                    </script>
                </body></html>";
        }else{
            echo "<!DOCTYPE html><html lang='ko'>
            <head>
                <meta charset='UTF-8'>
                <meta http-equiv='X-UA-Compatible' content='IE=edge'>
                <meta name='viewport' content='width=device-width, initial-scale=1.0'>
                <title>거래명세서가 메일로 전달</title>
            </head><body>
                <div>
                    <p>메일 전송에 문제가 있습니다.</p>
                </div>
                <div>
                    <button onclick='closeTabClick()'>확인인</button>
                </div>
                <script>
                    function newTabClick() {
                        window.open('new-tab.html', '_blank');
                    }
                    function closeTabClick() {
                        window.close();
                    }
                </script>
            </body></html>";
        }
    }

    /*
    public function stateChange(){        
        $day_7ago = date('Y-m-d h:i:s', strtotime('-7 Day'));
        $this->orderPartinfoModel->autoStateChange05($day_7ago);
        $this->orderPartinfoModel->autoStateChange06($day_7ago);
        exit;
    }
    */

    public function toRefund(){
        $order_code = $this->request->getPost('order_code');
        $order_data = $this->refundInfoModel->findByOrderCode($order_code);
        $refundinfo_id = $order_data->info_id;

        if ($refundinfo_id) {

            return redirect()->route('guest.refundinfo.show_create',[$refundinfo_id]);

        } else {

            $dataRow = $this->request->getPost('item_counts') + '1';

            $refundPartinfo = new RefundPartinfo();

            for($i=1;$i < $dataRow; $i++):
                $refundPartinfo->refund_code = $this->request->getPost('refund_code');
                $refundPartinfo->order_id = $this->request->getPost('order_id'.$i);
                
                $order_code = $this->request->getPost('order_code'.$i);
                $refundPartinfo->order_code = $order_code;

                $refundPartinfo->item_code = $this->request->getPost('item_code'.$i);
                $refundPartinfo->category3_code = $this->request->getPost('category3_code'.$i);
                $refundPartinfo->part_number = $this->request->getPost('part_number'.$i);
                $refundPartinfo->manufacturer_name = $this->request->getPost('manufacturer_name'.$i);
                $refundPartinfo->qty = $this->request->getPost('qty'.$i);
                $refundPartinfo->price = $this->request->getPost('price'.$i);
                $refundPartinfo->supply_price = $this->request->getPost('supply_price'.$i);
                $refundPartinfo->vat = $this->request->getPost('vat'.$i);
                $refundPartinfo->amount = $this->request->getPost('amount'.$i);
                $refundPartinfo->stock_location = $this->request->getPost('stock_location'.$i);
                $refundPartinfo->delivery_code = $this->request->getPost('delivery_code'.$i);

                $itemCheck = $this->request->getPost('chk'.$i);

                $qty = $refundPartinfo->qty;
                $order_id = $refundPartinfo->order_id;
                $order_code = $refundPartinfo->order_code;

                if ($itemCheck == 'active') {
                    $insertId = $this->refundPartinfoModel->save($refundPartinfo, true);

                    if ($insertId) {
                        $this->orderPartinfoModel->updateStatusId($order_id, '12');
                    }
                }
            endfor;

            $refund_code = $this->request->getPost('refund_code');

            $partData = $this->refundPartinfoModel->getPartinfo($refund_code);
            $itemCount = count($partData['lists']);

            if ($itemCount == 0) {
                $refererUrl = $_SERVER['HTTP_REFERER'];
                session()->setFlashdata('status_text', '반품하실 상품을 체크해 주시기 바랍니다.');
                return redirect()->to($refererUrl)
                    ->with('status_icon', 'warning')
                    ->with('status', '반품할 상품이 없습니다');
            }
            // var_dump($itemCount);
            // exit;

            // Create Refund
            $refundInfo = new RefundInfo();

            $refundInfo->refund_code = $refund_code;
            // $refundInfo->refund_code = $this->request->getPost('refund_code');

            // $refundInfo->refund_type = $this->request->getPost('');
            // $refundInfo->return_status = $this->request->getPost('');
            // $refundInfo->refund_status = $this->request->getPost('');
            // $refundInfo->return_shipping = $this->request->getPost('');
            // $refundInfo->return_zipocode = $this->request->getPost('');
            // $refundInfo->return_add1 = $this->request->getPost('');
            // $refundInfo->return_add2 = $this->request->getPost('');

            $refundInfo->order_code = $this->request->getPost('order_code');
            $refundInfo->order_status = $this->request->getPost('order_status');
            $refundInfo->member_code = $this->request->getPost('member_code');
            $refundInfo->orderer_name = $this->request->getPost('orderer_name');
            $refundInfo->orderer_email = $this->request->getPost('orderer_email');
            $refundInfo->orderer_phone = $this->request->getPost('orderer_phone');
            // $refundInfo->shipping_recipient = $this->request->getPost('');
            $refundInfo->shipping_name = $this->request->getPost('shipping_name');
            $refundInfo->delivery_phone = $this->request->getPost('delivery_phone');
            $refundInfo->shipping_phone = $this->request->getPost('shipping_phone');
            $refundInfo->company_name = $this->request->getPost('company_name');
            $refundInfo->shipping_zipocode = $this->request->getPost('shipping_zipocode');
            $refundInfo->shipping_add1 = $this->request->getPost('shipping_add1');
            $refundInfo->shipping_add2 = $this->request->getPost('shipping_add2');
            $refundInfo->shipping_message = $this->request->getPost('shipping_message');


            // $refundInfo->notice = $this->request->getPost('');
            // $refundInfo->content = $this->request->getPost('');
            // $refundInfo->answer_content = $this->request->getPost('');
            $refundInfo->firstitem_code = $this->request->getPost('firstitem_code');
            $refundInfo->firstitem_number = $this->request->getPost('firstitem_number');
            $refundInfo->firstitem_image = $this->request->getPost('firstitem_image');
            $refundInfo->item_counts = $this->request->getPost('item_counts');
            $refundInfo->supply_price = $this->request->getPost('upply_price');
            $refundInfo->vat = $this->request->getPost('vat');
            $refundInfo->amount_total = $this->request->getPost('amount_total');
            $refundInfo->delivery_fee = $this->request->getPost('delivery_fee');
            $refundInfo->change_flg = $this->request->getPost('change_flg');
            $refundInfo->refund_flg = $this->request->getPost('refund_flg');
            // $refundInfo->payment_date = $this->request->getPost('');
            $refundInfo->payment_flg = $this->request->getPost('payment_flg');
            $refundInfo->deposit_name = $this->request->getPost('deposit_name');
            $refundInfo->deposit_bank = $this->request->getPost('deposit_bank');

            /*
            $refundInfo->deposit_date = $this->request->getPost('deposit_date');
            $refundInfo->resultCode = $this->request->getPost('resultCode');
            $refundInfo->resultMsg = $this->request->getPost('resultMsg');
            $refundInfo->tid = $this->request->getPost('tid');
            $refundInfo->MOID = $this->request->getPost('MOID');
            $refundInfo->TotPrice = $this->request->getPost('TotPrice');
            $refundInfo->goodName = $this->request->getPost('goodName');
            $refundInfo->applDate = $this->request->getPost('applDate');
            $refundInfo->applTime = $this->request->getPost('applTime');
            $refundInfo->payMethod = $this->request->getPost('payMethod');
            $refundInfo->applNum = $this->request->getPost('applNum');
            $refundInfo->P_FN_NM = $this->request->getPost('P_FN_NM');
            $refundInfo->VACT_Num = $this->request->getPost('VACT_Num');
            $refundInfo->VACT_BankCode = $this->request->getPost('VACT_BankCode');
            $refundInfo->vactBankName = $this->request->getPost('vactBankName');
            $refundInfo->VACT_Date = $this->request->getPost('VACT_Date');
            $refundInfo->payDevice = $this->request->getPost('payDevice');
            */

            // $refundInfo->sales_proof_flg = $this->request->getPost('sales_proof_flg');
            // $refundInfo->amount_payment = $this->request->getPost('amount_payment');


            // var_dump($refundInfo);
            $refundId = $this->refundInfoModel->save($refundInfo, true);
            // var_dump($refundId);
            // exit;

            $orderInfo = $this->orderInfoModel->findInfoById($orderInfoId);

            if ($refundId == 'true') {
                // $refund_code = $this->request->getPost('refund_code');
                $refundInfo = $this->refundInfoModel->findByRefundCode($refund_code);

                $id = $refundInfo->info_id;
                return redirect()->route('guest.refundinfo.show_create',[$id]);
            }

        }

    }


    public function modify(){
        $order = new orderInfo($this->request->getPost());
        
        $orderId = $this->orderInfoModel->save($order, true);
        $orderInfoId = $this->request->getPost('info_id');
        return redirect()->route('guest.orderinfo.detail',[$orderInfoId]);

    }

}
