<?php 
namespace App\Controllers\Guest;

use App\Controllers\Guest\BaseController;
use App\Entities\Member;
use App\Entities\ExchangeInfo;
use App\Helpers\FileHelper;
use App\Helpers\ArrayHelper;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Helpers\NumberHelper;
use App\Models\MemberModel;
use App\Models\ExchangeInfoModel;
use App\Models\ProductModel;
use App\Models\ApiPndataModel;
use App\Models\ApiPnDetaildataModel;
use App\Entities\ApiProductdetail;
use App\Models\ApiProductdetailModel;
use App\Entities\ApiProductinfo;
use App\Models\ApiProductinfoModel;
use App\Models\ApiDatalogsModel;
use App\Services\ApiDatalogsService;

use Config\Services;


class ProductApiController extends BaseController
{

    protected $memberModel;
    protected $exchangeInfoModel;
    protected $productModel;
    protected $apiPndataModel;
    protected $apiPnDetaildataModel;
    protected $apiProductdetailModel;
    protected $apiProductinfoModel;
    protected $apiDatalogsModel;
    protected $apiDatalogsService;

    public function __construct()
    {
        $this->memberModel = new MemberModel();
        $this->exchangeInfoModel = new ExchangeInfoModel();
        $this->productModel = new ProductModel();
        $this->apiPndataModel = new ApiPndataModel();
        $this->apiPnDetaildataModel = new ApiPnDetaildataModel();
        $this->apiProductdetailModel = new ApiProductdetailModel();
        $this->apiProductinfoModel = new ApiProductinfoModel();
        $this->apiDatalogsModel = new ApiDatalogsModel();
        $this->apiDatalogsService = new ApiDatalogsService();
    }



    public function index(){

        // $incount = "3500";
        $incount = "50"; // test
        $api_code = "RS";
        $rsApiIds = $this->apiPndataModel->getRsApiId($api_code);
        
        // var_dump (count($rsApiIds));
        // exit;

        if (count($rsApiIds) > 0) {

            $ExchangeRat = $this->exchangeRat();
            $exchange_rat = $ExchangeRat["standard_amount"];

            foreach ($rsApiIds as $key => $itemId):
    
                 if  ($incount > $key) {
                    $api_partnumber = $itemId->api_partnumber;
                    fopen('https://chipdirect.co.kr/productapi/rsproductapi?pn='.$api_partnumber.'&exr='.$exchange_rat , 'r');
                    // fopen('http://rnd.chipdirect.co.kr/productapi/rsproductapi?pn='.$api_partnumber.'&exr='.$exchange_rat , 'r');
                    // fopen('https://chipdirect.co.kr/productapi/rsproductapi?pn='.$api_partnumber.'&exr='.$exchange_rat , 'r');
                 }
    
            endforeach;
     
            // $this->apiProductinfoModel->updateProducts();
            // $this->apiProductinfoModel->truncate();
            
        } else {

            $count_tmp = $this->apiProductinfoModel->insertPndata();

            // $incount = "3500";
            $incount = "50"; // test
            $api_code = "RS";
            $rsApiIds = $this->apiPndataModel->getRsApiId($api_code);
            
            $ExchangeRat = $this->exchangeRat();
            $exchange_rat = $ExchangeRat["standard_amount"];

            foreach ($rsApiIds as $key => $itemId):
    
                 if  ($incount > $key) {
                    $api_partnumber = $itemId->api_partnumber;
                    fopen('https://chipdirect.co.kr/productapi/rsproductapi?pn='.$api_partnumber.'&exr='.$exchange_rat , 'r');
                    //fopen('http://rnd.chipdirect.co.kr/productapi/rsproductapi?pn='.$api_partnumber.'&exr='.$exchange_rat , 'r');
                    //fopen('https://chipdirect.co.kr/productapi/rsproductapi?pn='.$api_partnumber.'&exr='.$exchange_rat , 'r');
                 }
    
            endforeach;
     
            // $this->apiProductinfoModel->updateProducts();
            // $this->apiProductinfoModel->truncate();

        }

        exit;
    }


    public function exchangeRat(){

        // $url = 'https://v6.exchangerate-api.com/v6/c8b12ee70053da2aeacac2f6/latest/HKD';
        $url = 'https://v6.exchangerate-api.com/v6/c8b12ee70053da2aeacac2f6/latest/USD';
        
        $headers[] = 'Accept: application/json';
        $headers[] = 'Cache-Control: no-cache';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);

        $jsonExchange = json_decode($response,true);
        //var_dump($jsonExchange);
        //exit;

        $standard_amount = round($jsonExchange["conversion_rates"]["KRW"], 2); 
        $counrty_code = $jsonExchange["base_code"];

        $exchangeInfo = new ExchangeInfo;
        $exchangeInfo = [
            'counrty_code'       => $counrty_code,
            'standard_amount'    => $standard_amount,
            'del_flg' => 0
        ];

        $this->exchangeInfoModel->save($exchangeInfo);
        return $exchangeInfo;
    }

    public function rsProductApi(){   

        $pn = $_GET["pn"];
        $exchange_rat = $_GET["exr"];
        $api_code = "RS";
        $stock_counrty = "GB";
        $price_counrty = "HK";


        $url = 'https://services-json.electrocomponents.com/service/ProductStockService/v01_00/JSON/Location/COUNTRY_CODE/'.$stock_counrty.'/ProductStocks?ProductNumber='.$pn;
        $headers[] = 'Authorization: Basic bXV3b25hcHBsaWNhdGlvbl92MV8wLXVzZXI6TVUkcG4wOSR4Jg==';
        $headers[] = 'Accept: application/json';
        $headers[] = 'Cache-Control: no-cache';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);

        $jsonStock = json_decode($response,true);
        $stock = $jsonStock["GetProductStocksResp"]["ProductStockCollection"] ["ProductStock"][0]["Quantity"];

        $url_price = 'https://services-json.electrocomponents.com/service/ProductPriceService/v01_00/JSON/Location/COUNTRY_CODE/'.$price_counrty.'/Timezone/UTC+0/ProductPrices?ProductNumber='.$pn;

        $ch_price = curl_init();
        curl_setopt($ch_price, CURLOPT_URL, $url_price);
        curl_setopt($ch_price, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch_price, CURLOPT_RETURNTRANSFER, true);
        $price = curl_exec($ch_price);
        curl_close($ch_price);

        $jsonPrice = json_decode($price,true);

        $BreakPrice = $jsonPrice["GetProductPricesResp"]["ProductPriceCollection"]["ProductPrice"][0]["CatalogueBreakPriceCollection"]["BreakPrice"];

        if ($BreakPrice[0]["PriceNoTax"]) {
            $apiprice['mini_quantity1'] = $BreakPrice[0]["Quantity"];
            $apiprice['price1'] = round($BreakPrice[0]["PriceNoTax"]*$exchange_rat);
        }else{
            $apiprice['mini_quantity1'] = 0;
            $apiprice['price1'] = 0;
        }

        if ($BreakPrice[1]["PriceNoTax"]) {
            $apiprice['max_quantity1'] = $BreakPrice[1]["Quantity"]-1;
            $apiprice['mini_quantity2'] = $BreakPrice[1]["Quantity"];
            $apiprice['price2'] = round($BreakPrice[1]["PriceNoTax"]*$exchange_rat);
        }else{
            $apiprice['max_quantity1'] = 0;
            $apiprice['mini_quantity2'] = 0;
            $apiprice['price2'] = 0;
        }

        if ($BreakPrice[2]["PriceNoTax"]) {
            $apiprice['max_quantity2'] = $BreakPrice[2]["Quantity"]-1;
            $apiprice['mini_quantity3'] = $BreakPrice[2]["Quantity"];
            $apiprice['price3'] = round($BreakPrice[2]["PriceNoTax"]*$exchange_rat);
        }else{
            $apiprice['max_quantity2'] = 0;
            $apiprice['mini_quantity3'] = 0;
            $apiprice['price3'] = 0;
        }

        if ($BreakPrice[3]["PriceNoTax"]) {
            $apiprice['max_quantity3'] = $BreakPrice[3]["Quantity"]-1;
            $apiprice['mini_quantity4'] = $BreakPrice[3]["Quantity"];
            $apiprice['price4'] = round($BreakPrice[3]["PriceNoTax"]*$exchange_rat);
        }else{
            $apiprice['max_quantity3'] = 0;
            $apiprice['mini_quantity4'] = 0;
            $apiprice['price4'] = 0;
        }

        if ($BreakPrice[4]["PriceNoTax"]) {
            $apiprice['max_quantity4'] = $BreakPrice[4]["Quantity"]-1;
            $apiprice['mini_quantity5'] = $BreakPrice[4]["Quantity"];
            $apiprice['price5'] = round($BreakPrice[4]["PriceNoTax"]*$exchange_rat);
        }else{
            $apiprice['max_quantity4'] = 0;
            $apiprice['mini_quantity5'] = 0;
            $apiprice['price5'] = 0;
        }

        if ($BreakPrice[5]["PriceNoTax"]) {
            $apiprice['max_quantity5'] = $BreakPrice[5]["Quantity"]-1;
            $apiprice['mini_quantity6'] = $BreakPrice[5]["Quantity"];
            $apiprice['price6'] = round($BreakPrice[5]["PriceNoTax"]*$exchange_rat);
            $apiprice['max_quantity6'] = 0;
        }else{
            $apiprice['max_quantity5'] = 0;
            $apiprice['mini_quantity6'] = 0;
            $apiprice['price6'] = 0;
            $apiprice['max_quantity6'] = 0;
        }

        $apiProductinfo = new ApiProductinfo;

        $apiProductinfo = [
            'api_code'          => $api_code,
            'api_partnumber'    => $pn,
            'stock'            =>  $stock,
            'price1'            => $apiprice['price1'],
            'mini_qty1'         => $apiprice['mini_quantity1'],
            'max_qty1'          => $apiprice['max_quantity1'],
            'price2'            => $apiprice['price2'],
            'mini_qty2'         => $apiprice['mini_quantity2'],
            'max_qty2'          => $apiprice['max_quantity2'],
            'price3'            => $apiprice['price3'],
            'mini_qty3'         => $apiprice['mini_quantity3'],
            'max_qty3'          => $apiprice['max_quantity3'],
            'price4'            => $apiprice['price4'],
            'mini_qty4'         => $apiprice['mini_quantity4'],
            'max_qty4'          => $apiprice['max_quantity4'],
            'price5'            => $apiprice['price5'],
            'mini_qty5'         => $apiprice['mini_quantity5'],
            'max_qty5'          => $apiprice['max_quantity5'],
            'price6'            => $apiprice['price6'],
            'mini_qty6'         => $apiprice['mini_quantity6'],
            'max_qty6'          => $apiprice['max_quantity6'],
            'del_flg' => 0
        ];

        //var_dump ($apiProductinfo);
        //exit;

        $this->apiProductinfoModel->save($apiProductinfo);
        $this->apiPndataModel->updateActiveFlg($pn);

    }


    public function apiToTxt(){
        // https://chipdirect.co.kr/productapi/apitotxt
        // UPDATE `api_pndata` SET `active_flg` = '0';

        $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
        $pathFile = FileHelper::FOLDER_PATCH_API_TOTEXT;
        $filepath = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';

        $result=opendir($filepath);

        while($file=readdir($result)) {
           if($file=="."||$file=="..") {continue;}
           $fileInfo = pathinfo($file);
           $fileExt = $fileInfo['extension'];
      
           If (empty($fileExt)){
              $dir_count++;
           } else {
              $file_count++;
           }
         }
        // echo"디렉토리 갯수는:".$dir_count."<br>";
        // echo"파일의 갯수는:".$file_count;
        // exit;

        $filenum = $file_count+1;

        //$incount = "3500";
        $incount = "50"; // test
        $api_code = "RS";

        $rsApiIds = $this->apiPndataModel->getRsApiId($api_code);

        if (count($rsApiIds) > 0) {
            $ExchangeRat = $this->exchangeRat();
            $exchange_rat = $ExchangeRat["standard_amount"];

            foreach ($rsApiIds as $key => $itemId):
    
                 if  ($incount > $key) {
                    $api_partnumber = $itemId->api_partnumber;
                    fopen('https://chipdirect.co.kr/productapi/rsapitotext?pn='.$api_partnumber.'&exr='.$exchange_rat.'&filenum='.$filenum , 'r');
                    //fopen('http://rnd.chipdirect.co.kr/productapi/rsapitotext?pn='.$api_partnumber.'&exr='.$exchange_rat.'&filenum='.$filenum , 'r');
                    //fopen('https://chipdirect.co.kr/productapi/rsapitotext?pn='.$api_partnumber.'&exr='.$exchange_rat.'&filenum='.$filenum , 'r');
                 }
    
            endforeach;

        } else {
            $this->apiProductinfoModel->insertPndata();
            $rsApiIds = $this->apiPndataModel->getRsApiId($api_code);
            $ExchangeRat = $this->exchangeRat();
            $exchange_rat = $ExchangeRat["standard_amount"];

            foreach ($rsApiIds as $key => $itemId):
    
                 if  ($incount > $key) {
                    $api_partnumber = $itemId->api_partnumber;
                    fopen('https://chipdirect.co.kr/productapi/rsapitotext?pn='.$api_partnumber.'&exr='.$exchange_rat.'&filenum='.$filenum , 'r');
                    //fopen('http://rnd.chipdirect.co.kr/productapi/rsapitotext?pn='.$api_partnumber.'&exr='.$exchange_rat.'&filenum='.$filenum , 'r');
                    //fopen('https://chipdirect.co.kr/productapi/rsapitotext?pn='.$api_partnumber.'&exr='.$exchange_rat.'&filenum='.$filenum , 'r');
                 }
    
            endforeach;
        }

        exit;
    }

    
    public function rsApiToText(){   

        $pn = $_GET["pn"];
        $exchange_rat = $_GET["exr"];
        $filenum = $_GET["filenum"];
        $api_code = "RS";
        $stock_counrty = "GB";
        $price_counrty = "HK";

        $stock = "0";
        $price1 = "0";
        $mini_quantity1 = "0";
        $max_quantity1 = "0";
        $price2 = "0";
        $mini_quantity2 = "0";
        $max_quantity2 = "0";
        $price3 = "0";
        $mini_quantity3 = "0";
        $max_quantity3 = "0";
        $price4 = "0";
        $mini_quantity4 = "0";
        $max_quantity4 = "0";
        $price5 = "0";
        $mini_quantity5 = "0";
        $max_quantity5 = "0";
        $price6 = "0";
        $mini_quantity6 = "0";
        $max_quantity6 = "0";


        $url = 'https://services-json.electrocomponents.com/service/ProductStockService/v01_00/JSON/Location/COUNTRY_CODE/'.$stock_counrty.'/ProductStocks?ProductNumber='.$pn;
        $headers[] = 'Authorization: Basic bXV3b25hcHBsaWNhdGlvbl92MV8wLXVzZXI6TVUkcG4wOSR4Jg==';
        $headers[] = 'Accept: application/json';
        $headers[] = 'Cache-Control: no-cache';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);

        $jsonStock = json_decode($response,true);
        $stock = $jsonStock["GetProductStocksResp"]["ProductStockCollection"] ["ProductStock"][0]["Quantity"];

        $url_price = 'https://services-json.electrocomponents.com/service/ProductPriceService/v01_00/JSON/Location/COUNTRY_CODE/'.$price_counrty.'/Timezone/UTC+0/ProductPrices?ProductNumber='.$pn;
        $ch_price = curl_init();
        curl_setopt($ch_price, CURLOPT_URL, $url_price);
        curl_setopt($ch_price, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch_price, CURLOPT_RETURNTRANSFER, true);
        $price = curl_exec($ch_price);
        curl_close($ch_price);

        $jsonPrice = json_decode($price,true);

        // $ProductNumber = $jsonPrice["GetProductPricesResp"]["ProductPriceCollection"]["ProductPrice"][0]["ProductNumber"];
        $BaseUOM = $jsonPrice["GetProductPricesResp"]["ProductPriceCollection"]["ProductPrice"][0]["BaseUOM"];
        $SalesUOM = $jsonPrice["GetProductPricesResp"]["ProductPriceCollection"]["ProductPrice"][0]["SalesUOM"];
        // $CurrencyCode = $jsonPrice["GetProductPricesResp"]["ProductPriceCollection"]["ProductPrice"][0]["CurrencyCode"];
        $PackSize = $jsonPrice["GetProductPricesResp"]["ProductPriceCollection"]["ProductPrice"][0]["PackSize"];
        $InMOQ = $jsonPrice["GetProductPricesResp"]["ProductPriceCollection"]["ProductPrice"][0]["MOQ"];

        if ($InMOQ > $PackSize) {
            $MOQ = $InMOQ;
        } else {
            $MOQ = $PackSize;
        }

        $BreakPrice = $jsonPrice["GetProductPricesResp"]["ProductPriceCollection"]["ProductPrice"][0]["CatalogueBreakPriceCollection"]["BreakPrice"];

        if ($BreakPrice[0]["Quantity"] > 0) {
            $mini_quantity1 = $BreakPrice[0]["Quantity"];
            }
            $basic_price1 = round($BreakPrice[0]["PriceNoTax"]*$exchange_rat);
            $price1 = round($basic_price1-round($basic_price1*0.09));

            if ($BreakPrice[1]["Quantity"] > 0) {
            $max_quantity1 = $BreakPrice[1]["Quantity"]-1;
            $mini_quantity2 = $BreakPrice[1]["Quantity"];
            }
            $basic_price2 = round($BreakPrice[1]["PriceNoTax"]*$exchange_rat);
            $price2 = round($basic_price2-round($basic_price2*0.09));

            if ($BreakPrice[2]["Quantity"] > 0) {
            $max_quantity2 = $BreakPrice[2]["Quantity"]-1;
            $mini_quantity3 = $BreakPrice[2]["Quantity"];
            }
            $basic_price3 = round($BreakPrice[2]["PriceNoTax"]*$exchange_rat);
            $price3 = round($basic_price3-round($basic_price3*0.09));

            if ($BreakPrice[3]["Quantity"] > 0) {
            $max_quantity3 = $BreakPrice[3]["Quantity"]-1;
            $mini_quantity4 = $BreakPrice[3]["Quantity"];
            }
            $basic_price4 = round($BreakPrice[3]["PriceNoTax"]*$exchange_rat);
            $price4 = round($basic_price4-round($basic_price4*0.09));

            if ($BreakPrice[4]["Quantity"] > 0) {
            $max_quantity4 = $BreakPrice[4]["Quantity"]-1;
            $mini_quantity5 = $BreakPrice[4]["Quantity"];
            }
            $basic_price5 = round($BreakPrice[4]["PriceNoTax"]*$exchange_rat);
            $price5 = round($basic_price5-round($basic_price5*0.09));

            if ($BreakPrice[5]["Quantity"] > 0) {
            $max_quantity5 = $BreakPrice[5]["Quantity"]-1;
            $mini_quantity6 = $BreakPrice[5]["Quantity"];
            }
            $basic_price6 = round($BreakPrice[5]["PriceNoTax"]*$exchange_rat);
            $price6 = round($basic_price6-round($basic_price6*0.09));


        $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
        $pathFile = FileHelper::FOLDER_PATCH_API_TOTEXT;
        $filepath = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';
        $filename = "rsapitext".$filenum;

        $fp = fopen($filepath.$filename.".csv", "a");
        $text = $api_code.','.$pn.','.$stock.','.$BaseUOM.','.$SalesUOM.','.$MOQ.','.$InMOQ.','.$PackSize.','.$price1.','.$mini_quantity1.','.$max_quantity1.','.$price2.','.$mini_quantity2.','.$max_quantity2.','.$price3.','.$mini_quantity3.','.$max_quantity3.','.$price4.','.$mini_quantity4.','.$max_quantity4.','.$price5.','.$mini_quantity5.','.$max_quantity5.','.$price6.','.$mini_quantity6.','.$max_quantity6;

        fwrite($fp, $text."\n");
        fclose($fp);

        $this->apiPndataModel->updateActiveFlg($pn);
        //exit;

    }


    function loop_file_check($filename, $filecon, $fileexe){

		$cfg					= array();
		$cfg['allowed_types']	= $fileexe;
		$cfg['file_name']		= $filename.$filecon;

        $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
        $pathFile = FileHelper::FOLDER_PATCH_API_TOTEXT;
		$cfg['upload_path']	    = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';
		$cfg['overwrite']		= TRUE;

			$this->fileName = $fileName;
			$this->filePath = $cfg['upload_path'] . $cfg['file_name'] . '.' . $cfg['allowed_types'];

	}

    
    public function moveCsvFile()
    {
        // 디렉토리 갯수와 파일의 갯수 구하기
        $file_count = 0;
        $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
        $pathFile = FileHelper::FOLDER_PATCH_API_TOTEXT;
        $loopexcel_path = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';

        $pathFileBackup = FileHelper::FOLDER_PATCH_API_TOTEXT_BACKUP;
        $apifilebackup_path = PUBLIC_PATH.$uploadpath.'/'.$pathFileBackup.'/';       
        $backup_day = date('Ymd');
        $result = opendir($loopexcel_path);

		while($file=readdir($result)) {
			if($file=="."||$file=="..") {continue;} // file명이 ".", ".." 이면 무시함
			$fileInfo = pathinfo($file);
			$fileExt = $fileInfo['extension']; // 파일의 확장자를 구함

			If (empty($fileExt)){
			$dir_count++;
			} else {
			$file_count++;
			}
		}

        $file_countend = $file_count+1;
        for ($file_count =1;$file_count < $file_countend;$file_count ++) {
                
                $filecon = $file_count;
                $bs_filename = 'rsapitext';
                $this->loop_file_check($bs_filename, $filecon, 'csv');
                $loopfilepath = $this->filePath;
                $apifilebakpath = $apifilebackup_path.$backup_day."_".$bs_filename.$filecon.".csv";

                if(file_exists($loopfilepath)) {
                    exec("mv ".$loopfilepath." ".$apifilebakpath);	
                }

            // $this->apiProductinfoModel->truncate(); //ApiProductinfo 테이블 초기화
        }
    }

    
    public function importCsvToDb()
    {
        $this->apiProductinfoModel->truncate(); //ApiProductinfo 테이블 초기화

        // 디렉토리 갯수와 파일의 갯수 구하기
        $file_count = 0;
        $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
        $pathFile = FileHelper::FOLDER_PATCH_API_TOTEXT;
        $loopexcel_path = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';

        $isDir = is_dir($loopexcel_path);

        $result = opendir($loopexcel_path); 

		while($file=readdir($result)) {
			
			if($file=="."||$file=="..") {continue;} // file명이 ".", ".." 이면 무시함
			$fileInfo = pathinfo($file);
			$fileExt = $fileInfo['extension']; // 파일의 확장자를 구함

			If (empty($fileExt)){
			$dir_count++; // 파일에 확장자가 없으면 디렉토리로 판단하여 dir_count를 증가시킴
			} else {
			$file_count++;// 파일에 확장자가 있으면 file_count를 증가시킴
			}

		}

        $file_countend = $file_count+1;

        for ($file_count =1;$file_count < $file_countend;$file_count ++) {
                
                $filecon = $file_count;
                $bs_filename = 'rsapitext';

                $this->loop_file_check($bs_filename, $filecon, 'csv');
                $loopfilepath = $this->filePath;

                    $file = fopen($loopfilepath,"r");
                    
                    $i = 1;
                    $numberOfFields = 26;
                    $csvArr = array();
                    while (($filedata = fgetcsv($file, 10000, ",")) !== FALSE) {
                        $num = count($filedata);

                        if($i > 0 && $num == $numberOfFields){ 
                            $csvArr[$i]['api_code'] = $filedata[0];
                            $csvArr[$i]['api_partnumber'] = $filedata[1];
                            $csvArr[$i]['stock'] = $filedata[2];
                            $csvArr[$i]['baseUOM'] = $filedata[3];
                            $csvArr[$i]['salesUOM'] = $filedata[4];
                            $csvArr[$i]['MOQ'] = $filedata[5];
                            $csvArr[$i]['InMOQ'] = $filedata[6];
                            $csvArr[$i]['packSize'] = $filedata[7];
                            $csvArr[$i]['price1'] = $filedata[8];
                            $csvArr[$i]['mini_qty1'] = $filedata[9];
                            $csvArr[$i]['max_qty1'] = $filedata[10];
                            $csvArr[$i]['price2'] = $filedata[11];
                            $csvArr[$i]['mini_qty2'] = $filedata[12];
                            $csvArr[$i]['max_qty2'] = $filedata[13];
                            $csvArr[$i]['price3'] = $filedata[14];
                            $csvArr[$i]['mini_qty3'] = $filedata[15];
                            $csvArr[$i]['max_qty3'] = $filedata[16];
                            $csvArr[$i]['price4'] = $filedata[17];
                            $csvArr[$i]['mini_qty4'] = $filedata[18];
                            $csvArr[$i]['max_qty4'] = $filedata[19];
                            $csvArr[$i]['price5'] = $filedata[20];
                            $csvArr[$i]['mini_qty5'] = $filedata[21];
                            $csvArr[$i]['max_qty5'] = $filedata[22];
                            $csvArr[$i]['price6'] = $filedata[23];
                            $csvArr[$i]['mini_qty6'] = $filedata[24];
                            $csvArr[$i]['max_qty6'] = $filedata[25];
                        }
                        $i++;

                    }
                
                    fclose($file);
                   
                    $count = 0;
                    $apiproductinfo = new ApiProductinfo();

                    foreach($csvArr as $exceldata){
                            $apiproductinfo->api_code = $exceldata['api_code'];
                            $apiproductinfo->api_partnumber = $exceldata['api_partnumber'];
                            $apiproductinfo->stock = $exceldata['stock'];
                            $apiproductinfo->baseUOM = $exceldata['baseUOM'];
                            $apiproductinfo->salesUOM = $exceldata['salesUOM'];
                            $apiproductinfo->MOQ = $exceldata['MOQ'];
                            $apiproductinfo->InMOQ = $exceldata['InMOQ'];
                            $apiproductinfo->packSize = $exceldata['packSize'];
                            $apiproductinfo->price1 = $exceldata['price1'];
                            $apiproductinfo->mini_qty1 = $exceldata['mini_qty1'];
                            $apiproductinfo->max_qty1 = $exceldata['max_qty1'];
                            $apiproductinfo->price2 = $exceldata['price2'];
                            $apiproductinfo->mini_qty2 = $exceldata['mini_qty2'];
                            $apiproductinfo->max_qty2 = $exceldata['max_qty2'];
                            $apiproductinfo->price3 = $exceldata['price3'];
                            $apiproductinfo->mini_qty3 = $exceldata['mini_qty3'];
                            $apiproductinfo->max_qty3 = $exceldata['max_qty3'];
                            $apiproductinfo->price4 = $exceldata['price4'];
                            $apiproductinfo->mini_qty4 = $exceldata['mini_qty4'];
                            $apiproductinfo->max_qty4 = $exceldata['max_qty4'];
                            $apiproductinfo->price5 = $exceldata['price5'];
                            $apiproductinfo->mini_qty5 = $exceldata['mini_qty5'];
                            $apiproductinfo->max_qty5 = $exceldata['max_qty5'];
                            $apiproductinfo->price6 = $exceldata['price6'];
                            $apiproductinfo->mini_qty6 = $exceldata['mini_qty6'];
                            $apiproductinfo->max_qty6 = $exceldata['max_qty6'];
                            $apiproductinfo->qty_flag = '0';

                            //var_dump($apiproductinfo);
                            //exit;

                            if($this->apiProductinfoModel->insert($apiproductinfo)){
                                 $count++;
                            }
                    }
                $count_all = $count_all + $count;
        }
    
        $this->apiProductinfoModel->updateProducts(); //API정보 부품정보에 반영.
        $this->moveCsvFile();
        
    }

    public function detailToTxt(){
        // echo"detailToTxt";
        // exit;

        $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
        $pathFile = FileHelper::FOLDER_PATCH_API_DETAILTOTEXT;
        $filepath = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';

        $result=opendir($filepath);
        while($file=readdir($result)) {
           if($file=="."||$file=="..") {continue;}
           $fileInfo = pathinfo($file);
           $fileExt = $fileInfo['extension'];
      
           If (empty($fileExt)){
              $dir_count++;
           } else {
              $file_count++;
           }
           
         }

        $filenum = $file_count+1;

        //$incount = "3500";
        $incount = "50"; // chipdirect.co.kr_test
        $api_code = "RS";

        $rsApiIds = $this->apiPnDetaildataModel->getRsApiId($api_code);

        if (count($rsApiIds) > 0) {

            foreach ($rsApiIds as $key => $itemId):
    
                 if  ($incount > $key) {
                    $api_partnumber = $itemId->api_partnumber;
                    // fopen('https://chipdirect.co.kr/productapi/rsdetailtotext?pn='.$api_partnumber.'&filenum='.$filenum , 'r');                    
                    // fopen('http://app.chipdirect.co.kr/productapi/rsdetailtotext?pn='.$api_partnumber.'&filenum='.$filenum , 'r');
                    fopen('https://chipdirect.co.kr/productapi/rsdetailtotext?pn='.$api_partnumber.'&filenum='.$filenum , 'r');
                 }
    
            endforeach;

        } else {
            $this->apiProductinfoModel->insertPndata();
            $rsApiIds = $this->apiPndataModel->getRsApiId($api_code);

            foreach ($rsApiIds as $key => $itemId):
    
                 if  ($incount > $key) {
                    $api_partnumber = $itemId->api_partnumber;
                    // fopen('https://chipdirect.co.kr/productapi/rsdetailtotext?pn='.$api_partnumber.'&filenum='.$filenum , 'r');
                    // fopen('http://app.chipdirect.co.kr/productapi/rsdetailtotext?pn='.$api_partnumber.'&filenum='.$filenum , 'r');
                    fopen('https://chipdirect.co.kr/productapi/rsdetailtotext?pn='.$api_partnumber.'&filenum='.$filenum , 'r');
                 }
    
            endforeach;
        }

        exit;
    }

    public function rsApiDetailToText(){   

        $pn = $_GET["pn"];
        $filenum = $_GET["filenum"];
        $api_code = "RS";

        $pdf_url = 'https://documents.rs-online.com/techlib:/itc_doclist_GB.htm?stockno='.$pn;
        $headers[] = 'Authorization: Basic bXV3b25hcHBsaWNhdGlvbl92MV8wLXVzZXI6TVUkcG4wOSR4Jg==';
        $headers[] = 'Accept: application/json';
        $headers[] = 'Cache-Control: no-cache';
        $ch_url = curl_init();
        curl_setopt($ch_url, CURLOPT_URL, $pdf_url);
        curl_setopt($ch_url, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch_url, CURLOPT_RETURNTRANSFER, true);
        $response_url = curl_exec($ch_url);
        curl_close($ch_url);

        $response_array = explode("javascript:showLineTechDocDMS('", $response_url);
        $datasheet_array = explode(".pdf", $response_array[1]);
        $pdf_url = $datasheet_array[0].".pdf";

        $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
        $pathFile = FileHelper::FOLDER_PATCH_API_DETAILTOTEXT;
        $filepath = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';
        $filename = "rsdetailtext".$filenum;

        $fp = fopen($filepath.$filename.".csv", "a");
        $text = $api_code.','.$pn.','.$pdf_url;

        fwrite($fp, $text."\n");
        fclose($fp);

        $this->apiPnDetaildataModel->updateActiveFlg($pn);
        //exit;

    }


    public function detailCsvToDb(){

        // echo"detailCsvToDb Test";
        // exit;

        // 디렉토리 갯수와 파일의 갯수 구하기
        $file_count = 0;
        $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
        $pathFile = FileHelper::FOLDER_PATCH_API_DETAILTOTEXT;
        $loopexcel_path = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';

        // $isDir = is_dir($loopexcel_path);
        $result = opendir($loopexcel_path); 

		while($file=readdir($result)) {
			
			if($file=="."||$file=="..") {continue;} // file명이 ".", ".." 이면 무시함
			$fileInfo = pathinfo($file);
			$fileExt = $fileInfo['extension']; // 파일의 확장자를 구함

			If (empty($fileExt)){
			$dir_count++; // 파일에 확장자가 없으면 디렉토리로 판단하여 dir_count를 증가시킴
			} else {
			$file_count++;// 파일에 확장자가 있으면 file_count를 증가시킴
			}

		}

        $file_countend = $file_count+1;

        for ($file_count =1;$file_count < $file_countend;$file_count ++) {
                
                $filecon = $file_count;
                $bs_filename = 'rsdetailtext';

                $this->detail_file_check($bs_filename, $filecon, 'csv');
                $loopfilepath = $this->filePath;

                    $file = fopen($loopfilepath,"r");
                    
                    $i = 1;
                    $numberOfFields = 3;
                    $csvArr = array();
                    while (($filedata = fgetcsv($file, 10000, ",")) !== FALSE) {
                        $num = count($filedata);

                        if($i > 0 && $num == $numberOfFields){ 
                            $csvArr[$i]['api_code'] = $filedata[0];
                            $csvArr[$i]['api_partnumber'] = $filedata[1];
                            $csvArr[$i]['pdf_dir'] = $filedata[2];
                        }
                        $i++;
                    }
                
                    fclose($file);
                   
                    $count = 0;
                    $apiproductdetail = new ApiProductdetail();

                    foreach($csvArr as $exceldata){
                            $apiproductdetail->api_code = $exceldata['api_code'];
                            $apiproductdetail->api_partnumber = $exceldata['api_partnumber'];
                            $apiproductdetail->pdf_dir = $exceldata['pdf_dir'];
                            $apiproductdetail->qty_flag = '0';

                            // var_dump($apiproductdetail);
                            // exit;

                            if($this->apiProductdetailModel->insert($apiproductdetail)){
                                 $count++;
                            }
                    }
                $count_all = $count_all + $count;
        }

        $this->moveDetailCsvFile();
        
    }

    function detail_file_check($filename, $filecon, $fileexe){

		$cfg					= array();
		$cfg['allowed_types']	= $fileexe;
		$cfg['file_name']		= $filename.$filecon;

        $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
        $pathFile = FileHelper::FOLDER_PATCH_API_DETAILTOTEXT;
		$cfg['upload_path']	    = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';
		$cfg['overwrite']		= TRUE;

			$this->fileName = $fileName;
			$this->filePath = $cfg['upload_path'] . $cfg['file_name'] . '.' . $cfg['allowed_types'];

	}


    public function moveDetailCsvFile(){
        // 디렉토리 갯수와 파일의 갯수 구하기
        $file_count = 0;
        $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
        $pathFile = FileHelper::FOLDER_PATCH_API_DETAILTOTEXT;
        $loopexcel_path = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';

        $pathFileBackup = FileHelper::FOLDER_PATCH_API_DETAILTOTEXT_BACKUP;
        $apifilebackup_path = PUBLIC_PATH.$uploadpath.'/'.$pathFileBackup.'/';       

        $backup_day = date('Ymd');
        $result = opendir($loopexcel_path);

		while($file=readdir($result)) {
			if($file=="."||$file=="..") {continue;} // file명이 ".", ".." 이면 무시함
			$fileInfo = pathinfo($file);
			$fileExt = $fileInfo['extension']; // 파일의 확장자를 구함

			If (empty($fileExt)){
			$dir_count++;
			} else {
			$file_count++;
			}
		}

        $file_countend = $file_count+1;

        for ($file_count =1;$file_count < $file_countend;$file_count ++) {
                
                $filecon = $file_count;
                $bs_filename = 'rsdetailtext';
                $this->detail_file_check($bs_filename, $filecon, 'csv');
                $loopfilepath = $this->filePath;
                $apifilebakpath = $apifilebackup_path.$backup_day."_".$bs_filename.$filecon.".csv";

                if(file_exists($loopfilepath)) {
                    exec("mv ".$loopfilepath." ".$apifilebakpath);	
                }

        }
    }

    public function detailToProduct(){

        $this->apiProductdetailModel->updateProducts();  //API정보 부품정보에 반영
        // $this->apiProductdetailModel->truncate(); //ApiProductinfo 테이블 초기화

        exit;
        
    }

}