<?php
namespace App\Controllers\Guest;


//use App\Controllers\BaseController;
use CodeIgniter\Controller;
use CodeIgniter\HTTP\RequestInterface;
use App\Models\QsProductModel;

class QsProductController extends BaseController
{

    protected $qsProductModel;

    public function __construct()
    {

        $this->qsProductModel = new QsProductModel();

    }


    public function index()
    {
        return $this->viewGuest('autosearch/index4');
    }

    public function getProduct(){
        $request = service('request');
        $postData = $request->getPost();

        $response = array();
        // Read new token and assign in $response['token']
        $response['token'] = csrf_hash();
        $data = array();

        if(isset($postData['search'])){

            $search = $postData['search'];
            $num_chara = strlen($search);

            // Fetch record
            if ($num_chara > 2) {
                
                $productlist =  $this->qsProductModel->select('product_id,part_number,selling_price1')
                    ->like('part_number', $search, 'after')
                    ->orderBy('part_number')
                    ->findAll(8);

                foreach($productlist as $product){
                    $data[] = array(
                        "value" => $product['product_id'],
                        "value2" => $product['selling_price1'],
                        "label" => $product['part_number'],
                    );
                }
            }

        }

        $response['data'] = $data;

        return $this->response->setJSON($response);

    }
}
