<?php 
namespace App\Controllers\Guest;

use App\Entities\RefundInfo;
use App\Entities\RefundPartinfo;
use App\Helpers\AuthHelpers;
use App\Models\RefundInfoModel;
use App\Models\RefundPartinfoModel;
use App\Services\RefundInfoService;
use App\Models\ReasonreturnInfoModel;
use App\Helpers\FileHelper;
// use App\Entities\RefundInfoFile;
use App\Models\ProductModel;
use App\Models\StocklocationCategoryModel;

use App\Models\OrderInfoModel;
use App\Models\OrderPartinfoModel;

class RefundInfoController extends BaseController
{
    protected $refundInfoModel;
    protected $refundPartinfoModel;
    protected $refundInfoService;
    protected $reasonreturnInfoModel;
    private $productModel;
    protected $stocklocationCategoryModel;

    protected $orderInfoModel;
    protected $orderPartinfoModel;

    public function __construct()
    {
        $this->refundInfoModel = new RefundInfoModel();
        $this->refundPartinfoModel = new RefundPartinfoModel();
        $this->refundInfoService = new RefundInfoService();
        $this->reasonreturnInfoModel = new ReasonreturnInfoModel();
        $this->productModel = new ProductModel();
        $this->stocklocationCategoryModel = new StocklocationCategoryModel();

        $this->orderInfoModel = new OrderInfoModel();
        $this->orderPartinfoModel = new OrderPartinfoModel();
    }

    public function index(){        
        $perPage = $this->request->getGet('perpage');
        $condition = $this->request->getGet();
        $condition['member_code'] = AuthHelpers::getLoginInfoGuest()->member_code;
        //var_dump ($member_code);
        //exit;

        if( isset($condition['refund_code']) && $condition['refund_code'] != '' ) $condition['is_search'] = true;
        $data = $this->refundInfoModel->getSearchMem($condition,$perPage);

        // var_dump ($data['lists']);
        // exit;

        return $this->viewGuest('refundinfo/index', array_merge($data,$condition));
    }

    public function detail($refundInfoId){
        $refundInfo = $this->refundInfoModel->findInfoById($refundInfoId);
        $refund_code = $refundInfo->refund_code;
        //var_dump($refundInfo->member_code);

        $member_code = AuthHelpers::getLoginInfoGuest()->member_code;
        //var_dump ($member_code);

        $data = $this->refundPartinfoModel->getPartinfo($refund_code);
        $lists = $data['lists'];
        //var_dump($lists);
        //exit;

        foreach ($lists as $key => $item){
            $part_sequence =  $item->item_code;
            //echo $key." : ".$part_sequence."<br>";

            $now_product_info = $this->productModel->findByProductInfo($part_sequence);

            $nowinfo = [
            'product_code'   => $now_product_info ->product_code,
            'part_number' => $now_product_info ->part_number,
            'image_dir'   => $now_product_info ->image_dir,
            'api_flg'   => $now_product_info ->api_flg,
            'selling_price1' => $now_product_info ->selling_price1,
            'part_number_sequence' => $now_product_info ->part_number_sequence,
            'brief_description' => $now_product_info ->brief_description,
            'product_related' => $now_product_info ->product_related,
            'stock_location' => $now_product_info ->stock_location,
            'delivery_code' => $now_product_info ->delivery_code
            ];

            $lists[$key]->nowinfo = $nowinfo;
        }

        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
        $data['reasonreturninfo'] = $this->reasonreturnInfoModel->findAll();
        $data['refundInfo'] = $refundInfo;
        
       //var_dump($data['lists']);
       //var_dump($data['refundInfo']);
       //exit;

        return $this->viewGuest('refundinfo/detail', $data);
    }

    public function showCreate($id){       
        $refundInfo = $this->refundInfoModel->findInfoById($id);
        $refund_code = $refundInfo->refund_code;

        $data = $this->refundPartinfoModel->getPartinfo($refund_code);
        $lists = $data['lists'];

        foreach ($lists as $key => $item){
            $part_sequence =  $item->item_code;
            $now_product_info = $this->productModel->findByProductInfo($part_sequence);

            $nowinfo = [
            'product_code'   => $now_product_info ->product_code,
            'part_number' => $now_product_info ->part_number,
            'image_dir'   => $now_product_info ->image_dir,
            'api_flg'   => $now_product_info ->api_flg,
            'selling_price1' => $now_product_info ->selling_price1,
            'part_number_sequence' => $now_product_info ->part_number_sequence,
            'brief_description' => $now_product_info ->brief_description,
            'product_related' => $now_product_info ->product_related,
            'stock_location' => $now_product_info ->stock_location,
            'delivery_code' => $now_product_info ->delivery_code
            ];

            $lists[$key]->nowinfo = $nowinfo;
        }

        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
        $data['reasonreturninfo'] = $this->reasonreturnInfoModel->findAll();
        $data['refundInfo'] = $refundInfo;

        return $this->viewGuest('refundinfo/refund_create', $data);
    }

    
    public function create(){

        $id= $this->request->getPost('info_id');
        $refund_code = $this->request->getPost('refund_code');

        // $this->rules = $this->refundInfoModel->getValidationRules();
        //if($this->checkValidation()){

            //Update Inquiry
            $refundPartinfo = new RefundPartinfo();
            $dataRow = $this->request->getPost('dataRow');

            for($i=1;$i <= $dataRow;$i++):
                $refund_id = $this->request->getPost('refund_id'.$i);
                $refund_type = $this->request->getPost('refund_type'.$i);
                $refund_reason = $this->request->getPost('refund_reason'.$i);

                if ($refund_id) {
                    $this->refundPartinfoModel->updateStatus($refund_id, $refund_code, $refund_type, $refund_reason);
                }

            endfor;

            $refundInfoItem = $this->refundInfoModel->find($id);
            $order_code = $refundInfoItem->order_code;

            if(isset($refundInfoItem)){
                $inputs = $this->request->getPost();
                $refundInfoItem->fill($inputs);
                $refundInfoItem->return_status = 1;
                $this->refundInfoModel->save($refundInfoItem);

                $orderCount = $this->orderPartinfoModel->orderCount($order_code);
                $orderStatusCount = $this->orderPartinfoModel->orderStatusCount($order_code, '12');

                if ($orderCount == $orderStatusCount) {
                    $this->orderInfoModel->updateStatus($order_code, '12');
                }else{
                    $this->orderInfoModel->updateStatus($order_code, '16');
                }

            }

            $emailSubject ='[반품문의] 신규 반품문의가 도착했습니다.';
            $emailtMessage = '사이트에 새로운 반품문의가 도착했습니다.<br>관리자 페이지에서 반품문의 내용을 확인하세요.<br>감사합니다.';

            $this->toEmail($emailSubject, $emailtMessage);
            
            $message = "Update RefundInfo success";
            return redirect()->route('guest.refundinfo')->with('message',$message);

    }
    
    public function toEmail($emailSubject, $emailtMessage) {

        $email = \Config\Services::email();
        
        $config['protocol'] = 'html';
        $config['mailPath'] = '/usr/sbin/sendmail -t -i';
        $config['fromEmail'] = 'kyungyeon.jung@gmail.com';
        $config['fromName'] = 'ChipDirect';

        $email->initialize($config);
        $email->setFrom('chip@selpasemicom.com', 'ChipDirect');
        $email->setTo('pixel25@naver.com');
        $email->setSubject($emailSubject);
        $email->setMessage($emailtMessage);
        $email->send();

    }

}
