<?php 
namespace App\Controllers\Guest;

// use App\Entities\MemberReview;
use App\Entities\Review;
use App\Helpers\AuthHelpers;
// use App\Models\AppInfoModel;
// use App\Models\MemberReviewModel;
use App\Models\ReviewModel;
use App\Models\ReviewCategoryModel;
use App\Services\ReviewService;
use App\Helpers\FileHelper;
use App\Models\ReviewFileModel;
use App\Entities\ReviewFile;
use App\Models\ProductModel;

class ReviewController extends BaseController
{
    // protected $memberReviewModel;
    
    private $productModel;
    protected $reviewModel;
    protected $reviewFileModel;
    protected $reviewCategoryModel;
    protected $reviewService;

    public function __construct()
    {
        // $this->memberReviewModel = new MemberReviewModel();
        // $this->appInfoModel = new AppInfoModel();

        $this->productModel = new ProductModel();
        $this->reviewModel = new ReviewModel();
        $this->reviewFileModel = new ReviewFileModel();
        $this->reviewCategoryModel = new ReviewCategoryModel();
        $this->reviewService = new ReviewService();
    }

    public function validationMapFieldLabels()
    {
        return [
            'memo_content' => 'Memo'
        ];
    }


    public function index(){        
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( isset($searchInput['title']) && $searchInput['title'] != '' ) $searchInput['is_search'] = true;
        $data = $this->reviewModel->getSearch($searchInput,$perPage);
        //var_dump ($data);
        //exit;
        return $this->viewGuest('review/index', array_merge($data,$searchInput));
    }

    public function detail($reviewId){
        $item = $this->reviewModel->findInfoById($reviewId);
        $files = $this->reviewFileModel->where('review_id',$reviewId)->findAll();
        $data['item'] = $item;

        $item_code = $item->item_code;
        $productinfo = $this->productModel->findByProductCode($item_code);

        $data['productinfo'] = $productinfo;

        $data['files'] = $files;
        //increase hit
        $isViewSession = AuthHelpers::getSession()->get(AuthHelpers::SESSION_INCREASE_HIT_REVIEW);
        if(!isset($isViewSession) || (is_array($isViewSession) && !in_array($reviewId, $isViewSession))){
            if(!isset($isViewSession)) $isViewSession = [];
            $isViewSession[] = $reviewId;
            AuthHelpers::getSession()->set(AuthHelpers::SESSION_INCREASE_HIT_REVIEW, $isViewSession);
            $this->reviewModel->update(['id' => $reviewId], ['hit_number' => $item->hit_number + 1]);
        }
        return $this->viewGuest('review/review_detail', $data);
    }

    public function showCreate(){
        $this->rules = $this->reviewModel->getValidationRules();

        $categories = $this->reviewCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['maxFiles'] = 10;
        // var_dump ($data);
        // exit;
        
        $account = AuthHelpers::getLoginInfoGuest();
        // var_dump ($account);
        // exit;
        $data['memberName'] = '';
        $data['memberEmail'] = '';
        $data['memberPhone'] = '';
        $data['memberCode'] = '';
        if(isset($account)){
            $data['memberName'] = $account->member_name;
            $data['memberEmail'] = $account->member_email;
            $data['memberPhone'] = $account->member_phone;
            $data['memberCode'] = $account->member_code;
        }

        return $this->viewGuest('review/review_create', $data);
    }

    public function create(){
        $this->rules = $this->reviewModel->getValidationRules();

        if($this->checkValidation()){
            $review = new Review($this->request->getPost());
            $insertId = $this->reviewModel->insert($review, true);

            if($insertId > 0){
                $files = $this->request->getFiles();
                // var_dump($files);
                // exit;

                if(isset($files)){
                    foreach ($files as $file){
                        $fileName = $file->getClientName();
                        if(isset($fileName) && !empty($fileName)){
                            $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_REVIEW, $insertId);
                            $reviewFile = new ReviewFile([
                                'review_id' => esc($insertId),
                                'file_name' => esc($fileName),
                                'file_dir' => esc($filePath)
                            ]);
                            $this->reviewFileModel->save($reviewFile);
                        }
                    }
                }
            }

            $message = 'Create review success.';
            return redirect()->route('guest.review')->with('message' , $message);
        }else{
            return $this->viewGuest('review/review_create', [
                'validator' => $this->validator
            ]);
        }

    }

    public function showUpdate($id){
        $this->rules = $this->reviewModel->getValidationRules();
        $reviewItem = $this->reviewModel->find($id);
        $data['item'] = $reviewItem;

        $item_code = $reviewItem->item_code;
        $productinfo = $this->productModel->findByProductCode($item_code);
        $data['productinfo'] = $productinfo;

        $files = $this->reviewFileModel->where('review_id',$id)->findAll();
        $categories = $this->reviewCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['files'] = $files;
        $data['maxFiles'] = 10 - count($files);
        // var_dump($data);
        // exit;

        return $this->viewGuest('review/update', $data);
    }

    public function update($id){
        $this->rules = $this->reviewModel->getValidationRules();

        if($this->checkValidation()){
            // $this->reviewService->updateReview($id,$this->request);
            $reviewItem = $this->reviewModel->find($id);

            if(isset($reviewItem)){
                $inputs = $this->request->getPost();

                $inputs['public_flg'] = get_public_id($inputs['public_flg']);
                $reviewItem->fill($inputs);

                //var_dump($reviewItem);
                //exit;

                $this->reviewModel->save($reviewItem);
                $files = $this->request->getFiles();
                // var_dump($files);
                // exit;

                if(isset($files)){
                    foreach ($files as $file){
                        $fileName = $file->getClientName();
                        if(isset($fileName) && !empty($fileName)){
                            $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_REVIEW, $insertId);
                            $reviewFile = new ReviewFile([
                                'review_id' => esc($id),
                                'file_name' => esc($fileName),
                                'file_dir' => esc($filePath)
                            ]);
                            $this->reviewFileModel->save($reviewFile);
                        }
                    }
                }

            }


            $message = "Update review success";
            return redirect()->route('guest.review')->with('message',$message);
        }else{
            return view('review/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteNews($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->reviewService->deleteNews($ids);
            if($result) $message = "Delete review success";
        }
        return redirect()->route('guest.review')->with('message',$message);
    }

    public function deleteFile($reviewId,$fileNo){
        $this->reviewFileModel->delete($fileNo);
        $message = "Delete file success";
        return redirect()->route('guest.review.update',[$reviewId])->with('message',$message);;
    }

    public function viewFile($reviewId, $fileId){
        $file = $this->reviewFileModel->findReviewFile($reviewId, $fileId);
        if(isset($file)){
            $pdfPath = $file->file_dir;
            $filename = "$file->file_name";
            $this->setHeaderViewFile($filename,PUBLIC_PATH . $pdfPath);
        }
        exit;
    }

}
