<?php namespace App\Controllers\Guest;

use App\Entities\PartInquiry;
use App\Entities\SearchToday;
use App\Entities\ExchangeInfo;
use App\Entities\ApiStatus;
// use App\Helpers\ArrayHelper;
use App\Helpers\AuthHelpers;
use App\Models\PartInquiryModel;
use App\Models\CartPartinfoModel;
use App\Models\InquiryPartinfoModel;
use App\Models\EstimatePartinfoModel;
use App\Models\ProductModel;
use App\Models\ProductdetailModel;
use App\Models\ProductsShippingModel;
use App\Models\ManufacturerModel;
use App\Models\Categorylevel1Model;
use App\Models\Categorylevel2Model;
use App\Models\Categorylevel3Model;
use App\Models\PackagingUnitModel;
use App\Models\EventinfoModel;
use App\Models\StocklocationCategoryModel;
use App\Models\LeadtimeCategoryModel;
use App\Models\DeliverycodeModel;
use App\Models\ReviewModel;
use App\Models\ReviewCategoryModel;
use App\Models\InquiryModel;
use App\Models\InquiryCategoryModel;
use App\Models\EstimateModel;
use App\Models\EstimateCategoryModel;
use App\Models\SearchTodayModel;
use App\Models\OrderPartinfoModel;
use App\Models\ExchangeInfoModel;
use App\Models\ApiStatusModel;

class SaleController extends BaseController
{
    protected $productModel;
    protected $productdetailModel;
    protected $productsShippingModel;
    protected $manufacturerModel;
    protected $categorylevel1Model;
    protected $categorylevel2Model;
    protected $categorylevel3Model;
    protected $packagingUnitModel;
    protected $eventinfoModel;
    protected $stocklocationCategoryModel;
    protected $leadtimeCategoryModel;
    protected $deliverycodesModel;
    protected $reviewModel;
    protected $reviewCategoryModel;
    protected $inquiryFileModel;
    protected $inquiryCategoryModel;
    protected $estimatePartinfoModel;
    protected $estimateModel;
    protected $estimateCategoryModel;
    protected $searchTodayModel;
    protected $orderPartinfoModel;
    protected $exchangeInfoModel;
    protected $apiStatusModel;

    public function __construct()
    {
        $this->partInquiryModel = new PartInquiryModel();
        $this->cartPartinfoModel = new CartPartinfoModel();
        $this->inquiryPartinfoModel = new InquiryPartinfoModel();
        $this->estimatePartinfoModel = new EstimatePartinfoModel();
        $this->productModel = new ProductModel();
        $this->productdetailModel = new ProductdetailModel();
        $this->productsShippingModel = new ProductsShippingModel();
        $this->manufacturerModel = new ManufacturerModel();
        $this->categorylevel1Model = new Categorylevel1Model();
        $this->categorylevel2Model = new Categorylevel2Model();
        $this->categorylevel3Model = new Categorylevel3Model();
        $this->packagingUnitModel = new PackagingUnitModel();
        $this->eventinfoModel = new EventinfoModel();
        $this->stocklocationCategoryModel = new StocklocationCategoryModel();
        $this->leadtimeCategoryModel = new LeadtimeCategoryModel();
        $this->deliverycodesModel = new DeliverycodeModel();
        $this->reviewModel = new ReviewModel();
        $this->reviewCategoryModel = new ReviewCategoryModel();
        $this->inquiryModel = new InquiryModel();
        $this->inquiryCategoryModel = new InquiryCategoryModel();
        $this->estimateModel = new EstimateModel();
        $this->estimateCategoryModel = new EstimateCategoryModel();
        $this->searchTodayModel = new SearchTodayModel();
        $this->orderPartinfoModel = new OrderPartinfoModel();
        $this->exchangeInfoModel = new ExchangeInfoModel();
        $this->apiStatusModel = new ApiStatusModel();
    }

    public function index()
    {
        $perPage = $this->request->getGet('perpage');

        $condition['search_code'] = $this->request->getGet('search_code');
        $condition['keyword'] = $this->request->getGet('keyword');
        $condition['part_category'] = $this->request->getGet('part_category');
        $condition['part_category2'] = $this->request->getGet('part_category2');
        //$condition['part_category3'] = $this->request->getGet('part_category3');
        $condition['sort'] = $this->request->getGet('sort');


        // var_dump($condition);

        if ($condition['keyword']) {
            $search_keyword = $condition['keyword'];

            $cartCount = $this->searchTodayModel->getKeywordCount($search_keyword);

            if ($cartCount == 0) {
                $searchToday = new SearchToday;

                $searchToday = [
                    'word'    => $search_keyword,
                    'count'   => 1,
                    'del_flg' => 0
                ];

                $this->searchTodayModel->save($searchToday);
            } else {
                $keywordInfo = $this->searchTodayModel->findKeywordInfo($search_keyword);
                $wordId = $keywordInfo->id;                
                $this->searchTodayModel->update(['id' => $wordId], ['count' => $keywordInfo->count + 1]);
            }

        }

        $data = $this->productModel->getSearch($condition, $perPage);
       // print_r($this->productModel->getLastQuery());    
       // exit;

        if ($condition['search_code']) {

            $part_category_info = $this->categorylevel1Model->findByCategoryCode($condition['search_code']);
            
            $data['part_category1_name'] = $part_category_info['categorylevel1_name'];
            $data['part_category1_code'] = $part_category_info['categorylevel1_code'];
            $part_category1_mlist = $this->categorylevel1Model->orderBy('categorylevel1_name', 'DESC')->findAll();
            $data['part_category1_mlist'] = $part_category1_mlist; 
      
            
            
        } elseif ($condition['part_category']) {
            // $part_category_info = $this->categorylevel1Model->findByCategoryName($condition['part_category']);
            $part_category_info = $this->categorylevel1Model->findByCategoryCode($condition['part_category']);
            // var_dump($part_category_info);

            $data['part_category1_name'] = $part_category_info['categorylevel1_name'];
            $data['part_category1_code'] = $part_category_info['categorylevel1_code'];
            $part_category1_mlist = $this->categorylevel1Model->orderBy('categorylevel1_name', 'DESC')->findAll();
            $data['part_category1_mlist'] = $part_category1_mlist;     
          
        } elseif ($condition['part_category2']) {
            // $part_category2_info = $this->categorylevel2Model->findByCategoryName($condition['part_category2']);
            $part_category2_info = $this->categorylevel2Model->findByCategoryCode($condition['part_category2']);

            $data['part_category2_name'] = $part_category2_info['categorylevel2_name'];
            $data['part_category2_code'] = $part_category2_info['categorylevel2_code'];
            $part_category_info = $this->categorylevel1Model->findByCategoryCode($part_category2_info['categorylevel1_code']);
            $data['part_category1_name'] = $part_category_info['categorylevel1_name'];
            $data['part_category1_code'] = $part_category_info['categorylevel1_code'];
            $part_category2_mlist = $this->categorylevel2Model->getCategory2List($part_category2_info['categorylevel1_code']);
            $data['part_category2_mlist'] = $part_category2_mlist;
       
        /*
        } elseif ($condition['part_category3']) {
            // $part_category3_info = $this->categorylevel3Model->findByCategoryCode($condition['part_category3']);
            $part_category3_info = $this->categorylevel3Model->findByCategoryCode($condition['part_category3']);
            // var_dump($part_category3_info);

            $data['part_category3_name'] = $part_category3_info['categorylevel3_name'];
            $data['part_category3_code'] = $part_category3_info['categorylevel3_code'];
            $part_category2_info = $this->categorylevel2Model->findByCategoryCode($part_category3_info['categorylevel2_code']);
            $data['part_category2_name'] = $part_category2_info['categorylevel2_name'];
            $data['part_category2_code'] = $part_category2_info['categorylevel2_code'];
            $part_category_info = $this->categorylevel1Model->findByCategoryCode($part_category2_info['categorylevel1_code']);
            $data['part_category1_name'] = $part_category_info['categorylevel1_name'];
            $data['part_category1_code'] = $part_category_info['categorylevel1_code'];
            $part_category3_mlist = $this->categorylevel3Model->getCategory3List($part_category3_info['categorylevel2_code']);
            $data['part_category3_mlist'] = $part_category3_mlist;
        */

        } else {
            $data['part_category1_mlist'] =  $this->categorylevel1Model->orderBy('categorylevel1_name', 'ASC')->findAll();
        }

           $inquiry_code = AuthHelpers::getIqrCode();
           if(!$inquiry_code) {
           AuthHelpers::setIqrCode($inquirycode);
           }

        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();

        return $this->viewGuest('sale/index',array_merge($data,$condition));
    }
    

    public function partcategory()
    {
        $perPage = $this->request->getGet('perpage');

        $condition['part_category'] = $this->request->getGet('part_category');
        $condition['part_category2'] = $this->request->getGet('part_category2');
        // $condition['part_category3'] = $this->request->getGet('part_category3');
 
        $data = $this->productModel->getSearch($condition, $perPage);

        if ($condition['part_category']) {
            $part_category_info = $this->categorylevel1Model->findByCategoryCode($condition['part_category']);

            $data['part_category1_name'] = $part_category_info['categorylevel1_name'];
            $data['part_category1_code'] = $part_category_info['categorylevel1_code'];
            $part_category1_mlist = $this->categorylevel1Model->orderBy('categorylevel1_name', 'DESC')->findAll();
            $data['part_category1_mlist'] = $part_category1_mlist;     
         
        } elseif ($condition['part_category2']) {
            $part_category2_info = $this->categorylevel2Model->findByCategoryCode($condition['part_category2']);
            $data['part_category2_name'] = $part_category2_info['categorylevel2_name'];
            $data['part_category2_code'] = $part_category2_info['categorylevel2_code'];
            $part_category_info = $this->categorylevel1Model->findByCategoryCode($part_category2_info['categorylevel1_code']);
            $data['part_category1_name'] = $part_category_info['categorylevel1_name'];
            $data['part_category1_code'] = $part_category_info['categorylevel1_code'];
            $part_category2_mlist = $this->categorylevel2Model->getCategory2List($part_category2_info['categorylevel1_code']);
            $data['part_category2_mlist'] = $part_category2_mlist;

            // var_dump($part_category2_info);
            // var_dump($part_category2_mlist);
            // exit;

            /*
        } elseif ($condition['part_category3']) {

            $part_category3_info = $this->categorylevel3Model->findByCategoryCode($condition['part_category3']);
            $data['part_category3_name'] = $part_category3_info['categorylevel3_name'];
            $data['part_category3_code'] = $part_category3_info['categorylevel3_code'];
            $part_category2_info = $this->categorylevel2Model->findByCategoryName($part_category3_info['categorylevel2_code']);
            $data['part_category2_name'] = $part_category2_info['categorylevel2_name'];
            $data['part_category2_code'] = $part_category2_info['categorylevel2_code'];
            $part_category_info = $this->categorylevel1Model->findByCategoryName($part_category2_info['categorylevel1_code']);
            $data['part_category1_name'] = $part_category_info['categorylevel1_name'];
            $data['part_category1_code'] = $part_category_info['categorylevel1_code'];
            $part_category3_mlist = $this->categorylevel3Model->getCategory3List($part_category3_info['categorylevel2_code']);
            $data['part_category3_mlist'] = $part_category3_mlist;
            */
        } else {
            $data['part_category1_mlist'] =  $this->categorylevel1Model->orderBy('categorylevel1_name', 'ASC')->findAll();
        }

           $inquiry_code = AuthHelpers::getIqrCode();
           if(!$inquiry_code) {
           AuthHelpers::setIqrCode($inquirycode);
           }

        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
        
        return $this->viewGuest('sale/index',array_merge($data,$condition));
    }
    

    
    public function newproduct()
    {
        $perPage = $this->request->getGet('perpage');

        $condition['product_sctype'] = 'newproduct';
        $condition['sort'] = $this->request->getGet('sort');
        $data = $this->productModel->getNewproduct($condition, $perPage);

        $data['part_category1_mlist'] =  $this->categorylevel1Model->orderBy('categorylevel1_name', 'ASC')->findAll();

        $inquiry_code = AuthHelpers::getIqrCode();
       if(!$inquiry_code) {
        AuthHelpers::setIqrCode($inquirycode);
       }

       $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();

        return $this->viewGuest('sale/product_grid',array_merge($data,$condition));
    }

    public function bestproduct()
    {
        $perPage = $this->request->getGet('perpage');

        $condition['product_sctype'] = 'bestproduct';
        $condition['sort'] = $this->request->getGet('sort');

        $data = $this->productModel->getProduct($condition, $perPage);

        $data['part_category1_mlist'] =  $this->categorylevel1Model->orderBy('categorylevel1_name', 'ASC')->findAll();

        $inquiry_code = AuthHelpers::getIqrCode();
        if(!$inquiry_code) {
        AuthHelpers::setIqrCode($inquirycode);
        }

        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();

        return $this->viewGuest('sale/product_grid',array_merge($data,$condition));
    }


    public function partList()
    {
        $perPage = $this->request->getGet('perpage');
        $condition['ep_chk'] ="Y"; 
        $data = $this->productModel->getPartList($condition, $perPage);
        return $this->viewGuest('sale/partlist',array_merge($data,$condition));
    }

    public function brandproduct()
    {
        $perPage = $this->request->getGet('perpage');

        $condition['product_sctype'] = 'brandproduct';
        $condition['maker_seq'] = $this->request->getGet('maker_seq');
        $condition['sort'] = $this->request->getGet('sort');

        // var_dump($condition['maker_seq']);

        $data = $this->productModel->getProduct($condition, $perPage);

        // var_dump($data);
        // exit;

        $data['part_category1_mlist'] =  $this->categorylevel1Model->orderBy('categorylevel1_name', 'ASC')->findAll();

        $inquiry_code = AuthHelpers::getIqrCode();
        if(!$inquiry_code) {
        AuthHelpers::setIqrCode($inquirycode);
        }

        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();

        return $this->viewGuest('sale/product_list',array_merge($data,$condition));
    }

    public function eventproduct()
    {
        $perPage = $this->request->getGet('perpage');

        $condition['product_sctype'] = 'eventproduct';
        $condition['id'] = $this->request->getGet('id');
        $condition['sort'] = $this->request->getGet('sort');
        $display_type = $this->request->getGet('display_type');

        $data = $this->productModel->getProduct($condition, $perPage);

        $data['part_category1_mlist'] =  $this->categorylevel1Model->orderBy('categorylevel1_name', 'ASC')->findAll();

        $inquiry_code = AuthHelpers::getIqrCode();
        if(!$inquiry_code) {
        AuthHelpers::setIqrCode($inquirycode);
        }

        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
        
        if($display_type =='1') {
        return $this->viewGuest('sale/product_grid',array_merge($data,$condition));
        
        } elseif($display_type =='2') {
            return $this->viewGuest('sale/product_list',array_merge($data,$condition));

        } else {
        return $this->viewGuest('sale/product_list',array_merge($data,$condition));
        }
    }


    
    public function allProduct()
    {

		$categorylevel1data = $this->categorylevel1Model->where('del_flg', 0)->orderBy('categorylevel1_id', 'ASC')->findAll();
        $data['categorylevel1count'] = count($categorylevel1data);
        $data['categorylevel1data'] = $categorylevel1data;

		$i=0;
		foreach ($categorylevel1data as $menu){
				$categorylevel1_code = $menu['categorylevel1_code'];

				$categorylevel2data = $this->categorylevel2Model->where('categorylevel1_code', $categorylevel1_code)->where('del_flg', 0)->orderBy('categorylevel2_id', 'ASC')->findAll();
                $data['categorylevel1data'][$i]['categorylevel2count'] = count($categorylevel2data);
                $data['categorylevel1data'][$i]['categorylevel2data'] = $categorylevel2data;

				$j=0;

				foreach ($categorylevel2data as $menu2){
					$categorylevel2_code = $menu2['categorylevel2_code'];

					$categorylevel3data = $this->categorylevel3Model->where('categorylevel2_code', $categorylevel2_code)->where('del_flg', 0)->orderBy('categorylevel3_id', 'ASC')->findAll();
					$data['categorylevel1data'][$i]['categorylevel2data'][$j]['categorylevel3count'] = count($categorylevel3data);
                    $data['categorylevel1data'][$i]['categorylevel2data'][$j]['categorylevel3data'] = $categorylevel3data;

				$j++;
				}

		$i++;
		}

        // var_dump($data);
        // exit;

        $inquiry_code = AuthHelpers::getIqrCode();
        if(!$inquiry_code) {
        AuthHelpers::setIqrCode($inquirycode);
        }

        return $this->viewGuest('sale/allproduct',array_merge($data));
    }

    public function scproduct()
    {
        $perPage = $this->request->getGet('perpage');

        $condition['product_sctype'] = 'scproduct';
        $condition2['category'] = $this->request->getGet('category');
        $condition['keyword'] = $this->request->getGet('keyword');

        $data = $this->productModel->getCategorySearch($condition, $condition2, $perPage);

        return $this->viewGuest('sale/scproduct',array_merge($data,$condition2,$condition));
    }

    public function apiStatusErr($api_code){
        $apiStatus = new ApiStatus;
        $apiStatus = [
            'api_code'    => $api_code,
            'active_flg' => 1
        ];

        $this->apiStatusModel->save($apiStatus);
    }

    public function detail($itemCode){

        $item = $this->productModel->findByProductCode($itemCode);
        
        $api_updated_day = date("Y-m-d", strtotime($item->api_updated_at));
        $today = date("Y-m-d");

        $referer_domain = $_SERVER['HTTP_REFERER'];
        $referer_url = parse_url($referer_domain, PHP_URL_HOST);

        if ($referer_url == "chipdirect.co.kr") {

            
            if ($item->api_code == "SPW") {

                $product_id = $item->product_id;
                $product_code = $item->product_code;
                $part_number = $item->part_number;

                $key = "BsC95BSUFCR95DftYEpz0bCAUvMK7OD";
                $secret = "O3PsFLzjbVQNaj7Eqn4uf5WFT5AwTIlfSR4FJ";
                $nonce = "63yeike7dy6c2kjd";
                $keyword = $part_number;

                $timestamp = time();

                $str = 'key='.$key.'&nonce='.$nonce.'&secret='.$secret.'&timestamp='.$timestamp;
                $str_encode = sha1($str);

                $url = 'https://ips.lcsc.com/rest/wmsc2agent/search/product?key='.$key.'&nonce='.$nonce.'&timestamp='.$timestamp.'&signature='.$str_encode.'&keyword='.$keyword;
                $headers[] = 'Accept: application/json';
                $headers[] = 'Cache-Control: no-cache';

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                $ch_response = curl_exec($ch);
                $err = curl_error($ch);

                if ($err) {
                echo "cURL Error #:" . $err;
                curl_close($ch);
                } else {
                curl_close($ch);

                $details = json_decode($ch_response,true);

                    
                    if ($details["success"] == true) {

                        $results = $details["result"];
                        $product_list = $results["product_list"];

                        foreach ($product_list as $key => $productitem) {

                            if($part_number == $productitem["mpn"]) {

                            $part_category_info = $this->categorylevel1Model->findByCategoryName($productitem["category"]["name1"]);
                            $productitem["category"]["id1"] = $part_category_info["categorylevel1_code"];
                            
                            $part_category2_info = $this->categorylevel2Model->findByCategoryName($productitem["category"]["name2"]);
                            $productitem["category"]["id2"] = $part_category2_info["categorylevel2_code"];

                            // $manufacturer_info = $this->manufacturerModel->findByManufactureId($productitem["manufacturer"]["name"]);
                            // $productitem["manufacturer"]["id"] =$manufacturer_info->maker_seq;

                            // $packaging_info = $this->packagingUnitModel->findByPackingName($productitem ["packaging_unit"]);
                            // $productitem ["packaging_code"] = $packaging_info->packing_code;

                            $counrty_code = "USD";
                            $ExchangeRat = $this->exchangeInfoModel->where('counrty_code',$counrty_code)->orderBy('created_at desc')->first();
                            $exchange_rat = $ExchangeRat->standard_amount;

                            $this->productModel->updateLcscSpwup($product_code, $productitem, $exchange_rat);

                            $this->productdetailModel->updateDetailLcscSpwup($product_code, $productitem);

                            }

                        }

                    } else {
                    
                            $appid = 'SELPASEMICOM$CO$LTD_690';
                            $appkey = '51d3afa11c937ae7ea0d8c4a4a77c5c9';
                            $timestamp = time();

                            $sign = md5('_t='.$timestamp.'&appid='.$appid.'|'.$appkey);

                            $url = 'https://openapi.ickey.cn/v2/new-token/create';
                            $headers[] = 'Content-Type: application/x-www-form-urlencoded';
                            $headers[] = 'Accept: application/json';
                            $headers[] = 'Cache-Control: no-cache';

                            $host_info = explode("/", $url);
                            $port = $host_info[0] == 'https:' ? 443 : 80;
                            $ch = curl_init();

                            curl_setopt($ch, CURLOPT_PORT, $port);
                            curl_setopt($ch, CURLOPT_URL, $url);
                            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_POSTFIELDS, 'appid='.$appid.'&_t='.$timestamp.'&sign='.$sign);

                            $response = curl_exec($ch);
                            curl_close($ch);

                            if (!$response) {
                                echo 'no response';
                                exit;
                            }else{

                                $tokenres = json_decode($response,true);
                                $token = $tokenres["result"]["token"];                                
                                $keyword = $part_number;

                                $url = 'https://openapi.ickey.cn/search-v1/products/get-single-goods-new';
                                $headers[] = 'Content-Type: application/x-www-form-urlencoded';
                                $headers[] = 'Accept: application/json';
                                $headers[] = 'Cache-Control: no-cache';

                                $host_info = explode("/", $url);
                                $port = $host_info[0] == 'https:' ? 443 : 80;
                                $ch_item = curl_init();

                                curl_setopt($ch_item, CURLOPT_PORT, $port);
                                curl_setopt($ch_item, CURLOPT_URL, $url);
                                curl_setopt($ch_item, CURLOPT_HTTPHEADER, $headers);
                                curl_setopt($ch_item, CURLOPT_RETURNTRANSFER, true);
                                curl_setopt($ch_item, CURLOPT_POSTFIELDS, 'token='.$token.'&_t='.$timestamp.'&keyword='.$keyword);

                                $response_item = curl_exec($ch_item);

                                curl_close($ch_item);

                                if (!$response_item) {
                                    echo '<br>no response';
                                }else{
                                    
                                    $details = json_decode($response_item,true);
                                    // var_dump($details);

                                    if ( $details["success"] == true) {

                                        foreach ($details["result"] as $key => $productitem) {

                                            if ($key == 0) {
                                                if($part_number == $productitem["pro_name"]) {

                                                $ickdefaultimg = "//static.ickimg.com/assets/release3.001/img/pic/default_list_logo.jpg?utm_source=api";
                                                if ($productitem["img_url"] == $ickdefaultimg) {
                                                    $productitem["img_url"] = "";
                                                }

                                                // $packaging_info = $this->packagingUnitModel->findByPackingName($productitem["package"]);
                                                // $productitem ["packaging_code"] = $packaging_info->packing_code;

                                                $counrty_code = "CNY";
                                                $ExchangeRat = $this->exchangeInfoModel->where('counrty_code',$counrty_code)->orderBy('created_at desc')->first();
                                                $exchange_rat = $ExchangeRat->standard_amount;

                                                    $this->productModel->updateIckSpwup($product_code, $productitem, $exchange_rat);
                                                    $this->productdetailModel->updateDetailIckSpwup($product_code, $productitem);

                                                }

                                            }


                                        }

                                    }
                                    
                                }

                            }

                    }

                }

            }

            if ($api_updated_day != $today) {

                if ($item->api_code == "LC") {
                    $key = "BsC95BSUFCR95DftYEpz0bCAUvMK7OD";
                    $secret = "O3PsFLzjbVQNaj7Eqn4uf5WFT5AwTIlfSR4FJ";
                    $nonce = "63yeike7dy6c2kjd";

                    $product_api_id = $item->product_api_id;
                    $timestamp = time();

                    $str = 'key='.$key.'&nonce='.$nonce.'&secret='.$secret.'&timestamp='.$timestamp;
                    $str_encode = sha1($str);

                    $url = 'https://ips.lcsc.com/rest/wmsc2agent/product/info/'.$product_api_id.'?key='.$key.'&nonce='.$nonce.'&timestamp='.$timestamp.'&signature='.$str_encode;;
                    $headers[] = 'Accept: application/json';
                    $headers[] = 'Cache-Control: no-cache';

                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                    $ch_response = curl_exec($ch);
                    $err = curl_error($ch);

                    if ($err) {
                        curl_close($ch);
                        $this->apiStatusErr($item->api_code);

                    } else {
                        curl_close($ch);
                        $details = json_decode($ch_response,true);

                        if ($details["success"] == false) {
                            $this->apiStatusErr($item->api_code);

                        } else {
                            $results = $details["result"];
                            $upqty = $results["quantity"];
                            $prices_array = $results["prices"];

                            $counrty_code = "USD";
                            $ExchangeRat = $this->exchangeInfoModel->where('counrty_code',$counrty_code)->orderBy('created_at desc')->first();
                            $exchange_rat = $ExchangeRat->standard_amount;

                            if ($prices_array) {
                                $this->productModel->updateLcscAipup($product_api_id, $upqty, $prices_array, $exchange_rat);
                            }
                        }
                    }
                }
                
                if ($item->api_code == "ICK") {
                    $appid = 'SELPASEMICOM$CO$LTD_690';
                    $appkey = '51d3afa11c937ae7ea0d8c4a4a77c5c9';
                    $timestamp = time();
                    $sign = md5('_t='.$timestamp.'&appid='.$appid.'|'.$appkey);

                    $url = 'https://openapi.ickey.cn/v2/new-token/create';
                    $headers[] = 'Content-Type: application/x-www-form-urlencoded';
                    $headers[] = 'Accept: application/json';
                    $headers[] = 'Cache-Control: no-cache';

                    $host_info = explode("/", $url);
                    $port = $host_info[0] == 'https:' ? 443 : 80;
                    $ch = curl_init();

                    curl_setopt($ch, CURLOPT_PORT, $port);
                    curl_setopt($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, 'appid='.$appid.'&_t='.$timestamp.'&sign='.$sign);

                    $response = curl_exec($ch);
                    curl_close($ch);

                    if (!$response) {
                        $this->apiStatusErr($item->api_code);

                    }else{
                        $tokenres = json_decode($response,true);
                        $token = $tokenres["result"]["token"];
                        $sku0 = $item->product_api_id;

                        $url = 'https://openapi.ickey.cn/search-v1/products/sku-info';
                        $headers[] = 'Content-Type: application/x-www-form-urlencoded';
                        $headers[] = 'Accept: application/json';
                        $headers[] = 'Cache-Control: no-cache';

                        $host_info = explode("/", $url);
                        $port = $host_info[0] == 'https:' ? 443 : 80;
                        $ch_item = curl_init();

                        curl_setopt($ch_item, CURLOPT_PORT, $port);
                        curl_setopt($ch_item, CURLOPT_URL, $url);
                        curl_setopt($ch_item, CURLOPT_HTTPHEADER, $headers);
                        curl_setopt($ch_item, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($ch_item, CURLOPT_POSTFIELDS, 'token='.$token.'&_t='.$timestamp.'&sku[0]='.$sku0);

                        $response_item = curl_exec($ch_item);
                        curl_close($ch_item);

                        if (!$response_item) {
                            $this->apiStatusErr($item->api_code);
                            //echo 'no response';
                        }else{
                            $response = json_decode($response_item,true);
                            $results = $response["result"];

                            if ($results) {
                                $counrty_code = "CNY";
                                $ExchangeRat = $this->exchangeInfoModel->where('counrty_code',$counrty_code)->orderBy('created_at desc')->first();
                                $exchange_rat = $ExchangeRat->standard_amount;

                                $skunum = $sku0;
                                $sku = $results[$skunum]["sku"];

                                if ($sku == $skunum) {
                                $this->productModel->updateIckAipup($sku, $results, $exchange_rat);
                                }
                            }
                        }
                    }
                }
            }
        }

        $item_now = $this->productModel->findByProductCode($itemCode);
        $itemdetail = $this->productdetailModel->where('product_code',$itemCode)->first();

        if ($item_now) {
            $part_category_code = $item_now->part_category;
            $part_category_info = $this->categorylevel1Model->findByCategoryCode($part_category_code);

            $item_now->part_category_name = $part_category_info['categorylevel1_name'];
            $item_now->part_category_code = $part_category_info['categorylevel1_code'];

            $part_category2_code = $item_now->part_category2;
            $part_category2_info = $this->categorylevel2Model->findByCategoryCode($part_category2_code);
            $item_now->part_category2_name = $part_category2_info['categorylevel2_name'];
            $item_now->part_category2_code = $part_category2_info['categorylevel2_code'];

            $part_category3_code = $item_now->part_category3;
            $part_category3_info = $this->categorylevel3Model->findByCategoryCode($part_category3_code);
            $item_now->part_category3_name = $part_category3_info['categorylevel3_name'];
            $item_now->part_category3_code = $part_category3_info['categorylevel3_code'];

            $delivery_code = $item_now->delivery_code;
            $delivery_code_info = $this->deliverycodesModel->findByCategoryInfo($delivery_code);
            $item_now->delivery_content = $delivery_code_info->content;
            if($item_now->price){
            $item_now->discount_rate = floor(100-($item_now->selling_price1/$item_now->price*100));
            }

            $inquiry = $this->inquiryModel->getSearchSale($itemCode,$perPage);
            $data['inquirypager'] = $inquiry['pager'];
            $data['inquirylist'] = $inquiry['lists'];
            $data['device_type'] = $this->get_device_type();

            $inquiry_code = AuthHelpers::getIqrCode();
            if(!$inquiry_code) {
            AuthHelpers::setIqrCode($inquirycode);
            }

            $data['item'] = $item_now;
            $data['itemdetail'] = $itemdetail;

            $data['eventinfos'] = $this->eventinfoModel->getEventinfo();
            $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
            $data['leadtimecategorys'] = $this->leadtimeCategoryModel->findAll();
            $data['deliverycodes'] = $this->deliverycodesModel->findAll();

            return $this->viewGuest('sale/detail',$data);

        }else{

            $msg = '해당 제품정보가 없습니다.';     
            echo "<script type='text/javascript'>alert('$msg');history.go(-1);</script>";

        }
    }

    function get_device_type() {
        $user_agent = $_SERVER['HTTP_USER_AGENT'];
        $mobile_agents = array('iphone','ipod','ipad','android','webos','blackberry','nokia','opera mini','windows mobile','windows phone','iemobile');
        foreach($mobile_agents as $mobile_agent) {
            if (strpos(strtolower($user_agent), strtolower($mobile_agent)) !== false) {
                return 'mobile';
            }
        }
        return 'PC';
    }

    public function viewPdf($itemId, $partNumber){
        $item = $this->productModel->find($itemId);
        if(isset($item)){
            $pdfPath = $item->pdf_dir;
            $filename = "$item->part_number.pdf";
            $this->setHeaderViewPdf($filename,PUBLIC_PATH . $pdfPath);
        }
        exit;
    }

    public function addCart($itemId){
        if(AuthHelpers::checkLoginGuest()){
            $quantity = $this->request->getGet('quantity');
            $price = $this->request->getGet('price');
            $item = $this->productModel->findByItemId($itemId);
            if(isset($item)){
                AuthHelpers::addItemCart($item, $quantity, $price);
                $cart = AuthHelpers::getCart();
                $cartCount = count($cart->items);
                $dataJson = [
                    'countCart' => $cartCount,
                ];
                return $this->toJsonSuccess('Add cart success', $dataJson);
            }
            return $this->toJsonError('Sale item do not exit');
        }
        $data=[
            'status' => -1,
            'message' => 'Please login.'
        ];
        return $this->toJson($data);
    }


    public function inquiry($itemId)
    {
        $this->rules = $this->partInquiryModel->getValidationRules();
        $account = AuthHelpers::getLoginInfoGuest();
        $data['memberName'] = '';
        $data['memberEmail'] = '';
        if(isset($account)){
            $data['memberName'] = $account->member_name;
            $data['memberEmail'] = $account->member_email;
        }

        $item = $this->productModel->findByItemId($itemId);
        $data['item_id'] = $item->item_id;
        $data['part_number'] = $item->part_number;
        $data['qty'] = $item->qty;
        $data['price'] = $item->price;
        $manufactureId = $item->maker_seq;

        $manufacturer = $this->manufacturerModel->findById($manufactureId);
        $data['maker_seq'] = $manufacturer->maker_seq;
        $data['name'] = $manufacturer->name;
        $data['code'] = $manufacturer->code;

        return $this->viewGuest('sale/inquiry', $data);
    }

    public function createInquiry()
    {
        $this->rules = $this->partInquiryModel->getValidationRules();
        if($this->checkValidation()){
            //Create Inquiry
            $inquiry = new PartInquiry($this->request->getPost());
            $this->partInquiryModel->save($inquiry);

            $inquiry_id = $this->partInquiryModel->insertID;

            return redirect()->route('guest.sale.sendmail')->with('inquiry_id', $inquiry_id);
        }else{
            return redirect('guest.sale.inquiry')->withInput();
        }
    }

    public function partInquiry()
    {
            $api_code = $this->request->getPost('api_code');
            $product_api_id = $this->request->getPost('product_api_id');

            ///////////////////////////////////////

        //    if ($api_code == "LC") {
        //        $key = "BsC95BSUFCR95DftYEpz0bCAUvMK7OD";
        //        $secret = "O3PsFLzjbVQNaj7Eqn4uf5WFT5AwTIlfSR4FJ";
        //        $nonce = "63yeike7dy6c2kjd";
        //        $timestamp = time();
        //        $str = 'key='.$key.'&nonce='.$nonce.'&secret='.$secret.'&timestamp='.$timestamp;
        //        $str_encode = sha1($str);
        //        $url = 'https://ips.lcsc.com/rest/wmsc2agent/product/info/'.$product_api_id.'?key='.$key.'&nonce='.$nonce.'&timestamp='.$timestamp.'&signature='.$str_encode;;
        //        $headers[] = 'Accept: application/json';
        //        $headers[] = 'Cache-Control: no-cache';
        //        $ch = curl_init();
        //        curl_setopt($ch, CURLOPT_URL, $url);
        //        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        //        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        //        $ch_response = curl_exec($ch);
        //        $err = curl_error($ch);
        //        if ($err) {
        //            echo "cURL Error #:" . $err;
        //            curl_close($ch);
        //        } else {
        //            curl_close($ch);
        //            $details = json_decode($ch_response,true);
        //            $results = $details["result"];
        //            $upqty = $results["quantity"];
        //            $prices_array = $results["prices"];
        //            $counrty_code = "USD";
        //            $ExchangeRat = $this->exchangeInfoModel->where('counrty_code',$counrty_code)->orderBy('created_at desc')->first();
        //            $exchange_rat = $ExchangeRat->standard_amount;
        //            if ($prices_array) {
        //                $this->productModel->updateLcscAipup($product_api_id, $upqty, $prices_array, $exchange_rat);
        //            }
        //        }
        //    }
    
            ///////////////////////////////////////

        // $this->rules = $this->cartPartinfoModel->getValidationRules();

        // if($this->checkValidation()){
    
            //Create Inquiry
            $inquiry = new PartInquiry($this->request->getPost());

            $qty = $inquiry->qty;
            $price = $inquiry->price;
            $part_sequence =  $inquiry->part_sequence;
            $inquiry_code =  $inquiry->inquiry_code;

            $item = $this->productModel->findByProductCode($part_sequence);
            $inventory = $item->qty;

            // var_dump($inventory);
            // echo "<br>";
            // var_dump($qty);
            // exit;

            if ($inventory < $qty){

                $refererUrl = $_SERVER['HTTP_REFERER'];

                session()->setFlashdata('status_text', '구매수량 보다 재고수량이 부족합니다.');
                return redirect()->to($refererUrl)
                    ->with('status_icon', 'warning')
                    ->with('status', '재고부족');

            }


            // [M] 카트에 동일 제품 유무 체크
            $containedPart =  $this->cartPartinfoModel->containedPart($inquiry_code, $part_sequence);
            $containedCount = count($containedPart['lists']);

        if ($containedCount == 0) {
            $price1 = $item->selling_price1;
            $quantity1 = $item->unit_mini_quantity1;
            $quantity1k = $quantity1 * 2;
            $price2 = $item->selling_price2;
            $quantity2 = $item->unit_mini_quantity2;
            $quantity2k = $quantity2 * 2;
            $price3 = $item->selling_price3;
            $quantity3 = $item->unit_mini_quantity3;
            $quantity3k = $quantity3 * 2;
            $price4 = $item->selling_price4;
            $quantity4 = $item->unit_mini_quantity4;
            $quantity4k = $quantity4 * 2;
            $price5 = $item->selling_price5;
            $quantity5 = $item->unit_mini_quantity5;
            $quantity5k = $quantity5 * 2;
            $price6 = $item->selling_price6;
            $quantity6 = $item->unit_mini_quantity6;
            $quantity6k = $quantity6 * 2;
    
            if ($qty >= $quantity6 and $price6 != 0) {
                    $price = $price6;
            } elseif ($qty >= $quantity5 and $price5 != 0) {
                    $price = $price5;
            } elseif ($qty >= $quantity4 and $price4 != 0) {
                    $price = $price4;
            } elseif ($qty >= $quantity3 and $price3 != 0) {
                    $price = $price3;
            } elseif ($qty >= $quantity2 and $price2 != 0) {
                    $price = $price2;
            } elseif ($qty >= $quantity1 and $price1 != 0) {
                    $price = $price1;
            }

    
            $inquiry->price = $price;

            // [M] 카트에 재고등록
            $this->cartPartinfoModel->save($inquiry);

            $inquiry_id = $this->cartPartinfoModel->insertID;

            $refererUrl = $_SERVER['HTTP_REFERER'];

            session()->setFlashdata('status_text', '장바구니에 선택하신 부품을 담았습니다.');
            return redirect()->to($refererUrl)
                ->with('status_icon', 'success')
                ->with('status', '장바구니 담기 성공');
        
        } else {

            if ($containedCount == 1) {

                foreach ($containedPart['lists'] as $key => $upitem){
                    $inquiry_id = $upitem->inquiry_id;
                    $containedQty = $upitem->qty;
                }

                $upqty= $containedQty + $qty;

                $price1 = $item->selling_price1;
                $quantity1 = $item->unit_mini_quantity1;
                $quantity1k = $quantity1 * 2;
                $price2 = $item->selling_price2;
                $quantity2 = $item->unit_mini_quantity2;
                $quantity2k = $quantity2 * 2;
                $price3 = $item->selling_price3;
                $quantity3 = $item->unit_mini_quantity3;
                $quantity3k = $quantity3 * 2;
                $price4 = $item->selling_price4;
                $quantity4 = $item->unit_mini_quantity4;
                $quantity4k = $quantity4 * 2;
                $price5 = $item->selling_price5;
                $quantity5 = $item->unit_mini_quantity5;
                $quantity5k = $quantity5 * 2;
                $price6 = $item->selling_price6;
                $quantity6 = $item->unit_mini_quantity6;
                $quantity6k = $quantity6 * 2;
        
                if ($upqty >= $quantity6 and $price6 != 0) {
                        $price = $price6;
                } elseif ($upqty >= $quantity5 and $price5 != 0) {
                        $price = $price5;
                } elseif ($upqty >= $quantity4 and $price4 != 0) {
                        $price = $price4;
                } elseif ($upqty >= $quantity3 and $price3 != 0) {
                        $price = $price3;
                } elseif ($upqty >= $quantity2 and $price2 != 0) {
                        $price = $price2;
                } elseif ($upqty >= $quantity1 and $price1 != 0) {
                        $price = $price1;
                }

                $this->cartPartinfoModel->containedtUpqty($inquiry_code, $inquiry_id, $upqty, $price);

                $refererUrl = $_SERVER['HTTP_REFERER'];

                session()->setFlashdata('status_text', '장바구니에 선택하신 동일부품의 내역으로 추가했습니다.');
                return redirect()->to($refererUrl)
                    ->with('status_icon', 'success')
                    ->with('status', '장바구니 담기 성공');
                    
            } else {

                $refererUrl = $_SERVER['HTTP_REFERER'];

                session()->setFlashdata('status_text', '장바구니 정보에 오류가 있습니다.');
                return redirect()->to($refererUrl)
                    ->with('status_icon', 'warning')
                    ->with('status', '장바구니 담기 실패');
                    

            }
            
        }

    }

    public function estimatePart()
    {

       $api_code = $this->request->getPost('api_code');
       $product_api_id = $this->request->getPost('product_api_id');

        // var_dump($this->request->getPost());
        // exit;


       ///////////////////////////////////////

    //    if ($api_code == "LC") {
    //        $key = "BsC95BSUFCR95DftYEpz0bCAUvMK7OD";
    //        $secret = "O3PsFLzjbVQNaj7Eqn4uf5WFT5AwTIlfSR4FJ";
    //        $nonce = "63yeike7dy6c2kjd";
    //        $timestamp = time();
    //        $str = 'key='.$key.'&nonce='.$nonce.'&secret='.$secret.'&timestamp='.$timestamp;
    //        $str_encode = sha1($str);
    //        $url = 'https://ips.lcsc.com/rest/wmsc2agent/product/info/'.$product_api_id.'?key='.$key.'&nonce='.$nonce.'&timestamp='.$timestamp.'&signature='.$str_encode;;
    //        $headers[] = 'Accept: application/json';
    //        $headers[] = 'Cache-Control: no-cache';
    //        $ch = curl_init();
    //        curl_setopt($ch, CURLOPT_URL, $url);
    //        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    //        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    //        $ch_response = curl_exec($ch);
    //        $err = curl_error($ch);
    //        if ($err) {
    //            echo "cURL Error #:" . $err;
    //            curl_close($ch);
    //        } else {
    //            curl_close($ch);
    //            $details = json_decode($ch_response,true);
    //            $results = $details["result"];
    //            $upqty = $results["quantity"];
    //            $prices_array = $results["prices"];
    //            $counrty_code = "USD";
    //            $ExchangeRat = $this->exchangeInfoModel->where('counrty_code',$counrty_code)->orderBy('created_at desc')->first();
    //            $exchange_rat = $ExchangeRat->standard_amount;
    //            if ($prices_array) {
    //                $this->productModel->updateLcscAipup($product_api_id, $upqty, $prices_array, $exchange_rat);
    //            }
    //        }
    //    }

       ///////////////////////////////////////


        $this->rules = $this->estimatePartinfoModel->getValidationRules();
        if($this->checkValidation()){
    
            $estimate = new PartInquiry($this->request->getPost());
            // var_dump($estimate);
            // exit;
            
            $this->estimatePartinfoModel->save($estimate);

            $estimate_id = $this->estimatePartinfoModel->insertID;

            return redirect('guest.estimate.show_create')->withInput();

        }else{
          // return redirect('guest.sale.index')->withInput();
        }
    }


    public function estimateFromCart()
    {
        $estimate = new PartInquiry();

        $dataRow = $this->request->getPost('dataRow');
           
           for($i=1;$i <= $dataRow;$i++):
                $inquiry_code = $this->request->getPost('inquiry_code'.$i);
                $inquiry_id = $this->request->getPost('inquiry_id'.$i);

                $estimate->inquiry_code = $inquiry_code;
                if (!$member_id) {
                $estimate->member_id = AuthHelpers::getLoginInfoGuest()->member_email;
                }

                $estimate->name = $this->request->getPost('name'.$i);
                $estimate->part_sequence = $this->request->getPost('product_code'.$i);
                $estimate->category3_code = $this->request->getPost('category3_code'.$i);                
                $estimate->stock_location = $this->request->getPost('stock_location'.$i);
                $estimate->delivery_code = $this->request->getPost('delivery_code'.$i);
                $estimate->leadtime = $this->request->getPost('leadtime'.$i);
                $estimate->part_number = $this->request->getPost('part_number'.$i);
                $estimate->price = $this->request->getPost('price'.$i);
                $estimate->qty = $this->request->getPost('p_num'.$i);

                $this->estimatePartinfoModel->save($estimate);
                $this->cartPartinfoModel->updateIdActiveFlg($inquiry_code, $inquiry_id);
           endfor;

        return redirect('guest.estimate.show_create')->withInput();

    }


    public function inquiryPart()
    {

        $this->rules = $this->inquiryPartinfoModel->getValidationRules();

        if($this->checkValidation()){
    
            $inquiry = new PartInquiry($this->request->getPost());
            $this->inquiryPartinfoModel->save($inquiry);
            $inquiry_id = $this->inquiryPartinfoModel->insertID;

           return redirect('guest.inquiry.show_create')->withInput();
        }else{
          // return redirect('guest.sale.index')->withInput();
        }
    }

    
    public function sendmail()
    {
        //echo "메일 테스트";
        //exit;

        $email = \Config\Services::email();

        $config['protocol'] = 'html';
        $config['mailPath'] = '/usr/sbin/sendmail -t -i';
        $config['fromEmail'] = 'chipdirectmall@gmail.com';
        $config['fromName'] = 'ChipDirect';


        $email->initialize($config);
        $email->setFrom('pixel@mediain.co.kr', 'Selpasemicom');
        $email->setTo('pixel25@naver.com');
        $email->setSubject('[메일테스트] 메일 테스터를 전송했습니다.');
        $email->setMessage('메일 테스터를 전송했습니다.<br>메일 테스터를 전송했습니다.');

        if($email->send(false)){
            $message = 'Create inquiry success.';
            return redirect()->route('guest.sale.sendmailok')->with('message' , $message);	
        }else{
            echo "There is a problem with sending E-Mail.";
        }
    }

    public function sendmailok()
    {
        echo "메일 테스트 성공 !!";
        exit;
    }


    public function stateChange(){        
        // $today = date('Y-m-d h:i:s ', time());
        $day_7ago = date('Y-m-d h:i:s', strtotime('-7 Day'));
        // echo $today."<br>".$day_7ago."<br>";
        $this->orderPartinfoModel->autoStateChange05($day_7ago);
        $this->orderPartinfoModel->autoStateChange06($day_7ago);
        exit;
    }


}
