<?php namespace App\Entities;

class Manufacturer extends BaseEntity
{
    public const MAKER_SEQ = "maker_seq";
    public const MAKER_CODE = "maker_code";
    public const NAME = "name";
    public const MANUFACTURER_LINK = "manufacturer_link";
    public const MANUFACTURER_CONTENT = "manufacturer_content";
    public const MANUFACTURER_IMAGE_DIR = "manufacturer_image_dir";
    public const MANUFACTURER_LOGO_DIR = "manufacturer_logo_dir";
    public const DEL_FLG = "del_flg";
    public const CREATED_AT = "created_at";
    public const UPDATED_AT = "updated_at";

    public function toArrayData($columns = []){
        $data = [
            self::MAKER_SEQ => $this->maker_seq,
            self::MAKER_CODE => $this->maker_code,
            self::NAME => $this->name,
            self::MANUFACTURER_LINK => $this->manufacturer_link,
            self::MANUFACTURER_CONTENT => $this->manufacturer_content,
            self::MANUFACTURER_IMAGE_DIR => $this->manufacturer_image_dir,
            self::MANUFACTURER_LOGO_DIR => $this->manufacturer_logo_dir,
            self::DEL_FLG => $this->del_flg,
            self::CREATED_AT => $this->created_at,
            self::UPDATED_AT  => $this->updated_at
        ];
        if(!isset($columns) || count($columns) <= 0) return $data;
        $resultData = [];
        foreach($columns as $column){
            if(isset($data[$column])){
                $resultData[$column] = $data[$column];
            }
        }
        return $resultData;
    }
}