<?php namespace App\Entities;

class Product extends BaseEntity
{
    public const PRODUCT_ID = "product_id";
    public const PRODUCT_CODE = "product_code";
    public const PART_CATEGORY = "part_category";
    public const PART_CATEGORY_NAME = "categorylevel1_name";
    public const PART_CATEGORY2 = "part_category2";
    public const PART_CATEGORY2_NAME = "categorylevel2_name";
    public const PART_CATEGORY3 = "part_category3";
    public const PART_CATEGORY3_NAME = "categorylevel3_name";
    public const MAKER_SEQ = "maker_seq";
    public const MAKER_NAME = "maker_name";    
    public const LOCATION_CODE = "location_code";
    public const DISPLAY_SET = "display_set";
    public const NEWPRODUCT_CHK = "newproduct_chk";
    public const BESTPRODUCT_CHK = "bestproduct_chk";
    public const RECOMPRODUCT_CHK = "recomproduct_chk";
    public const BRANDPRODUCT_CHK = "brandproduct_chk";
    public const EVENT_SET = "event_set";
    public const PART_NUMBER = "part_number";
    public const part_number_sequence = "part_number_sequence";
    public const SEARCH_WORD = "search_word";
    public const BRIEF_DESCRIPTION = "brief_description";
    public const SITUATION = "situation";
    public const EXPOSURE = "exposure";

    public const PRODUCT_RELATED = "product_related";
    public const DATE_CODE = "date_code";
    public const IMAGE_DIR = "image_dir";

    public const DELIVERY_CODE = "delivery_code";
    public const API_FLG = "api_flg";
    public const API_CODE = "api_code";
    public const TARIFF_RATE = "tariff_rate";
    public const PRODUCT_API_ID = "product_api_id";
    public const QTY = "qty";
    public const PACKING_CODE = "packing_code";
    public const WEARING_PRICE = "wearing_price";
    public const PRICE = "price";
    public const LEADTIME = "leadtime";
    public const MOQ = "moq";
    public const IN_MOQ = "in_moq";
    public const MPQ = "mpq";
    public const STOCK_LOCATION = "stock_location";
    public const TAXABLE = "taxable";


    public const SELLING_PRICE1 = "selling_price1";
    public const MARGIN_RATE1 = "margin_rate1";
    public const unit_mini_quantity1 = "unit_mini_quantity1";
    public const UNIT_MAX_QUANTITY1 = "unit_max_quantity1";

    public const SELLING_PRICE2 = "selling_price2";
    public const MARGIN_RATE2 = "margin_rate2";
    public const unit_mini_quantity2 = "unit_mini_quantity2";
    public const UNIT_MAX_QUANTITY2 = "unit_max_quantity2";

    public const SELLING_PRICE3 = "selling_price3";
    public const MARGIN_RATE3 = "margin_rate3";
    public const unit_mini_quantity3 = "unit_mini_quantity3";
    public const UNIT_MAX_QUANTITY3 = "unit_max_quantity3";

    public const SELLING_PRICE4 = "selling_price4";
    public const MARGIN_RATE4 = "margin_rate4";
    public const unit_mini_quantity4 = "unit_mini_quantity4";
    public const UNIT_MAX_QUANTITY4 = "unit_max_quantity4";

    public const SELLING_PRICE5 = "selling_price5";
    public const MARGIN_RATE5 = "margin_rate5";
    public const unit_mini_quantity5 = "unit_mini_quantity5";
    public const UNIT_MAX_QUANTITY5 = "unit_max_quantity5";

    public const SELLING_PRICE6 = "selling_price6";
    public const MARGIN_RATE6 = "margin_rate6";
    public const unit_mini_quantity6 = "unit_mini_quantity6";
    public const UNIT_MAX_QUANTITY6 = "unit_max_quantity6";
    public const ACTIVE_FLG = "active_flg";
    public const DEL_FLG = "del_flg";
    public const CREATED_AT = "created_at";
    public const UPDATED_AT = "updated_at";

    public function toArrayData($columns = []){
        $data = [
            self::PRODUCT_ID  => $this->product_id,
            self::PRODUCT_CODE  => $this->product_code,
            self::PART_CATEGORY  => $this->part_category,
            self::PART_CATEGORY_NAME  => $this->categorylevel1_name,
            self::PART_CATEGORY2  => $this->part_category2,
            self::PART_CATEGORY2_NAME  => $this->categorylevel2_name,
            self::PART_CATEGORY3  => $this->part_category3,
            self::PART_CATEGORY3_NAME  => $this->categorylevel3_name,
            self::MAKER_SEQ  => $this->maker_seq,
            self::MAKER_NAME  => $this->maker_name,
            self::LOCATION_CODE  => $this->location_code,
            self::DISPLAY_SET  => $this->display_set,
            self::NEWPRODUCT_CHK  => $this->newproduct_chk,
            self::BESTPRODUCT_CHK  => $this->bestproduct_chk,
            self::RECOMPRODUCT_CHK  => $this->recomproduct_chk,
            self::BRANDPRODUCT_CHK  => $this->brandproduct_chk,
            self::EVENT_SET  => $this->event_set,
            self::PART_NUMBER  => $this->part_number,
            self::part_number_sequence  => $this->part_number_sequence,
            self::SEARCH_WORD  => $this->search_word,
            self::BRIEF_DESCRIPTION  => $this->brief_description,
            self::SITUATION  => $this->situation,
            self::EXPOSURE  => $this->exposure,
            self::PRODUCT_RELATED  => $this->product_related,
            self::DATE_CODE  => $this->date_code,
            self::IMAGE_DIR  => $this->image_dir,
            self::DELIVERY_CODE  => $this->delivery_code,
            self::API_FLG  => $this->api_flg,
            self::API_CODE  => $this->api_code,
            self::TARIFF_RATE  => $this->tariff_rate,
            self::PRODUCT_API_ID  => "'".$this->product_api_id,
            self::QTY  => $this->qty,
            self::PACKING_CODE  => $this->packing_code,
            self::WEARING_PRICE  => $this->wearing_price,
            self::PRICE  => $this->price,
            self::LEADTIME  => $this->leadtime,
            self::MOQ  => $this->moq,
            self::MPQ  => $this->mpq,
            self::STOCK_LOCATION  => $this->stock_location,
            self::TAXABLE  => $this->taxable,

            self::SELLING_PRICE1  => $this->selling_price1,
            self::MARGIN_RATE1  => $this->margin_rate1,
            self::unit_mini_quantity1  => $this->unit_mini_quantity1,
            self::UNIT_MAX_QUANTITY1  => $this->unit_max_quantity1,

            self::SELLING_PRICE2  => $this->selling_price2,
            self::MARGIN_RATE2  => $this->margin_rate2,
            self::unit_mini_quantity2  => $this->unit_mini_quantity2,
            self::UNIT_MAX_QUANTITY2  => $this->unit_max_quantity2,

            self::SELLING_PRICE3  => $this->selling_price3,
            self::MARGIN_RATE3  => $this->margin_rate3,
            self::unit_mini_quantity3  => $this->unit_mini_quantity3,
            self::UNIT_MAX_QUANTITY3  => $this->unit_max_quantity3,

            self::SELLING_PRICE4  => $this->selling_price4,
            self::MARGIN_RATE4  => $this->margin_rate4,
            self::unit_mini_quantity4  => $this->unit_mini_quantity4,
            self::UNIT_MAX_QUANTITY4  => $this->unit_max_quantity4,

            self::SELLING_PRICE5  => $this->selling_price5,
            self::MARGIN_RATE5  => $this->margin_rate5,
            self::unit_mini_quantity5  => $this->unit_mini_quantity5,
            self::UNIT_MAX_QUANTITY5  => $this->unit_max_quantity5,

            self::SELLING_PRICE6  => $this->selling_price6,
            self::MARGIN_RATE6  => $this->margin_rate6,
            self::unit_mini_quantity6  => $this->unit_mini_quantity6,
            self::UNIT_MAX_QUANTITY6  => $this->unit_max_quantity6,
            self::ACTIVE_FLG  => $this->active_flg,
            self::DEL_FLG  => $this->del_flg,
            self::CREATED_AT  => $this->created_at,
            self::UPDATED_AT  => $this->updated_at
        ];
        if(!isset($columns) || count($columns) <= 0) return $data;
        $resultData = [];
        foreach($columns as $column){
            if(isset($data[$column])){
                $resultData[$column] = $data[$column];
            }
        }
        return $resultData;
    }

    public function cloneProductAddCart(){
        $product = new Product();
        $product->product_id = $this->product_id;
        $product->qty = 1;
        $product->part_number = $this->part_number;
        $product->maker_seq = $this->maker_seq;
        $product->name = $this->name;
        $product->price = isset($this->price) ? $this->price: 0;
        $product->amount = $product->qty * $product->price;
        return $product;

    }
}