<?php namespace App\Entities;

class Showwindow extends BaseEntity
{
    public const PRODUCT_ID = "product_id";
    public const PRODUCT_CODE = "product_code";
    public const PART_CATEGORY = "part_category";
    public const PART_CATEGORY2 = "part_category2";
    public const PART_CATEGORY3 = "part_category3";
    public const MAKER_SEQ = "maker_seq";
    public const LOCATION_CODE = "location_code";
    public const DISPLAY_SET = "display_set";
    public const NEWPRODUCT_CHK = "newproduct_chk";
    public const BESTPRODUCT_CHK = "bestproduct_chk";
    public const RECOMPRODUCT_CHK = "recomproduct_chk";
    public const BRANDPRODUCT_CHK = "brandproduct_chk";
    public const EVENT_SET = "event_set";
    public const PART_NUMBER = "part_number";
    public const BRIEF_DESCRIPTION = "brief_description";
    public const SITUATION = "situation";
    public const EXPOSURE = "exposure";
    public const DESCRIPTION = "description";
    public const PRODUCT_RELATED = "product_related";
    public const DATE_CODE = "date_code";
    public const IMAGE_DIR = "image_dir";
    public const PDF_DIR = "pdf_dir";
    public const DELIVERY_CODE = "delivery_code";
    public const API_FLG = "api_flg";
    public const API_CODE = "api_code";
    public const TARIFF_RATE = "tariff_rate";
    public const PRODUCT_API_ID = "product_api_id";
    public const QTY = "qty";
    public const PACKING_CODE = "packing_code";
    public const WEARING_PRICE = "wearing_price";
    public const PRICE = "price";
    public const LEADTIME = "leadtime";
    public const MOQ = "moq";
    public const MPQ = "mpq";
    public const STOCK_LOCATION = "stock_location";
    public const TAXABLE = "taxable";

    public const SELLING_PRICE1 = "selling_price1";
    public const MARGIN_RATE1 = "margin_rate1";
    public const unit_mini_quantity1 = "unit_mini_quantity1";
    public const UNIT_MAX_QUANTITY1 = "unit_max_quantity1";

    public const ACTIVE_FLG = "active_flg";
    public const DEL_FLG = "del_flg";
    public const CREATED_AT = "created_at";
    public const UPDATED_AT = "updated_at";

    public function toArrayData($columns = []){
        $data = [
            self::PRODUCT_ID  => $this->product_id,
            self::PRODUCT_CODE  => $this->product_code,
            self::PART_CATEGORY  => $this->part_category,
            self::PART_CATEGORY2  => $this->part_category2,
            self::PART_CATEGORY3  => $this->part_category3,
            self::MAKER_SEQ  => $this->maker_seq,
            self::LOCATION_CODE  => $this->location_code,
            self::DISPLAY_SET  => $this->display_set,
            self::NEWPRODUCT_CHK  => $this->newproduct_chk,
            self::BESTPRODUCT_CHK  => $this->bestproduct_chk,
            self::RECOMPRODUCT_CHK  => $this->recomproduct_chk,
            self::BRANDPRODUCT_CHK  => $this->brandproduct_chk,
            self::EVENT_SET  => $this->event_set,
            self::PART_NUMBER  => $this->part_number,
            self::BRIEF_DESCRIPTION  => $this->brief_description,
            self::SITUATION  => $this->situation,
            self::EXPOSURE  => $this->exposure,
            self::DESCRIPTION  => $this->description,
            self::PRODUCT_RELATED  => $this->product_related,
            self::DATE_CODE  => $this->date_code,
            self::IMAGE_DIR  => $this->image_dir,
            self::PDF_DIR  => $this->pdf_dir,
            self::DELIVERY_CODE  => $this->delivery_code,
            self::API_FLG  => $this->api_flg,
            self::API_CODE  => $this->api_code,
            self::TARIFF_RATE  => $this->tariff_rate,
            self::PRODUCT_API_ID  => $this->product_api_id,
            self::QTY  => $this->qty,
            self::PACKING_CODE  => $this->packing_code,
            self::WEARING_PRICE  => $this->wearing_price,
            self::PRICE  => $this->price,
            self::LEADTIME  => $this->leadtime,
            self::MOQ  => $this->moq,
            self::MPQ  => $this->mpq,
            self::STOCK_LOCATION  => $this->stock_location,
            self::TAXABLE  => $this->taxable,

            self::SELLING_PRICE1  => $this->selling_price1,
            self::MARGIN_RATE1  => $this->margin_rate1,
            self::unit_mini_quantity1  => $this->unit_mini_quantity1,
            self::UNIT_MAX_QUANTITY1  => $this->unit_max_quantity1,

            self::ACTIVE_FLG  => $this->active_flg,
            self::DEL_FLG  => $this->del_flg,
            self::CREATED_AT  => $this->created_at,
            self::UPDATED_AT  => $this->updated_at
        ];
        if(!isset($columns) || count($columns) <= 0) return $data;
        $resultData = [];
        foreach($columns as $column){
            if(isset($data[$column])){
                $resultData[$column] = $data[$column];
            }
        }
        return $resultData;
    }

    public function cloneShowwindowAddCart(){
        $product = new Showwindow();
        $product->product_id = $this->product_id;
        $product->qty = 1;
        $product->part_number = $this->part_number;
        $product->maker_seq = $this->maker_seq;
        $product->name = $this->name;
        $product->price = isset($this->price) ? $this->price: 0;
        $product->amount = $product->qty * $product->price;
        return $product;

    }
}