<?php namespace App\Filters\Admin;

use App\Controllers\Common\SessionConstant;
use App\Helpers\AuthHelpers;
use App\Models\AccountManagerModel;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Filters\FilterInterface;

class AuthFilter implements FilterInterface
{
    private $accountManagerModel;

    public function __construct()
    {
        $this->accountManagerModel = new AccountManagerModel();
        helper('cookie');
    }

    public function before(RequestInterface $request, $arguments = null)
    {
        $requestUri = $_SERVER['PATH_INFO'];
        if($requestUri != '/admin/login' && !AuthHelpers::checkLoginAdmin()){
            $accountManager = AuthHelpers::getCookieInfoAdmin();
            if(isset($accountManager) && isset($accountManager->account_id)){
                $account = $this->accountManagerModel->find($accountManager->account_id);
                if(isset($account)){
                    AuthHelpers::setLoginAdmin($account->toSession());
                }
            }else{
                return redirect()->route('admin.show_login');
            }
        }else{
            $accountManager = AuthHelpers::getLoginInfoAdmin();
            if($accountManager->remember == 1){
                AuthHelpers::setCookieLoginAdmin($accountManager);
            }
        }
    }

    //--------------------------------------------------------------------

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {

    }
}