<?php namespace App\Filters\Guest;

use App\Helpers\AuthHelpers;
use App\Models\MemberModel;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Filters\FilterInterface;

class AuthFilter implements FilterInterface
{
    private $memberModel;

    public function __construct()
    {
        $this->memberModel = new MemberModel();
        helper('cookie');
    }

    public function before(RequestInterface $request, $arguments = null)
    {
        if(!AuthHelpers::checkLoginGuest()){
            $memberAccount = AuthHelpers::getCookieInfoGuest();
            if(isset($memberAccount) && isset($memberAccount->member_id)){
                $account = $this->memberModel->find($memberAccount->member_id);
                if(isset($account)){
                    AuthHelpers::setLoginGuest($account->toSession());
                }
            }else{
                return redirect()->route('guest.login');
            }
        }
    }

    //--------------------------------------------------------------------

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {

    }
}