<?php

if(!function_exists('asset_admin_css')){
    function asset_admin_css($url){
        return base_url('css/admin/'.$url);
    }
}

if(!function_exists('asset_admin_js')){
    function asset_admin_js($url){
        return base_url('js/admin/'.$url);
    }
}

if(!function_exists('route_admin')){
    function route_admin($method, ...$params){
        return route_to('admin.'.$method, ...$params);
    }
}

if(!function_exists('is_public')){
    function is_public($value){
        return $value == PUBLIC_FLG_ON;
    }
}

if(!function_exists('public_name')){
    function public_name($value){
        if(is_public($value)) return lang_constant('public_flg_on_name');
        return lang('Constant.public_flg_off_name');
    }
}


if(!function_exists('public_check_input')){
    function public_check_input($value){
        if(is_public($value)) return 'checked="checked"';
        return '';
    }
}

if(!function_exists('get_public_id')){
    function get_public_id($value){
        if($value == 'on') return PUBLIC_FLG_ON;
        return PUBLIC_FLG_OFF;
    }
}

if(!function_exists('lang_categorylevel')){
    function lang_categorylevel($name){
        return lang('Layout_Admin.categorylevel_'.$name);
    }
}
if(!function_exists('lang_fileuploader')){
    function lang_fileuploader($name){
        return lang('Layout_Admin.fileuploader_'.$name);
    }
}
if(!function_exists('lang_loginapi')){
    function lang_loginapi($name){
        return lang('Layout_Admin.loginapi_'.$name);
    }
}
if(!function_exists('lang_paymentapi')){
    function lang_paymentapi($name){
        return lang('Layout_Admin.paymentapi_'.$name);
    }
}
if(!function_exists('lang_affiliateapi')){
    function lang_affiliateapi($name){
        return lang('Layout_Admin.affiliateapi_'.$name);
    }
}

//Lang Helper
if(!function_exists('lang_common')){
    function lang_common($name){
        return lang('Layout_Admin.common_'.$name);
    }
}
if(!function_exists('lang_news')){
    function lang_news($name){
        return lang('Layout_Admin.news_'.$name);
    }
}
if(!function_exists('lang_bannermains')){
    function lang_bannermains($name){
        return lang('Layout_Admin.bannermains_'.$name);
    }
}
if(!function_exists('lang_bannerinfos')){
    function lang_bannerinfos($name){
        return lang('Layout_Admin.bannerinfos_'.$name);
    }
}
if(!function_exists('lang_popups')){
    function lang_popups($name){
        return lang('Layout_Admin.popups_'.$name);
    }
}
if(!function_exists('lang_deliverycodes')){
    function lang_deliverycodes($name){
        return lang('Layout_Admin.deliverycodes_'.$name);
    }
}
if(!function_exists('lang_apiinfos')){
    function lang_apiinfos($name){
        return lang('Layout_Admin.apiinfos_'.$name);
    }
}
if(!function_exists('lang_leadtimecategorys')){
    function lang_leadtimecategorys($name){
        return lang('Layout_Admin.leadtimecategorys_'.$name);
    }
}
if(!function_exists('lang_stocklocationcategorys')){
    function lang_stocklocationcategorys($name){
        return lang('Layout_Admin.stocklocationcategorys_'.$name);
    }
}
if(!function_exists('lang_reasonreturninfo')){
    function lang_reasonreturninfo($name){
        return lang('Layout_Admin.reasonreturninfo_'.$name);
    }
}
if(!function_exists('lang_packagingunit')){
    function lang_packagingunit($name){
        return lang('Layout_Admin.packagingunit_'.$name);
    }
}
if(!function_exists('lang_shippingcompany')){
    function lang_shippingcompany($name){
        return lang('Layout_Admin.shippingcompany_'.$name);
    }
}
if(!function_exists('lang_searchranking')){
    function lang_searchranking($name){
        return lang('Layout_Admin.searchranking_'.$name);
    }
}
if(!function_exists('lang_searchtoday')){
    function lang_searchtoday($name){
        return lang('Layout_Admin.searchtoday_'.$name);
    }
}
if(!function_exists('lang_inquiry')){
    function lang_inquiry($name){
        return lang('Layout_Admin.inquiry_'.$name);
    }
}
if(!function_exists('lang_deferredpay')){
    function lang_deferredpay($name){
        return lang('Layout_Admin.deferredpay_'.$name);
    }
}
if(!function_exists('lang_one2one')){
    function lang_one2one($name){
        return lang('Layout_Admin.one2one_'.$name);
    }
}

if(!function_exists('lang_estimate')){
    function lang_estimate($name){
        return lang('Layout_Admin.estimate_'.$name);
    }
}
if(!function_exists('lang_review')){
    function lang_review($name){
        return lang('Layout_Admin.review_'.$name);
    }
}
if(!function_exists('lang_orderinfo')){
    function lang_orderinfo($name){
        return lang('Layout_Admin.orderinfo_'.$name);
    }
}
if(!function_exists('lang_buyerinfo')){
    function lang_buyerinfo($name){
        return lang('Layout_Admin.buyerinfo_'.$name);
    }
}
if(!function_exists('lang_taxinvoice')){
    function lang_taxinvoice($name){
        return lang('Layout_Admin.taxinvoice_'.$name);
    }
}
if(!function_exists('lang_refundinfo')){
    function lang_refundinfo($name){
        return lang('Layout_Admin.refundinfo_'.$name);
    }
}
if(!function_exists('lang_sale')){
    function lang_sale($name){
        return lang('Layout_Admin.sale_'.$name);
    }
}
if(!function_exists('lang_manufacturer')){
    function lang_manufacturer($name){
        return lang('Layout_Admin.manufacturer_'.$name);
    }
}
if(!function_exists('lang_member')){
    function lang_member($name){
        return lang('Layout_Admin.member_'.$name);
    }
}
if(!function_exists('lang_account')){
    function lang_account($name){
        return lang('Layout_Admin.account_'.$name);
    }
}
if(!function_exists('lang_constant')){
    function lang_constant($name){
        return lang('Constant.'.$name);
    }
}

if(!function_exists('lang_locationinfo')){
    function lang_locationinfo($name){
        return lang('Layout_Admin.locationinfo_'.$name);
    }
}
if(!function_exists('lang_apiproductinfo')){
    function lang_apiproductinfo($name){
        return lang('Layout_Admin.apiproductinfo_'.$name);
    }
}
if(!function_exists('lang_apiproductdetail')){
    function lang_apiproductdetail($name){
        return lang('Layout_Admin.apiproductdetail_'.$name);
    }
}
if(!function_exists('lang_digikeyapiproductinfo')){
    function lang_digikeyapiproductinfo($name){
        return lang('Layout_Admin.digikeyapiproductinfo_'.$name);
    }
}
if(!function_exists('lang_lcscproductinfo')){
    function lang_lcscproductinfo($name){
        return lang('Layout_Admin.lcscproductinfo_'.$name);
    }
}
if(!function_exists('lang_ickinginfo')){
    function lang_ickinginfo($name){
        return lang('Layout_Admin.ickinginfo_'.$name);
    }
}
if(!function_exists('lang_selpadatainfo')){
    function lang_selpadatainfo($name){
        return lang('Layout_Admin.selpadatainfo_'.$name);
    }
}
if(!function_exists('lang_displayinfo')){
    function lang_displayinfo($name){
        return lang('Layout_Admin.displayinfo_'.$name);
    }
}
if(!function_exists('lang_eventinfo')){
    function lang_eventinfo($name){
        return lang('Layout_Admin.eventinfo_'.$name);
    }
}
if(!function_exists('lang_mallinfo')){
    function lang_mallinfo($name){
        return lang('Layout_Admin.mallinfo_'.$name);
    }
}
if(!function_exists('lang_apidatalogs')){
    function lang_apidatalogs($name){
        return lang('Layout_Admin.apidatalogs_'.$name);
    }
}

//Url Helper
if(!function_exists('url_check_active')){
    function url_check_active($urlName){
        $urlCurrent = current_url();
        return strpos($urlCurrent, $urlName) > 0;
    }
}

if(!function_exists('left_menu_show_nav_dropdown')){
    function left_menu_show_nav_dropdown($uris){
        $urlCurrent = current_url();
        foreach ($uris as $uri){
            if(strpos($urlCurrent, $uri) > 0) return true;
        }
        return false;
    }
}

if(!function_exists('member_accept_name')){
    function member_accept_name($memberAcceptCode){
        $acceptName = '';
        switch ($memberAcceptCode){
            case MEMBER_ACCEPT_ON:
                $acceptName = lang_member('accept_on');
                break;
            case MEMBER_ACCEPT_OFF:
                $acceptName = lang_member('accept_off');
                break;
        }
        return $acceptName;
    }
}

//Kmall Helper
if(!function_exists('lang_product')){
    function lang_product($name){
        return lang('Layout_Admin.product_'.$name);
    }
}

if(!function_exists('lang_showwindow')){
    function lang_showwindow($name){
        return lang('Layout_Admin.showwindow_'.$name);
    }
}

if(!function_exists('lang_productcreate')){
    function lang_productcreate($name){
        return lang('Layout_Admin.productcreate_'.$name);
    }
}

if(!function_exists('lang_productmp')){
    function lang_productmp($name){
        return lang('Layout_Admin.productmp_'.$name);
    }
}

if(!function_exists('lang_mksitemap')){
    function lang_mksitemap($name){
        return lang('Layout_Admin.mksitemap_'.$name);
    }
}

if(!function_exists('lang_todaystat')){
    function lang_todaystat($name){
        return lang('Layout_Admin.todaystat_'.$name);
    }
}

if(!function_exists('lang_navercommerce')){
    function lang_navercommerce($name){
        return lang('Layout_Admin.navercommerce_'.$name);
    }
}

if(!function_exists('lang_manager')){
    function lang_manager($name){
        return lang('Layout_Admin.manager_'.$name);
    }
}

if(!function_exists('lang_navercommerceapi')){
    function lang_navercommerceapi($name){
        return lang('Layout_Admin.navercommerceapi_'.$name);
    }
}