<?php
namespace App\Helpers;

use App\Entities\AccountManager;
use App\Entities\CartInfo;
use App\Entities\Item;
use App\Entities\Member;
use CodeIgniter\HTTP\RedirectResponse;
use CodeIgniter\HTTP\Response;
use CodeIgniter\Session\Session;

class AuthHelpers{

    public static function getSession() : Session{
        return \Config\Services::session();
    }

    public const ADMIN_DATA = 'admin_login_data';
    public const MEMBER_DATA = 'member_login_data';
    public const TIME_OUT_SALE_INPUT = 'time_out_sale_input';
    public const CART_SESSION = 'cart_session';
    public const BACK_URL = "back_url";
    public const BACK_URL_LOGIN = "back_url_login";
    public const SESSION_INCREASE_HIT_NEW = 'increase_hit_new';
    public const SESSION_INCREASE_HIT_NOTICE = 'increase_hit_notice';
    public const SESSION_INCREASE_HIT_INQUIRY = 'increase_hit_inquiry';
    public const SESSION_INCREASE_HIT_DEFERREDPAY = 'increase_hit_deferredpay';
    public const SESSION_INCREASE_HIT_REVIEW = 'increase_hit_review';
    public const SESSION_INCREASE_HIT_ONE2ONE = 'increase_hit_one2one';

    public static function setLoginAdmin($loginInfo){
        self::getSession()->set(self::ADMIN_DATA ,$loginInfo);
    }

    public static function clearLoginAdmin(){
        self::getSession()->remove(self::ADMIN_DATA);
//        self::getSession()->destroy();
        //Clear Cookie
        $loginTime = time() - 604800; //3600 * 24 * 7
        // set_cookie(self::ADMIN_DATA, '', $loginTime, env('app.domain')); 
        setCookie(self::ADMIN_DATA, '', $loginTime, env('app.domain'));
    }

    public static function checkLoginAdmin(){
        $loginInfo = self::getSession()->get(self::ADMIN_DATA);
        if(!isset($loginInfo) || $loginInfo->active_flg != 1){
            return false;
        }
        return true;
    }

    /**
     * @return AccountManager
     */
    public static function getLoginInfoAdmin(){
        return self::getSession()->get(self::ADMIN_DATA);
    }

//    Cookie
    public static function setCookie($key , $value, RedirectResponse $response = null){
        $loginTime = time() + 604800; //3600 * 24 * 7
        if(isset($response)){
            $response->setCookie($key, $value, $loginTime,env('app.domain'));
        }else{
            //set_cookie($key, $value, $loginTime,env('app.domain'));
            setCookie($key, $value, $loginTime,env('app.domain'));
        }
    }

    public static function getCookie($key){
        return get_cookie($key);
    }

    public static function setCookieLoginAdmin($loginInfo){
        self::setCookie(self::ADMIN_DATA,$loginInfo->toJson());
    }

    public static function getCookieInfoAdmin(){
        $jsonLoginInfo = get_cookie(self::ADMIN_DATA);
        if(isset($jsonLoginInfo)){
            $accountManager = new AccountManager();
            $accountManager->decodeJson($jsonLoginInfo);
            return $accountManager;
        }
        return $jsonLoginInfo;
    }


//    Guest
    // Shop Id Cookie Set Start
        
    public const SHOP_ID = "shop_id";

    public static function setShopId($shopid){
        self::getSession()->set(self::SHOP_ID ,$shopid);
    }

    public static function getShopId(){
        return self::getSession()->get(self::SHOP_ID);
    }

    public static function clearShopId(RedirectResponse $response = null){
        self::getSession()->remove(self::SHOP_ID);
    }
    
    // Product Code Cookie Set Start
    
    public const PROD_CODE = "product_code";

    public static function setProdCode($productcode){
        self::getSession()->set(self::PROD_CODE ,$productcode);
    }

    public static function getProdCode(){
        return self::getSession()->get(self::PROD_CODE);
    }

    public static function clearProdCode(RedirectResponse $response = null){
        self::getSession()->remove(self::PROD_CODE);
    }

    
    // Phone Num Cookie Set Start

    public const PHONE_NUM = "phone_num";

    public static function setPhoneNum($phonenum){
        self::getSession()->set(self::PHONE_NUM ,$phonenum);
    }

    public static function getPhoneNum(){
        return self::getSession()->get(self::PHONE_NUM);
    }

    public static function clearPhoneNum(RedirectResponse $response = null){
        self::getSession()->remove(self::PHONE_NUM);
    }
    
    // Phone Num Cookie Set End

    // Inquiry Code Cookie Set Start
    
    public const IQR_CODE = "inquiry_code";

    public static function setIqrCode($inquirycode){
        $loginTime = time() + 604800; //3600 * 24 * 7
        $inquirycode = "IQR".date(time());

        self::getSession()->set(self::IQR_CODE , $inquirycode, $loginTime);
    }

    public static function resetIqrCode($inquirycode){
        $loginTime = time() + 604800; //3600 * 24 * 7
        self::getSession()->set(self::IQR_CODE , $inquirycode, $loginTime);
    }

    public static function getIqrCode(){
        return self::getSession()->get(self::IQR_CODE);
    }

    public static function clearIqrCode(RedirectResponse $response = null){
        self::getSession()->remove(self::IQR_CODE);
    }

    // Inquiry Code Cookie Set End

    // Quote Contact Code Cookie Set Start
    public const ESTIMATE_CODE = "estimate_code";

    public static function setEstimateCode($estimatecode){
        $loginTime = time() + 604800; //3600 * 24 * 7
        $estimatecode = "ESTIMATE".date(time());

        self::getSession()->set(self::ESTIMATE_CODE , $estimatecode, $loginTime);
    }

    public static function getEstimateCode(){
        return self::getSession()->get(self::ESTIMATE_CODE);
    }

    public static function clearEstimateCode(RedirectResponse $response = null){
        self::getSession()->remove(self::ESTIMATE_CODE);
    }

    // Quote Contact Code Cookie Set End

    public static function setLoginGuest($loginInfo){
        self::getSession()->set(self::MEMBER_DATA ,$loginInfo);
    }

    public static function getLoginInfoGuest(){
        return self::getSession()->get(self::MEMBER_DATA);
    }

    public static function clearLoginGuest(RedirectResponse $response = null){
        self::getSession()->remove(self::MEMBER_DATA);
        self::getSession()->remove(self::CART_SESSION);
        self::getSession()->remove(self::BACK_URL);
        self::getSession()->remove(self::BACK_URL_LOGIN);
        self::getSession()->remove(self::SESSION_INCREASE_HIT_NEW);
        self::getSession()->remove(self::SESSION_INCREASE_HIT_NOTICE);
        self::getSession()->remove(self::SESSION_INCREASE_HIT_INQUIRY);
        self::getSession()->remove(self::SESSION_INCREASE_HIT_DEFERREDPAY);
        self::getSession()->remove(self::SESSION_INCREASE_HIT_REVIEW);
        self::getSession()->remove(self::SESSION_INCREASE_HIT_ONE2ONE);        

        $loginTime = time() - 604800; //3600 * 24 * 7
        if(isset($response)){
            //Clear Cookie
            //$response->setCookie(self::MEMBER_DATA, '', $loginTime,env('app.domain'));
        }else{
            //Clear Cookie
            //set_cookie(self::MEMBER_DATA, '', $loginTime,env('app.domain'));
            setCookie(self::MEMBER_DATA, '', $loginTime,env('app.domain'));
        }
    }

    public static function checkLoginGuest(){
        $loginInfo = self::getSession()->get(self::MEMBER_DATA);
        if(isset($loginInfo) && !empty($loginInfo->member_name)){
            return true;
        }
        return false;
    }

    public static function setCookieLoginGuest($loginInfo, RedirectResponse $response = null){
        self::setCookie(self::MEMBER_DATA,$loginInfo->toJson(), $response);
    }

    public static function getCookieInfoGuest(){
        $jsonLoginInfo = self::getCookie(self::MEMBER_DATA);
        if(isset($jsonLoginInfo)){
            $memberAccount = new Member();
            $memberAccount->decodeJson($jsonLoginInfo);
            return $memberAccount;
        }
        return $jsonLoginInfo;
    }

    public static function addItemCart(Item $item, $quantity, $price){
        $cartInfo = self::getSession()->get(self::CART_SESSION);
        if(!isset($cartInfo)){
            $loginInfo = self::getLoginInfoGuest();
            $cartInfo = new CartInfo($loginInfo->member_id);
        }
        $cartInfo->addCart($item, $quantity, $price);
        self::setCart($cartInfo);
    }

    public static function getCart(){
        $cartInfo = self::getSession()->get(self::CART_SESSION);
        if(!isset($cartInfo)){
            $loginInfo = self::getLoginInfoGuest();
            $cartInfo = new CartInfo($loginInfo->member_id);
        }
        return $cartInfo;
    }

    public static function setCart(CartInfo $cartInfo){
        self::getSession()->set(self::CART_SESSION,$cartInfo);
    }

    public static function clearCart(){
        self::getSession()->remove(self::CART_SESSION);
    }

    public static function deleteCart($partNumber){
        $cartInfo = self::getSession()->get(self::CART_SESSION);
        if(isset($cartInfo)){
            $cartInfo->deleteItem($partNumber);
            if($cartInfo->isEmpty()){
                self::clearCart();
            }
        }
    }

    public static function changeCartQty($partNumber, $qty){
        $cartInfo = self::getSession()->get(self::CART_SESSION);
        if(isset($cartInfo)){
            $cartInfo->updateQtyItem($partNumber, $qty);
        }
    }

    public static function changeCartPrice($partNumber, $price){
        $cartInfo = self::getSession()->get(self::CART_SESSION);
        if(isset($cartInfo)){
            $cartInfo->updatePriceItem($partNumber, $price);
        }
    }
}