<?php
namespace App\Helpers;

use CodeIgniter\HTTP\Files\UploadedFile;

class FileHelper{
    public const FOLDER_PATH_UPLOAD = "upload";
    public const FOLDER_PATH_UPLOAD_NEWS = "news";
    public const FOLDER_PATH_UPLOAD_DELIVERYCODE = "deliverycode";    
    public const FOLDER_PATH_UPLOAD_SHIPPINGINFO = "shippinginfo";
    public const FOLDER_PATH_UPLOAD_BANNERMAIN = "bannermain";
    public const FOLDER_PATH_UPLOAD_BANNERINFO = "bannerinfo";
    public const FOLDER_PATH_UPLOAD_POPUP = "popup";

    public const FOLDER_PATH_UPLOAD_NOTICE = "notice";
    public const FOLDER_PATH_UPLOAD_INQUIRY = 'inquiry';
    public const FOLDER_PATH_UPLOAD_DEFERREDPAY = 'deferredpay';
    public const FOLDER_PATH_UPLOAD_REVIEW = 'review';
    public const FOLDER_PATH_UPLOAD_ONE2ONE = 'one2one';

    public const FOLDER_PATCH_UPLOAD_ITEM = "items";
    public const FOLDER_PATCH_UPLOAD_PRODUCTS = "products";
    public const FOLDER_PATCH_UPLOAD_MEMBER = "members";
    public const FOLDER_PATCH_UPLOAD_MEMBER_ATC = "members_attach";
    public const FOLDER_PATCH_UPLOAD_ACCOUNT = "accounts";
    public const FOLDER_PATCH_UPLOAD_TEMP = "tmp";
    public const FOLDER_PATCH_API_CONFIG_INFO = "apiconfiginfo";
    public const FOLDER_PATCH_API_TOTEXT = "apitotext";
    public const FOLDER_PATCH_API_TOTEXT_BACKUP = "apitotext_backup";

    public const FOLDER_PATCH_ICK_TOTEXT = "icktotext";
    public const FOLDER_PATCH_ICK_TOTEXT_BACKUP = "icktotext_backup";
    
    public const FOLDER_PATCH_LCSC_TOTEXT = "lcsctotext";
    public const FOLDER_PATCH_LCSC_TOTEXT_BACKUP = "lcsctotext_backup";

    public const FOLDER_PATCH_DKAPI_TOTEXT = "dkapitotext";
    public const FOLDER_PATCH_API_DETAILTOTEXT = "apidetailtotext";
    public const FOLDER_PATCH_API_DETAILTOTEXT_BACKUP = "apidetailtotext_backup";
    public const FOLDER_PATCH_DKAPI_TOTEXT_BACKUP = "dkapitotext_backup";
    public const FOLDER_PATCH_SITEMAP_TOTEXT = "sitemap";
    
    public const IMAGE_THUMBNAIL_NAME = 'thumbnail';
    public const IMAGE_BIG_NAME = 'big';
    public const IMAGE_ORIGIN_NAME = 'origin';
    public const FOLDER_PATCH_UPLOAD_DISPLAY = 'display';
    public const FOLDER_PATCH_UPLOAD_EVENT = 'event';

    public const FOLDER_PATCH_UPLOAD_LOOPEXCEL = 'loopexcel';
    public const FOLDER_PATCH_UPLOAD_EVENTEXCEL = 'eventexcel';
    public const FOLDER_PATCH_UPLOAD_APIIDCSV = 'apiidcsv';

    public static function saveFile($file, $writePath = null, $folderCode = null){
        if($file instanceof UploadedFile){
            $filePath = self::FOLDER_PATH_UPLOAD;
            if(isset($writePath)) $filePath.= '/'.$writePath;
            if(isset($folderCode)) $filePath.= '/'.$folderCode;
            $fileName = time().'_'.$file->getClientName();
            $file->move($filePath,$fileName);
            return $filePath . '/' . $fileName;
        }
    }


    public static function saveExFile($file, $writePath = null, $file_count){
        if($file instanceof UploadedFile){
            $filePath = self::FOLDER_PATH_UPLOAD;
            if(isset($writePath)) $filePath.= '/'.$writePath;
            $ext = pathinfo($file->getClientName(),PATHINFO_EXTENSION);
            $fileName = 'loop_data_'.$file_count.'.'.$ext;
            $file->move($filePath,$fileName);
            return $filePath . '/' . $fileName;
        }
    }

    public static function saveCSVFile($file, $writePath = null, $file_count){
        if($file instanceof UploadedFile){
            $filePath = self::FOLDER_PATH_UPLOAD;
            if(isset($writePath)) $filePath.= '/'.$writePath;
            $ext = pathinfo($file->getClientName(),PATHINFO_EXTENSION);
            $fileName = 'api_id_'.$file_count.'.'.$ext;
            $file->move($filePath,$fileName);
            return $filePath . '/' . $fileName;
        }
    }

    public static function saveImageItem($file, $writePath = null, $folderCode = null){
        if($file instanceof UploadedFile){
            $filePath = self::FOLDER_PATH_UPLOAD;
            if(isset($writePath)) $filePath.= '/'.$writePath;
            if(isset($folderCode)) $filePath.= '/'.$folderCode;
            $time = time();
            $ext = pathinfo($file->getClientName(),PATHINFO_EXTENSION);
            $fileName = $time.'_'.'file.'.$ext;
            $thumbnailName = $time.'_thumbnail_'.'file.'.$ext;
            $bigName = $time.'_big_'.'file.'.$ext;
            $file->move($filePath,$fileName);
            $fileResult = $filePath . '/' . $fileName;
            $fileThumbnailResult = $filePath . '/' . $thumbnailName;
            $fileBigResult = $filePath . '/' . $bigName;
            //Save Image Thumbnail
//            $image = \Config\Services::image();
//            $image->withFile($fileResult)->resize(180,180)->save($fileThumbnailResult);
            //Save Image Big
//            $image->withFile($fileResult)->resize(500,500)->save($fileBigResult);
            return [
                'thumbnail' => $fileThumbnailResult,
                'big' => $fileBigResult,
                'origin' => $fileResult
            ];
        }
    }

    public static function deleteFile($pathFile){
        if(isset($pathFile) && $pathFile != null){
            helper('filesystem');
            $systemPath = PUBLIC_PATH;
            $file = $systemPath.'/'.$pathFile;
            if(file_exists($file) && is_file($file)){
                unlink($file);
            }elseif(file_exists($file)){
                self::deleteAll($file);
            }
        }
    }


    public static function deleteCSVFile($writePath = null){
        $pathFile = self::FOLDER_PATH_UPLOAD;
        if(isset($writePath)) $pathFile.= '/'.$writePath;

        if(isset($pathFile) && $pathFile != null){
            helper('filesystem');
            $systemPath = PUBLIC_PATH;
            $file = $systemPath.'/'.$pathFile;
            if(file_exists($file) && is_file($file)){
                unlink($file);
            }elseif(file_exists($file)){
                self::deleteAll($file);
            }
        }
    }

    public static function deleteAll($str) {
        //It it's a file.
        if (is_file($str)) {
            //Attempt to delete it.
            return unlink($str);
        }
        //If it's a directory.
        elseif (is_dir($str)) {
            //Get a list of the files in this directory.
            $scan = glob(rtrim($str,'/').'/*');
            //Loop through the list of files.
            foreach($scan as $index=>$path) {
                //Call our recursive function.
                self::deleteAll($path);
            }
            //Remove the directory itself.
            return @rmdir($str);
        }
    }
}