<?php

namespace App\Libraries\Excel;

use App\Helpers\DateHelper;
use App\Helpers\FileHelper;
use CodeIgniter\HTTP\Files\UploadedFile;
use CodeIgniter\I18n\Time;
use phpDocumentor\Reflection\Types\Array_;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Excel
{
    private const EXCEL_COLUMNS = ['A','B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z','AA', 'AB', 'AC', 'AD', 'AE', 'AF', 'AG', 'AH', 'AI', 'AJ', 'AK', 'AL', 'AM', 'AN', 'AO', 'AP', 'AQ', 'AR', 'AS', 'AT', 'AU', 'AV', 'AW', 'AX', 'AY', 'AZ',
        'BA', 'BB', 'BC', 'BD', 'BE', 'BF', 'BG', 'BH', 'BI', 'BJ', 'BK', 'BL', 'BM', 'BN', 'BO', 'BP', 'BQ', 'BR', 'BS', 'BT', 'BU', 'BV', 'BW', 'BX', 'BY', 'BZ','CA', 'CB', 'CC', 'CD', 'CE', 'CF', 'CG', 'CH', 'CI', 'CJ', 'CK', 'CL', 'CM', 'CN', 'CO', 'CP', 'CQ', 'CR', 'CS', 'CT', 'CU', 'CV', 'CW', 'CX', 'CY', 'CZ'];

    public function export($headerColumns, $data = [], $dataColumns = [], $options = [])
    {
        $fileName = 'excel_download.xlsx';
        if(isset($options['file_name'])) $fileName = $options['file_name'].'.xlsx';

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        //Set header
        $rows = 1;//Row header
        foreach ($headerColumns as $index => $headerColumn){
            $sheet->setCellValue(self::EXCEL_COLUMNS[$index].$rows, $headerColumn);
        }
        $rows = 2;
        //Set data
        foreach ($data as $item){
            if(is_array($item)) $items = $item;
            else $items = $this->dataObjectToArray($item);
            foreach ($headerColumns as $index => $headerColumn){
                $dataColumnKey = $headerColumn;
                if(isset($dataColumns) && count($dataColumns) > $index){
                    $dataColumnKey = $dataColumns[$index];
                }else if(!isset($items[$dataColumnKey])){
                    $dataColumnKey = $index;
                }
                $strValue = '';
                if(is_array($items) && isset($items[$dataColumnKey])){
                    $value = $items[$dataColumnKey];
                    if( $value instanceof Time){
                        $strValue = DateHelper::toTimeString($value);
                    }else{
                        $strValue = $items[$dataColumnKey];
                    }
                }
                $sheet->setCellValue(self::EXCEL_COLUMNS[$index].$rows, $strValue);
            }
            $rows++;

        }
        $writer = new Xlsx($spreadsheet);
        $filePath = "upload/excel";
        if(!file_exists(PUBLIC_PATH.$filePath)){
            mkdir(PUBLIC_PATH.$filePath);
        }
        $filePath = "upload/excel/" . $fileName;
        $writer->save($filePath);
        return $filePath;
    }

    public function export2($headerEmptys, $headerColumns, $data = [], $dataColumns = [], $options = [])
    {
        $fileName = 'excel_download.xlsx';
        if(isset($options['file_name'])) $fileName = $options['file_name'].'.xlsx';

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        //Set header
        $rows = 1;//Row header
        foreach ($headerEmptys as $index => $headerEmpty){
            $sheet->setCellValue(self::EXCEL_COLUMNS[$index].$rows, $headerEmpty);
        }

        $rows = 2;//Row header
        foreach ($headerEmptys as $index => $headerEmpty){
            $sheet->setCellValue(self::EXCEL_COLUMNS[$index].$rows, $headerEmpty);
        }

        $rows = 3;//Row header
        foreach ($headerEmptys as $index => $headerEmpty){
            $sheet->setCellValue(self::EXCEL_COLUMNS[$index].$rows, $headerEmpty);
        }

        $rows = 4;//Row header
        foreach ($headerEmptys as $index => $headerEmpty){
            $sheet->setCellValue(self::EXCEL_COLUMNS[$index].$rows, $headerEmpty);
        }

        $rows = 5;//Row header
        foreach ($headerEmptys as $index => $headerEmpty){
            $sheet->setCellValue(self::EXCEL_COLUMNS[$index].$rows, $headerEmpty);
        }

        $rows = 6;//Row header
        foreach ($headerColumns as $index => $headerColumn){
            $sheet->setCellValue(self::EXCEL_COLUMNS[$index].$rows, $headerColumn);
        }
        
        $rows = 7;
        //Set data
        foreach ($data as $item){
            if(is_array($item)) $items = $item;
            else $items = $this->dataObjectToArray($item);
            foreach ($headerColumns as $index => $headerColumn){
                $dataColumnKey = $headerColumn;
                if(isset($dataColumns) && count($dataColumns) > $index){
                    $dataColumnKey = $dataColumns[$index];
                }else if(!isset($items[$dataColumnKey])){
                    $dataColumnKey = $index;
                }
                $strValue = '';
                if(is_array($items) && isset($items[$dataColumnKey])){
                    $value = $items[$dataColumnKey];
                    if( $value instanceof Time){
                        $strValue = DateHelper::toTimeString($value);
                    }else{
                        $strValue = $items[$dataColumnKey];
                    }
                }
                $sheet->setCellValue(self::EXCEL_COLUMNS[$index].$rows, $strValue);
            }
            $rows++;

        }
        $writer = new Xlsx($spreadsheet);
        $filePath = "upload/excel";
        if(!file_exists(PUBLIC_PATH.$filePath)){
            mkdir(PUBLIC_PATH.$filePath);
        }
        $filePath = "upload/excel/" . $fileName;
        $writer->save($filePath);
        return $filePath;
    }

    public function dataObjectToArray($dataObject){
        if(isset($dataObject) && !is_array($dataObject)){
            if(method_exists($dataObject,'toArrayData')){
                return $dataObject->toArrayData();
            }
        }
        return $dataObject;
    }

    /**
     * @param UploadedFile|string $filePath
     * @throws \PhpOffice\PhpSpreadsheet\Reader\Exception
     */
    public function import($file){
        if(isset($file)){
            $filePath = $file;
            if($file instanceof UploadedFile){
                $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATCH_UPLOAD_TEMP);
            }
            $inputFileType = IOFactory::identify($filePath);
            $reader = IOFactory::createReader($inputFileType);
            $spreadsheet = $reader->load($filePath);
            $data = $spreadsheet->getActiveSheet()->toArray();
            return $data;
        }

    }
}