<?php
namespace App\Libraries\NaverPay;

class Naver_pay_lib {

    /**
     * SoapXml
     * @param $Api
     * @return mixed|string
     */
    public function soapXml($Api)
    {
        //var_dump($Api);
        $Naver_Pay = array();

        $Naver_Pay['GetChangedProductOrderList'] = $this->GetChangedProductOrderList;       //상품 주문 변경 내역 조회
        $Naver_Pay['GetProductOrderInfoList'   ] = $this->GetProductOrderInfoList;          //상품 주문 정보 조회

        $Naver_Pay['PlaceProductOrder'         ] = $this->PlaceProductOrder;                //발주
        $Naver_Pay['DelayProductOrder'         ] = $this->DelayProductOrder;                //발송 지연
        $Naver_Pay['ShipProductOrder'          ] = $this->ShipProductOrder;                 //발송
        $Naver_Pay['ShipProductOrder_Direct'  ] = $this->ShipProductOrder_Direct;          //직접발송

        $Naver_Pay['CancelSale'                ] = $this->CancelSale;                       //판매 취소
        $Naver_Pay['ApproveCancelApplication'  ] = $this->ApproveCancelReturnApplication;   //취소 요청 승인

        $Naver_Pay['RequestReturn'             ] = $this->RequestReturn;                    //반품 접수
        $Naver_Pay['ApproveReturnApplication'  ] = $this->ApproveCancelReturnApplication;   //반품 요청 승인
        $Naver_Pay['WithholdReturn'            ] = $this->WithholdReturn;                   //반품 보류

        $Naver_Pay['GetPurchaseReviewList'     ] = $this->GetPurchaseReviewList;            //상품 평가 내역 조회

        $Naver_Pay['GetCustomerInquiryList'    ] = $this->GetCustomerInquiryList;           //쇼핑 문의 내역 조회
        $Naver_Pay['AnswerCustomerInquiry'     ] = $this->AnswerCustomerInquiry;            //쇼핑 문의 답변

        if($Api == 'GetCustomerInquiryList' || $Api == 'AnswerCustomerInquiry'){
            $xml = $this->soap_qna_request;
            $xml = str_replace( '##Operation##', $Api,             $xml );
            $xml = str_replace( '##Service##'  , $Naver_Pay[$Api], $xml );
        }else if($Api == 'ShipProductOrder_Direct'){
            $xml = $this->soap_order_request;
            $xml = str_replace( '##Operation##', 'ShipProductOrder', $xml );
            $xml = str_replace( '##Service##'  , $Naver_Pay[$Api], $xml );
        } else{
            $xml = $this->soap_order_request;
            $xml = str_replace( '##Operation##', $Api,             $xml );
            $xml = str_replace( '##Service##'  , $Naver_Pay[$Api], $xml );
        }

        return $xml;
    }

    /**
     * Base Request
     * @var string
     */
    private $soap_order_request = "<soapenv:Envelope 
    xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" 
    xmlns:mall=\"http://mall.checkout.platform.nhncorp.com/\" 
    xmlns:base=\"http://base.checkout.platform.nhncorp.com/\">
    <soapenv:Header/>
        <soapenv:Body>
            <mall:##Operation##Request>
                <base:AccessCredentials>
                    <base:AccessLicense>##AccessLicense##</base:AccessLicense>
                    <base:Timestamp>##Timestamp##</base:Timestamp>
                    <base:Signature>##Signature##</base:Signature>
                </base:AccessCredentials>
                <base:RequestID>##RequestID##</base:RequestID>
                <base:DetailLevel><![CDATA[Full]]></base:DetailLevel>
                <base:Version>##Version##</base:Version>
                    ##Service##
            </mall:##Operation##Request>
        </soapenv:Body>
    </soapenv:Envelope>";

    private $soap_qna_request = "<soapenv:Envelope 
    xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"
	xmlns:mall=\"http://customerinquiry.checkout.platform.nhncorp.com/\">
    <soapenv:Header/>
        <soapenv:Body>
            <mall:##Operation##Request>
                <mall:AccessCredentials>
                    <mall:AccessLicense>##AccessLicense##</mall:AccessLicense>
                    <mall:Timestamp>##Timestamp##</mall:Timestamp>
                    <mall:Signature>##Signature##</mall:Signature>
                </mall:AccessCredentials>
                <mall:RequestID>##RequestID##</mall:RequestID>
                <mall:DetailLevel><![CDATA[Full]]></mall:DetailLevel>
                <mall:Version>##Version##</mall:Version>
                    ##Service##
            </mall:##Operation##Request>
        </soapenv:Body>
    </soapenv:Envelope>";

    /**
     * Operation Request
     * @var string
     */
    private $GetChangedProductOrderList = "<base:InquiryTimeFrom>##InquiryTimeFrom##</base:InquiryTimeFrom>
			<base:InquiryTimeTo>##InquiryTimeTo##</base:InquiryTimeTo>
			<mall:LastChangedStatusCode>##LastChangedStatusCode##</mall:LastChangedStatusCode>
			<mall:MallID>##MallID##</mall:MallID>";

    private $GetProductOrderInfoList = "<mall:ProductOrderIDList>##ProductOrderIDList##</mall:ProductOrderIDList>";

    private $PlaceProductOrder = "<mall:ProductOrderID>##ProductOrderID##</mall:ProductOrderID>
			<mall:CheckReceiverAddressChanged>##CheckReceiverAddressChanged##</mall:CheckReceiverAddressChanged>";

    private $DelayProductOrder = "<mall:ProductOrderID>##ProductOrderID##</mall:ProductOrderID>
			<mall:DispatchDueDate>##DispatchDueDate##</mall:DispatchDueDate>
			<mall:DispatchDelayReasonCode>##DispatchDelayReasonCode##</mall:DispatchDelayReasonCode>
			<mall:DispatchDelayDetailReason>##DispatchDelayDetailReason##</mall:DispatchDelayDetailReason>";

    private $ShipProductOrder = "<mall:ProductOrderID>##ProductOrderID##</mall:ProductOrderID>
            <mall:DeliveryMethodCode>##DeliveryMethodCode##</mall:DeliveryMethodCode>
            <mall:DeliveryCompanyCode>##DeliveryCompanyCode##</mall:DeliveryCompanyCode>
            <mall:TrackingNumber>##TrackingNumber##</mall:TrackingNumber>
            <mall:DispatchDate>##DispatchDate##</mall:DispatchDate>";

    private $ShipProductOrder_Direct = "<mall:ProductOrderID>##ProductOrderID##</mall:ProductOrderID>
            <mall:DeliveryMethodCode>##DeliveryMethodCode##</mall:DeliveryMethodCode>
            <mall:DispatchDate>##DispatchDate##</mall:DispatchDate>";

    private $CancelSale = "<mall:ProductOrderID>##ProductOrderID##</mall:ProductOrderID>     
            <mall:CancelReasonCode>##CancelReasonCode##</mall:CancelReasonCode>";

    private $RequestReturn = "<mall:ProductOrderID>##ProductOrderID##</mall:ProductOrderID>     
            <mall:ReturnReasonCode>##ReturnReasonCode##</mall:ReturnReasonCode>     
            <mall:CollectDeliveryMethodCode>##CollectDeliveryMethodCode##</mall:CollectDeliveryMethodCode>";

    private $WithholdReturn = "<mall:ProductOrderID>##ProductOrderID##</mall:ProductOrderID>
            <mall:ReturnHoldCode>##ReturnHoldCode##</mall:ReturnHoldCode>
            <mall:ReturnHoldDetailContent>##ReturnHoldDetailContent##</mall:ReturnHoldDetailContent>";

    private $ApproveCancelReturnApplication = "<mall:ProductOrderID>##ProductOrderID##</mall:ProductOrderID>
            <mall:EtcFeeDemandAmount>0</mall:EtcFeeDemandAmount>";

    private $GetPurchaseReviewList = "<base:InquiryTimeFrom>##InquiryTimeFrom##</base:InquiryTimeFrom>
            <base:InquiryTimeTo>##InquiryTimeTo##</base:InquiryTimeTo>
            <mall:MallID>##MallID##</mall:MallID>
            <mall:PurchaseReviewClassType>##PurchaseReviewClassType##</mall:PurchaseReviewClassType>";

    private $GetCustomerInquiryList = "<mall:ServiceType>##ServiceType##</mall:ServiceType>
            <mall:MallID>##MallID##</mall:MallID>
            <mall:InquiryTimeFrom>##InquiryTimeFrom##</mall:InquiryTimeFrom>
            <mall:InquiryTimeTo>##InquiryTimeTo##</mall:InquiryTimeTo>
            <mall:IsAnswered>false</mall:IsAnswered>";

    private $AnswerCustomerInquiry = "<mall:MallID>##MallID##</mall:MallID>
            <mall:ServiceType>##ServiceType##</mall:ServiceType>
            <mall:InquiryID>##InquiryID##</mall:InquiryID>
            <mall:AnswerContent>##AnswerContent##</mall:AnswerContent>
            <mall:AnswerContentID>##AnswerContentID##</mall:AnswerContentID>
            <mall:ActionType>##ActionType##</mall:ActionType>";

    /**
     * Connection check Request
     * @var string
     */
    public $check_request = "<soapenv:Envelope
	xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"
	xmlns:mall=\"http://mall.checkout.platform.nhncorp.com/\"
	xmlns:base=\"http://base.checkout.platform.nhncorp.com/\">
	<soapenv:Header/>
	<soapenv:Body>
		<mall:GetChangedProductOrderListRequest>
			<base:AccessCredentials>
				<base:AccessLicense>##AccessLicense##</base:AccessLicense>
				<base:Timestamp>##Timestamp##</base:Timestamp>
				<base:Signature>##Signature##</base:Signature>
			</base:AccessCredentials>
			<base:RequestID>##RequestID##</base:RequestID>
			<base:DetailLevel>Full</base:DetailLevel>
			<base:Version>##Version##</base:Version>
			<base:InquiryTimeFrom>##InquiryTimeFrom##</base:InquiryTimeFrom>
			<base:InquiryTimeTo>##InquiryTimeTo##</base:InquiryTimeTo>
			<mall:LastChangedStatusCode/>
			<mall:MallID/>
		</mall:GetChangedProductOrderListRequest>
	</soapenv:Body>
</soapenv:Envelope>";

};

?>