<?php
namespace App\Models;

use App\Entities\AccountManager;

class AccountManagerSubModel extends BaseModel {
    protected $table      = 'account_managers_sub';
    protected $primaryKey = 'sub_id';

    protected $allowedFields = ['account_id','com_name','ceo_name','ceo_email','sectors','condition','com_zipcode','com_address1','com_address2','com_phone','com_fax','biz_number','onlinesales_number','mall_name','mall_name_eng','mall_domain','active_flg','del_flg'];

    protected $returnType = 'App\Entities\AccountManagerSub';
    protected $useSoftDeletes = false;

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = true;


    /**
     * @param $email
     * @param $password
     * @return App\Entities\AccountManagerSub|null
     */

     public function findAccountId($account_id){
        return $this->where('account_id', $account_id)->first();
    }
}