<?php
namespace App\Models;

use App\Helpers\DateHelper;

class ApiPndataModel extends BaseModel {
    protected $table      = 'api_pndata';
    protected $primaryKey = 'id';
    
    protected $allowedFields = ['api_code','api_partnumber','active_flg'];

    protected $returnType = 'App\Entities\ApiPndata';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = true;

public function getApiId($api_code, $limit){
    $queryBuilder = $this->where('active_flg', 0);
    $queryBuilder = $this->like('api_code', $api_code);
    $queryBuilder = $this->select("api_partnumber");
    // $queryBuilder = $this->findAll();
    
    return $this->executePaginate($queryBuilder, $limit);
}

public function getPnStatus(){
    return $this->where('active_flg', 0)->findAll();
}

public function findByProductSeq($product_api_id){
    $tableProduct = ProductModel::getTableName();
    return $this->where('product_api_id', esc($product_api_id))->select("$tableProduct.maker_seq")->first();
}

public function updateActiveFlg($api_partnumber){
    $queryBuilder = $this->set('active_flg', '1');
    $queryBuilder = $this->where('api_partnumber', $api_partnumber);
    $queryBuilder = $this->update();
 }


}
